/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.text.StyledDocument;

public class ManifestPrint
implements Printable {
    private StyledDocument documentToBePrinted;
    private float numberOfLines = 0.0f;
    private float linesPerPage = 0.0f;
    private double numberOfPages = 0.0;
    private float pageHeight = 0.0f;
    private float pageWidth = 0.0f;
    private float lineHeight = 0.0f;
    private int lastLinePrinted = 0;
    private String[] stringArray;

    public static void printComponent(StyledDocument c) {
        new ManifestPrint(c).print();
    }

    public ManifestPrint(StyledDocument documentToBePrinted) {
        this.documentToBePrinted = documentToBePrinted;
    }

    public void print() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(this);
        if (printJob.printDialog()) {
            try {
                System.out.println("Calling PrintJob.print()");
                printJob.print();
                System.out.println("End PrintJob.print()");
            }
            catch (PrinterException pe) {
                System.out.println("Error printing: " + pe);
            }
        }
    }

    private void prepareForPrinting(Graphics2D graphics) {
        this.numberOfLines = 0.0f;
        this.linesPerPage = 0.0f;
        this.numberOfPages = 0.0;
        this.lastLinePrinted = 0;
        int i = 0;
        while (i < this.documentToBePrinted.getLength()) {
            try {
                if (this.documentToBePrinted.getText(i, 1).equals("\n")) {
                    this.numberOfLines += 1.0f;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        this.stringArray = new String[(int)this.numberOfLines];
        int index = 0;
        int currentLine = 0;
        int i2 = 0;
        while (i2 < this.documentToBePrinted.getLength()) {
            try {
                if (this.documentToBePrinted.getText(i2, 1).equals("\n")) {
                    this.stringArray[currentLine] = this.documentToBePrinted.getText(index, i2 + 1 - index);
                    index = i2 + 1;
                    ++currentLine;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i2;
        }
        Font font = new Font("Arial", 0, 10);
        FontMetrics metrics = graphics.getFontMetrics(font);
        this.lineHeight = metrics.getHeight();
        this.linesPerPage = (int)Math.floor((this.pageHeight - (float)graphics.getFontMetrics(new Font("Arial", 0, 14)).getHeight() + 25.0f) / this.lineHeight);
        System.out.println("Before calculating: " + Math.ceil(this.numberOfLines / this.linesPerPage));
        this.numberOfPages = Math.ceil(this.numberOfLines / this.linesPerPage);
        System.out.println("After First : " + Math.ceil(this.numberOfPages / 2.0));
        this.numberOfPages = Math.ceil(this.numberOfPages / 2.0);
        System.out.println("Total Pages: " + this.numberOfPages);
        System.out.println("Total Lines: " + this.numberOfLines);
        System.out.println("Lines Per Page: " + this.linesPerPage);
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) {
        Graphics2D g2d = (Graphics2D)g;
        this.pageHeight = (int)pf.getImageableHeight() - 100;
        this.pageWidth = (int)pf.getImageableWidth() - 100;
        int basey = 0;
        if (pageIndex == 0) {
            this.prepareForPrinting(g2d);
        }
        if ((double)pageIndex < this.numberOfPages) {
            g2d.translate(pf.getImageableX() + 50.0, pf.getImageableY() + 50.0);
            g2d.setFont(new Font("Arial", 1, 14));
            g2d.setColor(Color.BLACK);
            g2d.drawString("TerrainLinx Manifest", this.pageWidth / 2.0f - 75.0f, 0.0f);
            basey = g2d.getFontMetrics(new Font("Arial", 0, 14)).getHeight() + 25;
            g2d.setFont(new Font("Arial", 0, 10));
            g2d.setColor(Color.BLACK);
            g2d.drawLine((int)(this.pageWidth / 2.0f), basey, (int)(this.pageWidth / 2.0f), (int)this.pageHeight);
            int index = pageIndex * (int)this.linesPerPage * 2;
            int i = 0;
            while ((float)i <= this.linesPerPage) {
                if (index < this.stringArray.length) {
                    g2d.drawString(this.stringArray[index], 25.0f, (float)i * this.lineHeight + (float)basey);
                    ++index;
                }
                ++i;
            }
            i = 1;
            while ((float)i <= this.linesPerPage) {
                if (index < this.stringArray.length) {
                    g2d.drawString(this.stringArray[index], this.pageWidth / 2.0f + 25.0f, (float)i * this.lineHeight + (float)basey);
                    ++index;
                }
                ++i;
            }
            return 0;
        }
        return 1;
    }
}

