/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

class MyPanel
extends JPanel
implements Serializable {
    private AffineTransform identity = new AffineTransform();
    private boolean gridenabled = true;
    public Rectangle boundingBox;
    public Rectangle selectedArea;
    public boolean setBoundingBox;
    public int GridWidth = 16;
    public int GridHeight = 16;
    public boolean outLineEnabled = false;
    public String tabTitle = "";
    public LinkedList<Tile> tileList;
    public MyPanel prevLayer = null;
    public MyPanel nextLayer = null;
    public float transpVal = 0.5f;
    public int tableWidth = 0;
    public int tableHeight = 0;
    public ArrayList<Tile> wallsList;
    public ArrayList<Tile> postsList;
    public ArrayList<Tile> genSymbList;
    public ArrayList<Tile> balconyList;
    public ArrayList<Tile> trussesList;
    public ArrayList<Tile> roofingList;
    public ArrayList<Tile> railingList;
    public ArrayList<Tile> stairsRampsList;
    public boolean lockTiles = false;
    public boolean lockSymbols = false;
    public elementState tileState = elementState.UNLOCKED;
    public elementState symbolState = elementState.UNLOCKED;
    public boolean showPrevLayer = false;
    public boolean showNextLayer = false;

    public MyPanel() {
        this.boundingBox = new Rectangle();
        this.selectedArea = new Rectangle();
        this.setBackground(Color.decode("0x131313"));
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.tileList = new LinkedList();
        this.wallsList = new ArrayList();
        this.postsList = new ArrayList();
        this.genSymbList = new ArrayList();
        this.balconyList = new ArrayList();
        this.trussesList = new ArrayList();
        this.roofingList = new ArrayList();
        this.railingList = new ArrayList();
        this.stairsRampsList = new ArrayList();
        this.prevLayer = null;
        this.nextLayer = null;
        this.setLayout(null);
    }

    @Override
    public Dimension preferredSize() {
        return new Dimension(2000, 2000);
    }

    public void SetGridState(boolean state) {
        this.gridenabled = state;
        this.repaint();
    }

    public boolean GetGridState() {
        return this.gridenabled;
    }

    public void RefreshEditor() {
        this.repaint();
    }

    public boolean isEmpty() {
        return this.tileList.size() == 0 && this.wallsList.size() == 0 && this.postsList.size() == 0 && this.genSymbList.size() == 0 && this.balconyList.size() == 0 && this.trussesList.size() == 0 && this.railingList.size() == 0 && this.roofingList.size() == 0 && this.stairsRampsList.size() == 0;
    }

    @Override
    public void paintComponent(Graphics g) {
        Image image;
        AlphaComposite composite;
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        int olX = 0;
        int olY = 0;
        int olWidth = 0;
        int olHeight = 0;
        if (this.gridenabled) {
            g2d.setStroke(new BasicStroke(1.5f));
            composite = AlphaComposite.getInstance(3, 0.3f);
            g2d.setComposite(composite);
            g2d.setColor(Color.decode("0xebebeb"));
            int c = 0;
            while (c < this.getWidth()) {
                g2d.drawLine(c, 0, c, this.getHeight());
                c += this.GridWidth;
            }
            int r = 0;
            while (r < this.getHeight()) {
                g2d.drawLine(0, r, this.getWidth(), r);
                r += this.GridHeight;
            }
        }
        if (this.tableWidth != 0 && this.tableHeight != 0) {
            Rectangle tableRect = null;
            AlphaComposite composite2 = AlphaComposite.getInstance(3, 0.3f);
            if (this.GridWidth == 16 && this.GridHeight == 16) {
                tableRect = new Rectangle(32, 32, this.tableWidth * 16, this.tableHeight * 16);
            } else if (this.GridWidth == 24 && this.GridHeight == 24) {
                tableRect = new Rectangle(48, 48, this.tableWidth * 16, this.tableHeight * 16);
            }
            Iterator<Tile> triangle1X = (Iterator<Tile>)new int[]{tableRect.x, tableRect.x + tableRect.width, tableRect.x + tableRect.width};
            int[] triangle1Y = new int[]{tableRect.y, tableRect.y, tableRect.y + tableRect.height};
            Polygon triangle1 = new Polygon((int[])triangle1X, triangle1Y, 3);
            int[] triangle2X = new int[]{tableRect.x, tableRect.x + tableRect.width, tableRect.x};
            int[] triangle2Y = new int[]{tableRect.y, tableRect.y + tableRect.height, tableRect.y + tableRect.height};
            Polygon triangle2 = new Polygon(triangle2X, triangle2Y, 3);
            g2d.setColor(Color.WHITE);
            g2d.drawRect(tableRect.x, tableRect.y, tableRect.width, tableRect.height);
            g2d.setComposite(composite2);
            g2d.fillPolygon(triangle1);
            composite2 = AlphaComposite.getInstance(3, 0.1f);
            g2d.setComposite(composite2);
            g2d.fillPolygon(triangle2);
            g2d.setComposite(AlphaComposite.Clear);
        }
        if (this.prevLayer != null && this.showPrevLayer && !this.prevLayer.isEmpty()) {
            AffineTransform trans;
            composite = AlphaComposite.getInstance(3, this.transpVal);
            for (Tile tile : this.prevLayer.tileList) {
                trans = new AffineTransform();
                trans.setTransform(this.identity);
                trans.rotate(tile.GetRotation(), tile.GetPosX() + tile.GetWidth() / 2, tile.GetPosY() + tile.GetHeight() / 2);
                trans.translate(tile.GetPosX(), tile.GetPosY());
                image = tile.tileImage.image;
                g2d.setComposite(composite);
                g2d.drawImage(image, trans, this);
                if (!this.outLineEnabled || tile.GetOutlineColor() == null) continue;
                if (tile.GetRotation() == 0.0 || tile.GetRotation() == Math.PI) {
                    olX = tile.GetPosX();
                    olY = tile.GetPosY();
                    olWidth = tile.GetWidth();
                    olHeight = tile.GetHeight();
                } else {
                    olX = tile.GetPosX() + tile.GetWidth() / 2 - tile.GetHeight() / 2;
                    olY = tile.GetPosY() + tile.GetHeight() / 2 - tile.GetWidth() / 2;
                    olWidth = tile.GetHeight();
                    olHeight = tile.GetWidth();
                }
                g2d.setColor(tile.GetOutlineColor());
                g2d.setStroke(new BasicStroke(3.0f));
                g2d.setComposite(composite);
                g2d.drawRect(olX, olY, olWidth, olHeight);
            }
            for (Tile stairRamp : this.prevLayer.stairsRampsList) {
                trans = new AffineTransform();
                trans.setTransform(this.identity);
                trans.rotate(stairRamp.GetRotation(), stairRamp.GetPosX() + stairRamp.GetWidth() / 2, stairRamp.GetPosY() + stairRamp.GetHeight() / 2);
                trans.translate(stairRamp.GetPosX(), stairRamp.GetPosY());
                image = stairRamp.tileImage.image;
                g2d.setComposite(composite);
                g2d.drawImage(image, trans, this);
            }
            for (Tile balcony : this.prevLayer.balconyList) {
                trans = new AffineTransform();
                trans.setTransform(this.identity);
                trans.rotate(balcony.GetRotation(), balcony.GetPosX() + balcony.GetWidth() / 2, balcony.GetPosY() + balcony.GetHeight() / 2);
                trans.translate(balcony.GetPosX(), balcony.GetPosY());
                image = balcony.tileImage.image;
                g2d.setComposite(composite);
                g2d.drawImage(image, trans, this);
            }
            for (Tile wall : this.prevLayer.wallsList) {
                trans = new AffineTransform();
                trans.setTransform(this.identity);
                trans.rotate(wall.GetRotation(), wall.GetPosX() + wall.GetWidth() / 2, wall.GetPosY() + wall.GetHeight() / 2);
                trans.translate(wall.GetPosX(), wall.GetPosY());
                image = wall.tileImage.image;
                g2d.setComposite(composite);
                g2d.drawImage(image, trans, this);
            }
            for (Tile railing : this.prevLayer.railingList) {
                trans = new AffineTransform();
                trans.setTransform(this.identity);
                trans.rotate(railing.GetRotation(), railing.GetPosX() + railing.GetWidth() / 2, railing.GetPosY() + railing.GetHeight() / 2);
                trans.translate(railing.GetPosX(), railing.GetPosY());
                image = railing.tileImage.image;
                g2d.setComposite(composite);
                g2d.drawImage(image, trans, this);
            }
            for (Tile post : this.prevLayer.postsList) {
                trans = new AffineTransform();
                trans.setTransform(this.identity);
                trans.rotate(post.GetRotation(), post.GetPosX() + post.GetWidth() / 2, post.GetPosY() + post.GetHeight() / 2);
                trans.translate(post.GetPosX(), post.GetPosY());
                image = post.tileImage.image;
                g2d.setComposite(composite);
                g2d.drawImage(image, trans, this);
            }
            for (Tile trusses : this.prevLayer.trussesList) {
                trans = new AffineTransform();
                trans.setTransform(this.identity);
                trans.rotate(trusses.GetRotation(), trusses.GetPosX() + trusses.GetWidth() / 2, trusses.GetPosY() + trusses.GetHeight() / 2);
                trans.translate(trusses.GetPosX(), trusses.GetPosY());
                image = trusses.tileImage.image;
                g2d.setComposite(composite);
                g2d.drawImage(image, trans, this);
            }
            for (Tile roofing : this.prevLayer.roofingList) {
                trans = new AffineTransform();
                trans.setTransform(this.identity);
                trans.rotate(roofing.GetRotation(), roofing.GetPosX() + roofing.GetWidth() / 2, roofing.GetPosY() + roofing.GetHeight() / 2);
                trans.translate(roofing.GetPosX(), roofing.GetPosY());
                image = roofing.tileImage.image;
                g2d.setComposite(composite);
                g2d.drawImage(image, trans, this);
            }
            for (Tile genSymb : this.prevLayer.genSymbList) {
                trans = new AffineTransform();
                trans.setTransform(this.identity);
                trans.rotate(genSymb.GetRotation(), genSymb.GetPosX() + genSymb.GetWidth() / 2, genSymb.GetPosY() + genSymb.GetHeight() / 2);
                trans.translate(genSymb.GetPosX(), genSymb.GetPosY());
                image = genSymb.tileImage.image;
                g2d.setComposite(composite);
                g2d.drawImage(image, trans, this);
            }
            if (this.boundingBox != null && this.boundingBox.width != 0 && this.boundingBox.height != 0) {
                g2d.setStroke(new BasicStroke(1.0f));
                g2d.setColor(Color.WHITE);
                g2d.drawRect(this.boundingBox.x, this.boundingBox.y, this.boundingBox.width, this.boundingBox.height);
            }
            if (this.selectedArea != null && this.selectedArea.width != 0 && this.selectedArea.height != 0) {
                g2d.setStroke(new BasicStroke(3.0f));
                g2d.setColor(Color.LIGHT_GRAY);
                g2d.drawRect(this.selectedArea.x, this.selectedArea.y, this.selectedArea.width, this.selectedArea.height);
            }
        }
        if (this.tileState != elementState.HIDDEN) {
            int i = 0;
            while (i < this.tileList.size()) {
                AffineTransform trans = new AffineTransform();
                trans.setTransform(this.identity);
                trans.rotate(this.tileList.get(i).GetRotation(), this.tileList.get(i).GetPosX() + this.tileList.get(i).GetWidth() / 2, this.tileList.get(i).GetPosY() + this.tileList.get(i).GetHeight() / 2);
                trans.translate(this.tileList.get(i).GetPosX(), this.tileList.get(i).GetPosY());
                g2d.setComposite(AlphaComposite.getInstance(10));
                g2d.drawImage(this.tileList.get((int)i).tileImage.image, trans, this);
                ++i;
            }
        }
        if (this.gridenabled) {
            g2d.setStroke(new BasicStroke(1.0f));
            AlphaComposite composite3 = AlphaComposite.getInstance(3, 0.3f);
            g2d.setComposite(composite3);
            g2d.setColor(Color.decode("0x000000"));
            int c = 0;
            while (c < this.getWidth()) {
                g2d.drawLine(c, 0, c, this.getHeight());
                c += this.GridWidth;
            }
            int r = 0;
            while (r < this.getHeight()) {
                g2d.drawLine(0, r, this.getWidth(), r);
                r += this.GridHeight;
            }
        }
        g2d.setComposite(AlphaComposite.getInstance(2));
        if (this.outLineEnabled) {
            int i = 0;
            while (i < this.tileList.size()) {
                AffineTransform trans = new AffineTransform();
                trans.setTransform(this.identity);
                trans.rotate(this.tileList.get(i).GetRotation(), this.tileList.get(i).GetPosX() + this.tileList.get(i).GetWidth() / 2, this.tileList.get(i).GetPosY() + this.tileList.get(i).GetHeight() / 2);
                trans.translate(this.tileList.get(i).GetPosX(), this.tileList.get(i).GetPosY());
                if (this.tileList.get(i).GetOutlineColor() != null) {
                    if (this.tileList.get(i).GetRotation() == 0.0 || this.tileList.get(i).GetRotation() == Math.PI) {
                        olX = this.tileList.get(i).GetPosX();
                        olY = this.tileList.get(i).GetPosY();
                        olWidth = this.tileList.get(i).GetWidth();
                        olHeight = this.tileList.get(i).GetHeight();
                    } else if (this.tileList.get(i).GetRotation() == Math.toRadians(45.0) || this.tileList.get(i).GetRotation() == Math.toRadians(135.0) || this.tileList.get(i).GetRotation() == Math.toRadians(225.0) || this.tileList.get(i).GetRotation() == Math.toRadians(315.0)) {
                        int centerx = this.tileList.get(i).GetPosX() + this.tileList.get(i).GetWidth() / 2;
                        int centery = this.tileList.get(i).GetPosY() + this.tileList.get(i).GetHeight() / 2;
                        olX = centerx - (int)(Math.cos(45.0) * (double)this.tileList.get(i).GetWidth()) / 2;
                        olY = centerx + (int)(Math.cos(45.0) * (double)this.tileList.get(i).GetWidth()) / 2;
                        olWidth = centery - (int)(Math.cos(45.0) * (double)this.tileList.get(i).GetWidth());
                        olHeight = centery + (int)(Math.cos(45.0) * (double)this.tileList.get(i).GetWidth());
                    } else {
                        olX = this.tileList.get(i).GetPosX() + this.tileList.get(i).GetWidth() / 2 - this.tileList.get(i).GetHeight() / 2;
                        olY = this.tileList.get(i).GetPosY() + this.tileList.get(i).GetHeight() / 2 - this.tileList.get(i).GetWidth() / 2;
                        olWidth = this.tileList.get(i).GetHeight();
                        olHeight = this.tileList.get(i).GetWidth();
                    }
                    g2d.setColor(this.tileList.get(i).GetOutlineColor());
                    g2d.setStroke(new BasicStroke(3.0f));
                    g2d.drawRect(olX, olY, olWidth, olHeight);
                }
                ++i;
            }
        }
        if (this.symbolState != elementState.HIDDEN) {
            for (Tile stairRamp : this.stairsRampsList) {
                AffineTransform trans = new AffineTransform();
                trans.setTransform(this.identity);
                trans.rotate(stairRamp.GetRotation(), stairRamp.GetPosX() + stairRamp.GetWidth() / 2, stairRamp.GetPosY() + stairRamp.GetHeight() / 2);
                trans.translate(stairRamp.GetPosX(), stairRamp.GetPosY());
                Image image2 = stairRamp.tileImage.image;
                g2d.setComposite(AlphaComposite.getInstance(10));
                g2d.drawImage(image2, trans, this);
            }
            for (Tile balcony : this.balconyList) {
                AffineTransform trans = new AffineTransform();
                trans.setTransform(this.identity);
                trans.rotate(balcony.GetRotation(), balcony.GetPosX() + balcony.GetWidth() / 2, balcony.GetPosY() + balcony.GetHeight() / 2);
                trans.translate(balcony.GetPosX(), balcony.GetPosY());
                Image image3 = balcony.tileImage.image;
                g2d.setComposite(AlphaComposite.getInstance(10));
                g2d.drawImage(image3, trans, this);
            }
            for (Tile wall : this.wallsList) {
                AffineTransform trans = new AffineTransform();
                trans.setTransform(this.identity);
                trans.rotate(wall.GetRotation(), wall.GetPosX() + wall.GetWidth() / 2, wall.GetPosY() + wall.GetHeight() / 2);
                trans.translate(wall.GetPosX(), wall.GetPosY());
                Image image4 = wall.tileImage.image;
                g2d.setComposite(AlphaComposite.getInstance(10));
                g2d.drawImage(image4, trans, this);
            }
            for (Tile railing : this.railingList) {
                AffineTransform trans = new AffineTransform();
                trans.setTransform(this.identity);
                trans.rotate(railing.GetRotation(), railing.GetPosX() + railing.GetWidth() / 2, railing.GetPosY() + railing.GetHeight() / 2);
                trans.translate(railing.GetPosX(), railing.GetPosY());
                Image image5 = railing.tileImage.image;
                g2d.setComposite(AlphaComposite.getInstance(10));
                g2d.drawImage(image5, trans, this);
            }
            for (Tile post : this.postsList) {
                AffineTransform trans = new AffineTransform();
                trans.setTransform(this.identity);
                trans.rotate(post.GetRotation(), post.GetPosX() + post.GetWidth() / 2, post.GetPosY() + post.GetHeight() / 2);
                trans.translate(post.GetPosX(), post.GetPosY());
                Image image6 = post.tileImage.image;
                g2d.setComposite(AlphaComposite.getInstance(10));
                g2d.drawImage(image6, trans, this);
            }
            for (Tile trusses : this.trussesList) {
                AffineTransform trans = new AffineTransform();
                trans.setTransform(this.identity);
                trans.rotate(trusses.GetRotation(), trusses.GetPosX() + trusses.GetWidth() / 2, trusses.GetPosY() + trusses.GetHeight() / 2);
                trans.translate(trusses.GetPosX(), trusses.GetPosY());
                Image image7 = trusses.tileImage.image;
                g2d.setComposite(AlphaComposite.getInstance(10));
                g2d.drawImage(image7, trans, this);
            }
            for (Tile roofing : this.roofingList) {
                AffineTransform trans = new AffineTransform();
                trans.setTransform(this.identity);
                trans.rotate(roofing.GetRotation(), roofing.GetPosX() + roofing.GetWidth() / 2, roofing.GetPosY() + roofing.GetHeight() / 2);
                trans.translate(roofing.GetPosX(), roofing.GetPosY());
                Image image8 = roofing.tileImage.image;
                g2d.setComposite(AlphaComposite.getInstance(3, 0.75f));
                g2d.drawImage(image8, trans, this);
            }
            for (Tile genSymb : this.genSymbList) {
                AffineTransform trans = new AffineTransform();
                trans.setTransform(this.identity);
                trans.rotate(genSymb.GetRotation(), genSymb.GetPosX() + genSymb.GetWidth() / 2, genSymb.GetPosY() + genSymb.GetHeight() / 2);
                trans.translate(genSymb.GetPosX(), genSymb.GetPosY());
                Image image9 = genSymb.tileImage.image;
                g2d.setComposite(AlphaComposite.getInstance(10));
                g2d.drawImage(image9, trans, this);
            }
        }
        if (this.boundingBox != null && this.boundingBox.width != 0 && this.boundingBox.height != 0) {
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.setColor(Color.WHITE);
            g2d.drawRect(this.boundingBox.x, this.boundingBox.y, this.boundingBox.width, this.boundingBox.height);
        }
        if (this.selectedArea != null && this.selectedArea.width != 0 && this.selectedArea.height != 0) {
            g2d.setStroke(new BasicStroke(3.0f));
            g2d.setColor(Color.LIGHT_GRAY);
            g2d.drawRect(this.selectedArea.x, this.selectedArea.y, this.selectedArea.width, this.selectedArea.height);
        }
        if (this.nextLayer != null && this.showNextLayer && !this.nextLayer.isEmpty()) {
            AlphaComposite composite4 = AlphaComposite.getInstance(3, this.transpVal);
            for (Tile tile : this.nextLayer.tileList) {
                AffineTransform trans = new AffineTransform();
                trans.setTransform(this.identity);
                trans.rotate(tile.GetRotation(), tile.GetPosX() + tile.GetWidth() / 2, tile.GetPosY() + tile.GetHeight() / 2);
                trans.translate(tile.GetPosX(), tile.GetPosY());
                image = tile.tileImage.image;
                g2d.setComposite(composite4);
                g2d.drawImage(image, trans, this);
                if (!this.outLineEnabled || tile.GetOutlineColor() == null) continue;
                if (tile.GetRotation() == 0.0 || tile.GetRotation() == Math.PI) {
                    olX = tile.GetPosX();
                    olY = tile.GetPosY();
                    olWidth = tile.GetWidth();
                    olHeight = tile.GetHeight();
                } else {
                    olX = tile.GetPosX() + tile.GetWidth() / 2 - tile.GetHeight() / 2;
                    olY = tile.GetPosY() + tile.GetHeight() / 2 - tile.GetWidth() / 2;
                    olWidth = tile.GetHeight();
                    olHeight = tile.GetWidth();
                }
                g2d.setColor(tile.GetOutlineColor());
                g2d.setStroke(new BasicStroke(3.0f));
                g2d.setComposite(composite4);
                g2d.drawRect(olX, olY, olWidth, olHeight);
            }
            for (Tile stairRamp : this.nextLayer.stairsRampsList) {
                AffineTransform trans = new AffineTransform();
                trans.setTransform(this.identity);
                trans.rotate(stairRamp.GetRotation(), stairRamp.GetPosX() + stairRamp.GetWidth() / 2, stairRamp.GetPosY() + stairRamp.GetHeight() / 2);
                trans.translate(stairRamp.GetPosX(), stairRamp.GetPosY());
                image = stairRamp.tileImage.image;
                g2d.setComposite(composite4);
                g2d.drawImage(image, trans, this);
            }
            for (Tile balcony : this.nextLayer.balconyList) {
                AffineTransform trans = new AffineTransform();
                trans.setTransform(this.identity);
                trans.rotate(balcony.GetRotation(), balcony.GetPosX() + balcony.GetWidth() / 2, balcony.GetPosY() + balcony.GetHeight() / 2);
                trans.translate(balcony.GetPosX(), balcony.GetPosY());
                image = balcony.tileImage.image;
                g2d.setComposite(composite4);
                g2d.drawImage(image, trans, this);
            }
            for (Tile wall : this.nextLayer.wallsList) {
                AffineTransform trans = new AffineTransform();
                trans.setTransform(this.identity);
                trans.rotate(wall.GetRotation(), wall.GetPosX() + wall.GetWidth() / 2, wall.GetPosY() + wall.GetHeight() / 2);
                trans.translate(wall.GetPosX(), wall.GetPosY());
                image = wall.tileImage.image;
                g2d.setComposite(composite4);
                g2d.drawImage(image, trans, this);
            }
            for (Tile railing : this.nextLayer.railingList) {
                AffineTransform trans = new AffineTransform();
                trans.setTransform(this.identity);
                trans.rotate(railing.GetRotation(), railing.GetPosX() + railing.GetWidth() / 2, railing.GetPosY() + railing.GetHeight() / 2);
                trans.translate(railing.GetPosX(), railing.GetPosY());
                image = railing.tileImage.image;
                g2d.setComposite(composite4);
                g2d.drawImage(image, trans, this);
            }
            for (Tile post : this.nextLayer.postsList) {
                AffineTransform trans = new AffineTransform();
                trans.setTransform(this.identity);
                trans.rotate(post.GetRotation(), post.GetPosX() + post.GetWidth() / 2, post.GetPosY() + post.GetHeight() / 2);
                trans.translate(post.GetPosX(), post.GetPosY());
                image = post.tileImage.image;
                g2d.setComposite(composite4);
                g2d.drawImage(image, trans, this);
            }
            for (Tile trusses : this.nextLayer.trussesList) {
                AffineTransform trans = new AffineTransform();
                trans.setTransform(this.identity);
                trans.rotate(trusses.GetRotation(), trusses.GetPosX() + trusses.GetWidth() / 2, trusses.GetPosY() + trusses.GetHeight() / 2);
                trans.translate(trusses.GetPosX(), trusses.GetPosY());
                image = trusses.tileImage.image;
                g2d.setComposite(composite4);
                g2d.drawImage(image, trans, this);
            }
            for (Tile roofing : this.nextLayer.roofingList) {
                AffineTransform trans = new AffineTransform();
                trans.setTransform(this.identity);
                trans.rotate(roofing.GetRotation(), roofing.GetPosX() + roofing.GetWidth() / 2, roofing.GetPosY() + roofing.GetHeight() / 2);
                trans.translate(roofing.GetPosX(), roofing.GetPosY());
                image = roofing.tileImage.image;
                g2d.setComposite(composite4);
                g2d.drawImage(image, trans, this);
            }
            for (Tile genSymb : this.nextLayer.genSymbList) {
                AffineTransform trans = new AffineTransform();
                trans.setTransform(this.identity);
                trans.rotate(genSymb.GetRotation(), genSymb.GetPosX() + genSymb.GetWidth() / 2, genSymb.GetPosY() + genSymb.GetHeight() / 2);
                trans.translate(genSymb.GetPosX(), genSymb.GetPosY());
                image = genSymb.tileImage.image;
                g2d.setComposite(composite4);
                g2d.drawImage(image, trans, this);
            }
        }
        g2d.setComposite(AlphaComposite.getInstance(10));
        if (this.boundingBox != null && this.boundingBox.width != 0 && this.boundingBox.height != 0) {
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.setColor(Color.WHITE);
            g2d.drawRect(this.boundingBox.x, this.boundingBox.y, this.boundingBox.width, this.boundingBox.height);
        }
        if (this.selectedArea != null && this.selectedArea.width != 0 && this.selectedArea.height != 0) {
            g2d.setStroke(new BasicStroke(3.0f));
            g2d.setColor(Color.LIGHT_GRAY);
            g2d.drawRect(this.selectedArea.x, this.selectedArea.y, this.selectedArea.width, this.selectedArea.height);
        }
    }

    public static enum elementState {
        LOCKED,
        UNLOCKED,
        HIDDEN;

    }
}

