/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

class SplashWindow
extends JWindow {
    private int totaltime;

    public SplashWindow(Image image, final Frame f, int waitTime) {
        super(f);
        JLabel l = new JLabel(new ImageIcon(image));
        this.getContentPane().add((Component)l, "Center");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension labelSize = l.getPreferredSize();
        this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
        final int pause = waitTime;
        final Runnable closerRunner = new Runnable(){

            @Override
            public void run() {
                SplashWindow.this.setVisible(false);
                f.setVisible(true);
                SplashWindow.this.dispose();
            }
        };
        Runnable waitRunner = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(pause);
                    SwingUtilities.invokeAndWait(closerRunner);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.setVisible(true);
        this.toFront();
        Thread splashThread = new Thread(waitRunner, "SplashThread");
        splashThread.start();
    }
}

