/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicButtonUI;

public class TabComponent
extends JPanel {
    private final JTabbedPane pane;
    public JButton button;
    public JTextField textfield;
    ZipSource jar;
    private static final MouseListener buttonMouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
            }
        }
    };

    public TabComponent(JTabbedPane pane, ActionListener listener, ZipSource jar) {
        super(new FlowLayout(0, 0, 0));
        if (pane == null) {
            throw new NullPointerException("TabbedPane is null");
        }
        this.pane = pane;
        this.setOpaque(false);
        this.setName("buttonTabComponent");
        this.jar = jar;
        this.textfield = new JTextField(5){};
        this.add(this.textfield);
        this.textfield.addActionListener(listener);
        this.textfield.setActionCommand("Tab Title");
        this.textfield.addKeyListener((KeyListener)((Object)listener));
        this.button = new TabButton(jar);
        this.button.addActionListener(listener);
        this.button.setActionCommand("Remove Tab");
        this.add(this.button);
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
    }

    private class TabButton
    extends JButton {
        ZipSource jar;

        public TabButton(ZipSource jar) {
            int size = 17;
            this.setPreferredSize(new Dimension(23, 18));
            this.setToolTipText("close this tab");
            this.setUI(new BasicButtonUI());
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setBorderPainted(false);
            this.addMouseListener(buttonMouseListener);
            this.setRolloverEnabled(true);
            this.jar = jar;
        }

        @Override
        public void updateUI() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g.create();
            if (this.getModel().isPressed()) {
                g2.translate(1, 1);
            }
            g2.drawImage(new ImageIcon(this.jar.getResource("minus_button.gif")).getImage(), 6, 1, null);
            g2.dispose();
        }
    }
}

