/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.io.Serializable;

class Tile
implements Serializable {
    private int posX;
    private int posY;
    private double rotation;
    private String imageName;
    private int width;
    private int height;
    private Color outlineColor;
    private String setName;
    private AffineTransform identity = new AffineTransform();
    private boolean hasAlpha;
    public String tileType = "";
    public String tileName = "";
    public transient WWEImage tileImage;

    public Tile(int x, int y, double rot, String name) {
        this.posX = x;
        this.posY = y;
        this.rotation = rot;
        this.imageName = name;
        this.outlineColor = null;
    }

    public Tile(Tile copy) {
        this.posX = copy.GetPosX();
        this.posY = copy.GetPosY();
        this.rotation = copy.GetRotation();
        this.imageName = copy.GetImageName();
        this.width = copy.GetWidth();
        this.height = copy.GetHeight();
        this.outlineColor = copy.GetOutlineColor();
        this.setName = copy.GetSetName();
        this.tileType = copy.tileType;
        this.tileName = copy.tileName;
        this.tileImage = copy.tileImage;
        this.hasAlpha = copy.GetHasAlpha();
    }

    public void SetWidth(int w) {
        this.width = w;
    }

    public int GetWidth() {
        return this.width;
    }

    public void SetHeight(int h) {
        this.height = h;
    }

    public int GetHeight() {
        return this.height;
    }

    public double GetRotation() {
        return this.rotation;
    }

    public void SetRotation(double rot) {
        this.rotation = rot;
    }

    public void Rotate(double delta) {
        this.rotation += delta;
        if (this.rotation >= Math.PI * 2) {
            this.rotation -= Math.PI * 2;
        } else if (this.rotation < 0.0) {
            this.rotation += Math.PI * 2;
        }
    }

    public void SetPosition(int x, int y) {
        this.posX = x;
        this.posY = y;
    }

    public int GetPosX() {
        return this.posX;
    }

    public int GetPosY() {
        return this.posY;
    }

    public void SetPosX(int x) {
        this.posX = x;
    }

    public void SetPosY(int y) {
        this.posY = y;
    }

    public void Move(int deltax, int deltay) {
        this.posX += deltax;
        this.posY += deltay;
    }

    public String GetImageName() {
        return this.imageName;
    }

    public Color GetOutlineColor() {
        return this.outlineColor;
    }

    public void SetOutlineColor(Color color) {
        this.outlineColor = color;
    }

    public void SetSetName(String name) {
        this.setName = name;
    }

    public String GetSetName() {
        return this.setName;
    }

    public boolean GetHasAlpha() {
        return this.hasAlpha;
    }

    public void SetHasAlpha(boolean alpha) {
        this.hasAlpha = alpha;
    }
}

