/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public final class ZipSource {
    public boolean debugOn = false;
    private Hashtable htSizes = new Hashtable();
    private Hashtable htJarContents = new Hashtable();
    public String setName = "";
    private String jarFileName;

    public ZipSource(String jarFileName) {
        this.jarFileName = jarFileName;
        this.init();
    }

    public byte[] getResource(String name) {
        return (byte[])this.htJarContents.get(name);
    }

    private void init() {
        try {
            ZipFile zf = new ZipFile(this.jarFileName);
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                if (this.debugOn) {
                    System.out.println(this.dumpZipEntry(ze));
                }
                this.htSizes.put(ze.getName(), new Integer((int)ze.getSize()));
            }
            zf.close();
            FileInputStream fis = new FileInputStream(this.jarFileName);
            BufferedInputStream bis = new BufferedInputStream(fis);
            ZipInputStream zis = new ZipInputStream(bis);
            ZipEntry ze = null;
            while ((ze = zis.getNextEntry()) != null) {
                int size;
                if (ze.isDirectory()) continue;
                if (this.debugOn) {
                    System.out.println("ze.getName()=" + ze.getName() + "," + "getSize()=" + ze.getSize());
                }
                if ((size = (int)ze.getSize()) == -1) {
                    size = (Integer)this.htSizes.get(ze.getName());
                }
                byte[] b = new byte[size];
                int rb = 0;
                int chunk = 0;
                while (size - rb > 0) {
                    chunk = zis.read(b, rb, size - rb);
                    if (chunk == -1) break;
                    rb += chunk;
                }
                this.htJarContents.put(ze.getName(), b);
                if (!this.debugOn) continue;
                System.out.println(String.valueOf(ze.getName()) + "  rb=" + rb + ",size=" + size + ",csize=" + ze.getCompressedSize());
            }
        }
        catch (NullPointerException e) {
            System.out.println("done.");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String dumpZipEntry(ZipEntry ze) {
        StringBuffer sb = new StringBuffer();
        if (ze.isDirectory()) {
            sb.append("d ");
        } else {
            sb.append("f ");
        }
        if (ze.getMethod() == 0) {
            sb.append("stored   ");
        } else {
            sb.append("defalted ");
        }
        sb.append(ze.getName());
        sb.append("\t");
        sb.append("" + ze.getSize());
        if (ze.getMethod() == 8) {
            sb.append("/" + ze.getCompressedSize());
        }
        return sb.toString();
    }
}

