/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.encoding;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.ISO8859_16Encoding;
import org.jcodings.specific.ISO8859_1Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.encoding.ISO_8859_16;
import org.jruby.util.encoding.RubyCoderResult;
import org.jruby.util.encoding.Transcoder;
import org.jruby.util.io.EncodingUtils;
import org.jruby.util.unsafe.UnsafeHolder;

public class CharsetTranscoder
extends Transcoder {
    private static Set<String> BAD_TRANSCODINGS_HACK = new HashSet<String>();
    private static final int MAX_ARRAY_SIZE;
    private CodingActions actions;
    private TranscoderEngine transcoder;
    private RaiseException lastError;
    public static final String[] XMLTextCharacterTranslator;
    public static final String[] XMLAttrCharacterTranslator;
    public static final Set<Charset> UNICODE_CHARSETS;

    public CharsetTranscoder(ThreadContext context, Encoding outEncoding, Encoding inEncoding) {
        this(context, outEncoding, inEncoding, CharsetTranscoder.processCodingErrorActions(context, null));
    }

    public CharsetTranscoder(ThreadContext context, Encoding outEncoding, Encoding inEncoding, int flags, IRubyObject replace2) {
        this(context, outEncoding, inEncoding, CharsetTranscoder.processCodingErrorActions(context, flags, replace2));
    }

    public CharsetTranscoder(ThreadContext context, Encoding outEncoding, Encoding inEncoding, CodingActions actions) {
        super(context, outEncoding, inEncoding);
        this.actions = actions == null ? CharsetTranscoder.processCodingErrorActions(context, null) : actions;
    }

    public static CharsetTranscoder open(ThreadContext context, byte[] sourceEncoding, byte[] destinationEncoding, int flags, IRubyObject replace2) {
        EncodingDB.Entry src = context.runtime.getEncodingService().findEncodingOrAliasEntry(new ByteList(sourceEncoding, false));
        EncodingDB.Entry dest = context.runtime.getEncodingService().findEncodingOrAliasEntry(new ByteList(destinationEncoding, false));
        if (src == null && dest == null) {
            return new CharsetTranscoder(context, ASCIIEncoding.INSTANCE, ASCIIEncoding.INSTANCE, flags, replace2);
        }
        return new CharsetTranscoder(context, dest.getEncoding(), src.getEncoding(), flags, replace2);
    }

    public static ByteList transcode(ThreadContext context, ByteList value2, Encoding fromEncoding, Encoding toEncoding, IRubyObject opts) {
        if (toEncoding == null) {
            return value2;
        }
        if (fromEncoding == null) {
            fromEncoding = value2.getEncoding();
        }
        if (fromEncoding == toEncoding) {
            return value2;
        }
        return new CharsetTranscoder(context, toEncoding, fromEncoding, CharsetTranscoder.processCodingErrorActions(context, opts)).transcode(context, value2, false);
    }

    public static ByteList transcode(ThreadContext context, ByteList value2, Encoding fromEncoding, Encoding toEncoding, IRubyObject opts, boolean is7BitASCII) {
        if (toEncoding == null) {
            return value2;
        }
        if (fromEncoding == null) {
            fromEncoding = value2.getEncoding();
        }
        if (fromEncoding == toEncoding) {
            return value2;
        }
        return new CharsetTranscoder(context, toEncoding, fromEncoding, CharsetTranscoder.processCodingErrorActions(context, opts)).transcode(context, value2, is7BitASCII);
    }

    public static ByteList strTranscode(ThreadContext context, RubyString self2, Encoding fromEncoding, Encoding toEncoding, IRubyObject opt) {
        int ecflags = 0;
        IRubyObject[] ecopts_p = new IRubyObject[1];
        if (!opt.isNil()) {
            ecflags = EncodingUtils.econvPrepareOpts(context, opt, ecopts_p);
        }
        return CharsetTranscoder.strTranscode0(context, self2, fromEncoding, toEncoding, ecflags, ecopts_p[0]);
    }

    public static ByteList strTranscode0(ThreadContext context, RubyString self2, Encoding senc, Encoding denc, int ecflags, IRubyObject ecopts) {
        IRubyObject replace2;
        ByteList selfByteList = self2.getByteList();
        boolean is7BitASCII = self2.isCodeRangeAsciiOnly();
        IRubyObject iRubyObject = replace2 = ecopts != null && !ecopts.isNil() ? ((RubyHash)ecopts).op_aref(context, context.runtime.newSymbol("replace")) : context.nil;
        if ((ecflags & 0x10FF00) == 0) {
            if (senc != null && senc == denc) {
                if ((ecflags & 0xF) != 0) {
                    return selfByteList;
                }
                return selfByteList;
            }
            if (senc != null && denc != null && senc.isAsciiCompatible() && denc.isAsciiCompatible() && self2.scanForCodeRange() == 32) {
                ByteList value2 = selfByteList.shallowDup();
                value2.setEncoding(denc);
                return value2;
            }
        }
        return new CharsetTranscoder(context, denc, senc, CharsetTranscoder.processCodingErrorActions(context, ecflags, replace2)).transcode(context, selfByteList, is7BitASCII);
    }

    @Override
    public RubyCoderResult transcode(ThreadContext context, ByteList value2, ByteList dest) {
        Encoding fromEncoding = this.inEncoding != null ? this.inEncoding : value2.getEncoding();
        return this.transcode(context, value2, dest, fromEncoding, false, true);
    }

    @Override
    public RubyCoderResult econvConvert(ThreadContext context, ByteList inBuffer, ByteList outBuffer) {
        Encoding fromEncoding = this.inEncoding != null ? this.inEncoding : inBuffer.getEncoding();
        this.primitiveConvert(context, inBuffer.shallowDup(), outBuffer, 0, -1, fromEncoding, false, this.actions.ecflags);
        if (this.lastResult != null) {
            this.createLastError();
        } else {
            outBuffer.append(this.finish(inBuffer.getEncoding()));
        }
        return this.lastResult;
    }

    @Override
    public ByteList transcode(ThreadContext context, ByteList value2) {
        ByteList dest = new ByteList();
        this.transcode(context, value2, dest);
        return dest;
    }

    @Override
    public ByteList transcode(ThreadContext context, ByteList value2, boolean is7BitASCII) {
        Encoding fromEncoding = this.inEncoding != null ? this.inEncoding : value2.getEncoding();
        ByteList result2 = new ByteList();
        this.transcode(context, value2, result2, fromEncoding, is7BitASCII, true);
        return result2;
    }

    @Override
    public ByteList convert(ThreadContext context, ByteList value2, boolean is7BitASCII) {
        Encoding fromEncoding = this.inEncoding != null ? this.inEncoding : value2.getEncoding();
        ByteList result2 = new ByteList();
        this.transcode(context, value2, result2, fromEncoding, is7BitASCII, false);
        this.lastResult = new RubyCoderResult("finished", fromEncoding, this.outEncoding, null, null);
        return result2;
    }

    @Override
    public ByteList econvStrConvert(ThreadContext context, ByteList value2, boolean finish2) {
        Encoding fromEncoding = this.inEncoding != null ? this.inEncoding : value2.getEncoding();
        ByteList result2 = new ByteList();
        this.transcode(context, value2, result2, fromEncoding, false, finish2);
        this.lastResult = new RubyCoderResult("finished", fromEncoding, this.outEncoding, null, null);
        return result2;
    }

    private RubyCoderResult transcode(ThreadContext context, ByteList inBuffer, ByteList outBuffer, Encoding inEncoding, boolean is7BitASCII, boolean finish2) {
        this.primitiveConvert(context, inBuffer.shallowDup(), outBuffer, 0, -1, inEncoding, is7BitASCII, this.actions.ecflags);
        if (this.lastResult != null) {
            this.createLastError();
            if (this.lastError != null) {
                throw this.lastError;
            }
        }
        if (finish2) {
            outBuffer.append(this.finish(inBuffer.getEncoding()));
        }
        return this.lastResult;
    }

    @Override
    public RubyCoderResult primitiveConvert(ThreadContext context, ByteList inBuffer, ByteList outBuffer, int outOffset, int outLimit, Encoding inEncoding, boolean is7BitASCII, int flags) {
        Ruby runtime = context.runtime;
        Encoding outEncoding = this.outEncoding != null ? this.outEncoding : inBuffer.getEncoding();
        ByteBuffer inBytes = ByteBuffer.wrap(inBuffer.getUnsafeBytes(), inBuffer.begin(), inBuffer.length());
        boolean growable = true;
        if (outLimit > 0) {
            growable = false;
        } else {
            outLimit = outBuffer.getRealSize();
        }
        int realOffset = outBuffer.getBegin() + outOffset;
        ByteBuffer outBytes = ByteBuffer.wrap(outBuffer.getUnsafeBytes(), realOffset, outLimit - outOffset);
        if (this.transcoder == null || outEncoding != this.outEncoding || inEncoding != this.inEncoding) {
            this.createTranscoder(inEncoding, outEncoding, this.actions, is7BitASCII);
        }
        TranscoderEngine transcoderEngine = this.transcoder;
        transcoderEngine.getClass();
        TranscoderEngine.TranscoderState state2 = transcoderEngine.new TranscoderEngine.TranscoderState(inBytes, outBytes, growable);
        this.lastResult = this.transcoder.transcode(state2, flags);
        inBuffer.setBegin(inBytes.position());
        inBuffer.setRealSize(inBytes.remaining());
        outBytes = state2.outBytes;
        if (outOffset == outBuffer.getRealSize()) {
            outBuffer.append(Arrays.copyOfRange(outBytes.array(), realOffset, outBytes.limit()));
        } else {
            outBuffer.replace(outOffset, outLimit - outOffset, Arrays.copyOfRange(outBytes.array(), realOffset, outBytes.limit()));
        }
        outBuffer.setEncoding(outEncoding);
        return this.lastResult;
    }

    @Override
    public ByteList finish(Encoding altEncoding) {
        Encoding outEncoding;
        Encoding encoding2 = outEncoding = this.outEncoding != null ? this.outEncoding : altEncoding;
        if (this.transcoder == null) {
            return new ByteList();
        }
        ByteList finish2 = this.transcoder.finish();
        finish2.setEncoding(outEncoding);
        this.transcoder.reset();
        return finish2;
    }

    @Override
    public RubyCoderResult getLastResult() {
        return this.lastResult;
    }

    @Override
    public RaiseException getLastError() {
        this.createLastError();
        return this.lastError;
    }

    public String getReplaceWith() {
        if (this.actions.replaceWith == null) {
            if (this.transcoder == null) {
                if (this.outEncoding != null && this.outEncoding.getCharset() != null) {
                    return CharsetTranscoder.replaceStringFromActions(this.actions, this.outEncoding.getCharset());
                }
                return "?";
            }
        } else if (this.transcoder == null) {
            return this.actions.replaceWith;
        }
        return CharsetTranscoder.replaceStringFromActions(this.actions, this.transcoder.encoder.charset());
    }

    private void createLastError() {
        if (this.lastResult != null && this.lastResult.isError()) {
            RubyString errorBytes = this.runtime.newString(new ByteList(this.lastResult.errorBytes, ASCIIEncoding.INSTANCE, true));
            errorBytes.setEncoding(ASCIIEncoding.INSTANCE);
            if (this.lastResult.isInvalid()) {
                this.lastError = this.runtime.newInvalidByteSequenceError("\"" + errorBytes.inspect19().toString() + "\" on " + this.lastResult.inEncoding);
                this.lastError.getException().dataWrapStruct(this.lastResult);
            } else if (this.lastResult.isUndefined()) {
                this.lastError = this.runtime.newUndefinedConversionError("\"" + errorBytes.inspect19().toString() + "\" from " + this.lastResult.inEncoding + " to " + this.lastResult.outEncoding);
                this.lastError.getException().dataWrapStruct(this.lastResult);
            }
        }
    }

    private void createTranscoder(Encoding inEncoding, Encoding outEncoding, CodingActions actions, boolean is7BitASCII) {
        boolean binaryToCharacter = false;
        if (inEncoding == ASCIIEncoding.INSTANCE && outEncoding != ASCIIEncoding.INSTANCE) {
            inEncoding = USASCIIEncoding.INSTANCE;
            actions.onMalformedInput = actions.onUnmappableCharacter;
            binaryToCharacter = true;
        }
        Charset inCharset = CharsetTranscoder.transcodeCharsetFor(this.runtime, inEncoding.getName(), inEncoding, is7BitASCII);
        Charset outCharset = CharsetTranscoder.transcodeCharsetFor(this.runtime, outEncoding.getName(), outEncoding, is7BitASCII);
        this.transcoder = new TranscoderEngine(inCharset, outCharset, binaryToCharacter);
    }

    public static String stringFromCoderResult(CoderResult coderResult, int flags, boolean binaryToCharacter) {
        if (coderResult == null) {
            return "finished";
        }
        if (coderResult.isError()) {
            if (coderResult.isMalformed() && !binaryToCharacter) {
                return "invalid_byte_sequence";
            }
            if (coderResult.isUnmappable() || binaryToCharacter) {
                return "undefined_conversion";
            }
            return "finished";
        }
        if (coderResult.isUnderflow()) {
            if ((flags & 0x10000) == 0) {
                return "incomplete_input";
            }
            return "source_buffer_empty";
        }
        if (coderResult.isOverflow()) {
            return "destination_buffer_full";
        }
        if ((flags & 0x10000) == 0) {
            return "finished";
        }
        return "source_buffer_empty";
    }

    private static String replaceStringFromActions(CodingActions actions, Charset outCharset) {
        String replaceString = actions.replaceWith != null ? actions.replaceWith : (UNICODE_CHARSETS.contains(outCharset) ? "\ufffd" : "?");
        return replaceString;
    }

    public CodingActions getCodingErrorActions() {
        return this.actions;
    }

    public static CodingActions processCodingErrorActions(ThreadContext context, int flags, IRubyObject replace2) {
        if (flags == 0) {
            return new CodingActions(CodingErrorAction.REPORT, CodingErrorAction.REPORT, 0, null);
        }
        CodingErrorAction onMalformedInput = CodingErrorAction.REPORT;
        CodingErrorAction onUnmappableCharacter = CodingErrorAction.REPORT;
        String replaceWith = null;
        if ((flags & 0xF) == 2) {
            onMalformedInput = CodingErrorAction.REPLACE;
        }
        if ((flags & 0xF0) == 32 || (flags & 0xF0) == 48) {
            onUnmappableCharacter = CodingErrorAction.REPLACE;
        }
        if (replace2 != null && !replace2.isNil()) {
            replaceWith = replace2.convertToString().toString();
        }
        return new CodingActions(onUnmappableCharacter, onMalformedInput, flags, replaceWith);
    }

    public static CodingActions processCodingErrorActions(ThreadContext context, IRubyObject opts) {
        if (opts == null || opts.isNil()) {
            return new CodingActions(CodingErrorAction.REPORT, CodingErrorAction.REPORT, 0, null);
        }
        Ruby runtime = context.runtime;
        int flags = 0;
        RubyHash hash2 = opts.convertToHash();
        IRubyObject replace2 = hash2.fastARef(runtime.newSymbol("replace"));
        return CharsetTranscoder.processCodingErrorActions(context, flags |= EncodingUtils.econvPrepareOpts(context, opts, new IRubyObject[]{opts}), replace2);
    }

    public static Charset transcodeCharsetFor(Ruby runtime, byte[] name2, Encoding encoding2, boolean is7Bit) {
        if (encoding2 == null) {
            EncodingDB.Entry entry = runtime.getEncodingService().findEncodingOrAliasEntry(name2);
            if (entry == null) {
                return null;
            }
            encoding2 = entry.getEncoding();
        }
        if (encoding2 == ASCIIEncoding.INSTANCE) {
            return ISO8859_1Encoding.INSTANCE.getCharset();
        }
        Charset from = null;
        String realEncodingName = new String(encoding2.getName());
        if (!realEncodingName.equals(encoding2.getCharsetName()) && !BAD_TRANSCODINGS_HACK.contains(realEncodingName)) {
            try {
                from = Charset.forName(realEncodingName);
                if (from != null) {
                    return from;
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        try {
            from = encoding2.getCharset();
            if (from != null && encoding2.getCharsetName() != null && from.name().equals(encoding2.getCharsetName())) {
                return from;
            }
        }
        catch (Exception exception3) {
            // empty catch block
        }
        try {
            from = Charset.forName(encoding2.toString());
        }
        catch (Exception exception4) {
            // empty catch block
        }
        if (from == null) {
            if (is7Bit) {
                return Charset.forName("US-ASCII");
            }
            if (encoding2 == ISO8859_16Encoding.INSTANCE) {
                return ISO_8859_16.INSTANCE;
            }
            throw runtime.newConverterNotFoundError("code converter not found for " + encoding2.toString());
        }
        return from;
    }

    static {
        BAD_TRANSCODINGS_HACK.add("ISO-2022-JP-2");
        BAD_TRANSCODINGS_HACK.add("CP50220");
        BAD_TRANSCODINGS_HACK.add("CP50221");
        MAX_ARRAY_SIZE = UnsafeHolder.U != null ? Integer.MAX_VALUE - UnsafeHolder.U.arrayBaseOffset(byte[].class) : 0x7FFFFFF7;
        XMLTextCharacterTranslator = new String[128];
        XMLAttrCharacterTranslator = new String[128];
        CharsetTranscoder.XMLTextCharacterTranslator[38] = "&amp;";
        CharsetTranscoder.XMLTextCharacterTranslator[60] = "&lt;";
        CharsetTranscoder.XMLTextCharacterTranslator[62] = "&gt;";
        CharsetTranscoder.XMLAttrCharacterTranslator[38] = "&amp;";
        CharsetTranscoder.XMLAttrCharacterTranslator[60] = "&lt;";
        CharsetTranscoder.XMLAttrCharacterTranslator[62] = "&gt;";
        CharsetTranscoder.XMLAttrCharacterTranslator[34] = "&quot;";
        HashSet<Charset> charsets = new HashSet<Charset>();
        charsets.add(Charset.forName("UTF-8"));
        charsets.add(Charset.forName("UTF-16"));
        charsets.add(Charset.forName("UTF-16BE"));
        charsets.add(Charset.forName("UTF-16LE"));
        charsets.add(Charset.forName("UTF-32"));
        charsets.add(Charset.forName("UTF-32BE"));
        charsets.add(Charset.forName("UTF-32LE"));
        UNICODE_CHARSETS = Collections.unmodifiableSet(charsets);
    }

    public static class CodingActions {
        CodingErrorAction onUnmappableCharacter;
        CodingErrorAction onMalformedInput;
        String replaceWith;
        public int ecflags;

        CodingActions(CodingErrorAction onUnmappableCharacter, CodingErrorAction onMalformedInput, int ecflags, String replaceWith) {
            this.onUnmappableCharacter = onUnmappableCharacter;
            this.onMalformedInput = onMalformedInput;
            this.replaceWith = replaceWith;
            this.ecflags = ecflags;
        }

        public String toString() {
            return "UnmappableCharacter: " + this.onUnmappableCharacter + ", MalformedInput: " + this.onMalformedInput + ", replaceWith: " + this.replaceWith;
        }

        public CodingErrorAction getOnUnmappableCharacter() {
            return this.onUnmappableCharacter;
        }

        public void setOnUnmappableCharacter(CodingErrorAction onUnmappableCharacter) {
            this.onUnmappableCharacter = onUnmappableCharacter;
        }

        public CodingErrorAction getOnMalformedInput() {
            return this.onMalformedInput;
        }

        public void setOnMalformedInput(CodingErrorAction onMalformedInput) {
            this.onMalformedInput = onMalformedInput;
        }

        public String getReplaceWith() {
            return this.replaceWith;
        }

        public void setReplaceWith(String replaceWith) {
            this.replaceWith = replaceWith;
        }
    }

    public class TranscoderEngine {
        public CharBuffer tmpChars;
        public final CharsetDecoder decoder;
        public final CharsetEncoder encoder;
        public boolean binaryToCharacter;
        public RubyCoderResult result;
        public boolean didDecode;
        public boolean didEncode;

        public TranscoderEngine(Charset inCharset, Charset outCharset, boolean binaryToCharacter) {
            this.encoder = outCharset.newEncoder();
            this.decoder = inCharset.newDecoder();
            this.tmpChars = CharBuffer.allocate(1024);
            this.binaryToCharacter = binaryToCharacter;
        }

        public float averageByteRatio() {
            return this.encoder.averageBytesPerChar() * this.decoder.averageCharsPerByte();
        }

        public RubyCoderResult transcode(TranscoderState state2, int flags) {
            boolean partialInput = (flags & 0x10000) != 0;
            boolean afterOutput = (flags & 0x20000) != 0;
            int ecflags = ((CharsetTranscoder)CharsetTranscoder.this).actions.ecflags;
            boolean universalNewline = (ecflags & 0x100) != 0;
            boolean crlfNewline = (ecflags & 0x1000) != 0;
            boolean crNewline = (ecflags & 0x2000) != 0;
            boolean xmlText = (ecflags & 0x4000) != 0;
            boolean xmlAttr = (ecflags & 0x8000) != 0;
            CodingErrorAction onMalformedInput = ((CharsetTranscoder)CharsetTranscoder.this).actions.onMalformedInput;
            CodingErrorAction onUnmappableCharacter = ((CharsetTranscoder)CharsetTranscoder.this).actions.onUnmappableCharacter;
            if (this.binaryToCharacter) {
                onMalformedInput = onUnmappableCharacter;
            }
            String replaceString = null;
            this.didDecode = false;
            this.didEncode = false;
            if (onUnmappableCharacter == CodingErrorAction.REPLACE || onMalformedInput == CodingErrorAction.REPLACE) {
                replaceString = CharsetTranscoder.replaceStringFromActions(CharsetTranscoder.this.actions, this.encoder.charset());
            }
            if (xmlAttr) {
                this.tmpChars.clear();
                this.tmpChars.put("\"");
                this.tmpChars.flip();
                this.encode(state2, this.tmpChars, replaceString, ecflags, false);
            }
            while (state2.inBytes.hasRemaining()) {
                this.tmpChars.clear();
                this.didDecode = true;
                CoderResult coderResult = this.decoder.decode(state2.inBytes, this.tmpChars, !partialInput);
                if (!coderResult.isError()) {
                    this.tmpChars.flip();
                    if (!this.encode(state2, this.doTranslations(universalNewline, crlfNewline, crNewline, xmlText, xmlAttr), replaceString, ecflags, false)) {
                        return this.result;
                    }
                    if (coderResult.isUnderflow()) {
                        break;
                    }
                } else if (coderResult.isMalformed()) {
                    if (onMalformedInput == CodingErrorAction.REPORT) {
                        byte[] errorBytes = new byte[coderResult.length()];
                        state2.inBytes.get(errorBytes);
                        this.result = new RubyCoderResult(CharsetTranscoder.stringFromCoderResult(coderResult, ecflags, this.binaryToCharacter), CharsetTranscoder.this.inEncoding, CharsetTranscoder.this.outEncoding, errorBytes, null);
                        return this.result;
                    }
                    this.tmpChars.flip();
                    if (!this.encode(state2, this.tmpChars, replaceString, ecflags, false)) {
                        return this.result;
                    }
                    state2.inBytes.get();
                    if (onMalformedInput == CodingErrorAction.REPLACE && !this.putReplacement(state2, replaceString, ecflags)) {
                        return this.result;
                    }
                } else if (coderResult.isUnmappable()) {
                    if (onUnmappableCharacter == CodingErrorAction.REPORT) {
                        byte[] errorBytes = new byte[coderResult.length()];
                        state2.inBytes.get(errorBytes);
                        this.result = new RubyCoderResult(CharsetTranscoder.stringFromCoderResult(coderResult, ecflags, this.binaryToCharacter), CharsetTranscoder.this.inEncoding, CharsetTranscoder.this.outEncoding, errorBytes, null);
                        return this.result;
                    }
                    this.tmpChars.flip();
                    if (!this.encode(state2, this.tmpChars, replaceString, ecflags, false)) {
                        return this.result;
                    }
                    state2.inBytes.get();
                    if (onUnmappableCharacter == CodingErrorAction.REPLACE && !this.putReplacement(state2, replaceString, ecflags)) {
                        return this.result;
                    }
                }
                if (!afterOutput) continue;
                break;
            }
            if (xmlAttr) {
                this.tmpChars.clear();
                this.tmpChars.put("\"");
                this.tmpChars.flip();
                this.encode(state2, this.tmpChars, replaceString, ecflags, false);
            }
            state2.outBytes.flip();
            this.result = partialInput ? new RubyCoderResult("source_buffer_empty", CharsetTranscoder.this.inEncoding, CharsetTranscoder.this.outEncoding, null, null) : new RubyCoderResult("finished", CharsetTranscoder.this.inEncoding, CharsetTranscoder.this.outEncoding, null, null);
            return this.result;
        }

        public ByteList finish() {
            CoderResult result2;
            TranscoderState state2 = new TranscoderState(null, ByteBuffer.allocate(16), true);
            CharBuffer tmpChars = this.tmpChars;
            tmpChars.clear();
            if (this.didDecode) {
                result2 = this.decoder.flush(tmpChars);
                while (result2 == CoderResult.OVERFLOW) {
                    tmpChars.flip();
                    CharBuffer newTmp = CharBuffer.allocate(tmpChars.capacity() * 2);
                    newTmp.put(tmpChars);
                    tmpChars = newTmp;
                    result2 = this.decoder.flush(tmpChars);
                }
                tmpChars.flip();
                if (tmpChars.hasRemaining()) {
                    this.encode(state2, tmpChars, ((CharsetTranscoder)CharsetTranscoder.this).actions.replaceWith, 0, true);
                } else {
                    this.encoder.encode(tmpChars, state2.outBytes, true);
                }
            } else {
                tmpChars.limit(tmpChars.position());
                this.encoder.encode(tmpChars, state2.outBytes, true);
            }
            if (this.didEncode) {
                result2 = this.encoder.flush(state2.outBytes);
                while (result2 == CoderResult.OVERFLOW) {
                    this.growBuffer(state2, 0);
                    result2 = this.encoder.flush(state2.outBytes);
                }
            }
            state2.outBytes.flip();
            return new ByteList(state2.outBytes.array(), state2.outBytes.position(), state2.outBytes.limit() - state2.outBytes.position());
        }

        public void reset() {
            this.decoder.reset();
            this.encoder.reset();
            this.tmpChars.clear();
        }

        private boolean growBuffer(TranscoderState state2, int flags) {
            if (!state2.growable) {
                this.result = new RubyCoderResult(CharsetTranscoder.stringFromCoderResult(CoderResult.OVERFLOW, flags, false), CharsetTranscoder.this.inEncoding, CharsetTranscoder.this.outEncoding, null, null);
                return false;
            }
            int toN = state2.outBytes.capacity();
            if (toN == MAX_ARRAY_SIZE) {
                throw new ArrayIndexOutOfBoundsException("cannot allocate output buffer larger than " + MAX_ARRAY_SIZE + " bytes");
            }
            toN = (int)Math.min((long)toN * 2L + 1L, (long)MAX_ARRAY_SIZE);
            ByteBuffer newOutBytes = ByteBuffer.allocate(toN);
            state2.outBytes.flip();
            newOutBytes.put(state2.outBytes);
            state2.outBytes = newOutBytes;
            return true;
        }

        private boolean encode(TranscoderState state2, CharBuffer inChars, String replaceString, int flags, boolean endOfInput) {
            boolean undefHexCharRef;
            boolean bl = undefHexCharRef = (flags & 0xF0) == 48;
            while (inChars.hasRemaining()) {
                this.didEncode = true;
                CoderResult coderResult = this.encoder.encode(inChars, state2.outBytes, endOfInput);
                if (coderResult.isError() || coderResult.isUnderflow()) {
                    if (!inChars.hasRemaining()) {
                        if (coderResult.isUnderflow()) {
                            return true;
                        }
                        throw CharsetTranscoder.this.runtime.newEncodingError("BUG: only errors and underflow should get here");
                    }
                    char badChar = inChars.get();
                    if (((CharsetTranscoder)CharsetTranscoder.this).actions.onUnmappableCharacter == CodingErrorAction.REPORT) {
                        this.result = new RubyCoderResult(CharsetTranscoder.stringFromCoderResult(coderResult, flags, false), CharsetTranscoder.this.inEncoding, CharsetTranscoder.this.outEncoding, Character.toString(badChar).getBytes(this.decoder.charset()), null);
                        return false;
                    }
                    if (((CharsetTranscoder)CharsetTranscoder.this).actions.onUnmappableCharacter != CodingErrorAction.REPLACE || !(undefHexCharRef ? !this.putReplacement(state2, "&#x" + Integer.toHexString(badChar).toUpperCase() + ";", flags) : !this.putReplacement(state2, replaceString, flags))) continue;
                    return false;
                }
                if (coderResult != CoderResult.OVERFLOW || this.growBuffer(state2, flags)) continue;
                return false;
            }
            return true;
        }

        private boolean putReplacement(TranscoderState state2, String replaceString, int flags) {
            while ((float)state2.outBytes.remaining() < (float)replaceString.length() * this.encoder.maxBytesPerChar()) {
                if (this.growBuffer(state2, flags)) continue;
                return false;
            }
            this.encoder.encode(CharBuffer.wrap(replaceString), state2.outBytes, false);
            return true;
        }

        private CharBuffer doTranslations(boolean universalNewline, boolean crlfNewline, boolean crNewline, boolean xmlText, boolean xmlAttr) {
            CharBuffer inChars = this.tmpChars;
            if (universalNewline || crlfNewline || crNewline) {
                CharBuffer newTmp = crlfNewline ? CharBuffer.allocate(this.tmpChars.remaining() * 2) : this.tmpChars.duplicate();
                boolean lastWasCR = false;
                block10: while (this.tmpChars.remaining() > 0) {
                    char ch = this.tmpChars.get();
                    if (universalNewline) {
                        switch (ch) {
                            case '\r': {
                                lastWasCR = true;
                                continue block10;
                            }
                            case '\n': {
                                if (lastWasCR) {
                                    newTmp.put('\n');
                                } else {
                                    newTmp.get();
                                }
                                lastWasCR = false;
                                continue block10;
                            }
                        }
                        if (lastWasCR) {
                            newTmp.put('\n');
                        }
                        newTmp.put(ch);
                        lastWasCR = false;
                        continue;
                    }
                    if (crNewline) {
                        switch (ch) {
                            case '\n': {
                                newTmp.put('\r');
                                continue block10;
                            }
                        }
                        newTmp.get();
                        continue;
                    }
                    if (!crlfNewline) continue;
                    switch (ch) {
                        case '\n': {
                            newTmp.put('\r');
                            newTmp.put('\n');
                            continue block10;
                        }
                    }
                    newTmp.put(ch);
                }
                newTmp.flip();
                inChars = newTmp;
            }
            if (xmlText || xmlAttr) {
                StringBuilder builder = new StringBuilder(inChars.remaining());
                while (inChars.hasRemaining()) {
                    char ch = inChars.get();
                    String replace2 = null;
                    if (ch >= '\u0080') {
                        builder.append(ch);
                        continue;
                    }
                    if (xmlText) {
                        replace2 = XMLTextCharacterTranslator[ch];
                        if (replace2 != null) {
                            builder.append(replace2);
                            continue;
                        }
                        builder.append(ch);
                        continue;
                    }
                    if (xmlAttr) {
                        replace2 = XMLAttrCharacterTranslator[ch];
                        if (replace2 != null) {
                            builder.append(replace2);
                            continue;
                        }
                        builder.append(ch);
                        continue;
                    }
                    builder.append(ch);
                }
                inChars = CharBuffer.wrap(builder);
            }
            return inChars;
        }

        public class TranscoderState {
            public final ByteBuffer inBytes;
            public ByteBuffer outBytes;
            public boolean growable;

            public TranscoderState(ByteBuffer inBytes, ByteBuffer outBytes, boolean growable) {
                this.growable = growable;
                this.inBytes = inBytes;
                this.outBytes = outBytes;
            }

            public TranscoderState(ByteBuffer inBytes, boolean growable) {
                this(inBytes, ByteBuffer.allocate((int)((float)inBytes.remaining() * transcoderEngine.averageByteRatio())), growable);
            }
        }
    }
}

