/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.jcodings.constants.PosixBracket;
import org.joni.ApplyCaseFold;
import org.joni.ApplyCaseFoldArg;
import org.joni.BitStatus;
import org.joni.Lexer;
import org.joni.Option;
import org.joni.Regex;
import org.joni.ScanEnvironment;
import org.joni.ast.AnchorNode;
import org.joni.ast.AnyCharNode;
import org.joni.ast.BackRefNode;
import org.joni.ast.CClassNode;
import org.joni.ast.CTypeNode;
import org.joni.ast.CallNode;
import org.joni.ast.ConsAltNode;
import org.joni.ast.EncloseNode;
import org.joni.ast.Node;
import org.joni.ast.QuantifierNode;
import org.joni.ast.StateNode;
import org.joni.ast.StringNode;
import org.joni.constants.CCSTATE;
import org.joni.constants.CCVALTYPE;
import org.joni.constants.TokenType;

class Parser
extends Lexer {
    protected final Regex regex;
    protected Node root;
    protected int returnCode;
    private static final int POSIX_BRACKET_NAME_MIN_LEN = 4;
    private static final int POSIX_BRACKET_CHECK_LIMIT_LENGTH = 20;
    private static final byte[] BRACKET_END = ":]".getBytes();
    private int nextChar;

    protected Parser(ScanEnvironment scanEnvironment, byte[] byArray, int n, int n2) {
        super(scanEnvironment, byArray, n, n2);
        this.regex = scanEnvironment.reg;
    }

    protected final Node parse() {
        this.root = this.parseRegexp();
        this.regex.numMem = this.env.numMem;
        return this.root;
    }

    private boolean parsePosixBracket(CClassNode cClassNode) {
        boolean bl;
        this.mark();
        if (this.peekIs(94)) {
            this.inc();
            bl = true;
        } else {
            bl = false;
        }
        if (this.enc.strLength(this.bytes, this.p, this.stop) >= 7) {
            byte[][] byArray = PosixBracket.PBSNamesLower;
            for (int i = 0; i < byArray.length; ++i) {
                byte[] byArray2 = byArray[i];
                if (this.enc.strNCmp(this.bytes, this.p, this.stop, byArray2, 0, byArray2.length) != 0) continue;
                this.p = this.enc.step(this.bytes, this.p, this.stop, byArray2.length);
                if (this.enc.strNCmp(this.bytes, this.p, this.stop, BRACKET_END, 0, BRACKET_END.length) != 0) {
                    this.newSyntaxException("invalid POSIX bracket type");
                }
                cClassNode.addCType(PosixBracket.PBSValues[i], bl, this.env, this);
                this.inc();
                this.inc();
                return false;
            }
        }
        this.c = 0;
        int n = 0;
        while (this.left() && (this.c = this.peek()) != 58 && this.c != 93) {
            this.inc();
            if (++n <= 20) continue;
        }
        if (this.c == 58 && this.left()) {
            this.inc();
            if (this.left()) {
                this.fetch();
                if (this.c == 93) {
                    this.newSyntaxException("invalid POSIX bracket type");
                }
            }
        }
        this.restore();
        return true;
    }

    private CClassNode parseCharProperty() {
        int n = this.fetchCharPropertyToCType();
        CClassNode cClassNode = new CClassNode();
        cClassNode.addCType(n, false, this.env, this);
        if (this.token.getPropNot()) {
            cClassNode.setNot();
        }
        return cClassNode;
    }

    private boolean codeExistCheck(int n, boolean bl) {
        this.mark();
        boolean bl2 = false;
        while (this.left()) {
            if (bl && bl2) {
                bl2 = false;
                continue;
            }
            this.fetch();
            if (this.c == n) {
                this.restore();
                return true;
            }
            if (this.c != this.syntax.metaCharTable.esc) continue;
            bl2 = true;
        }
        this.restore();
        return false;
    }

    private CClassNode parseCharClass() {
        boolean bl;
        this.fetchTokenInCC();
        if (this.token.type == TokenType.CHAR && this.token.getC() == 94 && !this.token.escaped) {
            bl = true;
            this.fetchTokenInCC();
        } else {
            bl = false;
        }
        if (this.token.type == TokenType.CC_CLOSE) {
            if (!this.codeExistCheck(93, true)) {
                this.newSyntaxException("empty char-class");
            }
            this.env.ccEscWarn("]");
            this.token.type = TokenType.CHAR;
        }
        CClassNode cClassNode = new CClassNode();
        CClassNode cClassNode2 = null;
        CClassNode cClassNode3 = null;
        CClassNode.CCStateArg cCStateArg = new CClassNode.CCStateArg();
        boolean bl2 = false;
        cCStateArg.state = CCSTATE.START;
        while (this.token.type != TokenType.CC_CLOSE) {
            boolean bl3 = false;
            switch (this.token.type) {
                case CHAR: {
                    int n = this.enc.codeToMbcLength(this.token.getC());
                    cCStateArg.inType = n > 1 ? CCVALTYPE.CODE_POINT : CCVALTYPE.SB;
                    cCStateArg.v = this.token.getC();
                    cCStateArg.vIsRaw = false;
                    this.valEntry2(cClassNode, cCStateArg);
                    break;
                }
                case RAW_BYTE: {
                    int n;
                    if (!this.enc.isSingleByte() && this.token.base != 0) {
                        int n2;
                        byte[] byArray = new byte[18];
                        int n3 = this.p;
                        int n4 = this.token.base;
                        byArray[0] = (byte)this.token.getC();
                        for (n2 = 1; n2 < this.enc.maxLength(); ++n2) {
                            this.fetchTokenInCC();
                            if (this.token.type != TokenType.RAW_BYTE || this.token.base != n4) {
                                bl3 = true;
                                break;
                            }
                            byArray[n2] = (byte)this.token.getC();
                        }
                        if (n2 < this.enc.minLength()) {
                            this.newValueException("too short multibyte code string");
                        }
                        if (n2 < (n = this.enc.length(byArray, 0, n2))) {
                            this.newValueException("too short multibyte code string");
                        } else if (n2 > n) {
                            this.p = n3;
                            for (n2 = 1; n2 < n; ++n2) {
                                this.fetchTokenInCC();
                            }
                            bl3 = false;
                        }
                        if (n2 == 1) {
                            cCStateArg.v = byArray[0] & 0xFF;
                            cCStateArg.inType = CCVALTYPE.SB;
                        } else {
                            cCStateArg.v = this.enc.mbcToCode(byArray, 0, byArray.length);
                            cCStateArg.inType = CCVALTYPE.CODE_POINT;
                        }
                    } else {
                        cCStateArg.v = this.token.getC();
                        cCStateArg.inType = CCVALTYPE.SB;
                    }
                    cCStateArg.vIsRaw = true;
                    this.valEntry2(cClassNode, cCStateArg);
                    break;
                }
                case CODE_POINT: {
                    cCStateArg.v = this.token.getCode();
                    cCStateArg.vIsRaw = true;
                    this.valEntry(cClassNode, cCStateArg);
                    break;
                }
                case POSIX_BRACKET_OPEN: {
                    if (this.parsePosixBracket(cClassNode)) {
                        this.env.ccEscWarn("[");
                        this.p = this.token.backP;
                        cCStateArg.v = this.token.getC();
                        cCStateArg.vIsRaw = false;
                        this.valEntry(cClassNode, cCStateArg);
                        break;
                    }
                    cClassNode.nextStateClass(cCStateArg, this.env);
                    break;
                }
                case CHAR_TYPE: {
                    cClassNode.addCType(this.token.getPropCType(), this.token.getPropNot(), this.env, this);
                    cClassNode.nextStateClass(cCStateArg, this.env);
                    break;
                }
                case CHAR_PROPERTY: {
                    int n = this.fetchCharPropertyToCType();
                    cClassNode.addCType(n, this.token.getPropNot(), this.env, this);
                    cClassNode.nextStateClass(cCStateArg, this.env);
                    break;
                }
                case CC_RANGE: {
                    if (cCStateArg.state == CCSTATE.VALUE) {
                        this.fetchTokenInCC();
                        bl3 = true;
                        if (this.token.type == TokenType.CC_CLOSE) {
                            this.rangeEndVal(cClassNode, cCStateArg);
                            break;
                        }
                        if (this.token.type == TokenType.CC_AND) {
                            this.env.ccEscWarn("-");
                            this.rangeEndVal(cClassNode, cCStateArg);
                            break;
                        }
                        cCStateArg.state = CCSTATE.RANGE;
                        break;
                    }
                    if (cCStateArg.state == CCSTATE.START) {
                        cCStateArg.v = this.token.getC();
                        cCStateArg.vIsRaw = false;
                        this.fetchTokenInCC();
                        bl3 = true;
                        if (this.token.type == TokenType.CC_RANGE || bl2) {
                            this.env.ccEscWarn("-");
                        }
                        this.valEntry(cClassNode, cCStateArg);
                        break;
                    }
                    if (cCStateArg.state == CCSTATE.RANGE) {
                        this.env.ccEscWarn("-");
                        this.sbChar(cClassNode, cCStateArg);
                        break;
                    }
                    this.fetchTokenInCC();
                    bl3 = true;
                    if (this.token.type == TokenType.CC_CLOSE) {
                        this.rangeEndVal(cClassNode, cCStateArg);
                        break;
                    }
                    if (this.token.type == TokenType.CC_AND) {
                        this.env.ccEscWarn("-");
                        this.rangeEndVal(cClassNode, cCStateArg);
                        break;
                    }
                    if (this.syntax.allowDoubleRangeOpInCC()) {
                        this.env.ccEscWarn("-");
                        this.sbChar(cClassNode, cCStateArg);
                        break;
                    }
                    this.newSyntaxException("unmatched range specifier in char-class");
                    break;
                }
                case CC_CC_OPEN: {
                    CClassNode cClassNode4 = this.parseCharClass();
                    cClassNode.or(cClassNode4, this.enc);
                    break;
                }
                case CC_AND: {
                    if (cCStateArg.state == CCSTATE.VALUE) {
                        cCStateArg.v = 0;
                        cCStateArg.vIsRaw = false;
                        cClassNode.nextStateValue(cCStateArg, this.env);
                    }
                    bl2 = true;
                    cCStateArg.state = CCSTATE.START;
                    if (cClassNode2 != null) {
                        cClassNode2.and(cClassNode, this.enc);
                        break;
                    }
                    cClassNode2 = cClassNode;
                    if (cClassNode3 == null) {
                        cClassNode3 = new CClassNode();
                    }
                    cClassNode = cClassNode3;
                    break;
                }
                case EOT: {
                    this.newSyntaxException("premature end of char-class");
                }
                default: {
                    this.newInternalException("internal parser error (bug)");
                }
            }
            if (bl3) continue;
            this.fetchTokenInCC();
        }
        if (cCStateArg.state == CCSTATE.VALUE) {
            cCStateArg.v = 0;
            cCStateArg.vIsRaw = false;
            cClassNode.nextStateValue(cCStateArg, this.env);
        }
        if (cClassNode2 != null) {
            cClassNode2.and(cClassNode, this.enc);
            cClassNode = cClassNode2;
        }
        if (bl) {
            cClassNode.setNot();
        } else {
            cClassNode.clearNot();
        }
        if (cClassNode.isNot() && this.syntax.notNewlineInNegativeCC() && !cClassNode.isEmpty() && this.enc.isNewLine(10)) {
            if (this.enc.codeToMbcLength(10) == 1) {
                cClassNode.bs.set(10);
            } else {
                cClassNode.addCodeRange(this.env, 10, 10);
            }
        }
        return cClassNode;
    }

    private void valEntry2(CClassNode cClassNode, CClassNode.CCStateArg cCStateArg) {
        cClassNode.nextStateValue(cCStateArg, this.env);
    }

    private void valEntry(CClassNode cClassNode, CClassNode.CCStateArg cCStateArg) {
        int n = this.enc.codeToMbcLength(cCStateArg.v);
        cCStateArg.inType = n == 1 ? CCVALTYPE.SB : CCVALTYPE.CODE_POINT;
        this.valEntry2(cClassNode, cCStateArg);
    }

    private void sbChar(CClassNode cClassNode, CClassNode.CCStateArg cCStateArg) {
        cCStateArg.inType = CCVALTYPE.SB;
        cCStateArg.v = this.token.getC();
        cCStateArg.vIsRaw = false;
        this.valEntry2(cClassNode, cCStateArg);
    }

    private void rangeEndVal(CClassNode cClassNode, CClassNode.CCStateArg cCStateArg) {
        cCStateArg.v = 45;
        cCStateArg.vIsRaw = false;
        this.valEntry(cClassNode, cCStateArg);
    }

    private Node parseEnclose(TokenType tokenType) {
        Node node;
        Node node2 = null;
        if (!this.left()) {
            this.newSyntaxException("end pattern with unmatched parenthesis");
        }
        int n = this.env.option;
        if (this.peekIs(63) && this.syntax.op2QMarkGroupEffect()) {
            this.inc();
            if (!this.left()) {
                this.newSyntaxException("end pattern in group");
            }
            boolean bl = false;
            this.fetch();
            switch (this.c) {
                case 58: {
                    this.fetchToken();
                    node2 = this.parseSubExp(tokenType);
                    this.returnCode = 1;
                    return node2;
                }
                case 61: {
                    node2 = new AnchorNode(1024);
                    break;
                }
                case 33: {
                    node2 = new AnchorNode(2048);
                    break;
                }
                case 62: {
                    node2 = new EncloseNode(4);
                    break;
                }
                case 39: {
                    if (this.syntax.op2QMarkLtNamedGroup()) {
                        bl = false;
                        node2 = this.namedGroup2(bl);
                        break;
                    }
                    this.newSyntaxException("undefined group option");
                    break;
                }
                case 60: {
                    this.fetch();
                    if (this.c == 61) {
                        node2 = new AnchorNode(4096);
                        break;
                    }
                    if (this.c == 33) {
                        node2 = new AnchorNode(8192);
                        break;
                    }
                    if (this.syntax.op2QMarkLtNamedGroup()) {
                        this.unfetch();
                        this.c = 60;
                        bl = false;
                        node2 = this.namedGroup2(bl);
                        break;
                    }
                    this.newSyntaxException("undefined group option");
                    break;
                }
                case 64: {
                    if (this.syntax.op2AtMarkCaptureHistory()) {
                        if (this.syntax.op2QMarkLtNamedGroup()) {
                            this.fetch();
                            if (this.c == 60 || this.c == 39) {
                                bl = true;
                                node2 = this.namedGroup2(bl);
                            }
                            this.unfetch();
                        }
                        node = new EncloseNode(this.env.option, false);
                        int n2 = this.env.addMemEntry();
                        if (n2 >= 32) {
                            this.newValueException("group number is too big for capture history");
                        }
                        ((EncloseNode)node).regNum = n2;
                        node2 = node;
                        break;
                    }
                    this.newSyntaxException("undefined group option");
                    break;
                }
                case 45: 
                case 105: 
                case 109: 
                case 115: 
                case 120: {
                    boolean bl2 = false;
                    while (true) {
                        switch (this.c) {
                            case 41: 
                            case 58: {
                                break;
                            }
                            case 45: {
                                bl2 = true;
                                break;
                            }
                            case 120: {
                                n = BitStatus.bsOnOff(n, 2, bl2);
                                break;
                            }
                            case 105: {
                                n = BitStatus.bsOnOff(n, 1, bl2);
                                break;
                            }
                            case 115: {
                                if (this.syntax.op2OptionPerl()) {
                                    n = BitStatus.bsOnOff(n, 4, bl2);
                                    break;
                                }
                                this.newSyntaxException("undefined group option");
                                break;
                            }
                            case 109: {
                                if (this.syntax.op2OptionPerl()) {
                                    n = BitStatus.bsOnOff(n, 8, !bl2);
                                    break;
                                }
                                if (this.syntax.op2OptionRuby()) {
                                    n = BitStatus.bsOnOff(n, 4, bl2);
                                    break;
                                }
                                this.newSyntaxException("undefined group option");
                                break;
                            }
                            default: {
                                this.newSyntaxException("undefined group option");
                            }
                        }
                        if (this.c == 41) {
                            EncloseNode encloseNode = new EncloseNode(n, 0);
                            node2 = encloseNode;
                            this.returnCode = 2;
                            return node2;
                        }
                        if (this.c == 58) {
                            int n3 = this.env.option;
                            this.env.option = n;
                            this.fetchToken();
                            Node node3 = this.parseSubExp(tokenType);
                            this.env.option = n3;
                            EncloseNode encloseNode = new EncloseNode(n, 0);
                            encloseNode.setTarget(node3);
                            node2 = encloseNode;
                            this.returnCode = 0;
                            return node2;
                        }
                        if (!this.left()) {
                            this.newSyntaxException("end pattern in group");
                        }
                        this.fetch();
                    }
                }
                default: {
                    this.newSyntaxException("undefined group option");
                    break;
                }
            }
        } else {
            int n4;
            if (Option.isDontCaptureGroup(this.env.option)) {
                this.fetchToken();
                node2 = this.parseSubExp(tokenType);
                this.returnCode = 1;
                return node2;
            }
            EncloseNode encloseNode = new EncloseNode(this.env.option, false);
            encloseNode.regNum = n4 = this.env.addMemEntry();
            node2 = encloseNode;
        }
        this.fetchToken();
        Node node4 = this.parseSubExp(tokenType);
        if (node2.getType() == 7) {
            node = (AnchorNode)node2;
            ((AnchorNode)node).setTarget(node4);
        } else {
            node = (EncloseNode)node2;
            ((EncloseNode)node).setTarget(node4);
            if (((EncloseNode)node).type == 1) {
                this.env.setMemNode(((EncloseNode)node).regNum, node2);
            }
        }
        this.returnCode = 0;
        return node2;
    }

    private Node namedGroup2(boolean bl) {
        int n = this.p;
        int n2 = this.fetchName(this.c, false);
        int n3 = this.value;
        n2 = this.env.addMemEntry();
        if (bl && n2 >= 32) {
            this.newValueException("group number is too big for capture history");
        }
        this.regex.nameAdd(this.bytes, n, n3, n2, this.syntax);
        EncloseNode encloseNode = new EncloseNode(this.env.option, true);
        encloseNode.regNum = n2;
        EncloseNode encloseNode2 = encloseNode;
        if (bl) {
            this.env.captureHistory = BitStatus.bsOnAtSimple(this.env.captureHistory, n2);
        }
        ++this.env.numNamed;
        return encloseNode2;
    }

    private int findStrPosition(int[] nArray, int n, int n2, int n3) {
        int n4 = n2;
        int n5 = 0;
        while (n4 < n3) {
            int n6 = this.enc.mbcToCode(this.bytes, n4, n3);
            int n7 = n4 + this.enc.length(this.bytes, n4, n3);
            if (n6 == nArray[0]) {
                for (n5 = 1; n5 < n && n7 < n3 && (n6 = this.enc.mbcToCode(this.bytes, n7, n3)) == nArray[n5]; n7 += this.enc.length(this.bytes, n7, n3), ++n5) {
                }
                if (n5 >= n) {
                    if (this.bytes[this.nextChar] != 0) {
                        this.nextChar = n7;
                    }
                    return n4;
                }
            }
            n4 = n7;
        }
        return -1;
    }

    private Node parseExp(TokenType tokenType) {
        if (this.token.type == tokenType) {
            return new StringNode();
        }
        Node node = null;
        boolean bl = false;
        block0 : switch (this.token.type) {
            case EOT: 
            case ALT: {
                return new StringNode();
            }
            case SUBEXP_OPEN: {
                node = this.parseEnclose(TokenType.SUBEXP_CLOSE);
                if (this.returnCode == 1) {
                    bl = true;
                    break;
                }
                if (this.returnCode != 2) break;
                int n = this.env.option;
                EncloseNode encloseNode = (EncloseNode)node;
                this.env.option = encloseNode.option;
                this.fetchToken();
                Node node2 = this.parseSubExp(tokenType);
                this.env.option = n;
                encloseNode.setTarget(node2);
                return node;
            }
            case SUBEXP_CLOSE: {
                if (!this.syntax.allowUnmatchedCloseSubexp()) {
                    this.newSyntaxException("unmatched close parenthesis");
                }
                if (this.token.escaped) {
                    return this.parseExpTkRawByte(bl);
                }
                return this.parseExpTkByte(bl);
            }
            case STRING: {
                return this.parseExpTkByte(bl);
            }
            case RAW_BYTE: {
                return this.parseExpTkRawByte(bl);
            }
            case CODE_POINT: {
                byte[] byArray = new byte[7];
                int n = this.enc.codeToMbc(this.token.getCode(), byArray, 0);
                node = new StringNode(byArray, 0, n);
                break;
            }
            case QUOTE_OPEN: {
                int[] nArray = new int[]{this.syntax.metaCharTable.esc, 69};
                int n = this.p;
                int n2 = this.findStrPosition(nArray, nArray.length, n, this.stop);
                if (n2 == -1) {
                    this.nextChar = n2 = this.stop;
                }
                node = new StringNode(this.bytes, n, n2);
                this.p = this.nextChar;
                break;
            }
            case CHAR_TYPE: {
                switch (this.token.getPropCType()) {
                    case 12: {
                        node = new CTypeNode(this.token.getPropCType(), this.token.getPropNot());
                        break block0;
                    }
                    case 4: 
                    case 9: 
                    case 11: {
                        CClassNode cClassNode = new CClassNode();
                        cClassNode.addCType(this.token.getPropCType(), false, this.env, this);
                        if (this.token.getPropNot()) {
                            cClassNode.setNot();
                        }
                        node = cClassNode;
                        break block0;
                    }
                }
                this.newInternalException("internal parser error (bug)");
                break;
            }
            case CHAR_PROPERTY: {
                node = this.parseCharProperty();
                break;
            }
            case CC_CC_OPEN: {
                CClassNode cClassNode;
                node = cClassNode = this.parseCharClass();
                if (!Option.isIgnoreCase(this.env.option)) break;
                ApplyCaseFoldArg applyCaseFoldArg = new ApplyCaseFoldArg(this.env, cClassNode);
                this.enc.applyAllCaseFold(this.env.caseFoldFlag, ApplyCaseFold.INSTANCE, applyCaseFoldArg);
                if (applyCaseFoldArg.altRoot == null) break;
                node = ConsAltNode.newAltNode(node, applyCaseFoldArg.altRoot);
                break;
            }
            case ANYCHAR: {
                node = new AnyCharNode();
                break;
            }
            case ANYCHAR_ANYTIME: {
                node = new AnyCharNode();
                QuantifierNode quantifierNode = new QuantifierNode(0, -1, false);
                quantifierNode.setTarget(node);
                node = quantifierNode;
                break;
            }
            case BACKREF: {
                int[] nArray;
                if (this.token.getBackrefNum() > 1) {
                    nArray = this.token.getBackrefRefs();
                } else {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = this.token.getBackrefRef1();
                }
                int[] nArray3 = nArray;
                node = new BackRefNode(this.token.getBackrefNum(), nArray3, this.token.getBackrefByName(), this.token.getBackrefExistLevel(), this.token.getBackrefLevel(), this.env);
                break;
            }
            case CALL: {
                int n = this.token.getCallGNum();
                if (n < 0 && (n = this.backrefRelToAbs(n)) <= 0) {
                    this.newValueException("invalid backref number/name");
                }
                node = new CallNode(this.bytes, this.token.getCallNameP(), this.token.getCallNameEnd(), n);
                ++this.env.numCall;
                break;
            }
            case ANCHOR: {
                node = new AnchorNode(this.token.getAnchor());
                break;
            }
            case OP_REPEAT: 
            case INTERVAL: {
                if (this.syntax.contextIndepRepeatOps()) {
                    if (this.syntax.contextInvalidRepeatOps()) {
                        this.newSyntaxException("target of repeat operator is not specified");
                        break;
                    }
                    node = new StringNode();
                    break;
                }
                return this.parseExpTkByte(bl);
            }
            default: {
                this.newInternalException("internal parser error (bug)");
            }
        }
        this.fetchToken();
        return this.parseExpRepeat(node, bl);
    }

    private Node parseExpTkByte(boolean bl) {
        StringNode stringNode = new StringNode(this.bytes, this.token.backP, this.p);
        while (true) {
            this.fetchToken();
            if (this.token.type != TokenType.STRING) break;
            if (this.token.backP == stringNode.end) {
                stringNode.end = this.p;
                continue;
            }
            stringNode.cat(this.bytes, this.token.backP, this.p);
        }
        return this.parseExpRepeat(stringNode, bl);
    }

    private Node parseExpTkRawByte(boolean bl) {
        StringNode stringNode = new StringNode((byte)this.token.getC());
        stringNode.setRaw();
        int n = 1;
        while (true) {
            if (n >= this.enc.minLength() && n == this.enc.length(stringNode.bytes, stringNode.p, stringNode.end)) {
                this.fetchToken();
                stringNode.clearRaw();
                return this.parseExpRepeat(stringNode, bl);
            }
            this.fetchToken();
            if (this.token.type != TokenType.RAW_BYTE) {
                this.newValueException("too short multibyte code string");
            }
            stringNode.cat((byte)this.token.getC());
            ++n;
        }
    }

    private Node parseExpRepeat(Node node, boolean bl) {
        while (this.token.type == TokenType.OP_REPEAT || this.token.type == TokenType.INTERVAL) {
            Node node2;
            if (node.isInvalidQuantifier()) {
                this.newSyntaxException("target of repeat operator is invalid");
            }
            QuantifierNode quantifierNode = new QuantifierNode(this.token.getRepeatLower(), this.token.getRepeatUpper(), this.token.type == TokenType.INTERVAL);
            quantifierNode.greedy = this.token.getRepeatGreedy();
            int n = quantifierNode.setQuantifier(node, bl, this.env, this.bytes, this.getBegin(), this.getEnd());
            StateNode stateNode = quantifierNode;
            if (this.token.getRepeatPossessive()) {
                node2 = new EncloseNode(4);
                node2.setTarget(stateNode);
                stateNode = node2;
            }
            if (n == 0) {
                node = stateNode;
            } else if (n == 2) {
                node = ConsAltNode.newListNode(node, null);
                node2 = ((ConsAltNode)node).setCdr(ConsAltNode.newListNode(stateNode, null));
                this.fetchToken();
                return this.parseExpRepeatForCar(node, (ConsAltNode)node2, bl);
            }
            this.fetchToken();
        }
        return node;
    }

    private Node parseExpRepeatForCar(Node node, ConsAltNode consAltNode, boolean bl) {
        while (this.token.type == TokenType.OP_REPEAT || this.token.type == TokenType.INTERVAL) {
            if (consAltNode.car.isInvalidQuantifier()) {
                this.newSyntaxException("target of repeat operator is invalid");
            }
            QuantifierNode quantifierNode = new QuantifierNode(this.token.getRepeatLower(), this.token.getRepeatUpper(), this.token.type == TokenType.INTERVAL);
            quantifierNode.greedy = this.token.getRepeatGreedy();
            int n = quantifierNode.setQuantifier(consAltNode.car, bl, this.env, this.bytes, this.getBegin(), this.getEnd());
            StateNode stateNode = quantifierNode;
            if (this.token.getRepeatPossessive()) {
                EncloseNode encloseNode = new EncloseNode(4);
                encloseNode.setTarget(stateNode);
                stateNode = encloseNode;
            }
            if (n == 0) {
                consAltNode.setCar(stateNode);
            } else if (n == 2) assert (false);
            this.fetchToken();
        }
        return node;
    }

    private Node parseBranch(TokenType tokenType) {
        ConsAltNode consAltNode;
        Node node = this.parseExp(tokenType);
        if (this.token.type == TokenType.EOT || this.token.type == tokenType || this.token.type == TokenType.ALT) {
            return node;
        }
        ConsAltNode consAltNode2 = consAltNode = ConsAltNode.newListNode(node, null);
        while (this.token.type != TokenType.EOT && this.token.type != tokenType && this.token.type != TokenType.ALT) {
            node = this.parseExp(tokenType);
            if (node.getType() == 8) {
                consAltNode2.setCdr((ConsAltNode)node);
                while (((ConsAltNode)node).cdr != null) {
                    node = ((ConsAltNode)node).cdr;
                }
                consAltNode2 = (ConsAltNode)node;
                continue;
            }
            consAltNode2.setCdr(ConsAltNode.newListNode(node, null));
            consAltNode2 = consAltNode2.cdr;
        }
        return consAltNode;
    }

    private Node parseSubExp(TokenType tokenType) {
        Node node = this.parseBranch(tokenType);
        if (this.token.type == tokenType) {
            return node;
        }
        if (this.token.type == TokenType.ALT) {
            ConsAltNode consAltNode;
            ConsAltNode consAltNode2 = consAltNode = ConsAltNode.newAltNode(node, null);
            while (this.token.type == TokenType.ALT) {
                this.fetchToken();
                node = this.parseBranch(tokenType);
                consAltNode2.setCdr(ConsAltNode.newAltNode(node, null));
                consAltNode2 = consAltNode2.cdr;
            }
            if (this.token.type != tokenType) {
                this.parseSubExpError(tokenType);
            }
            return consAltNode;
        }
        this.parseSubExpError(tokenType);
        return null;
    }

    private void parseSubExpError(TokenType tokenType) {
        if (tokenType == TokenType.SUBEXP_CLOSE) {
            this.newSyntaxException("end pattern with unmatched parenthesis");
        } else {
            this.newInternalException("internal parser error (bug)");
        }
    }

    private Node parseRegexp() {
        this.fetchToken();
        return this.parseSubExp(TokenType.EOT);
    }
}

