/*
 * Decompiled with CFR 0.152.
 */
package org.joni.ast;

import org.joni.Option;
import org.joni.ast.Node;
import org.joni.ast.StateNode;
import org.joni.constants.EncloseType;

public final class EncloseNode
extends StateNode
implements EncloseType {
    public int type;
    public int regNum;
    public int option;
    public Node target;
    public int callAddr;
    public int minLength;
    public int maxLength;
    public int charLength;
    public int optCount;

    public EncloseNode(int n) {
        this.type = n;
        this.callAddr = -1;
    }

    public EncloseNode(int n, boolean bl) {
        this(1);
        if (bl) {
            this.setNamedGroup();
        }
        this.option = n;
    }

    public EncloseNode(int n, int n2) {
        this(2);
        this.option = n;
    }

    public int getType() {
        return 6;
    }

    protected void setChild(Node node) {
        this.target = node;
    }

    protected Node getChild() {
        return this.target;
    }

    public void setTarget(Node node) {
        this.target = node;
        node.parent = this;
    }

    public String getName() {
        return "Enclose";
    }

    public String toString(int n) {
        StringBuilder stringBuilder = new StringBuilder(super.toString(n));
        stringBuilder.append("\n  type: " + this.typeToString());
        stringBuilder.append("\n  regNum: " + this.regNum);
        stringBuilder.append("\n  option: " + Option.toString(this.option));
        stringBuilder.append("\n  target: " + EncloseNode.pad(this.target, n + 1));
        stringBuilder.append("\n  callAddr: " + this.callAddr);
        stringBuilder.append("\n  minLength: " + this.minLength);
        stringBuilder.append("\n  maxLength: " + this.maxLength);
        stringBuilder.append("\n  charLength: " + this.charLength);
        stringBuilder.append("\n  optCount: " + this.optCount);
        return stringBuilder.toString();
    }

    public String typeToString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isStopBacktrack()) {
            stringBuilder.append("STOP_BACKTRACK ");
        }
        if (this.isMemory()) {
            stringBuilder.append("MEMORY ");
        }
        if (this.isOption()) {
            stringBuilder.append("OPTION ");
        }
        return stringBuilder.toString();
    }

    public void setEncloseStatus(int n) {
        this.state |= n;
    }

    public void clearEncloseStatus(int n) {
        this.state &= ~n;
    }

    public void clearMemory() {
        this.type &= 0xFFFFFFFE;
    }

    public void setMemory() {
        this.type |= 1;
    }

    public boolean isMemory() {
        return (this.type & 1) != 0;
    }

    public void clearOption() {
        this.type &= 0xFFFFFFFD;
    }

    public void setOption() {
        this.type |= 2;
    }

    public boolean isOption() {
        return (this.type & 2) != 0;
    }

    public void clearStopBacktrack() {
        this.type &= 0xFFFFFFFB;
    }

    public void setStopBacktrack() {
        this.type |= 4;
    }

    public boolean isStopBacktrack() {
        return (this.type & 4) != 0;
    }
}

