/*
 * Decompiled with CFR 0.152.
 */
package org.joni.ast;

import org.joni.ScanEnvironment;
import org.joni.ast.Node;
import org.joni.ast.StateNode;
import org.joni.ast.StringNode;
import org.joni.constants.Reduce;

public final class QuantifierNode
extends StateNode {
    public Node target;
    public int lower;
    public int upper;
    public boolean greedy;
    public int targetEmptyInfo;
    public Node headExact;
    public Node nextHeadExact;
    public boolean isRefered;
    public int combExpCheckNum;
    public static final int REPEAT_INFINITE = -1;

    public QuantifierNode(int n, int n2, boolean bl) {
        this.lower = n;
        this.upper = n2;
        this.greedy = true;
        this.targetEmptyInfo = 0;
        if (bl) {
            this.setByNumber();
        }
    }

    public int getType() {
        return 5;
    }

    protected void setChild(Node node) {
        this.target = node;
    }

    protected Node getChild() {
        return this.target;
    }

    public void setTarget(Node node) {
        this.target = node;
        node.parent = this;
    }

    public StringNode convertToString() {
        StringNode stringNode = new StringNode();
        stringNode.flag = ((StringNode)this.target).flag;
        stringNode.swap(this);
        return stringNode;
    }

    public String getName() {
        return "Quantifier";
    }

    public String toString(int n) {
        StringBuilder stringBuilder = new StringBuilder(super.toString(n));
        stringBuilder.append("\n  target: " + QuantifierNode.pad(this.target, n + 1));
        stringBuilder.append("\n  lower: " + this.lower);
        stringBuilder.append("\n  upper: " + this.upper);
        stringBuilder.append("\n  greedy: " + this.greedy);
        stringBuilder.append("\n  targetEmptyInfo: " + this.targetEmptyInfo);
        stringBuilder.append("\n  headExact: " + QuantifierNode.pad(this.headExact, n + 1));
        stringBuilder.append("\n  nextHeadExact: " + QuantifierNode.pad(this.nextHeadExact, n + 1));
        stringBuilder.append("\n  isRefered: " + this.isRefered);
        stringBuilder.append("\n  combExpCheckNum: " + this.combExpCheckNum);
        return stringBuilder.toString();
    }

    public boolean isAnyCharStar() {
        return this.greedy && QuantifierNode.isRepeatInfinite(this.upper) && this.target.getType() == 3;
    }

    protected int popularNum() {
        if (this.greedy) {
            if (this.lower == 0) {
                if (this.upper == 1) {
                    return 0;
                }
                if (QuantifierNode.isRepeatInfinite(this.upper)) {
                    return 1;
                }
            } else if (this.lower == 1 && QuantifierNode.isRepeatInfinite(this.upper)) {
                return 2;
            }
        } else if (this.lower == 0) {
            if (this.upper == 1) {
                return 3;
            }
            if (QuantifierNode.isRepeatInfinite(this.upper)) {
                return 4;
            }
        } else if (this.lower == 1 && QuantifierNode.isRepeatInfinite(this.upper)) {
            return 5;
        }
        return -1;
    }

    protected void set(QuantifierNode quantifierNode) {
        this.setTarget(quantifierNode.target);
        quantifierNode.target = null;
        this.lower = quantifierNode.lower;
        this.upper = quantifierNode.upper;
        this.greedy = quantifierNode.greedy;
        this.targetEmptyInfo = quantifierNode.targetEmptyInfo;
        this.headExact = quantifierNode.headExact;
        this.nextHeadExact = quantifierNode.nextHeadExact;
        this.isRefered = quantifierNode.isRefered;
        this.combExpCheckNum = quantifierNode.combExpCheckNum;
    }

    public void reduceNestedQuantifier(QuantifierNode quantifierNode) {
        int n = this.popularNum();
        int n2 = quantifierNode.popularNum();
        if (n < 0 || n2 < 0) {
            return;
        }
        switch (Reduce.REDUCE_TABLE[n2][n]) {
            case DEL: {
                this.set(quantifierNode);
                break;
            }
            case A: {
                this.setTarget(quantifierNode.target);
                this.lower = 0;
                this.upper = -1;
                this.greedy = true;
                break;
            }
            case AQ: {
                this.setTarget(quantifierNode.target);
                this.lower = 0;
                this.upper = -1;
                this.greedy = false;
                break;
            }
            case QQ: {
                this.setTarget(quantifierNode.target);
                this.lower = 0;
                this.upper = 1;
                this.greedy = false;
                break;
            }
            case P_QQ: {
                this.setTarget(quantifierNode);
                this.lower = 0;
                this.upper = 1;
                this.greedy = false;
                quantifierNode.lower = 1;
                quantifierNode.upper = -1;
                quantifierNode.greedy = true;
                return;
            }
            case PQ_Q: {
                this.setTarget(quantifierNode);
                this.lower = 0;
                this.upper = 1;
                this.greedy = true;
                quantifierNode.lower = 1;
                quantifierNode.upper = -1;
                quantifierNode.greedy = false;
                return;
            }
            case ASIS: {
                this.setTarget(quantifierNode);
                return;
            }
        }
        quantifierNode.target = null;
    }

    public int setQuantifier(Node node, boolean bl, ScanEnvironment scanEnvironment, byte[] byArray, int n, int n2) {
        if (this.lower == 1 && this.upper == 1) {
            return 1;
        }
        switch (node.getType()) {
            case 0: {
                StringNode stringNode;
                StringNode stringNode2;
                if (bl || !(stringNode2 = (StringNode)node).canBeSplit(scanEnvironment.enc) || (stringNode = stringNode2.splitLastChar(scanEnvironment.enc)) == null) break;
                this.setTarget(stringNode);
                return 2;
            }
            case 5: {
                QuantifierNode quantifierNode = (QuantifierNode)node;
                int n3 = this.popularNum();
                int n4 = quantifierNode.popularNum();
                if (n4 < 0) break;
                if (n3 >= 0) {
                    this.reduceNestedQuantifier(quantifierNode);
                    return 0;
                }
                if (n4 != 1 && n4 != 2 || QuantifierNode.isRepeatInfinite(this.upper) || this.upper <= 1 || !this.greedy) break;
                this.upper = this.lower == 0 ? 1 : this.lower;
            }
        }
        this.setTarget(node);
        return 0;
    }

    public static boolean isRepeatInfinite(int n) {
        return n == -1;
    }
}

