/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import com.kenai.constantine.platform.OpenFlags;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.jcodings.Encoding;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyDir;
import org.jruby.RubyFileTest;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.ext.posix.util.Platform;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingCapable;
import org.jruby.util.ByteList;
import org.jruby.util.Dir;
import org.jruby.util.JRubyFile;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.ChannelStream;
import org.jruby.util.io.DirectoryAsFileException;
import org.jruby.util.io.FileExistsException;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.OpenFile;
import org.jruby.util.io.PipeException;
import org.jruby.util.io.Stream;

@JRubyClass(name={"File"}, parent="IO", include={"FileTest"})
public class RubyFile
extends RubyIO
implements EncodingCapable {
    private static final long serialVersionUID = 1L;
    public static final int LOCK_SH = 1;
    public static final int LOCK_EX = 2;
    public static final int LOCK_NB = 4;
    public static final int LOCK_UN = 8;
    private static final int FNM_NOESCAPE = 1;
    private static final int FNM_PATHNAME = 2;
    private static final int FNM_DOTMATCH = 4;
    private static final int FNM_CASEFOLD = 8;
    private static final int FNM_SYSCASE = Platform.IS_WINDOWS ? 8 : 0;
    protected String path;
    private FileLock currentLock;
    private static ObjectAllocator FILE_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            RubyFile instance = new RubyFile(runtime2, klass);
            instance.setMetaClass(klass);
            return instance;
        }
    };

    public Encoding getEncoding() {
        return null;
    }

    private static boolean startsWithDriveLetterOnWindows(String path2) {
        return path2 != null && Platform.IS_WINDOWS && (path2.length() > 1 && path2.charAt(0) == '/' ? path2.length() > 2 && RubyFile.isWindowsDriveLetter(path2.charAt(1)) && path2.charAt(2) == ':' : path2.length() > 1 && RubyFile.isWindowsDriveLetter(path2.charAt(0)) && path2.charAt(1) == ':');
    }

    static String adjustRootPathOnWindows(Ruby runtime2, String path2, String dir) {
        if (path2 == null) {
            return path2;
        }
        if (Platform.IS_WINDOWS) {
            if (path2.startsWith("/") && (path2.length() <= 2 || path2.charAt(2) != ':') || path2.startsWith("\\")) {
                if (path2.length() > 1 && (path2.charAt(1) == '/' || path2.charAt(1) == '\\')) {
                    return path2;
                }
                if (!RubyFile.startsWithDriveLetterOnWindows(dir)) {
                    dir = runtime2.getCurrentDirectory();
                }
                if (dir.length() >= 2) {
                    path2 = dir.substring(0, 2) + path2;
                }
            } else if (RubyFile.startsWithDriveLetterOnWindows(path2) && path2.length() == 2) {
                path2 = path2 + "/";
            }
        }
        return path2;
    }

    public RubyFile(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    public RubyFile(Ruby runtime2, String path2, final Reader reader) {
        this(runtime2, path2, new InputStream(){

            public int read() throws IOException {
                return reader.read();
            }
        });
    }

    public RubyFile(Ruby runtime2, String path2, InputStream in) {
        super(runtime2, runtime2.getFile());
        this.path = path2;
        try {
            this.openFile.setMainStream(ChannelStream.open(runtime2, new ChannelDescriptor(Channels.newChannel(in), RubyFile.getNewFileno(), new FileDescriptor())));
        }
        catch (InvalidValueException ex) {
            throw runtime2.newErrnoEINVALError();
        }
        this.openFile.setMode(this.openFile.getMainStream().getModes().getOpenFileFlags());
        this.registerDescriptor(this.openFile.getMainStream().getDescriptor());
    }

    public String getPath() {
        return this.path;
    }

    public static RubyClass createFileClass(Ruby runtime2) {
        RubyClass fileClass = runtime2.defineClass("File", runtime2.getIO(), FILE_ALLOCATOR);
        RubyModule constants2 = fileClass.defineModuleUnder("Constants");
        runtime2.setFile(fileClass);
        fileClass.index = 26;
        fileClass.setReifiedClass(RubyFile.class);
        RubyString separator = runtime2.newString("/");
        ThreadContext context = runtime2.getCurrentContext();
        fileClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof RubyFile;
            }
        };
        separator.freeze(context);
        fileClass.defineConstant("SEPARATOR", separator);
        fileClass.defineConstant("Separator", separator);
        if (File.separatorChar == '\\') {
            RubyString altSeparator = runtime2.newString("\\");
            altSeparator.freeze(context);
            fileClass.defineConstant("ALT_SEPARATOR", altSeparator);
        } else {
            fileClass.defineConstant("ALT_SEPARATOR", runtime2.getNil());
        }
        RubyString pathSeparator = runtime2.newString(File.pathSeparator);
        pathSeparator.freeze(context);
        fileClass.defineConstant("PATH_SEPARATOR", pathSeparator);
        fileClass.fastSetConstant("FNM_NOESCAPE", runtime2.newFixnum(1));
        fileClass.fastSetConstant("FNM_CASEFOLD", runtime2.newFixnum(8));
        fileClass.fastSetConstant("FNM_SYSCASE", runtime2.newFixnum(FNM_SYSCASE));
        fileClass.fastSetConstant("FNM_DOTMATCH", runtime2.newFixnum(4));
        fileClass.fastSetConstant("FNM_PATHNAME", runtime2.newFixnum(2));
        for (OpenFlags f : OpenFlags.values()) {
            String name2 = f.name();
            if (!name2.startsWith("O_")) continue;
            String cname = name2.substring(2);
            RubyFixnum cvalue = f == OpenFlags.O_ACCMODE ? runtime2.newFixnum(ModeFlags.ACCMODE) : runtime2.newFixnum(f.value());
            fileClass.fastSetConstant(cname, cvalue);
            constants2.fastSetConstant(cname, cvalue);
        }
        fileClass.fastSetConstant("LOCK_SH", runtime2.newFixnum(1));
        fileClass.fastSetConstant("LOCK_EX", runtime2.newFixnum(2));
        fileClass.fastSetConstant("LOCK_NB", runtime2.newFixnum(4));
        fileClass.fastSetConstant("LOCK_UN", runtime2.newFixnum(8));
        constants2.fastSetConstant("FNM_NOESCAPE", runtime2.newFixnum(1));
        constants2.fastSetConstant("FNM_CASEFOLD", runtime2.newFixnum(8));
        constants2.fastSetConstant("FNM_SYSCASE", runtime2.newFixnum(FNM_SYSCASE));
        constants2.fastSetConstant("FNM_DOTMATCH", runtime2.newFixnum(4));
        constants2.fastSetConstant("FNM_PATHNAME", runtime2.newFixnum(2));
        constants2.fastSetConstant("LOCK_SH", runtime2.newFixnum(1));
        constants2.fastSetConstant("LOCK_EX", runtime2.newFixnum(2));
        constants2.fastSetConstant("LOCK_NB", runtime2.newFixnum(4));
        constants2.fastSetConstant("LOCK_UN", runtime2.newFixnum(8));
        runtime2.getIO().includeModule(constants2);
        runtime2.getFileTest().extend_object(fileClass);
        fileClass.defineAnnotatedMethods(RubyFile.class);
        return fileClass;
    }

    @JRubyMethod
    public IRubyObject close() {
        if (this.currentLock != null) {
            try {
                this.currentLock.release();
            }
            catch (IOException e) {
                throw this.getRuntime().newIOError(e.getMessage());
            }
        }
        return super.close();
    }

    @JRubyMethod(required=1)
    public IRubyObject flock(ThreadContext context, IRubyObject lockingConstant) {
        ChannelDescriptor descriptor = this.openFile.getMainStream().getDescriptor();
        if (descriptor.isNull()) {
            return RubyFixnum.zero(context.getRuntime());
        }
        if (descriptor.getChannel() instanceof FileChannel) {
            block18: {
                FileChannel fileChannel = (FileChannel)descriptor.getChannel();
                int lockMode = RubyNumeric.num2int(lockingConstant);
                if (!this.openFile.isWritable() && (lockMode & 2) > 0) {
                    lockMode = lockMode ^ 2 | 1;
                }
                try {
                    switch (lockMode) {
                        case 8: 
                        case 12: {
                            if (this.currentLock == null) break;
                            this.currentLock.release();
                            this.currentLock = null;
                            return RubyFixnum.zero(context.getRuntime());
                        }
                        case 2: {
                            if (this.currentLock != null) {
                                this.currentLock.release();
                                this.currentLock = null;
                            }
                            this.currentLock = fileChannel.lock();
                            if (this.currentLock == null) break;
                            return RubyFixnum.zero(context.getRuntime());
                        }
                        case 6: {
                            if (this.currentLock != null) {
                                this.currentLock.release();
                                this.currentLock = null;
                            }
                            this.currentLock = fileChannel.tryLock();
                            if (this.currentLock == null) break;
                            return RubyFixnum.zero(context.getRuntime());
                        }
                        case 1: {
                            if (this.currentLock != null) {
                                this.currentLock.release();
                                this.currentLock = null;
                            }
                            this.currentLock = fileChannel.lock(0L, Long.MAX_VALUE, true);
                            if (this.currentLock == null) break;
                            return RubyFixnum.zero(context.getRuntime());
                        }
                        case 5: {
                            if (this.currentLock != null) {
                                this.currentLock.release();
                                this.currentLock = null;
                            }
                            this.currentLock = fileChannel.tryLock(0L, Long.MAX_VALUE, true);
                            if (this.currentLock == null) break;
                            return RubyFixnum.zero(context.getRuntime());
                        }
                    }
                }
                catch (IOException ioe) {
                    if (context.getRuntime().getDebug().isTrue()) {
                        ioe.printStackTrace(System.err);
                    }
                }
                catch (OverlappingFileLockException ioe) {
                    if (!context.getRuntime().getDebug().isTrue()) break block18;
                    ioe.printStackTrace(System.err);
                }
            }
            return context.getRuntime().getFalse();
        }
        return context.getRuntime().getFalse();
    }

    @JRubyMethod(required=1, optional=2, frame=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public IRubyObject initialize(IRubyObject[] args2, Block block) {
        IRubyObject fd;
        if (this.openFile == null) {
            throw this.getRuntime().newRuntimeError("reinitializing File");
        }
        if (args2.length > 0 && args2.length < 3 && !(fd = TypeConverter.convertToTypeWithCheck(args2[0], this.getRuntime().getFixnum(), "to_int")).isNil()) {
            args2[0] = fd;
            return super.initialize(args2, block);
        }
        return this.openFile(args2);
    }

    @JRubyMethod(name={"initialize"}, required=1, optional=2, frame=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject fd;
        if (this.openFile == null) {
            throw context.getRuntime().newRuntimeError("reinitializing File");
        }
        if (args2.length > 0 && args2.length <= 3 && !(fd = TypeConverter.convertToTypeWithCheck(args2[0], context.getRuntime().getFixnum(), "to_int")).isNil()) {
            args2[0] = fd;
            if (args2.length == 1) {
                return super.initialize19(context, args2[0], block);
            }
            if (args2.length == 2) {
                return super.initialize19(context, args2[0], args2[1], block);
            }
            return super.initialize19(context, args2[0], args2[1], args2[2], block);
        }
        return this.openFile19(context, args2);
    }

    private IRubyObject openFile19(ThreadContext context, IRubyObject[] args2) {
        RubyString filename2 = RubyFile.get_path(context, args2[0]);
        context.getRuntime().checkSafeString(filename2);
        this.path = filename2.getUnicodeValue();
        ModeFlags modes = new ModeFlags();
        int perm = 0;
        try {
            String modeString;
            if (args2.length > 1) {
                modeString = args2[1].convertToString().toString();
                modes = this.parseModes19(context, args2[1]);
            } else {
                modeString = "r";
                modes = this.parseModes19(context, RubyString.newString(context.getRuntime(), modeString));
            }
            if (args2.length > 2 && !args2[2].isNil()) {
                if (args2[2] instanceof RubyHash) {
                    modes = this.parseOptions(context, args2[2], modes);
                } else {
                    perm = this.getFilePermissions(args2);
                }
            }
            if (perm > 0) {
                this.sysopenInternal(this.path, modes, perm);
            } else {
                this.openInternal(this.path, modeString, modes);
            }
        }
        catch (InvalidValueException ex) {
            throw context.getRuntime().newErrnoEINVALError();
        }
        return this;
    }

    private IRubyObject openFile(IRubyObject[] args2) {
        RubyString filename2 = RubyFile.get_path(this.getRuntime().getCurrentContext(), args2[0]);
        this.getRuntime().checkSafeString(filename2);
        this.path = filename2.getUnicodeValue();
        try {
            if (args2.length > 1 && args2[1] instanceof RubyFixnum || args2.length > 2 && !args2[2].isNil()) {
                ModeFlags modes = this.parseModes(args2[1]);
                int perm = this.getFilePermissions(args2);
                this.sysopenInternal(this.path, modes, perm);
            } else {
                String modeString = "r";
                if (args2.length > 1 && !args2[1].isNil()) {
                    modeString = args2[1].convertToString().toString();
                }
                this.openInternal(this.path, modeString);
            }
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        return this;
    }

    private int getFilePermissions(IRubyObject[] args2) {
        return args2.length > 2 && !args2[2].isNil() ? RubyNumeric.num2int(args2[2]) : 438;
    }

    protected void sysopenInternal(String path2, ModeFlags modes, int perm) throws InvalidValueException {
        this.openFile = new OpenFile();
        this.openFile.setPath(path2);
        this.openFile.setMode(modes.getOpenFileFlags());
        int umask2 = this.getRuntime().getPosix().umask(0);
        perm -= perm & umask2;
        ChannelDescriptor descriptor = this.sysopen(path2, modes, perm);
        this.openFile.setMainStream(this.fdopen(descriptor, modes));
        this.registerDescriptor(descriptor);
    }

    protected void openInternal(String path2, String modeString, ModeFlags modes) throws InvalidValueException {
        this.openFile = new OpenFile();
        this.openFile.setMode(modes.getOpenFileFlags());
        this.openFile.setPath(path2);
        this.openFile.setMainStream(this.fopen(path2, modeString));
        this.registerDescriptor(this.openFile.getMainStream().getDescriptor());
    }

    protected void openInternal(String path2, String modeString) throws InvalidValueException {
        this.openFile = new OpenFile();
        this.openFile.setMode(RubyFile.getIOModes(this.getRuntime(), modeString).getOpenFileFlags());
        this.openFile.setPath(path2);
        this.openFile.setMainStream(this.fopen(path2, modeString));
        this.registerDescriptor(this.openFile.getMainStream().getDescriptor());
    }

    private ChannelDescriptor sysopen(String path2, ModeFlags modes, int perm) throws InvalidValueException {
        try {
            ChannelDescriptor descriptor = ChannelDescriptor.open(this.getRuntime().getCurrentDirectory(), path2, modes, perm, this.getRuntime().getPosix());
            return descriptor;
        }
        catch (FileNotFoundException fnfe) {
            throw this.getRuntime().newErrnoENOENTError();
        }
        catch (DirectoryAsFileException dafe) {
            throw this.getRuntime().newErrnoEISDirError();
        }
        catch (FileExistsException fee) {
            throw this.getRuntime().newErrnoEEXISTError("file exists: " + path2);
        }
        catch (IOException ioe) {
            throw this.getRuntime().newIOErrorFromException(ioe);
        }
    }

    private Stream fopen(String path2, String modeString) {
        try {
            Stream stream = ChannelStream.fopen(this.getRuntime(), path2, RubyFile.getIOModes(this.getRuntime(), modeString));
            if (stream == null) {
                // empty if block
            }
            return stream;
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (FileNotFoundException ex) {
            if (Ruby.isSecurityRestricted() || new File(path2).exists()) {
                throw this.getRuntime().newErrnoEACCESError("Permission denied - " + path2);
            }
            throw this.getRuntime().newErrnoENOENTError("File not found - " + path2);
        }
        catch (DirectoryAsFileException ex) {
            throw this.getRuntime().newErrnoEISDirError();
        }
        catch (FileExistsException ex) {
            throw this.getRuntime().newErrnoEEXISTError(path2);
        }
        catch (IOException ex) {
            throw this.getRuntime().newIOErrorFromException(ex);
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException ex) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
        catch (SecurityException ex) {
            throw this.getRuntime().newErrnoEACCESError("Permission denied - " + path2);
        }
    }

    @JRubyMethod(required=1)
    public IRubyObject chmod(ThreadContext context, IRubyObject arg2) {
        int mode2 = (int)arg2.convertToInteger().getLongValue();
        if (!new File(this.path).exists()) {
            throw context.getRuntime().newErrnoENOENTError("No such file or directory - " + this.path);
        }
        return context.getRuntime().newFixnum(context.getRuntime().getPosix().chmod(this.path, mode2));
    }

    @JRubyMethod(required=2)
    public IRubyObject chown(ThreadContext context, IRubyObject arg1, IRubyObject arg2) {
        int owner2 = -1;
        if (!arg1.isNil()) {
            owner2 = RubyNumeric.num2int(arg1);
        }
        int group2 = -1;
        if (!arg2.isNil()) {
            group2 = RubyNumeric.num2int(arg2);
        }
        if (!new File(this.path).exists()) {
            throw context.getRuntime().newErrnoENOENTError("No such file or directory - " + this.path);
        }
        return context.getRuntime().newFixnum(context.getRuntime().getPosix().chown(this.path, owner2, group2));
    }

    @JRubyMethod
    public IRubyObject atime(ThreadContext context) {
        return context.getRuntime().newFileStat(this.path, false).atime();
    }

    @JRubyMethod
    public IRubyObject ctime(ThreadContext context) {
        return context.getRuntime().newFileStat(this.path, false).ctime();
    }

    @JRubyMethod(required=1)
    public IRubyObject lchmod(ThreadContext context, IRubyObject arg2) {
        int mode2 = (int)arg2.convertToInteger().getLongValue();
        if (!new File(this.path).exists()) {
            throw context.getRuntime().newErrnoENOENTError("No such file or directory - " + this.path);
        }
        return context.getRuntime().newFixnum(context.getRuntime().getPosix().lchmod(this.path, mode2));
    }

    @JRubyMethod(required=2)
    public IRubyObject lchown(ThreadContext context, IRubyObject arg1, IRubyObject arg2) {
        int owner2 = -1;
        if (!arg1.isNil()) {
            owner2 = RubyNumeric.num2int(arg1);
        }
        int group2 = -1;
        if (!arg2.isNil()) {
            group2 = RubyNumeric.num2int(arg2);
        }
        if (!new File(this.path).exists()) {
            throw context.getRuntime().newErrnoENOENTError("No such file or directory - " + this.path);
        }
        return context.getRuntime().newFixnum(context.getRuntime().getPosix().lchown(this.path, owner2, group2));
    }

    @JRubyMethod
    public IRubyObject lstat(ThreadContext context) {
        return context.getRuntime().newFileStat(this.path, true);
    }

    @JRubyMethod
    public IRubyObject mtime(ThreadContext context) {
        return RubyFile.getLastModified(context.getRuntime(), this.path);
    }

    @JRubyMethod(meta=true, frame=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject path(ThreadContext context, IRubyObject self, IRubyObject str) {
        return RubyFile.get_path(context, str);
    }

    public static RubyString get_path(ThreadContext context, IRubyObject obj) {
        if (context.getRuntime().is1_9()) {
            IRubyObject str = obj.checkStringType();
            if (!str.isNil()) {
                return (RubyString)str;
            }
            if (obj.respondsTo("to_path")) {
                obj = obj.callMethod(context, "to_path");
            }
        }
        return obj.convertToString();
    }

    @JRubyMethod(name={"path", "to_path"})
    public RubyString path(ThreadContext context) {
        return context.getRuntime().newString(this.path);
    }

    @JRubyMethod
    public IRubyObject stat(ThreadContext context) {
        this.openFile.checkClosed(context.getRuntime());
        return context.getRuntime().newFileStat(this.path, false);
    }

    @JRubyMethod(required=1)
    public IRubyObject truncate(ThreadContext context, IRubyObject arg2) {
        RubyInteger newLength = arg2.convertToInteger();
        if (newLength.getLongValue() < 0L) {
            throw context.getRuntime().newErrnoEINVALError("invalid argument: " + this.path);
        }
        try {
            this.openFile.checkWritable(context.getRuntime());
            this.openFile.getMainStream().ftruncate(newLength.getLongValue());
        }
        catch (BadDescriptorException e) {
            throw context.getRuntime().newErrnoEBADFError();
        }
        catch (PipeException e) {
            throw context.getRuntime().newErrnoESPIPEError();
        }
        catch (InvalidValueException ex) {
            throw context.getRuntime().newErrnoEINVALError();
        }
        catch (IOException e) {
            // empty catch block
        }
        return RubyFixnum.zero(context.getRuntime());
    }

    public String toString() {
        return "RubyFile(" + this.path + ", " + this.openFile.getMode() + ", " + this.openFile.getMainStream().getDescriptor().getFileno() + ")";
    }

    private static ModeFlags getModes(Ruby runtime2, IRubyObject object) throws InvalidValueException {
        if (object instanceof RubyString) {
            return RubyFile.getIOModes(runtime2, ((RubyString)object).toString());
        }
        if (object instanceof RubyFixnum) {
            return new ModeFlags(((RubyFixnum)object).getLongValue());
        }
        throw runtime2.newTypeError("Invalid type for modes");
    }

    @JRubyMethod
    public IRubyObject inspect() {
        StringBuilder val = new StringBuilder();
        val.append("#<File:").append(this.path);
        if (!this.openFile.isOpen()) {
            val.append(" (closed)");
        }
        val.append(">");
        return this.getRuntime().newString(val.toString());
    }

    @JRubyMethod(required=1, optional=1, meta=true)
    public static IRubyObject basename(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        int index2;
        char c;
        String name2 = RubyFile.get_path(context, args2[0]).getUnicodeValue();
        if (Platform.IS_WINDOWS && name2.length() > 1 && name2.charAt(1) == ':' && Character.isLetter(name2.charAt(0))) {
            switch (name2.length()) {
                case 2: {
                    return RubyString.newEmptyString(context.getRuntime()).infectBy(args2[0]);
                }
                case 3: {
                    return context.getRuntime().newString(name2.substring(2)).infectBy(args2[0]);
                }
            }
            switch (name2.charAt(2)) {
                case '/': 
                case '\\': {
                    break;
                }
                default: {
                    name2 = name2.substring(2);
                }
            }
        }
        while (name2.length() > 1 && name2.charAt(name2.length() - 1) == '/') {
            name2 = name2.substring(0, name2.length() - 1);
        }
        int slashCount = 0;
        int length2 = name2.length();
        for (int i = length2 - 1; i >= 0 && ((c = name2.charAt(i)) == '/' || c == '\\'); --i) {
            ++slashCount;
        }
        if (slashCount > 0 && length2 > 1) {
            name2 = name2.substring(0, name2.length() - slashCount);
        }
        if ((index2 = name2.lastIndexOf(47)) == -1) {
            index2 = name2.lastIndexOf(92);
        }
        if (!name2.equals("/") && index2 != -1) {
            name2 = name2.substring(index2 + 1);
        }
        if (args2.length == 2) {
            String ext2 = RubyString.stringValue(args2[1]).toString();
            if (".*".equals(ext2)) {
                index2 = name2.lastIndexOf(46);
                if (index2 > 0) {
                    name2 = name2.substring(0, index2);
                }
            } else if (name2.endsWith(ext2)) {
                name2 = name2.substring(0, name2.length() - ext2.length());
            }
        }
        return context.getRuntime().newString(name2).infectBy(args2[0]);
    }

    @JRubyMethod(required=2, rest=true, meta=true)
    public static IRubyObject chmod(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        int count2 = 0;
        RubyInteger mode2 = args2[0].convertToInteger();
        for (int i = 1; i < args2.length; ++i) {
            boolean result;
            RubyString filename2 = RubyFile.get_path(context, args2[i]);
            if (!RubyFileTest.exist_p(filename2, filename2).isTrue()) {
                throw runtime2.newErrnoENOENTError("No such file or directory - " + filename2);
            }
            boolean bl = result = 0 == runtime2.getPosix().chmod(filename2.getUnicodeValue(), (int)mode2.getLongValue());
            if (!result) continue;
            ++count2;
        }
        return runtime2.newFixnum(count2);
    }

    @JRubyMethod(required=3, rest=true, meta=true)
    public static IRubyObject chown(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        int count2 = 0;
        int owner2 = -1;
        if (!args2[0].isNil()) {
            owner2 = RubyNumeric.num2int(args2[0]);
        }
        int group2 = -1;
        if (!args2[1].isNil()) {
            group2 = RubyNumeric.num2int(args2[1]);
        }
        for (int i = 2; i < args2.length; ++i) {
            boolean result;
            RubyString filename2 = RubyFile.get_path(context, args2[i]);
            if (!RubyFileTest.exist_p(filename2, filename2).isTrue()) {
                throw runtime2.newErrnoENOENTError("No such file or directory - " + filename2);
            }
            boolean bl = result = 0 == runtime2.getPosix().chown(filename2.getUnicodeValue(), owner2, group2);
            if (!result) continue;
            ++count2;
        }
        return runtime2.newFixnum(count2);
    }

    @JRubyMethod(required=1, meta=true)
    public static IRubyObject dirname(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        char endChar;
        String result;
        RubyString filename2 = RubyFile.get_path(context, arg2);
        String jfilename = filename2.getUnicodeValue();
        String name2 = jfilename.replace('\\', '/');
        int minPathLength = 1;
        boolean trimmedSlashes = false;
        boolean startsWithDriveLetterOnWindows = RubyFile.startsWithDriveLetterOnWindows(name2);
        if (startsWithDriveLetterOnWindows) {
            minPathLength = 3;
        }
        while (name2.length() > minPathLength && name2.charAt(name2.length() - 1) == '/') {
            trimmedSlashes = true;
            name2 = name2.substring(0, name2.length() - 1);
        }
        if (startsWithDriveLetterOnWindows && name2.length() == 2) {
            result = trimmedSlashes ? jfilename.substring(0, 3) : jfilename.substring(0, 2) + '.';
        } else {
            int index2 = name2.lastIndexOf(47);
            if (index2 == -1) {
                if (startsWithDriveLetterOnWindows) {
                    return context.getRuntime().newString(jfilename.substring(0, 2) + ".");
                }
                return context.getRuntime().newString(".");
            }
            if (index2 == 0) {
                return context.getRuntime().newString("/");
            }
            if (startsWithDriveLetterOnWindows && index2 == 2) {
                ++index2;
            }
            result = jfilename.substring(0, index2);
        }
        while (result.length() > minPathLength && ((endChar = result.charAt(result.length() - 1)) == '/' || endChar == '\\')) {
            result = result.substring(0, result.length() - 1);
        }
        return context.getRuntime().newString(result).infectBy(filename2);
    }

    private static boolean isWindowsDriveLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    @JRubyMethod(required=1, meta=true)
    public static IRubyObject extname(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        IRubyObject baseFilename = RubyFile.basename(context, recv2, new IRubyObject[]{arg2});
        String filename2 = RubyString.stringValue(baseFilename).getUnicodeValue();
        String result = "";
        int dotIndex = filename2.lastIndexOf(".");
        if (dotIndex > 0 && dotIndex != filename2.length() - 1) {
            result = filename2.substring(dotIndex);
        }
        return context.getRuntime().newString(result);
    }

    @JRubyMethod(required=1, optional=1, meta=true)
    public static IRubyObject expand_path(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyFile.expandPathInternal(context, recv2, args2, true);
    }

    @JRubyMethod(required=1, optional=1, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject absolute_path(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyFile.expandPathInternal(context, recv2, args2, false);
    }

    private static IRubyObject expandPathInternal(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, boolean expandUser) {
        JRubyFile path2;
        Ruby runtime2 = context.getRuntime();
        String relativePath = RubyFile.get_path(context, args2[0]).getUnicodeValue();
        boolean isAbsoluteWithFilePrefix = relativePath.startsWith("file:");
        String cwd = null;
        if (expandUser) {
            relativePath = RubyFile.expandUserPath(context, relativePath);
        }
        if (args2.length == 2 && !args2[1].isNil()) {
            boolean startsWithSlashNotOnWindows;
            cwd = RubyFile.get_path(context, args2[1]).getUnicodeValue();
            if (expandUser) {
                cwd = RubyFile.expandUserPath(context, cwd);
            }
            boolean bl = startsWithSlashNotOnWindows = (cwd = RubyFile.adjustRootPathOnWindows(runtime2, cwd, null)) != null && !Platform.IS_WINDOWS && cwd.length() > 0 && cwd.charAt(0) == '/';
            if (!startsWithSlashNotOnWindows && !RubyFile.startsWithDriveLetterOnWindows(cwd)) {
                cwd = new File(runtime2.getCurrentDirectory(), cwd).getAbsolutePath();
            }
        } else {
            cwd = runtime2.getCurrentDirectory();
        }
        if (cwd == null) {
            return runtime2.getNil();
        }
        String padSlashes = "";
        if (!Platform.IS_WINDOWS) {
            if (relativePath.length() > 0 && relativePath.charAt(0) == '/') {
                padSlashes = RubyFile.countSlashes(relativePath);
            } else if (cwd.length() > 0 && cwd.charAt(0) == '/') {
                padSlashes = RubyFile.countSlashes(cwd);
            }
        }
        if (relativePath.length() == 0) {
            path2 = JRubyFile.create(relativePath, cwd);
        } else {
            relativePath = RubyFile.adjustRootPathOnWindows(runtime2, relativePath, cwd);
            path2 = JRubyFile.create(cwd, relativePath);
        }
        String tempResult = padSlashes + RubyFile.canonicalize(path2.getAbsolutePath());
        if (isAbsoluteWithFilePrefix) {
            tempResult = tempResult.substring(tempResult.indexOf("file:"));
        }
        return runtime2.newString(tempResult);
    }

    public static String expandUserPath(ThreadContext context, String path2) {
        int pathLength = path2.length();
        if (pathLength >= 1 && path2.charAt(0) == '~') {
            int userEnd = path2.indexOf(47);
            if (userEnd == -1) {
                if (pathLength == 1) {
                    path2 = RubyDir.getHomeDirectoryPath(context).toString();
                } else {
                    userEnd = pathLength;
                }
            }
            if (userEnd == 1) {
                path2 = RubyDir.getHomeDirectoryPath(context).toString() + path2.substring(1);
            } else if (userEnd > 1) {
                String user = path2.substring(1, userEnd);
                IRubyObject dir = RubyDir.getHomeDirectoryPath(context, user);
                if (dir.isNil()) {
                    throw context.getRuntime().newArgumentError("user " + user + " does not exist");
                }
                path2 = "" + dir + (pathLength == userEnd ? "" : path2.substring(userEnd));
            }
        }
        return path2;
    }

    private static String countSlashes(String stringToCheck) {
        int slashCount = 0;
        for (int i = 0; i < stringToCheck.length() && stringToCheck.charAt(i) == '/'; ++i) {
            ++slashCount;
        }
        if (slashCount > 0) {
            --slashCount;
        }
        byte[] slashes = new byte[slashCount];
        for (int i = 0; i < slashCount; ++i) {
            slashes[i] = 47;
        }
        return new String(slashes);
    }

    private static String canonicalize(String path2) {
        return RubyFile.canonicalize(null, path2);
    }

    private static String canonicalize(String canonicalPath, String remaining) {
        String child;
        if (remaining == null) {
            if ("".equals(canonicalPath)) {
                return "/";
            }
            if (RubyFile.startsWithDriveLetterOnWindows(canonicalPath) && canonicalPath.length() == 2) {
                canonicalPath = canonicalPath + "/";
            }
            return canonicalPath;
        }
        int slash = remaining.indexOf(47);
        if (slash == -1) {
            child = remaining;
            remaining = null;
        } else {
            child = remaining.substring(0, slash);
            remaining = remaining.substring(slash + 1);
        }
        if (child.equals(".")) {
            if (slash == -1 && canonicalPath != null && canonicalPath.length() == 0 && slash == -1) {
                canonicalPath = canonicalPath + "/";
            }
        } else if (child.equals("..")) {
            if (canonicalPath == null) {
                throw new IllegalArgumentException("Cannot have .. at the start of an absolute path");
            }
            int lastDir = canonicalPath.lastIndexOf(47);
            if (lastDir == -1) {
                if (!RubyFile.startsWithDriveLetterOnWindows(canonicalPath)) {
                    canonicalPath = "";
                }
            } else {
                canonicalPath = canonicalPath.substring(0, lastDir);
            }
        } else {
            canonicalPath = canonicalPath == null ? child : canonicalPath + "/" + child;
        }
        return RubyFile.canonicalize(canonicalPath, remaining);
    }

    @JRubyMethod(name={"fnmatch", "fnmatch?"}, required=2, optional=1, meta=true)
    public static IRubyObject fnmatch(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        int flags = args2.length == 3 ? RubyNumeric.num2int(args2[2]) : 0;
        ByteList pattern = args2[0].convertToString().getByteList();
        ByteList path2 = RubyFile.get_path(context, args2[1]).getByteList();
        if (Dir.fnmatch(pattern.getUnsafeBytes(), pattern.getBegin(), pattern.getBegin() + pattern.getRealSize(), path2.getUnsafeBytes(), path2.getBegin(), path2.getBegin() + path2.getRealSize(), flags) == 0) {
            return context.getRuntime().getTrue();
        }
        return context.getRuntime().getFalse();
    }

    @JRubyMethod(name={"ftype"}, required=1, meta=true)
    public static IRubyObject ftype(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        return context.getRuntime().newFileStat(RubyFile.get_path(context, filename2).getUnicodeValue(), true).ftype();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String inspectJoin(ThreadContext context, IRubyObject recv2, RubyArray parent, RubyArray array) {
        Ruby runtime2 = context.getRuntime();
        if (runtime2.isInspecting(parent)) {
            return RubyFile.join(context, recv2, array).toString();
        }
        try {
            runtime2.registerInspecting(parent);
            String string2 = RubyFile.join(context, recv2, array).toString();
            return string2;
        }
        finally {
            runtime2.unregisterInspecting(parent);
        }
    }

    private static RubyString join(ThreadContext context, IRubyObject recv2, RubyArray ary) {
        IRubyObject[] args2 = ary.toJavaArray();
        boolean isTainted = false;
        StringBuilder buffer = new StringBuilder();
        Ruby runtime2 = context.getRuntime();
        for (int i = 0; i < args2.length; ++i) {
            String element;
            if (args2[i].isTaint()) {
                isTainted = true;
            }
            if (args2[i] instanceof RubyString) {
                element = args2[i].convertToString().getUnicodeValue();
            } else if (args2[i] instanceof RubyArray) {
                if (runtime2.isInspecting(args2[i])) {
                    throw runtime2.newArgumentError("recursive array");
                }
                element = RubyFile.inspectJoin(context, recv2, ary, (RubyArray)args2[i]);
            } else {
                RubyString path2 = RubyFile.get_path(context, args2[i]);
                element = path2.getUnicodeValue();
            }
            RubyFile.chomp(buffer);
            if (i > 0 && !element.startsWith("/") && !element.startsWith("\\")) {
                buffer.append("/");
            }
            buffer.append(element);
        }
        RubyString fixedStr = RubyString.newString(runtime2, buffer.toString());
        fixedStr.setTaint(isTainted);
        return fixedStr;
    }

    @JRubyMethod(rest=true, meta=true)
    public static RubyString join(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyFile.join(context, recv2, RubyArray.newArrayNoCopyLight(context.getRuntime(), args2));
    }

    private static void chomp(StringBuilder buffer) {
        for (int lastIndex = buffer.length() - 1; lastIndex >= 0 && (buffer.lastIndexOf("/") == lastIndex || buffer.lastIndexOf("\\") == lastIndex); --lastIndex) {
            buffer.setLength(lastIndex);
        }
    }

    @JRubyMethod(name={"lstat"}, required=1, meta=true)
    public static IRubyObject lstat(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        String f = RubyFile.get_path(context, filename2).getUnicodeValue();
        if (f.startsWith("file:") && f.indexOf(33) != -1) {
            f = f.substring(5, f.indexOf("!"));
        }
        return context.getRuntime().newFileStat(f, true);
    }

    @JRubyMethod(name={"stat"}, required=1, meta=true)
    public static IRubyObject stat(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        String f = RubyFile.get_path(context, filename2).getUnicodeValue();
        if (f.startsWith("file:") && f.indexOf(33) != -1) {
            f = f.substring(5, f.indexOf("!"));
        }
        return context.getRuntime().newFileStat(f, false);
    }

    @JRubyMethod(name={"atime"}, required=1, meta=true)
    public static IRubyObject atime(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        String f = RubyFile.get_path(context, filename2).getUnicodeValue();
        if (f.startsWith("file:") && f.indexOf(33) != -1) {
            f = f.substring(5, f.indexOf("!"));
        }
        return context.getRuntime().newFileStat(f, false).atime();
    }

    @JRubyMethod(name={"ctime"}, required=1, meta=true)
    public static IRubyObject ctime(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        String f = RubyFile.get_path(context, filename2).getUnicodeValue();
        if (f.startsWith("file:") && f.indexOf(33) != -1) {
            f = f.substring(5, f.indexOf("!"));
        }
        return context.getRuntime().newFileStat(f, false).ctime();
    }

    @JRubyMethod(required=2, rest=true, meta=true)
    public static IRubyObject lchmod(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        int count2 = 0;
        RubyInteger mode2 = args2[0].convertToInteger();
        for (int i = 1; i < args2.length; ++i) {
            boolean result;
            RubyString filename2 = RubyFile.get_path(context, args2[i]);
            if (!RubyFileTest.exist_p(filename2, filename2).isTrue()) {
                throw runtime2.newErrnoENOENTError("No such file or directory - " + filename2);
            }
            boolean bl = result = 0 == runtime2.getPosix().lchmod(filename2.getUnicodeValue(), (int)mode2.getLongValue());
            if (!result) continue;
            ++count2;
        }
        return runtime2.newFixnum(count2);
    }

    @JRubyMethod(required=2, rest=true, meta=true)
    public static IRubyObject lchown(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        int owner2 = !args2[0].isNil() ? RubyNumeric.num2int(args2[0]) : -1;
        int group2 = !args2[1].isNil() ? RubyNumeric.num2int(args2[1]) : -1;
        int count2 = 0;
        for (int i = 2; i < args2.length; ++i) {
            IRubyObject filename2 = args2[i];
            if (0 != runtime2.getPosix().lchown(filename2.toString(), owner2, group2)) {
                throw runtime2.newErrnoFromLastPOSIXErrno();
            }
            ++count2;
        }
        return runtime2.newFixnum(count2);
    }

    @JRubyMethod(required=2, meta=true, backtrace=true)
    public static IRubyObject link(ThreadContext context, IRubyObject recv2, IRubyObject from, IRubyObject to) {
        Ruby runtime2 = context.getRuntime();
        RubyString fromStr = RubyString.stringValue(from);
        RubyString toStr = RubyString.stringValue(to);
        int ret = runtime2.getPosix().link(fromStr.getUnicodeValue(), toStr.getUnicodeValue());
        if (ret != 0) {
            throw runtime2.newErrnoEEXISTError("File exists - " + fromStr + " or " + toStr);
        }
        return runtime2.newFixnum(ret);
    }

    @JRubyMethod(name={"mtime"}, required=1, meta=true)
    public static IRubyObject mtime(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        return RubyFile.getLastModified(context.getRuntime(), RubyFile.get_path(context, filename2).getUnicodeValue());
    }

    @JRubyMethod(required=2, meta=true)
    public static IRubyObject rename(ThreadContext context, IRubyObject recv2, IRubyObject oldName, IRubyObject newName) {
        Ruby runtime2 = context.getRuntime();
        RubyString oldNameString = RubyString.stringValue(oldName);
        RubyString newNameString = RubyString.stringValue(newName);
        runtime2.checkSafeString(oldNameString);
        runtime2.checkSafeString(newNameString);
        String newNameJavaString = newNameString.getUnicodeValue();
        String oldNameJavaString = oldNameString.getUnicodeValue();
        JRubyFile oldFile = JRubyFile.create(runtime2.getCurrentDirectory(), oldNameJavaString);
        JRubyFile newFile = JRubyFile.create(runtime2.getCurrentDirectory(), newNameJavaString);
        if (!oldFile.exists() || !newFile.getParentFile().exists()) {
            throw runtime2.newErrnoENOENTError("No such file or directory - " + oldNameJavaString + " or " + newNameJavaString);
        }
        JRubyFile dest = JRubyFile.create(runtime2.getCurrentDirectory(), newNameJavaString);
        if (oldFile.renameTo(dest)) {
            return RubyFixnum.zero(runtime2);
        }
        if (newFile.exists()) {
            runtime2.getPosix().chmod(newNameJavaString, 438);
            newFile.delete();
        }
        if (oldFile.renameTo(dest)) {
            return RubyFixnum.zero(runtime2);
        }
        throw runtime2.newErrnoEACCESError("Permission denied - " + oldNameJavaString + " or " + newNameJavaString);
    }

    @JRubyMethod(required=1, meta=true)
    public static RubyArray split(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        RubyString filename2 = RubyFile.get_path(context, arg2);
        return context.getRuntime().newArray(RubyFile.dirname(context, recv2, filename2), RubyFile.basename(context, recv2, new IRubyObject[]{filename2}));
    }

    @JRubyMethod(required=2, meta=true)
    public static IRubyObject symlink(ThreadContext context, IRubyObject recv2, IRubyObject from, IRubyObject to) {
        Ruby runtime2 = context.getRuntime();
        RubyString fromStr = RubyFile.get_path(context, from);
        RubyString toStr = RubyFile.get_path(context, to);
        String tovalue = toStr.getUnicodeValue();
        tovalue = JRubyFile.create(runtime2.getCurrentDirectory(), tovalue).getAbsolutePath();
        try {
            if (runtime2.getPosix().symlink(fromStr.getUnicodeValue(), tovalue) == -1) {
                throw runtime2.newErrnoEEXISTError("File exists - " + fromStr + " or " + toStr);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            throw runtime2.newNotImplementedError("symlink() function is unimplemented on this machine");
        }
        return runtime2.newFixnum(0);
    }

    @JRubyMethod(required=1, meta=true)
    public static IRubyObject readlink(ThreadContext context, IRubyObject recv2, IRubyObject path2) {
        Ruby runtime2 = context.getRuntime();
        try {
            String realPath = runtime2.getPosix().readlink(path2.convertToString().getUnicodeValue());
            if (!RubyFileTest.exist_p(recv2, path2).isTrue()) {
                throw runtime2.newErrnoENOENTError("No such file or directory - " + path2);
            }
            if (!RubyFileTest.symlink_p(recv2, path2).isTrue()) {
                throw runtime2.newErrnoEINVALError("invalid argument - " + path2);
            }
            if (realPath == null) {
                // empty if block
            }
            return runtime2.newString(realPath);
        }
        catch (IOException e) {
            throw runtime2.newIOError(e.getMessage());
        }
    }

    @JRubyMethod(required=2, meta=true)
    public static IRubyObject truncate(ThreadContext context, IRubyObject recv2, IRubyObject arg1, IRubyObject arg2) {
        Ruby runtime2 = context.getRuntime();
        RubyString filename2 = arg1.convertToString();
        RubyInteger newLength = arg2.convertToInteger();
        File childFile = new File(filename2.getUnicodeValue());
        File testFile = childFile.isAbsolute() ? childFile : new File(runtime2.getCurrentDirectory(), filename2.getByteList().toString());
        if (!testFile.exists()) {
            throw runtime2.newErrnoENOENTError("No such file or directory - " + filename2.getByteList().toString());
        }
        if (newLength.getLongValue() < 0L) {
            throw runtime2.newErrnoEINVALError("invalid argument: " + filename2);
        }
        IRubyObject[] args2 = new IRubyObject[]{filename2, runtime2.newString("r+")};
        RubyFile file2 = (RubyFile)RubyFile.open(context, recv2, args2, Block.NULL_BLOCK);
        file2.truncate(context, newLength);
        file2.close();
        return RubyFixnum.zero(runtime2);
    }

    @JRubyMethod(meta=true, optional=1)
    public static IRubyObject umask(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        int oldMask = 0;
        if (args2.length == 0) {
            oldMask = runtime2.getPosix().umask(0);
            runtime2.getPosix().umask(oldMask);
        } else if (args2.length == 1) {
            oldMask = runtime2.getPosix().umask((int)args2[0].convertToInteger().getLongValue());
        } else {
            runtime2.newArgumentError("wrong number of arguments");
        }
        return runtime2.newFixnum(oldMask);
    }

    @JRubyMethod(required=2, rest=true, meta=true)
    public static IRubyObject utime(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        long[] atimeval = null;
        long[] mtimeval = null;
        if (args2[0] != runtime2.getNil() || args2[1] != runtime2.getNil()) {
            atimeval = RubyFile.extractTimeval(runtime2, args2[0]);
            mtimeval = RubyFile.extractTimeval(runtime2, args2[1]);
        }
        int j = args2.length;
        for (int i = 2; i < j; ++i) {
            RubyString filename2 = RubyFile.get_path(context, args2[i]);
            runtime2.checkSafeString(filename2);
            JRubyFile fileToTouch = JRubyFile.create(runtime2.getCurrentDirectory(), filename2.getUnicodeValue());
            if (!fileToTouch.exists()) {
                throw runtime2.newErrnoENOENTError(" No such file or directory - \"" + filename2 + "\"");
            }
            runtime2.getPosix().utimes(fileToTouch.getAbsolutePath(), atimeval, mtimeval);
        }
        return runtime2.newFixnum(args2.length - 2);
    }

    @JRubyMethod(name={"unlink", "delete"}, rest=true, meta=true)
    public static IRubyObject unlink(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        for (int i = 0; i < args2.length; ++i) {
            RubyString filename2 = RubyFile.get_path(context, args2[i]);
            runtime2.checkSafeString(filename2);
            JRubyFile lToDelete = JRubyFile.create(runtime2.getCurrentDirectory(), filename2.getUnicodeValue());
            boolean isSymlink = RubyFileTest.symlink_p(recv2, filename2).isTrue();
            if (!lToDelete.exists() && !isSymlink) {
                throw runtime2.newErrnoENOENTError(" No such file or directory - \"" + filename2 + "\"");
            }
            if (lToDelete.delete()) continue;
            throw runtime2.newErrnoEACCESError("Permission denied - \"" + filename2 + "\"");
        }
        return runtime2.newFixnum(args2.length);
    }

    private static long[] extractTimeval(Ruby runtime2, IRubyObject value2) {
        long[] timeval = new long[2];
        if (value2 instanceof RubyFloat) {
            timeval[0] = Platform.IS_32_BIT ? (long)RubyNumeric.num2int(value2) : RubyNumeric.num2long(value2);
            double fraction = ((RubyFloat)value2).getDoubleValue() % 1.0;
            timeval[1] = (long)(fraction * 1000000.0 + 0.5);
        } else if (value2 instanceof RubyNumeric) {
            timeval[0] = Platform.IS_32_BIT ? (long)RubyNumeric.num2int(value2) : RubyNumeric.num2long(value2);
            timeval[1] = 0L;
        } else {
            RubyTime time = value2 instanceof RubyTime ? (RubyTime)value2 : (RubyTime)TypeConverter.convertToType(value2, runtime2.getTime(), "to_time", true);
            timeval[0] = Platform.IS_32_BIT ? (long)RubyNumeric.num2int(time.to_i()) : RubyNumeric.num2long(time.to_i());
            timeval[1] = Platform.IS_32_BIT ? (long)RubyNumeric.num2int(time.usec()) : RubyNumeric.num2long(time.usec());
        }
        return timeval;
    }

    private static IRubyObject getLastModified(Ruby runtime2, String path2) {
        JRubyFile file2 = JRubyFile.create(runtime2.getCurrentDirectory(), path2);
        if (!file2.exists()) {
            throw runtime2.newErrnoENOENTError("No such file or directory - " + path2);
        }
        return runtime2.newTime(file2.lastModified());
    }

    @JRubyModule(name={"File::Constants"})
    public static class Constants {
    }
}

