/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.TypeConverter;

@JRubyModule(name={"Math"})
public class RubyMath {
    private static final double[] ASINH_COEF = new double[]{-0.12820039911738187, -0.05881176118995177, 0.004727465432212481, -4.938363162653618E-4, 5.850620705855741E-5, -7.466998328931368E-6, 1.00116935835582E-6, -1.3903543858708333E-7, 1.9823169483172795E-8, -2.8847468417848845E-9, 4.2672965467159937E-10, -6.397608465436636E-11, 9.699168608906471E-12, -1.4844276972043772E-12, 2.290373793902745E-13, -3.5588395132732646E-14, 5.563969408005679E-15, -8.746250959962468E-16, 1.381524884452669E-16, -2.1916688282900364E-17, 3.490465852482756E-18};
    private static final double[] ATANH_COEF = new double[]{0.0943951023931955, 0.04919843705578616, 0.002102593522455433, 1.0735544497761166E-4, 5.978267249293031E-6, 3.505062030889135E-7, 2.1263743437653402E-8, 1.3216945357155272E-9, 8.36587550117807E-11, 5.370503749311002E-12, 3.4866594701571077E-13, 2.284549509603433E-14, 1.508407105944793E-15, 1.0024188168041091E-16, 6.69867473816507E-18, 4.497954546494931E-19};
    private static final double[] ERFC_COEF = new double[]{-0.049046121234691806, -0.14226120510371365, 0.010035582187599796, -5.768764699767485E-4, 2.741993125219606E-5, -1.1043175507344507E-6, 3.8488755420345036E-8, -1.1808582533875466E-9, 3.2334215826050907E-11, -7.991015947004549E-13, 1.7990725113961456E-14, -3.718635487818693E-16, 7.103599003714253E-18, -1.2612455119155226E-19};
    private static final double[] ERFC2_COEF = new double[]{-0.0696013466023095, -0.04110133936262089, 0.003914495866689627, -4.906395650548979E-4, 7.157479001377036E-5, -1.1530716341312328E-5, 1.9946705902019974E-6, -3.642666471599223E-7, 6.944372610005012E-8, -1.371220902104366E-8, 2.7883896610071373E-9, -5.814164724331161E-10, 1.2389204917527532E-10, -2.6906391453067435E-11, 5.942614350847911E-12, -1.3323867357581197E-12, 3.0280468061771323E-13, -6.966648814941033E-14, 1.620854541053923E-14, -3.809934465250492E-15, 9.040487815978831E-16, -2.1640061950896072E-16, 5.222102233995855E-17, -1.2697296023645554E-17, 3.1091455042761977E-18, -7.663762920320386E-19, 1.9008192513627452E-19};
    private static final double[] ERFCC_COEF = new double[]{0.07151793102029248, -0.026532434337606717, 0.0017111539779208558, -1.6375166345851787E-4, 1.9871293500552038E-5, -2.843712412766555E-6, 4.6061613089631305E-7, -8.227753025879209E-8, 1.5921418727709012E-8, -3.295071362252843E-9, 7.223439760400556E-10, -1.6648558133987297E-10, 4.010392588237665E-11, -1.004816214425731E-11, 2.608275913300334E-12, -6.991110560404025E-13, 1.9294923332617072E-13, -5.470131188754331E-14, 1.5896633097626975E-14, -4.726893980197555E-15, 1.4358733767849847E-15, -4.449510561817358E-16, 1.4048108847682335E-16, -4.5138183877642106E-17, 1.474521541045133E-17, -4.8926214069457765E-18, 1.6476121414106467E-18, -5.626817176329408E-19, 1.9474433822320786E-19};
    private static final double[] FACTORIAL = new double[]{1.0, 1.0, 2.0, 6.0, 24.0, 120.0, 720.0, 5040.0, 40320.0, 362880.0, 3628800.0, 3.99168E7, 4.790016E8, 6.2270208E9, 8.71782912E10, 1.307674368E12, 2.0922789888E13, 3.55687428096E14, 6.402373705728E15, 1.21645100408832E17, 2.43290200817664E18, 5.109094217170944E19, 1.1240007277776077E21};
    private static final double[] NEMES_GAMMA_COEFF = new double[]{1.0, 0.0, 0.08333333333333333, 0.0, 6.944444444444445E-4, 0.0, 6.586199294532628E-4, 0.0, -5.328781782774838E-4, 0.0, 7.927858870060838E-4, 0.0, -0.0018475818932203302, 0.0, 0.006250678247849418, 0.0, -0.02901710246301151, 0.0, 0.1771845724249131, 0.0, -1.3774768170399354};

    public static RubyModule createMathModule(Ruby runtime2) {
        RubyModule result = runtime2.defineModule("Math");
        runtime2.setMath(result);
        result.defineConstant("E", RubyFloat.newFloat(runtime2, Math.E));
        result.defineConstant("PI", RubyFloat.newFloat(runtime2, Math.PI));
        result.defineAnnotatedMethods(RubyMath.class);
        return result;
    }

    private static void domainCheck(IRubyObject recv2, double value2, String msg) {
        if (Double.isNaN(value2)) {
            throw recv2.getRuntime().newErrnoEDOMError(msg);
        }
    }

    private static void zeroInLogCheck(IRubyObject recv2, double value2) {
        if (value2 == 0.0) {
            throw recv2.getRuntime().newErrnoEDOMError("log");
        }
    }

    private static double chebylevSerie(double x, double[] coef) {
        double b1 = 0.0;
        double b0 = 0.0;
        double b2 = 0.0;
        double twox = 2.0 * x;
        for (int i = coef.length - 1; i >= 0; --i) {
            b2 = b1;
            b1 = b0;
            b0 = twox * b1 - b2 + coef[i];
        }
        return 0.5 * (b0 - b2);
    }

    private static double sign(double x, double y) {
        double abs3 = x < 0.0 ? -x : x;
        return y < 0.0 ? -abs3 : abs3;
    }

    private static RubyFloat needFloat(IRubyObject x) {
        if (x instanceof RubyFloat) {
            return (RubyFloat)x;
        }
        if (!x.getRuntime().getNumeric().isInstance(x)) {
            TypeConverter.handleUncoercibleObject(true, x, x.getRuntime().getFloat());
        }
        return (RubyFloat)TypeConverter.convertToType19(x, x.getRuntime().getFloat(), "to_f", true);
    }

    @JRubyMethod(name={"atan2"}, required=2, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyFloat atan2(IRubyObject recv2, IRubyObject x, IRubyObject y) {
        double valuea = RubyKernel.new_float(recv2, x).getDoubleValue();
        double valueb = RubyKernel.new_float(recv2, y).getDoubleValue();
        return RubyFloat.newFloat(recv2.getRuntime(), Math.atan2(valuea, valueb));
    }

    @JRubyMethod(name={"atan2"}, required=2, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyFloat atan219(IRubyObject recv2, IRubyObject x, IRubyObject y) {
        double valuea = RubyMath.needFloat(x).getDoubleValue();
        double valueb = RubyMath.needFloat(y).getDoubleValue();
        return RubyFloat.newFloat(recv2.getRuntime(), Math.atan2(valuea, valueb));
    }

    @JRubyMethod(name={"cos"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyFloat cos(IRubyObject recv2, IRubyObject x) {
        double value2 = RubyKernel.new_float(recv2, x).getDoubleValue();
        return RubyFloat.newFloat(recv2.getRuntime(), Math.cos(value2));
    }

    @JRubyMethod(name={"cos"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyFloat cos19(IRubyObject recv2, IRubyObject x) {
        double value2 = RubyMath.needFloat(x).getDoubleValue();
        return RubyFloat.newFloat(recv2.getRuntime(), Math.cos(value2));
    }

    @JRubyMethod(name={"sin"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyFloat sin(IRubyObject recv2, IRubyObject x) {
        double value2 = RubyKernel.new_float(recv2, x).getDoubleValue();
        return RubyFloat.newFloat(recv2.getRuntime(), Math.sin(value2));
    }

    @JRubyMethod(name={"sin"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyFloat sin19(IRubyObject recv2, IRubyObject x) {
        double value2 = RubyMath.needFloat(x).getDoubleValue();
        return RubyFloat.newFloat(recv2.getRuntime(), Math.sin(value2));
    }

    @JRubyMethod(name={"tan"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyFloat tan(IRubyObject recv2, IRubyObject x) {
        double value2 = RubyKernel.new_float(recv2, x).getDoubleValue();
        return RubyFloat.newFloat(recv2.getRuntime(), Math.tan(value2));
    }

    @JRubyMethod(name={"tan"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyFloat tan19(IRubyObject recv2, IRubyObject x) {
        double value2 = RubyMath.needFloat(x).getDoubleValue();
        return RubyFloat.newFloat(recv2.getRuntime(), Math.tan(value2));
    }

    @JRubyMethod(name={"asin"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyFloat asin(IRubyObject recv2, IRubyObject x) {
        double value2 = RubyKernel.new_float(recv2, x).getDoubleValue();
        double result = Math.asin(value2);
        RubyMath.domainCheck(recv2, result, "asin");
        return RubyFloat.newFloat(recv2.getRuntime(), result);
    }

    @JRubyMethod(name={"asin"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyFloat asin19(IRubyObject recv2, IRubyObject x) {
        double value2 = RubyMath.needFloat(x).getDoubleValue();
        double result = Math.asin(value2);
        RubyMath.domainCheck(recv2, result, "asin");
        return RubyFloat.newFloat(recv2.getRuntime(), result);
    }

    @JRubyMethod(name={"acos"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyFloat acos(IRubyObject recv2, IRubyObject x) {
        double value2 = RubyKernel.new_float(recv2, x).getDoubleValue();
        double result = Math.acos(value2);
        RubyMath.domainCheck(recv2, result, "acos");
        return RubyFloat.newFloat(recv2.getRuntime(), result);
    }

    @JRubyMethod(name={"acos"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyFloat acos19(IRubyObject recv2, IRubyObject x) {
        double value2 = RubyMath.needFloat(x).getDoubleValue();
        double result = Math.acos(value2);
        RubyMath.domainCheck(recv2, result, "acos");
        return RubyFloat.newFloat(recv2.getRuntime(), result);
    }

    @JRubyMethod(name={"atan"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyFloat atan(IRubyObject recv2, IRubyObject x) {
        double value2 = RubyKernel.new_float(recv2, x).getDoubleValue();
        return RubyFloat.newFloat(recv2.getRuntime(), Math.atan(value2));
    }

    @JRubyMethod(name={"atan"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyFloat atan19(IRubyObject recv2, IRubyObject x) {
        double value2 = RubyMath.needFloat(x).getDoubleValue();
        return RubyFloat.newFloat(recv2.getRuntime(), Math.atan(value2));
    }

    @JRubyMethod(name={"cosh"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyFloat cosh(IRubyObject recv2, IRubyObject x) {
        double value2 = RubyKernel.new_float(recv2, x).getDoubleValue();
        return RubyFloat.newFloat(recv2.getRuntime(), (Math.exp(value2) + Math.exp(-value2)) / 2.0);
    }

    @JRubyMethod(name={"cosh"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyFloat cosh19(IRubyObject recv2, IRubyObject x) {
        double value2 = RubyMath.needFloat(x).getDoubleValue();
        return RubyFloat.newFloat(recv2.getRuntime(), (Math.exp(value2) + Math.exp(-value2)) / 2.0);
    }

    @JRubyMethod(name={"sinh"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyFloat sinh(IRubyObject recv2, IRubyObject x) {
        double value2 = RubyKernel.new_float(recv2, x).getDoubleValue();
        return RubyFloat.newFloat(recv2.getRuntime(), (Math.exp(value2) - Math.exp(-value2)) / 2.0);
    }

    @JRubyMethod(name={"sinh"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyFloat sinh19(IRubyObject recv2, IRubyObject x) {
        double value2 = RubyMath.needFloat(x).getDoubleValue();
        return RubyFloat.newFloat(recv2.getRuntime(), (Math.exp(value2) - Math.exp(-value2)) / 2.0);
    }

    @JRubyMethod(name={"tanh"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyFloat tanh(IRubyObject recv2, IRubyObject x) {
        double value2 = RubyKernel.new_float(recv2, x).getDoubleValue();
        return RubyFloat.newFloat(recv2.getRuntime(), Math.tanh(value2));
    }

    @JRubyMethod(name={"tanh"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyFloat tanh19(IRubyObject recv2, IRubyObject x) {
        double value2 = RubyMath.needFloat(x).getDoubleValue();
        return RubyFloat.newFloat(recv2.getRuntime(), Math.tanh(value2));
    }

    @JRubyMethod(name={"acosh"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyFloat acosh(IRubyObject recv2, IRubyObject x) {
        double value2 = RubyKernel.new_float(recv2, x).getDoubleValue();
        double result = Double.isNaN(value2) || value2 < 1.0 ? Double.NaN : (value2 < 9.490626562E7 ? Math.log(value2 + Math.sqrt(value2 * value2 - 1.0)) : 0.6931471805599453 + Math.log(value2));
        RubyMath.domainCheck(recv2, result, "acosh");
        return RubyFloat.newFloat(recv2.getRuntime(), result);
    }

    @JRubyMethod(name={"acosh"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyFloat acosh19(IRubyObject recv2, IRubyObject x) {
        double value2 = RubyMath.needFloat(x).getDoubleValue();
        double result = Double.isNaN(value2) || value2 < 1.0 ? Double.NaN : (value2 < 9.490626562E7 ? Math.log(value2 + Math.sqrt(value2 * value2 - 1.0)) : 0.6931471805599453 + Math.log(value2));
        RubyMath.domainCheck(recv2, result, "acosh");
        return RubyFloat.newFloat(recv2.getRuntime(), result);
    }

    @JRubyMethod(name={"asinh"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyFloat asinh(IRubyObject recv2, IRubyObject x) {
        double result;
        double value2 = RubyKernel.new_float(recv2, x).getDoubleValue();
        double y = Math.abs(value2);
        if (Double.isNaN(value2)) {
            result = Double.NaN;
        } else if (y <= 1.05367E-8) {
            result = value2;
        } else if (y <= 1.0) {
            result = value2 * (1.0 + RubyMath.chebylevSerie(2.0 * value2 * value2 - 1.0, ASINH_COEF));
        } else if (y < 9.490626562E7) {
            result = Math.log(value2 + Math.sqrt(value2 * value2 + 1.0));
        } else {
            result = 0.6931471805599453 + Math.log(y);
            if (value2 < 0.0) {
                result *= -1.0;
            }
        }
        return RubyFloat.newFloat(recv2.getRuntime(), result);
    }

    @JRubyMethod(name={"asinh"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyFloat asinh19(IRubyObject recv2, IRubyObject x) {
        double result;
        double value2 = RubyMath.needFloat(x).getDoubleValue();
        double y = Math.abs(value2);
        if (Double.isNaN(value2)) {
            result = Double.NaN;
        } else if (y <= 1.05367E-8) {
            result = value2;
        } else if (y <= 1.0) {
            result = value2 * (1.0 + RubyMath.chebylevSerie(2.0 * value2 * value2 - 1.0, ASINH_COEF));
        } else if (y < 9.490626562E7) {
            result = Math.log(value2 + Math.sqrt(value2 * value2 + 1.0));
        } else {
            result = 0.6931471805599453 + Math.log(y);
            if (value2 < 0.0) {
                result *= -1.0;
            }
        }
        return RubyFloat.newFloat(recv2.getRuntime(), result);
    }

    @JRubyMethod(name={"atanh"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyFloat atanh(IRubyObject recv2, IRubyObject x) {
        return RubyMath.atanh_common(recv2, x);
    }

    @JRubyMethod(name={"atanh"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyFloat atanh_19(IRubyObject recv2, IRubyObject x) {
        double value2 = RubyMath.needFloat(x).getDoubleValue();
        double y = Math.abs(value2);
        if (y == 1.0) {
            throw recv2.getRuntime().newErrnoEDOMError("atanh");
        }
        return RubyMath.atanh_common(recv2, x);
    }

    private static RubyFloat atanh_common(IRubyObject recv2, IRubyObject x) {
        double value2 = RubyKernel.new_float(recv2, x).getDoubleValue();
        double y = Math.abs(value2);
        double result = Double.isNaN(value2) ? Double.NaN : (y < 1.82501E-8 ? value2 : (y <= 0.5 ? value2 * (1.0 + RubyMath.chebylevSerie(8.0 * value2 * value2 - 1.0, ATANH_COEF)) : (y < 1.0 ? 0.5 * Math.log((1.0 + value2) / (1.0 - value2)) : (y == 1.0 ? value2 * Double.POSITIVE_INFINITY : Double.NaN))));
        RubyMath.domainCheck(recv2, result, "atanh");
        return RubyFloat.newFloat(recv2.getRuntime(), result);
    }

    @JRubyMethod(name={"exp"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyFloat exp(IRubyObject recv2, IRubyObject exponent2) {
        double value2 = RubyKernel.new_float(recv2, exponent2).getDoubleValue();
        return RubyFloat.newFloat(recv2.getRuntime(), Math.exp(value2));
    }

    @JRubyMethod(name={"exp"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyFloat exp19(IRubyObject recv2, IRubyObject exponent2) {
        double value2 = RubyMath.needFloat(exponent2).getDoubleValue();
        return RubyFloat.newFloat(recv2.getRuntime(), Math.exp(value2));
    }

    private static RubyFloat log_common(IRubyObject recv2, double value2, double base) {
        double result = Math.log(value2) / Math.log(base);
        RubyMath.domainCheck(recv2, result, "log");
        return RubyFloat.newFloat(recv2.getRuntime(), result);
    }

    @JRubyMethod(name={"log"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyFloat log(IRubyObject recv2, IRubyObject x) {
        return RubyMath.log_common(recv2, RubyKernel.new_float(recv2, x).getDoubleValue(), Math.E);
    }

    @JRubyMethod(name={"log"}, required=1, optional=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyFloat log_19(IRubyObject recv2, IRubyObject[] args2) {
        double value2 = RubyMath.needFloat(args2[0]).getDoubleValue();
        double base = Math.E;
        if (args2.length == 2) {
            base = RubyMath.needFloat(args2[1]).getDoubleValue();
        }
        RubyMath.zeroInLogCheck(recv2, value2);
        return RubyMath.log_common(recv2, value2, base);
    }

    @JRubyMethod(name={"log10"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyFloat log10(IRubyObject recv2, IRubyObject x) {
        return RubyMath.log_common(recv2, RubyKernel.new_float(recv2, x).getDoubleValue(), 10.0);
    }

    @JRubyMethod(name={"log10"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyFloat log10_19(IRubyObject recv2, IRubyObject x) {
        double value2 = RubyMath.needFloat(x).getDoubleValue();
        RubyMath.zeroInLogCheck(recv2, value2);
        return RubyMath.log_common(recv2, value2, 10.0);
    }

    @JRubyMethod(name={"log2"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyFloat log2(IRubyObject recv2, IRubyObject x) {
        return RubyMath.log_common(recv2, RubyKernel.new_float(recv2, x).getDoubleValue(), 2.0);
    }

    @JRubyMethod(name={"log2"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyFloat log2_19(IRubyObject recv2, IRubyObject x) {
        double value2 = RubyMath.needFloat(x).getDoubleValue();
        RubyMath.zeroInLogCheck(recv2, value2);
        return RubyMath.log_common(recv2, value2, 2.0);
    }

    @JRubyMethod(name={"sqrt"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyFloat sqrt(IRubyObject recv2, IRubyObject x) {
        double value2 = RubyKernel.new_float(recv2, x).getDoubleValue();
        double result = value2 < 0.0 ? Double.NaN : Math.sqrt(value2);
        RubyMath.domainCheck(recv2, result, "sqrt");
        return RubyFloat.newFloat(recv2.getRuntime(), result);
    }

    @JRubyMethod(name={"sqrt"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyFloat sqrt19(IRubyObject recv2, IRubyObject x) {
        double value2 = RubyMath.needFloat(x).getDoubleValue();
        double result = value2 < 0.0 ? Double.NaN : Math.sqrt(value2);
        RubyMath.domainCheck(recv2, result, "sqrt");
        return RubyFloat.newFloat(recv2.getRuntime(), result);
    }

    @JRubyMethod(name={"cbrt"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyFloat cbrt(IRubyObject recv2, IRubyObject x) {
        double value2 = RubyKernel.new_float(recv2, x).getDoubleValue();
        double result = value2 < 0.0 ? -Math.pow(-value2, 0.3333333333333333) : Math.pow(value2, 0.3333333333333333);
        RubyMath.domainCheck(recv2, result, "cbrt");
        return RubyFloat.newFloat(recv2.getRuntime(), result);
    }

    @JRubyMethod(name={"hypot"}, required=2, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyFloat hypot(IRubyObject recv2, IRubyObject x, IRubyObject y) {
        double result;
        double valuea = RubyKernel.new_float(recv2, x).getDoubleValue();
        double valueb = RubyKernel.new_float(recv2, y).getDoubleValue();
        if (Math.abs(valuea) > Math.abs(valueb)) {
            result = valueb / valuea;
            result = Math.abs(valuea) * Math.sqrt(1.0 + result * result);
        } else if (valueb != 0.0) {
            result = valuea / valueb;
            result = Math.abs(valueb) * Math.sqrt(1.0 + result * result);
        } else {
            result = 0.0;
        }
        return RubyFloat.newFloat(recv2.getRuntime(), result);
    }

    @JRubyMethod(name={"hypot"}, required=2, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyFloat hypot19(IRubyObject recv2, IRubyObject x, IRubyObject y) {
        double result;
        double valuea = RubyMath.needFloat(x).getDoubleValue();
        double valueb = RubyMath.needFloat(y).getDoubleValue();
        if (Math.abs(valuea) > Math.abs(valueb)) {
            result = valueb / valuea;
            result = Math.abs(valuea) * Math.sqrt(1.0 + result * result);
        } else if (valueb != 0.0) {
            result = valuea / valueb;
            result = Math.abs(valueb) * Math.sqrt(1.0 + result * result);
        } else {
            result = 0.0;
        }
        return RubyFloat.newFloat(recv2.getRuntime(), result);
    }

    @JRubyMethod(name={"frexp"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyArray frexp(IRubyObject recv2, IRubyObject other) {
        double mantissa = RubyKernel.new_float(recv2, other).getDoubleValue();
        int sign2 = 1;
        long exponent2 = 0L;
        if (!Double.isInfinite(mantissa) && mantissa != 0.0) {
            if (mantissa < 0.0) {
                mantissa = -mantissa;
                sign2 = -1;
            }
            while (mantissa < 0.5) {
                mantissa *= 2.0;
                --exponent2;
            }
            while (mantissa >= 1.0) {
                mantissa *= 0.5;
                ++exponent2;
            }
        }
        return RubyArray.newArray(recv2.getRuntime(), RubyFloat.newFloat(recv2.getRuntime(), (double)sign2 * mantissa), RubyNumeric.int2fix(recv2.getRuntime(), exponent2));
    }

    @JRubyMethod(name={"frexp"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyArray frexp19(IRubyObject recv2, IRubyObject other) {
        double mantissa = RubyMath.needFloat(other).getDoubleValue();
        int sign2 = 1;
        long exponent2 = 0L;
        if (!Double.isInfinite(mantissa) && mantissa != 0.0) {
            if (mantissa < 0.0) {
                mantissa = -mantissa;
                sign2 = -1;
            }
            while (mantissa < 0.5) {
                mantissa *= 2.0;
                --exponent2;
            }
            while (mantissa >= 1.0) {
                mantissa *= 0.5;
                ++exponent2;
            }
        }
        return RubyArray.newArray(recv2.getRuntime(), RubyFloat.newFloat(recv2.getRuntime(), (double)sign2 * mantissa), RubyNumeric.int2fix(recv2.getRuntime(), exponent2));
    }

    @JRubyMethod(name={"ldexp"}, required=2, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyFloat ldexp(IRubyObject recv2, IRubyObject mantissa, IRubyObject exponent2) {
        double mantissaValue = RubyKernel.new_float(recv2, mantissa).getDoubleValue();
        return RubyFloat.newFloat(recv2.getRuntime(), mantissaValue * Math.pow(2.0, RubyNumeric.num2int(exponent2)));
    }

    @JRubyMethod(name={"ldexp"}, required=2, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyFloat ldexp19(IRubyObject recv2, IRubyObject mantissa, IRubyObject exponent2) {
        double mantissaValue = RubyMath.needFloat(mantissa).getDoubleValue();
        return RubyFloat.newFloat(recv2.getRuntime(), mantissaValue * Math.pow(2.0, RubyNumeric.num2int(exponent2)));
    }

    @JRubyMethod(name={"erf"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyFloat erf(IRubyObject recv2, IRubyObject x) {
        double value2 = RubyKernel.new_float(recv2, x).getDoubleValue();
        double y = Math.abs(value2);
        double result = y <= 1.49012E-8 ? 2.0 * value2 / 1.772453850905516 : (y <= 1.0 ? value2 * (1.0 + RubyMath.chebylevSerie(2.0 * value2 * value2 - 1.0, ERFC_COEF)) : (y < 6.013687357 ? RubyMath.sign(1.0 - RubyMath.erfc(recv2, RubyFloat.newFloat(recv2.getRuntime(), y)).getDoubleValue(), value2) : RubyMath.sign(1.0, value2)));
        return RubyFloat.newFloat(recv2.getRuntime(), result);
    }

    @JRubyMethod(name={"erf"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyFloat erf19(IRubyObject recv2, IRubyObject x) {
        double value2 = RubyMath.needFloat(x).getDoubleValue();
        double y = Math.abs(value2);
        double result = y <= 1.49012E-8 ? 2.0 * value2 / 1.772453850905516 : (y <= 1.0 ? value2 * (1.0 + RubyMath.chebylevSerie(2.0 * value2 * value2 - 1.0, ERFC_COEF)) : (y < 6.013687357 ? RubyMath.sign(1.0 - RubyMath.erfc(recv2, RubyFloat.newFloat(recv2.getRuntime(), y)).getDoubleValue(), value2) : RubyMath.sign(1.0, value2)));
        return RubyFloat.newFloat(recv2.getRuntime(), result);
    }

    @JRubyMethod(name={"erfc"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyFloat erfc(IRubyObject recv2, IRubyObject x) {
        double result;
        double value2 = RubyKernel.new_float(recv2, x).getDoubleValue();
        double y = Math.abs(value2);
        if (value2 <= -6.013687357) {
            result = 2.0;
        } else if (y < 1.49012E-8) {
            result = 1.0 - 2.0 * value2 / 1.772453850905516;
        } else {
            double ysq = y * y;
            if (y < 1.0) {
                result = 1.0 - value2 * (1.0 + RubyMath.chebylevSerie(2.0 * ysq - 1.0, ERFC_COEF));
            } else if (y <= 4.0) {
                result = Math.exp(-ysq) / y * (0.5 + RubyMath.chebylevSerie((8.0 / ysq - 5.0) / 3.0, ERFC2_COEF));
                if (value2 < 0.0) {
                    result = 2.0 - result;
                }
                if (value2 < 0.0) {
                    result = 2.0 - result;
                }
                if (value2 < 0.0) {
                    result = 2.0 - result;
                }
            } else {
                result = Math.exp(-ysq) / y * (0.5 + RubyMath.chebylevSerie(8.0 / ysq - 1.0, ERFCC_COEF));
                if (value2 < 0.0) {
                    result = 2.0 - result;
                }
            }
        }
        return RubyFloat.newFloat(recv2.getRuntime(), result);
    }

    @JRubyMethod(name={"erfc"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyFloat erfc19(IRubyObject recv2, IRubyObject x) {
        double result;
        double value2 = RubyMath.needFloat(x).getDoubleValue();
        double y = Math.abs(value2);
        if (value2 <= -6.013687357) {
            result = 2.0;
        } else if (y < 1.49012E-8) {
            result = 1.0 - 2.0 * value2 / 1.772453850905516;
        } else {
            double ysq = y * y;
            if (y < 1.0) {
                result = 1.0 - value2 * (1.0 + RubyMath.chebylevSerie(2.0 * ysq - 1.0, ERFC_COEF));
            } else if (y <= 4.0) {
                result = Math.exp(-ysq) / y * (0.5 + RubyMath.chebylevSerie((8.0 / ysq - 5.0) / 3.0, ERFC2_COEF));
                if (value2 < 0.0) {
                    result = 2.0 - result;
                }
                if (value2 < 0.0) {
                    result = 2.0 - result;
                }
                if (value2 < 0.0) {
                    result = 2.0 - result;
                }
            } else {
                result = Math.exp(-ysq) / y * (0.5 + RubyMath.chebylevSerie(8.0 / ysq - 1.0, ERFCC_COEF));
                if (value2 < 0.0) {
                    result = 2.0 - result;
                }
            }
        }
        return RubyFloat.newFloat(recv2.getRuntime(), result);
    }

    @JRubyMethod(name={"gamma"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyFloat gamma(IRubyObject recv2, IRubyObject x) {
        double value2 = RubyKernel.new_float(recv2, x).getDoubleValue();
        double result = RubyMath.nemes_gamma(value2);
        if (Double.isInfinite(result)) {
            result = value2 < 0.0 ? Double.NaN : Double.POSITIVE_INFINITY;
        }
        if (Double.isNaN(value2)) {
            return RubyFloat.newFloat(recv2.getRuntime(), Double.NaN);
        }
        RubyMath.domainCheck(recv2, result, "gamma");
        return RubyFloat.newFloat(recv2.getRuntime(), result);
    }

    @JRubyMethod(name={"lgamma"}, required=1, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyArray lgamma(IRubyObject recv2, IRubyObject x) {
        Ruby runtime2 = recv2.getRuntime();
        double value2 = RubyKernel.new_float(recv2, x).getDoubleValue();
        NemesLogGamma l = new NemesLogGamma(value2);
        IRubyObject[] ary = new IRubyObject[]{RubyFloat.newFloat(runtime2, l.value), RubyInteger.int2fix(runtime2, (int)l.sign)};
        return RubyArray.newArray(recv2.getRuntime(), ary);
    }

    private static double nemes_gamma(double x) {
        double int_part = (int)x;
        if (x - int_part == 0.0 && 0.0 < int_part && int_part <= (double)FACTORIAL.length) {
            return FACTORIAL[(int)int_part - 1];
        }
        NemesLogGamma l = new NemesLogGamma(x);
        return l.sign * Math.exp(l.value);
    }

    private static class NemesLogGamma {
        double value;
        double sign = 1.0;

        private NemesLogGamma(double x) {
            if (Double.isInfinite(x)) {
                this.value = Double.POSITIVE_INFINITY;
                return;
            }
            if (Double.isNaN(x)) {
                this.value = Double.NaN;
                return;
            }
            double int_part = (int)x;
            double d = this.sign = int_part % 2.0 == 0.0 && x - int_part != 0.0 && x < 0.0 ? -1.0 : 1.0;
            if (x - int_part == 0.0 && 0.0 < int_part && int_part <= (double)FACTORIAL.length) {
                this.value = Math.log(FACTORIAL[(int)int_part - 1]);
            } else if (x < 10.0) {
                double rising_factorial = 1.0;
                int i = 0;
                while ((double)i < (double)((int)Math.abs(x)) - int_part + 10.0) {
                    rising_factorial *= x + (double)i;
                    ++i;
                }
                NemesLogGamma l = new NemesLogGamma(x + (double)((int)Math.abs(x)) - int_part + 10.0);
                this.value = l.value - Math.log(Math.abs(rising_factorial));
            } else {
                double temp = 0.0;
                for (int i = 0; i < NEMES_GAMMA_COEFF.length; ++i) {
                    temp += NEMES_GAMMA_COEFF[i] * 1.0 / Math.pow(x, i);
                }
                this.value = x * (Math.log(x) - 1.0 + Math.log(temp)) + (Math.log(2.0) + Math.log(Math.PI) - Math.log(x)) / 2.0;
            }
        }
    }
}

