/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.joni.Matcher;
import org.joni.NameEntry;
import org.joni.Regex;
import org.joni.Region;
import org.joni.Syntax;
import org.joni.exception.JOniException;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.parser.ReOptions;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingCapable;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.KCode;
import org.jruby.util.Pack;
import org.jruby.util.Sprintf;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;

@JRubyClass(name={"Regexp"})
public class RubyRegexp
extends RubyObject
implements ReOptions,
EncodingCapable {
    private KCode kcode;
    private Regex pattern;
    private ByteList str = ByteList.EMPTY_BYTELIST;
    private static final int REGEXP_LITERAL_F = 64;
    private static final int REGEXP_KCODE_DEFAULT = 128;
    private static final int REGEXP_ENCODING_NONE = 256;
    private static final int ARG_OPTION_MASK = 7;
    private static final int ARG_ENCODING_FIXED = 16;
    private static final int ARG_ENCODING_NONE = 32;
    private static final RegexpCache patternCache = new RegexpCache();
    private static final RegexpCache quotedPatternCache = new RegexpCache();
    private static final RegexpCache preprocessedPatternCache = new RegexpCache();
    private static ObjectAllocator REGEXP_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyRegexp(runtime2, klass);
        }
    };
    private static final int EMBEDDABLE = 7;

    public void setLiteral() {
        this.flags |= 0x40;
    }

    public void clearLiteral() {
        this.flags &= 0xFFFFFFBF;
    }

    public boolean isLiteral() {
        return (this.flags & 0x40) != 0;
    }

    public void setKCodeDefault() {
        this.flags |= 0x80;
    }

    public void clearKCodeDefault() {
        this.flags &= 0xFFFFFF7F;
    }

    public boolean isKCodeDefault() {
        return (this.flags & 0x80) != 0;
    }

    public void setEncodingNone() {
        this.flags |= 0x100;
    }

    public void clearEncodingNone() {
        this.flags &= 0xFFFFFEFF;
    }

    public boolean isEncodingNone() {
        return (this.flags & 0x100) != 0;
    }

    public KCode getKCode() {
        return this.kcode;
    }

    public Encoding getEncoding() {
        return this.pattern.getEncoding();
    }

    private static Regex makeRegexp(Ruby runtime2, ByteList bytes2, int flags, Encoding enc) {
        try {
            int p2 = bytes2.getBegin();
            return new Regex(bytes2.getUnsafeBytes(), p2, p2 + bytes2.getRealSize(), flags, enc, Syntax.DEFAULT, runtime2.getWarnings());
        }
        catch (Exception e) {
            if (runtime2.is1_9()) {
                RubyRegexp.raiseRegexpError19(runtime2, bytes2, enc, flags, e.getMessage());
            } else {
                RubyRegexp.raiseRegexpError(runtime2, bytes2, enc, flags, e.getMessage());
            }
            return null;
        }
    }

    static Regex getRegexpFromCache(Ruby runtime2, ByteList bytes2, Encoding enc, int options2) {
        Map cache = RubyRegexp.patternCache.get();
        Regex regex = (Regex)cache.get(bytes2);
        if (regex != null && regex.getEncoding() == enc && regex.getOptions() == options2) {
            return regex;
        }
        regex = RubyRegexp.makeRegexp(runtime2, bytes2, options2, enc);
        cache.put(bytes2, regex);
        return regex;
    }

    static Regex getQuotedRegexpFromCache(Ruby runtime2, ByteList bytes2, Encoding enc, int options2) {
        Map cache = RubyRegexp.quotedPatternCache.get();
        Regex regex = (Regex)cache.get(bytes2);
        if (regex != null && regex.getEncoding() == enc && regex.getOptions() == options2) {
            return regex;
        }
        regex = RubyRegexp.makeRegexp(runtime2, RubyRegexp.quote(bytes2, enc), options2, enc);
        cache.put(bytes2, regex);
        return regex;
    }

    static Regex getQuotedRegexpFromCache19(Ruby runtime2, ByteList bytes2, int options2, boolean asciiOnly) {
        Encoding enc;
        Map cache = RubyRegexp.quotedPatternCache.get();
        Regex regex = (Regex)cache.get(bytes2);
        Encoding encoding2 = enc = asciiOnly ? USASCIIEncoding.INSTANCE : bytes2.getEncoding();
        if (regex != null && regex.getEncoding() == enc && regex.getOptions() == options2) {
            return regex;
        }
        ByteList quoted = RubyRegexp.quote19(bytes2, asciiOnly);
        regex = RubyRegexp.makeRegexp(runtime2, quoted, options2, quoted.getEncoding());
        regex.setUserObject(quoted);
        cache.put(bytes2, regex);
        return regex;
    }

    private static Regex getPreprocessedRegexpFromCache(Ruby runtime2, ByteList bytes2, Encoding enc, int options2, ErrorMode mode2) {
        Map cache = RubyRegexp.preprocessedPatternCache.get();
        Regex regex = (Regex)cache.get(bytes2);
        if (regex != null && regex.getEncoding() == enc && regex.getOptions() == options2) {
            return regex;
        }
        ByteList preprocessed = RubyRegexp.preprocess(runtime2, bytes2, enc, new Encoding[]{null}, ErrorMode.RAISE);
        regex = RubyRegexp.makeRegexp(runtime2, preprocessed, options2, enc);
        regex.setUserObject(preprocessed);
        cache.put(bytes2, regex);
        return regex;
    }

    public static RubyClass createRegexpClass(Ruby runtime2) {
        RubyClass regexpClass = runtime2.defineClass("Regexp", runtime2.getObject(), REGEXP_ALLOCATOR);
        runtime2.setRegexp(regexpClass);
        regexpClass.index = 9;
        regexpClass.setReifiedClass(RubyRegexp.class);
        regexpClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof RubyRegexp;
            }
        };
        regexpClass.defineConstant("IGNORECASE", runtime2.newFixnum(1));
        regexpClass.defineConstant("EXTENDED", runtime2.newFixnum(2));
        regexpClass.defineConstant("MULTILINE", runtime2.newFixnum(4));
        if (runtime2.is1_9()) {
            regexpClass.defineConstant("FIXEDENCODING", runtime2.newFixnum(16));
        }
        regexpClass.defineAnnotatedMethods(RubyRegexp.class);
        return regexpClass;
    }

    public int getNativeTypeIndex() {
        return 9;
    }

    private RubyRegexp(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    private RubyRegexp(Ruby runtime2) {
        super(runtime2, runtime2.getRegexp());
    }

    private RubyRegexp(Ruby runtime2, ByteList str) {
        this(runtime2);
        this.setKCodeDefault();
        this.kcode = runtime2.getKCode();
        this.str = str;
        this.pattern = RubyRegexp.getRegexpFromCache(runtime2, str, this.kcode.getEncoding(), 0);
    }

    private RubyRegexp(Ruby runtime2, ByteList str, int options2) {
        this(runtime2);
        this.setKCode(runtime2, options2 & 0x7F);
        this.str = str;
        this.pattern = RubyRegexp.getRegexpFromCache(runtime2, str, this.kcode.getEncoding(), options2 & 0xF);
    }

    public static RubyRegexp newRegexp(Ruby runtime2, String pattern, int options2) {
        return RubyRegexp.newRegexp(runtime2, ByteList.create(pattern), options2);
    }

    public static RubyRegexp newRegexp(Ruby runtime2, ByteList pattern, int options2) {
        try {
            return new RubyRegexp(runtime2, pattern, options2);
        }
        catch (RaiseException re) {
            throw runtime2.newSyntaxError(re.getMessage());
        }
    }

    public static RubyRegexp newDRegexp(Ruby runtime2, RubyString pattern, int options2) {
        try {
            return new RubyRegexp(runtime2, pattern.getByteList(), options2);
        }
        catch (RaiseException re) {
            throw runtime2.newRegexpError(re.getMessage());
        }
    }

    public static RubyRegexp newRegexp(Ruby runtime2, ByteList pattern) {
        return new RubyRegexp(runtime2, pattern);
    }

    static RubyRegexp newRegexp(Ruby runtime2, ByteList str, Regex pattern) {
        RubyRegexp regexp2 = new RubyRegexp(runtime2);
        regexp2.str = str;
        regexp2.setKCode(runtime2, pattern.getOptions());
        regexp2.pattern = pattern;
        return regexp2;
    }

    static RubyRegexp newDummyRegexp(Ruby runtime2, Regex regex) {
        RubyRegexp regexp2 = new RubyRegexp(runtime2);
        regexp2.pattern = regex;
        regexp2.str = ByteList.EMPTY_BYTELIST;
        regexp2.kcode = KCode.NONE;
        return regexp2;
    }

    private int getKcode() {
        if (this.kcode == KCode.NONE) {
            return 16;
        }
        if (this.kcode == KCode.EUC) {
            return 32;
        }
        if (this.kcode == KCode.SJIS) {
            return 48;
        }
        if (this.kcode == KCode.UTF8) {
            return 64;
        }
        return 0;
    }

    private void setKCode(Ruby runtime2, int options2) {
        this.clearKCodeDefault();
        switch (options2 & 0xFFFFFFF0) {
            default: {
                this.setKCodeDefault();
                this.kcode = runtime2.getKCode();
                break;
            }
            case 16: {
                this.kcode = KCode.NONE;
                break;
            }
            case 32: {
                this.kcode = KCode.EUC;
                break;
            }
            case 48: {
                this.kcode = KCode.SJIS;
                break;
            }
            case 64: {
                this.kcode = KCode.UTF8;
            }
        }
    }

    private int getOptions() {
        this.check();
        int options2 = this.pattern.getOptions() & 7;
        if (!this.isKCodeDefault()) {
            options2 |= this.getKcode();
        }
        return options2;
    }

    final Regex getPattern() {
        this.check();
        return this.pattern;
    }

    private static void encodingMatchError(Ruby runtime2, Regex pattern, Encoding strEnc) {
        throw runtime2.newEncodingCompatibilityError("incompatible encoding regexp match (" + pattern.getEncoding() + " regexp with " + strEnc + " string)");
    }

    private Encoding checkEncoding(RubyString str, boolean warn2) {
        if (str.scanForCodeRange() == 96) {
            throw this.getRuntime().newArgumentError("invalid byte sequence in " + str.getEncoding());
        }
        this.check();
        Encoding enc = str.getEncoding();
        if (!enc.isAsciiCompatible()) {
            if (enc != this.pattern.getEncoding()) {
                RubyRegexp.encodingMatchError(this.getRuntime(), this.pattern, enc);
            }
        } else if (!this.isKCodeDefault()) {
            if (!(enc == this.pattern.getEncoding() || this.pattern.getEncoding().isAsciiCompatible() && str.scanForCodeRange() == 32)) {
                RubyRegexp.encodingMatchError(this.getRuntime(), this.pattern, enc);
            }
            enc = this.pattern.getEncoding();
        }
        if (warn2 && this.isEncodingNone() && enc != ASCIIEncoding.INSTANCE && str.scanForCodeRange() != 32) {
            this.getRuntime().getWarnings().warn(IRubyWarnings.ID.REGEXP_MATCH_AGAINST_STRING, "regexp match /.../n against to " + enc + " string", new Object[0]);
        }
        return enc;
    }

    final Regex preparePattern(RubyString str) {
        this.check();
        Encoding enc = this.checkEncoding(str, true);
        if (enc == this.pattern.getEncoding()) {
            return this.pattern;
        }
        return RubyRegexp.getPreprocessedRegexpFromCache(this.getRuntime(), this.str, enc, this.pattern.getOptions(), ErrorMode.PREPROCESS);
    }

    static Regex preparePattern(Ruby runtime2, Regex pattern, RubyString str) {
        if (str.scanForCodeRange() == 96) {
            throw runtime2.newArgumentError("invalid byte sequence in " + str.getEncoding());
        }
        Encoding enc = str.getEncoding();
        if (!enc.isAsciiCompatible() && enc != pattern.getEncoding()) {
            RubyRegexp.encodingMatchError(runtime2, pattern, enc);
        }
        if (enc == pattern.getEncoding()) {
            return pattern;
        }
        return RubyRegexp.getPreprocessedRegexpFromCache(runtime2, (ByteList)pattern.getUserObject(), enc, pattern.getOptions(), ErrorMode.PREPROCESS);
    }

    private static int raisePreprocessError(Ruby runtime2, ByteList str, String err, ErrorMode mode2) {
        switch (mode2) {
            case RAISE: {
                RubyRegexp.raiseRegexpError19(runtime2, str, str.getEncoding(), 0, err);
            }
            case PREPROCESS: {
                throw runtime2.newArgumentError("regexp preprocess failed: " + err);
            }
        }
        return 0;
    }

    private static int readEscapedByte(Ruby runtime2, byte[] to, int toP, byte[] bytes2, int p2, int end2, ByteList str, ErrorMode mode2) {
        if (p2 == end2 || bytes2[p2++] != 92) {
            RubyRegexp.raisePreprocessError(runtime2, str, "too short escaped multibyte character", mode2);
        }
        boolean metaPrefix = false;
        boolean ctrlPrefix = false;
        int code = 0;
        block15: while (true) {
            if (p2 == end2) {
                RubyRegexp.raisePreprocessError(runtime2, str, "too short escape sequence", mode2);
            }
            switch (bytes2[p2++]) {
                case 92: {
                    code = 92;
                    break block15;
                }
                case 110: {
                    code = 10;
                    break block15;
                }
                case 116: {
                    code = 9;
                    break block15;
                }
                case 114: {
                    code = 13;
                    break block15;
                }
                case 102: {
                    code = 12;
                    break block15;
                }
                case 118: {
                    code = 11;
                    break block15;
                }
                case 97: {
                    code = 7;
                    break block15;
                }
                case 101: {
                    code = 27;
                    break block15;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    int olen = end2 < --p2 + 3 ? end2 - p2 : 3;
                    code = StringSupport.scanOct(bytes2, p2, olen);
                    p2 += StringSupport.octLength(bytes2, p2, olen);
                    break block15;
                }
                case 120: {
                    int hlen = end2 < p2 + 2 ? end2 - p2 : 2;
                    code = StringSupport.scanHex(bytes2, p2, hlen);
                    int len = StringSupport.hexLength(bytes2, p2, hlen);
                    if (len < 1) {
                        RubyRegexp.raisePreprocessError(runtime2, str, "invalid hex escape", mode2);
                    }
                    p2 += len;
                    break block15;
                }
                case 77: {
                    if (metaPrefix) {
                        RubyRegexp.raisePreprocessError(runtime2, str, "duplicate meta escape", mode2);
                    }
                    metaPrefix = true;
                    if (p2 + 1 < end2 && bytes2[p2++] == 45 && (bytes2[p2] & 0x80) == 0) {
                        if (bytes2[p2] == 92) {
                            ++p2;
                            continue block15;
                        }
                        code = bytes2[p2++] & 0xFF;
                        break block15;
                    }
                    RubyRegexp.raisePreprocessError(runtime2, str, "too short meta escape", mode2);
                }
                case 67: {
                    if (p2 == end2 || bytes2[p2++] != 45) {
                        RubyRegexp.raisePreprocessError(runtime2, str, "too short control escape", mode2);
                    }
                }
                case 99: {
                    if (ctrlPrefix) {
                        RubyRegexp.raisePreprocessError(runtime2, str, "duplicate control escape", mode2);
                    }
                    ctrlPrefix = true;
                    if (p2 < end2 && (bytes2[p2] & 0x80) == 0) {
                        if (bytes2[p2] == 92) {
                            ++p2;
                            continue block15;
                        }
                        code = bytes2[p2++] & 0xFF;
                        break block15;
                    }
                    RubyRegexp.raisePreprocessError(runtime2, str, "too short control escape", mode2);
                }
                default: {
                    RubyRegexp.raisePreprocessError(runtime2, str, "unexpected escape sequence", mode2);
                }
            }
            break;
        }
        if (code < 0 || code > 255) {
            RubyRegexp.raisePreprocessError(runtime2, str, "invalid escape code", mode2);
        }
        if (ctrlPrefix) {
            code &= 0x1F;
        }
        if (metaPrefix) {
            code |= 0x80;
        }
        to[toP] = (byte)code;
        return p2;
    }

    private static int unescapeEscapedNonAscii(Ruby runtime2, ByteList to, byte[] bytes2, int p2, int end2, Encoding enc, Encoding[] encp, ByteList str, ErrorMode mode2) {
        byte[] chBuf = new byte[enc.maxLength()];
        int chLen = 0;
        p2 = RubyRegexp.readEscapedByte(runtime2, chBuf, chLen++, bytes2, p2, end2, str, mode2);
        while (chLen < enc.maxLength() && StringSupport.preciseLength(enc, chBuf, 0, chLen) < -1) {
            p2 = RubyRegexp.readEscapedByte(runtime2, chBuf, chLen++, bytes2, p2, end2, str, mode2);
        }
        int cl = StringSupport.preciseLength(enc, chBuf, 0, chLen);
        if (cl == -1) {
            RubyRegexp.raisePreprocessError(runtime2, str, "invalid multibyte escape", mode2);
        }
        if (chLen > 1 || (chBuf[0] & 0x80) != 0) {
            to.append(chBuf, 0, chLen);
            if (encp[0] == null) {
                encp[0] = enc;
            } else if (encp[0] != enc) {
                RubyRegexp.raisePreprocessError(runtime2, str, "escaped non ASCII character in UTF-8 regexp", mode2);
            }
        } else {
            Sprintf.sprintf(runtime2, to, (CharSequence)"\\x%02X", chBuf[0] & 0xFF);
        }
        return p2;
    }

    private static void checkUnicodeRange(Ruby runtime2, int code, ByteList str, ErrorMode mode2) {
        if (55296 <= code && code <= 57343 || 0x10FFFF < code) {
            RubyRegexp.raisePreprocessError(runtime2, str, "invalid Unicode range", mode2);
        }
    }

    private static void appendUtf8(Ruby runtime2, ByteList to, int code, Encoding[] enc, ByteList str, ErrorMode mode2) {
        RubyRegexp.checkUnicodeRange(runtime2, code, str, mode2);
        if (code < 128) {
            Sprintf.sprintf(runtime2, to, (CharSequence)"\\x%02X", code);
        } else {
            to.ensure(to.getRealSize() + 6);
            to.setRealSize(to.getRealSize() + Pack.utf8Decode(runtime2, to.getUnsafeBytes(), to.getBegin() + to.getRealSize(), code));
            if (enc[0] == null) {
                enc[0] = UTF8Encoding.INSTANCE;
            } else if (!(enc[0] instanceof UTF8Encoding)) {
                RubyRegexp.raisePreprocessError(runtime2, str, "UTF-8 character in non UTF-8 regexp", mode2);
            }
        }
    }

    private static int unescapeUnicodeList(Ruby runtime2, ByteList to, byte[] bytes2, int p2, int end2, Encoding[] encp, ByteList str, ErrorMode mode2) {
        while (p2 < end2 && ASCIIEncoding.INSTANCE.isSpace(bytes2[p2] & 0xFF)) {
            ++p2;
        }
        boolean hasUnicode = false;
        block1: while (true) {
            int code = StringSupport.scanHex(bytes2, p2, end2 - p2);
            int len = StringSupport.hexLength(bytes2, p2, end2 - p2);
            if (len == 0) break;
            if (len > 6) {
                RubyRegexp.raisePreprocessError(runtime2, str, "invalid Unicode range", mode2);
            }
            p2 += len;
            RubyRegexp.appendUtf8(runtime2, to, code, encp, str, mode2);
            hasUnicode = true;
            while (true) {
                if (p2 >= end2 || !ASCIIEncoding.INSTANCE.isSpace(bytes2[p2] & 0xFF)) continue block1;
                ++p2;
            }
            break;
        }
        if (!hasUnicode) {
            RubyRegexp.raisePreprocessError(runtime2, str, "invalid Unicode list", mode2);
        }
        return p2;
    }

    private static int unescapeUnicodeBmp(Ruby runtime2, ByteList to, byte[] bytes2, int p2, int end2, Encoding[] encp, ByteList str, ErrorMode mode2) {
        if (p2 + 4 > end2) {
            RubyRegexp.raisePreprocessError(runtime2, str, "invalid Unicode escape", mode2);
        }
        int code = StringSupport.scanHex(bytes2, p2, 4);
        int len = StringSupport.hexLength(bytes2, p2, 4);
        if (len != 4) {
            RubyRegexp.raisePreprocessError(runtime2, str, "invalid Unicode escape", mode2);
        }
        RubyRegexp.appendUtf8(runtime2, to, code, encp, str, mode2);
        return p2 + 4;
    }

    private static boolean unescapeNonAscii(Ruby runtime2, ByteList to, byte[] bytes2, int p2, int end2, Encoding enc, Encoding[] encp, ByteList str, ErrorMode mode2) {
        boolean hasProperty = false;
        block9: while (p2 < end2) {
            int cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
            if (cl <= 0) {
                RubyRegexp.raisePreprocessError(runtime2, str, "invalid multibyte character", mode2);
            }
            if (cl > 1 || (bytes2[p2] & 0x80) != 0) {
                to.append(bytes2, p2, cl);
                p2 += cl;
                if (encp[0] == null) {
                    encp[0] = enc;
                    continue;
                }
                if (encp[0] == enc) continue;
                RubyRegexp.raisePreprocessError(runtime2, str, "non ASCII character in UTF-8 regexp", mode2);
                continue;
            }
            int c = bytes2[p2++] & 0xFF;
            switch (c) {
                case 92: {
                    if (p2 == end2) {
                        RubyRegexp.raisePreprocessError(runtime2, str, "too short escape sequence", mode2);
                    }
                    c = bytes2[p2++] & 0xFF;
                    switch (c) {
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            if (StringSupport.scanOct(bytes2, p2 - 1, end2 - (p2 - 1)) <= 127) {
                                to.append(92).append(c);
                                continue block9;
                            }
                        }
                        case 48: 
                        case 67: 
                        case 77: 
                        case 99: 
                        case 120: {
                            p2 = RubyRegexp.unescapeEscapedNonAscii(runtime2, to, bytes2, p2 - 2, end2, enc, encp, str, mode2);
                            continue block9;
                        }
                        case 117: {
                            if (p2 == end2) {
                                RubyRegexp.raisePreprocessError(runtime2, str, "too short escape sequence", mode2);
                            }
                            if (bytes2[p2] == 123) {
                                ++p2;
                                if ((p2 = RubyRegexp.unescapeUnicodeList(runtime2, to, bytes2, p2, end2, encp, str, mode2)) != end2 && bytes2[p2++] == 125) continue block9;
                                RubyRegexp.raisePreprocessError(runtime2, str, "invalid Unicode list", mode2);
                                continue block9;
                            }
                            p2 = RubyRegexp.unescapeUnicodeBmp(runtime2, to, bytes2, p2, end2, encp, str, mode2);
                            continue block9;
                        }
                        case 112: {
                            if (encp[0] == null) {
                                hasProperty = true;
                            }
                            to.append(92).append(c);
                            continue block9;
                        }
                    }
                    to.append(92).append(c);
                    continue block9;
                }
            }
            to.append(c);
        }
        return hasProperty;
    }

    private static ByteList preprocess(Ruby runtime2, ByteList str, Encoding enc, Encoding[] fixedEnc, ErrorMode mode2) {
        ByteList to = new ByteList(str.getRealSize());
        if (enc.isAsciiCompatible()) {
            fixedEnc[0] = null;
        } else {
            fixedEnc[0] = enc;
            to.setEncoding(enc);
        }
        boolean hasProperty = RubyRegexp.unescapeNonAscii(runtime2, to, str.getUnsafeBytes(), str.getBegin(), str.getBegin() + str.getRealSize(), enc, fixedEnc, str, mode2);
        if (hasProperty && fixedEnc[0] == null) {
            fixedEnc[0] = enc;
        }
        if (fixedEnc[0] != null) {
            to.setEncoding(fixedEnc[0]);
        }
        return to;
    }

    public static void preprocessCheck(Ruby runtime2, IRubyObject obj) {
        ByteList bytes2 = obj.convertToString().getByteList();
        RubyRegexp.preprocess(runtime2, bytes2, bytes2.getEncoding(), new Encoding[]{null}, ErrorMode.RAISE);
    }

    private void check() {
        if (this.pattern == null) {
            throw this.getRuntime().newTypeError("uninitialized Regexp");
        }
    }

    @JRubyMethod(name={"new", "compile"}, required=1, optional=2, meta=true)
    public static RubyRegexp newInstance(IRubyObject recv2, IRubyObject[] args2) {
        RubyClass klass = (RubyClass)recv2;
        RubyRegexp re = (RubyRegexp)klass.allocate();
        re.callInit(args2, Block.NULL_BLOCK);
        return re;
    }

    @JRubyMethod(name={"try_convert"}, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject try_convert(ThreadContext context, IRubyObject recv2, IRubyObject args2) {
        return TypeConverter.convertToTypeWithCheck(args2, context.getRuntime().getRegexp(), "to_regexp");
    }

    @JRubyMethod(name={"quote", "escape"}, required=1, optional=1, meta=true, compat=CompatVersion.RUBY1_8)
    public static RubyString quote(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        KCode code = args2.length == 1 || args2[1].isNil() ? runtime2.getKCode() : KCode.create(runtime2, args2[1].toString());
        RubyString src = args2[0].convertToString();
        RubyString dst = RubyString.newStringShared(runtime2, RubyRegexp.quote(src.getByteList(), code.getEncoding()));
        dst.infectBy(src);
        return dst;
    }

    @JRubyMethod(name={"quote", "escape"}, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject quote19(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        Ruby runtime2 = context.getRuntime();
        RubyString str = RubyRegexp.operandCheck(runtime2, arg2);
        return RubyString.newStringShared(runtime2, RubyRegexp.quote19(str.getByteList(), str.isAsciiOnly()));
    }

    /*
     * Unable to fully structure code
     */
    private static ByteList quote(ByteList bs, Encoding enc) {
        block15: {
            p = bs.getBegin();
            end = p + bs.getRealSize();
            bytes = bs.getUnsafeBytes();
            while (p < end) {
                block16: {
                    c = bytes[p] & 255;
                    cl = enc.length(bytes, p, end);
                    if (cl == 1) break block16;
                    while (cl-- > 0 && p < end) {
                        ++p;
                    }
                    --p;
                    ** GOTO lbl-1000
                }
                switch (c) {
                    case 9: 
                    case 10: 
                    case 12: 
                    case 13: 
                    case 32: 
                    case 35: 
                    case 36: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 45: 
                    case 46: 
                    case 63: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 123: 
                    case 124: 
                    case 125: {
                        break block15;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        ++p;
                        break;
                    }
                }
            }
            return bs;
        }
        result = new ByteList(end * 2);
        obytes = result.getUnsafeBytes();
        op = p - bs.getBegin();
        System.arraycopy(bytes, bs.getBegin(), obytes, 0, op);
        while (p < end) {
            block18: {
                block17: {
                    c = bytes[p] & 255;
                    cl = enc.length(bytes, p, end);
                    if (cl == 1) break block17;
                    while (cl-- > 0 && p < end) {
                        obytes[op++] = bytes[p++];
                    }
                    --p;
                    break block18;
                }
                switch (c) {
                    case 35: 
                    case 36: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 45: 
                    case 46: 
                    case 63: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 123: 
                    case 124: 
                    case 125: {
                        obytes[op++] = 92;
                        ** GOTO lbl61
                    }
                    case 32: {
                        obytes[op++] = 92;
                        obytes[op++] = 32;
                        break;
                    }
                    case 9: {
                        obytes[op++] = 92;
                        obytes[op++] = 116;
                        break;
                    }
                    case 10: {
                        obytes[op++] = 92;
                        obytes[op++] = 110;
                        break;
                    }
                    case 13: {
                        obytes[op++] = 92;
                        obytes[op++] = 114;
                        break;
                    }
                    case 12: {
                        obytes[op++] = 92;
                        obytes[op++] = 102;
                        break;
                    }
lbl61:
                    // 2 sources

                    default: {
                        obytes[op++] = (byte)c;
                    }
                }
            }
            ++p;
        }
        result.setRealSize(op);
        return result;
    }

    static ByteList quote19(ByteList bs, boolean asciiOnly) {
        Encoding enc;
        byte[] bytes2;
        int end2;
        int p2;
        block21: {
            p2 = bs.getBegin();
            end2 = p2 + bs.getRealSize();
            bytes2 = bs.getUnsafeBytes();
            enc = bs.getEncoding();
            while (p2 < end2) {
                int c;
                int cl;
                if (enc.isAsciiCompatible()) {
                    cl = 1;
                    c = bytes2[p2] & 0xFF;
                } else {
                    cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
                    c = enc.mbcToCode(bytes2, p2, end2);
                }
                if (!Encoding.isAscii(c)) {
                    p2 += StringSupport.length(enc, bytes2, p2, end2);
                    continue;
                }
                switch (c) {
                    case 9: 
                    case 10: 
                    case 12: 
                    case 13: 
                    case 32: 
                    case 35: 
                    case 36: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 45: 
                    case 46: 
                    case 63: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 123: 
                    case 124: 
                    case 125: {
                        break block21;
                    }
                    default: {
                        p2 += cl;
                        break;
                    }
                }
            }
            if (asciiOnly) {
                ByteList tmp = bs.shallowDup();
                tmp.setEncoding(USASCIIEncoding.INSTANCE);
                return tmp;
            }
            return bs;
        }
        ByteList result = new ByteList(end2 * 2);
        result.setEncoding(asciiOnly ? USASCIIEncoding.INSTANCE : bs.getEncoding());
        byte[] obytes = result.getUnsafeBytes();
        int op = p2 - bs.getBegin();
        System.arraycopy(bytes2, bs.getBegin(), obytes, 0, op);
        block12: while (p2 < end2) {
            int c;
            int cl;
            if (enc.isAsciiCompatible()) {
                cl = 1;
                c = bytes2[p2] & 0xFF;
            } else {
                cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
                c = enc.mbcToCode(bytes2, p2, end2);
            }
            if (!Encoding.isAscii(c)) {
                int n = StringSupport.length(enc, bytes2, p2, end2);
                while (n-- > 0) {
                    obytes[op++] = bytes2[p2++];
                }
                continue;
            }
            p2 += cl;
            switch (c) {
                case 35: 
                case 36: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 45: 
                case 46: 
                case 63: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 123: 
                case 124: 
                case 125: {
                    op += enc.codeToMbc(92, obytes, op);
                    break;
                }
                case 32: {
                    op += enc.codeToMbc(92, obytes, op);
                    op += enc.codeToMbc(32, obytes, op);
                    continue block12;
                }
                case 9: {
                    op += enc.codeToMbc(92, obytes, op);
                    op += enc.codeToMbc(116, obytes, op);
                    continue block12;
                }
                case 10: {
                    op += enc.codeToMbc(92, obytes, op);
                    op += enc.codeToMbc(110, obytes, op);
                    continue block12;
                }
                case 13: {
                    op += enc.codeToMbc(92, obytes, op);
                    op += enc.codeToMbc(114, obytes, op);
                    continue block12;
                }
                case 12: {
                    op += enc.codeToMbc(92, obytes, op);
                    op += enc.codeToMbc(102, obytes, op);
                    continue block12;
                }
            }
            op += enc.codeToMbc(c, obytes, op);
        }
        result.setRealSize(op);
        return result;
    }

    public static IRubyObject last_match_s(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return RubyRegexp.last_match_s(context, recv2);
            }
            case 1: {
                return RubyRegexp.last_match_s(context, recv2, args2[0]);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args2.length, 0, 1);
        return null;
    }

    @JRubyMethod(name={"last_match"}, meta=true, reads={FrameField.BACKREF})
    public static IRubyObject last_match_s(ThreadContext context, IRubyObject recv2) {
        IRubyObject match2 = context.getCurrentScope().getBackRef(context.getRuntime());
        if (match2 instanceof RubyMatchData) {
            ((RubyMatchData)match2).use();
        }
        return match2;
    }

    @JRubyMethod(name={"last_match"}, meta=true, reads={FrameField.BACKREF})
    public static IRubyObject last_match_s(ThreadContext context, IRubyObject recv2, IRubyObject nth) {
        IRubyObject match2 = context.getCurrentScope().getBackRef(context.getRuntime());
        if (match2.isNil()) {
            return match2;
        }
        return RubyRegexp.nth_match(((RubyMatchData)match2).backrefNumber(nth), match2);
    }

    @JRubyMethod(name={"union"}, rest=true, meta=true)
    public static IRubyObject union(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        int i;
        Ruby runtime2 = context.getRuntime();
        IRubyObject[] realArgs = args2;
        if (args2.length == 0) {
            return RubyRegexp.newRegexp(runtime2, ByteList.create("(?!)"), 0);
        }
        if (args2.length == 1) {
            IRubyObject v = TypeConverter.convertToTypeWithCheck(args2[0], runtime2.getRegexp(), "to_regexp");
            if (!v.isNil()) {
                return v;
            }
            IRubyObject a = TypeConverter.convertToTypeWithCheck(args2[0], runtime2.getArray(), "to_ary");
            if (!a.isNil()) {
                RubyArray aa = (RubyArray)a;
                int len = aa.getLength();
                realArgs = new IRubyObject[len];
                for (i = 0; i < len; ++i) {
                    realArgs[i] = aa.entry(i);
                }
            } else {
                return RubyRegexp.newRegexp(runtime2, RubyRegexp.quote(context, recv2, args2).getByteList(), 0);
            }
        }
        KCode kcode2 = null;
        IRubyObject kcode_re = runtime2.getNil();
        RubyString source2 = runtime2.newString();
        IRubyObject[] _args = new IRubyObject[3];
        for (i = 0; i < realArgs.length; ++i) {
            IRubyObject v;
            if (0 < i) {
                source2.cat((byte)124);
            }
            if (!(v = TypeConverter.convertToTypeWithCheck(realArgs[i], runtime2.getRegexp(), "to_regexp")).isNil()) {
                if (!((RubyRegexp)v).isKCodeDefault()) {
                    if (kcode2 == null) {
                        kcode_re = v;
                        kcode2 = ((RubyRegexp)v).kcode;
                    } else if (((RubyRegexp)v).kcode != kcode2) {
                        IRubyObject str1 = kcode_re.inspect();
                        IRubyObject str2 = v.inspect();
                        throw runtime2.newArgumentError("mixed kcode " + str1 + " and " + str2);
                    }
                }
                v = ((RubyRegexp)v).to_s();
            } else {
                v = RubyRegexp.quote(context, recv2, new IRubyObject[]{realArgs[i]});
            }
            source2.append(v);
        }
        _args[0] = source2;
        _args[1] = runtime2.getNil();
        if (kcode2 == null) {
            _args[2] = runtime2.getNil();
        } else if (kcode2 == KCode.NONE) {
            _args[2] = runtime2.newString("n");
        } else if (kcode2 == KCode.EUC) {
            _args[2] = runtime2.newString("e");
        } else if (kcode2 == KCode.SJIS) {
            _args[2] = runtime2.newString("s");
        } else if (kcode2 == KCode.UTF8) {
            _args[2] = runtime2.newString("u");
        }
        return recv2.callMethod(context, "new", _args);
    }

    private static void raiseRegexpError(Ruby runtime2, ByteList bytes2, Encoding enc, int flags, String err) {
        throw runtime2.newRegexpError(err + ": " + RubyRegexp.regexpDescription(runtime2, bytes2, enc, flags));
    }

    private static ByteList regexpDescription(Ruby runtime2, ByteList bytes2, Encoding enc, int options2) {
        return RubyRegexp.regexpDescription(runtime2, bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getRealSize(), enc, options2);
    }

    private static ByteList regexpDescription(Ruby runtime2, byte[] bytes2, int start2, int len, Encoding enc, int options2) {
        ByteList description = new ByteList();
        description.append((byte)47);
        RubyRegexp.appendRegexpString(runtime2, description, bytes2, start2, len, enc);
        description.append((byte)47);
        RubyRegexp.appendOptions(description, options2);
        return description;
    }

    private static void raiseRegexpError19(Ruby runtime2, ByteList bytes2, Encoding enc, int flags, String err) {
        throw runtime2.newRegexpError(err + ": " + RubyRegexp.regexpDescription19(runtime2, bytes2, flags, enc));
    }

    static ByteList regexpDescription19(Ruby runtime2, ByteList bytes2, int options2, Encoding enc) {
        return RubyRegexp.regexpDescription19(runtime2, bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getRealSize(), options2, enc);
    }

    private static ByteList regexpDescription19(Ruby runtime2, byte[] s, int start2, int len, int options2, Encoding enc) {
        ByteList description = new ByteList();
        description.setEncoding(enc);
        description.append((byte)47);
        RubyRegexp.appendRegexpString19(runtime2, description, s, start2, len, enc);
        description.append((byte)47);
        RubyRegexp.appendOptions(description, options2);
        return description;
    }

    @JRubyMethod(name={"initialize_copy"}, required=1)
    public IRubyObject initialize_copy(IRubyObject re) {
        if (this == re) {
            return this;
        }
        this.checkFrozen();
        if (this.getMetaClass().getRealClass() != re.getMetaClass().getRealClass()) {
            throw this.getRuntime().newTypeError("wrong argument type");
        }
        RubyRegexp regexp2 = (RubyRegexp)re;
        regexp2.check();
        return this.initializeCommon(regexp2.str, regexp2.getOptions());
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public IRubyObject initialize_m(IRubyObject arg2) {
        if (arg2 instanceof RubyRegexp) {
            return this.initializeByRegexp((RubyRegexp)arg2);
        }
        return this.initializeCommon(arg2.convertToString().getByteList(), 0);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public IRubyObject initialize_m(IRubyObject arg0, IRubyObject arg1) {
        if (arg0 instanceof RubyRegexp) {
            this.getRuntime().getWarnings().warn(IRubyWarnings.ID.REGEXP_IGNORED_FLAGS, "flags ignored", new Object[0]);
            return this.initializeByRegexp((RubyRegexp)arg0);
        }
        int options2 = arg1 instanceof RubyFixnum ? RubyNumeric.fix2int(arg1) : (arg1.isTrue() ? 1 : 0);
        return this.initializeCommon(arg0.convertToString().getByteList(), options2);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public IRubyObject initialize_m(IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        int options2;
        if (arg0 instanceof RubyRegexp) {
            this.getRuntime().getWarnings().warn(IRubyWarnings.ID.REGEXP_IGNORED_FLAGS, "flags and encoding ignored", new Object[0]);
            return this.initializeByRegexp((RubyRegexp)arg0);
        }
        int n = arg1 instanceof RubyFixnum ? RubyNumeric.fix2int(arg1) : (options2 = arg1.isTrue() ? 1 : 0);
        if (!arg2.isNil()) {
            ByteList kcodeBytes = arg2.convertToString().getByteList();
            char first2 = kcodeBytes.length() > 0 ? kcodeBytes.charAt(0) : (char)'\u0000';
            options2 &= 0xFFFFFF8F;
            switch (first2) {
                case 'N': 
                case 'n': {
                    options2 |= 0x10;
                    break;
                }
                case 'E': 
                case 'e': {
                    options2 |= 0x20;
                    break;
                }
                case 'S': 
                case 's': {
                    options2 |= 0x30;
                    break;
                }
                case 'U': 
                case 'u': {
                    options2 |= 0x40;
                    break;
                }
            }
        }
        return this.initializeCommon(arg0.convertToString().getByteList(), options2);
    }

    private IRubyObject initializeByRegexp(RubyRegexp regexp2) {
        regexp2.check();
        int options2 = regexp2.pattern.getOptions();
        if (!regexp2.isKCodeDefault() && regexp2.kcode != null && regexp2.kcode != KCode.NIL) {
            if (regexp2.kcode == KCode.NONE) {
                options2 |= 0x10;
            } else if (regexp2.kcode == KCode.EUC) {
                options2 |= 0x20;
            } else if (regexp2.kcode == KCode.SJIS) {
                options2 |= 0x30;
            } else if (regexp2.kcode == KCode.UTF8) {
                options2 |= 0x40;
            }
        }
        return this.initializeCommon(regexp2.str, options2);
    }

    private RubyRegexp initializeCommon(ByteList bytes2, int options2) {
        Ruby runtime2 = this.getRuntime();
        if (!this.isTaint() && runtime2.getSafeLevel() >= 4) {
            throw runtime2.newSecurityError("Insecure: can't modify regexp");
        }
        this.checkFrozen();
        if (this.isLiteral()) {
            throw runtime2.newSecurityError("can't modify literal regexp");
        }
        this.setKCode(runtime2, options2);
        this.pattern = RubyRegexp.getRegexpFromCache(runtime2, bytes2, this.kcode.getEncoding(), options2 & 0xF);
        this.str = bytes2;
        return this;
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize_m19(IRubyObject arg2) {
        if (arg2 instanceof RubyRegexp) {
            return this.initializeByRegexp19((RubyRegexp)arg2);
        }
        return this.initializeCommon19(arg2.convertToString(), 0);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize_m19(IRubyObject arg0, IRubyObject arg1) {
        if (arg0 instanceof RubyRegexp) {
            this.getRuntime().getWarnings().warn(IRubyWarnings.ID.REGEXP_IGNORED_FLAGS, "flags ignored", new Object[0]);
            return this.initializeByRegexp19((RubyRegexp)arg0);
        }
        int options2 = arg1 instanceof RubyFixnum ? RubyNumeric.fix2int(arg1) : (arg1.isTrue() ? 1 : 0);
        return this.initializeCommon19(arg0.convertToString(), options2);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize_m19(IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        int options2;
        if (arg0 instanceof RubyRegexp) {
            this.getRuntime().getWarnings().warn(IRubyWarnings.ID.REGEXP_IGNORED_FLAGS, "flags ignored", new Object[0]);
            return this.initializeByRegexp19((RubyRegexp)arg0);
        }
        int n = arg1 instanceof RubyFixnum ? RubyNumeric.fix2int(arg1) : (options2 = arg1.isTrue() ? 1 : 0);
        if (!arg2.isNil()) {
            ByteList kcodeBytes = arg2.convertToString().getByteList();
            if (kcodeBytes.getRealSize() > 0 && kcodeBytes.getUnsafeBytes()[kcodeBytes.getBegin()] == 110 || kcodeBytes.getRealSize() > 1 && kcodeBytes.getUnsafeBytes()[kcodeBytes.getBegin() + 1] == 78) {
                return this.initializeCommon19(arg0.convertToString().getByteList(), ASCIIEncoding.INSTANCE, options2 | 0x20);
            }
            this.getRuntime().getWarnings().warn("encoding option is ignored - " + kcodeBytes);
        }
        return this.initializeCommon19(arg0.convertToString(), options2);
    }

    private IRubyObject initializeByRegexp19(RubyRegexp regexp2) {
        regexp2.check();
        return this.initializeCommon19(regexp2.str, regexp2.getEncoding(), regexp2.pattern.getOptions());
    }

    private RubyRegexp initializeCommon19(RubyString str, int options2) {
        ByteList bytes2 = str.getByteList();
        Encoding enc = bytes2.getEncoding();
        if ((options2 & 0x100) != 0 && enc != ASCIIEncoding.INSTANCE) {
            if (str.scanForCodeRange() != 32) {
                RubyRegexp.raiseRegexpError19(this.getRuntime(), bytes2, enc, options2, "/.../n has a non escaped non ASCII character in non ASCII-8BIT script");
            }
            enc = ASCIIEncoding.INSTANCE;
        }
        return this.initializeCommon19(bytes2, enc, options2);
    }

    private RubyRegexp initializeCommon19(ByteList bytes2, Encoding enc, int options2) {
        Ruby runtime2 = this.getRuntime();
        this.setKCode(runtime2, options2);
        if (!this.isTaint() && runtime2.getSafeLevel() >= 4) {
            throw runtime2.newSecurityError("Insecure: can't modify regexp");
        }
        this.checkFrozen();
        if (this.isLiteral()) {
            throw runtime2.newSecurityError("can't modify literal regexp");
        }
        if (this.pattern != null) {
            throw runtime2.newTypeError("already initialized regexp");
        }
        if (enc.isDummy()) {
            RubyRegexp.raiseRegexpError19(runtime2, bytes2, enc, options2, "can't make regexp with dummy encoding");
        }
        Encoding[] fixedEnc = new Encoding[]{null};
        ByteList unescaped = RubyRegexp.preprocess(runtime2, bytes2, enc, fixedEnc, ErrorMode.RAISE);
        if (fixedEnc[0] != null) {
            if (fixedEnc[0] != enc && (options2 & 0x10) != 0 || fixedEnc[0] != ASCIIEncoding.INSTANCE && (options2 & 0x20) != 0) {
                RubyRegexp.raiseRegexpError19(runtime2, bytes2, enc, options2, "incompatible character encoding");
            }
            if (fixedEnc[0] != ASCIIEncoding.INSTANCE) {
                options2 |= 0x10;
                enc = fixedEnc[0];
            }
        } else if ((options2 & 0x10) == 0) {
            enc = USASCIIEncoding.INSTANCE;
        }
        if ((options2 & 0x10) == 0 && fixedEnc[0] == null) {
            this.setKCodeDefault();
        }
        if ((options2 & 0x20) != 0) {
            this.setEncodingNone();
        }
        this.pattern = RubyRegexp.getRegexpFromCache(runtime2, unescaped, enc, options2 & 7);
        this.str = bytes2;
        return this;
    }

    @JRubyMethod(name={"kcode"})
    public IRubyObject kcode(ThreadContext context) {
        return !this.isKCodeDefault() && this.kcode != null ? context.getRuntime().newString(this.kcode.name()) : context.getRuntime().getNil();
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        this.check();
        int hash2 = this.pattern.getOptions();
        int len = this.str.getRealSize();
        int p2 = this.str.getBegin();
        byte[] bytes2 = this.str.getUnsafeBytes();
        while (len-- > 0) {
            hash2 = hash2 * 33 + bytes2[p2++];
        }
        return this.getRuntime().newFixnum(hash2 + (hash2 >> 5));
    }

    @JRubyMethod(name={"==", "eql?"}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return context.getRuntime().getTrue();
        }
        if (!(other instanceof RubyRegexp)) {
            return context.getRuntime().getFalse();
        }
        RubyRegexp otherRegex = (RubyRegexp)other;
        this.check();
        otherRegex.check();
        return context.getRuntime().newBoolean(this.str.equal(otherRegex.str) && this.kcode == otherRegex.kcode && this.pattern.getOptions() == otherRegex.pattern.getOptions());
    }

    @JRubyMethod(name={"~"}, reads={FrameField.LASTLINE, FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject op_match2(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        IRubyObject line = context.getCurrentScope().getLastLine(runtime2);
        if (line instanceof RubyString) {
            int start2 = this.search(context, (RubyString)line, 0, false);
            if (start2 < 0) {
                return runtime2.getNil();
            }
            return runtime2.newFixnum(start2);
        }
        context.getCurrentScope().setBackRef(runtime2.getNil());
        return runtime2.getNil();
    }

    @JRubyMethod(name={"==="}, required=1, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject eqq(ThreadContext context, IRubyObject arg2) {
        RubyString str;
        Ruby runtime2 = context.getRuntime();
        if (arg2 instanceof RubyString) {
            str = (RubyString)arg2;
        } else {
            IRubyObject tmp = arg2.checkStringType();
            if (tmp.isNil()) {
                context.getCurrentScope().setBackRef(tmp);
                return runtime2.getFalse();
            }
            str = (RubyString)tmp;
        }
        int start2 = this.search(context, str, 0, false);
        return start2 < 0 ? runtime2.getFalse() : runtime2.getTrue();
    }

    @JRubyMethod(name={"==="}, required=1, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject eqq19(ThreadContext context, IRubyObject arg2) {
        Ruby runtime2 = context.getRuntime();
        if ((arg2 = RubyRegexp.operandNoCheck(arg2)).isNil()) {
            context.getCurrentScope().setBackRef(arg2);
            return runtime2.getFalse();
        }
        int start2 = this.search19(context, (RubyString)arg2, 0, false);
        return start2 < 0 ? runtime2.getFalse() : runtime2.getTrue();
    }

    @JRubyMethod(name={"=~"}, required=1, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_match(ThreadContext context, IRubyObject str) {
        Ruby runtime2 = context.getRuntime();
        if (str.isNil()) {
            context.getCurrentScope().setBackRef(str);
            return str;
        }
        int start2 = this.search(context, str.convertToString(), 0, false);
        if (start2 < 0) {
            return runtime2.getNil();
        }
        return RubyFixnum.newFixnum(runtime2, start2);
    }

    @JRubyMethod(name={"=~"}, required=1, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_match19(ThreadContext context, IRubyObject arg2) {
        Ruby runtime2 = context.getRuntime();
        if (arg2.isNil()) {
            context.getCurrentScope().setBackRef(arg2);
            return arg2;
        }
        RubyString str = RubyRegexp.operandCheck(runtime2, arg2);
        int pos2 = this.matchPos(context, str, 0);
        if (pos2 < 0) {
            return runtime2.getNil();
        }
        return RubyFixnum.newFixnum(runtime2, str.subLength(pos2));
    }

    @JRubyMethod(name={"match"}, required=1, reads={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject match_m(ThreadContext context, IRubyObject str) {
        IRubyObject result = this.op_match(context, str);
        if (result.isNil()) {
            return result;
        }
        result = context.getCurrentScope().getBackRef(context.getRuntime());
        ((RubyMatchData)result).use();
        return result;
    }

    @JRubyMethod(name={"match"}, reads={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject match_m19(ThreadContext context, IRubyObject str, Block block) {
        return this.match19Common(context, str, 0, block);
    }

    @JRubyMethod(name={"match"}, reads={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject match_m19(ThreadContext context, IRubyObject str, IRubyObject pos2, Block block) {
        return this.match19Common(context, str, RubyNumeric.num2int(pos2), block);
    }

    private IRubyObject match19Common(ThreadContext context, IRubyObject arg2, int pos2, Block block) {
        DynamicScope scope = context.getCurrentScope();
        if (arg2.isNil()) {
            scope.setBackRef(arg2);
            return arg2;
        }
        Ruby runtime2 = context.getRuntime();
        RubyString str = RubyRegexp.operandCheck(runtime2, arg2);
        if (this.matchPos(context, str, pos2) < 0) {
            scope.setBackRef(runtime2.getNil());
            return runtime2.getNil();
        }
        IRubyObject backref = scope.getBackRef(runtime2);
        ((RubyMatchData)backref).use();
        if (block.isGiven()) {
            return block.yield(context, backref);
        }
        return backref;
    }

    private int matchPos(ThreadContext context, RubyString str, int pos2) {
        if (pos2 != 0) {
            if (pos2 < 0 && (pos2 += str.strLength()) < 0) {
                return pos2;
            }
            pos2 = this.adjustStartPos19(str, pos2, false);
        }
        return this.search19(context, str, pos2, false);
    }

    public final int search(ThreadContext context, RubyString str, int pos2, boolean reverse2) {
        this.check();
        DynamicScope scope = context.getCurrentScope();
        ByteList value2 = str.getByteList();
        if (pos2 <= value2.getRealSize() && pos2 >= 0) {
            int realSize = value2.getRealSize();
            int begin2 = value2.getBegin();
            Matcher matcher = this.pattern.matcher(value2.getUnsafeBytes(), begin2, begin2 + realSize);
            int result = matcher.search(begin2 + pos2, begin2 + (reverse2 ? 0 : realSize), 0);
            if (result >= 0) {
                this.updateBackRef(context, str, scope, matcher);
                return result;
            }
        }
        scope.setBackRef(context.getRuntime().getNil());
        return -1;
    }

    private RubyMatchData updateBackRef(ThreadContext context, RubyString str, DynamicScope scope, Matcher matcher) {
        RubyMatchData match2 = RubyRegexp.updateBackRef(context, str, scope, matcher, this.pattern);
        match2.regexp = this;
        match2.infectBy(this);
        return match2;
    }

    static final RubyMatchData updateBackRef(ThreadContext context, RubyString str, DynamicScope scope, Matcher matcher, Regex pattern) {
        RubyMatchData match2;
        Ruby runtime2 = context.getRuntime();
        IRubyObject backref = scope.getBackRef(runtime2);
        boolean setBackRef = false;
        if (backref.isNil() || ((RubyMatchData)backref).used()) {
            match2 = new RubyMatchData(runtime2);
            setBackRef = true;
        } else {
            match2 = (RubyMatchData)backref;
            match2.setTaint(runtime2.getSafeLevel() >= 3);
        }
        match2.regs = matcher.getRegion();
        match2.begin = matcher.getBegin();
        match2.end = matcher.getEnd();
        match2.pattern = pattern;
        match2.str = (RubyString)str.strDup(runtime2).freeze(context);
        match2.infectBy(str);
        if (setBackRef) {
            scope.setBackRef(match2);
        }
        return match2;
    }

    public final int search19(ThreadContext context, RubyString str, int pos2, boolean reverse2) {
        this.check();
        DynamicScope scope = context.getCurrentScope();
        ByteList value2 = str.getByteList();
        if (pos2 <= value2.getRealSize() && pos2 >= 0) {
            int realSize = value2.getRealSize();
            int begin2 = value2.getBegin();
            Matcher matcher = this.preparePattern(str).matcher(value2.getUnsafeBytes(), begin2, begin2 + realSize);
            int result = matcher.search(begin2 + pos2, begin2 + (reverse2 ? 0 : realSize), 0);
            if (result >= 0) {
                this.updateBackRef((ThreadContext)context, (RubyString)str, (DynamicScope)scope, (Matcher)matcher).charOffsetUpdated = false;
                return result;
            }
        }
        scope.setBackRef(context.getRuntime().getNil());
        return -1;
    }

    static final RubyMatchData updateBackRef19(ThreadContext context, RubyString str, DynamicScope scope, Matcher matcher, Regex pattern) {
        RubyMatchData match2 = RubyRegexp.updateBackRef(context, str, scope, matcher, pattern);
        match2.charOffsetUpdated = false;
        return match2;
    }

    @JRubyMethod(name={"options"})
    public IRubyObject options() {
        return this.getRuntime().newFixnum(this.getOptions());
    }

    @JRubyMethod(name={"casefold?"})
    public IRubyObject casefold_p(ThreadContext context) {
        this.check();
        return context.getRuntime().newBoolean((this.pattern.getOptions() & 1) != 0);
    }

    @JRubyMethod(name={"source"})
    public IRubyObject source() {
        this.check();
        RubyString str = RubyString.newStringShared(this.getRuntime(), this.str);
        if (this.isTaint()) {
            str.setTaint(true);
        }
        return str;
    }

    final int length() {
        return this.str.getRealSize();
    }

    @JRubyMethod(name={"inspect"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject inspect() {
        this.check();
        ByteList result = RubyRegexp.regexpDescription(this.getRuntime(), this.str, this.kcode.getEncoding(), this.pattern.getOptions());
        if (this.kcode != null && !this.isKCodeDefault()) {
            result.append((byte)this.kcode.name().charAt(0));
        }
        return RubyString.newString(this.getRuntime(), result);
    }

    @JRubyMethod(name={"inspect"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject inspect19() {
        if (this.pattern == null) {
            return this.anyToString();
        }
        return RubyString.newString(this.getRuntime(), RubyRegexp.regexpDescription19(this.getRuntime(), this.str, this.pattern.getOptions(), this.str.getEncoding()));
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        this.check();
        int options2 = this.pattern.getOptions();
        int p2 = this.str.getBegin();
        int len = this.str.getRealSize();
        byte[] bytes2 = this.str.getUnsafeBytes();
        ByteList result = new ByteList(len);
        result.append((byte)40).append((byte)63);
        while (len >= 4 && bytes2[p2] == 40 && bytes2[p2 + 1] == 63) {
            boolean err = true;
            p2 += 2;
            if ((len -= 2) > 0) {
                do {
                    if (bytes2[p2] == 109) {
                        options2 |= 4;
                    } else if (bytes2[p2] == 105) {
                        options2 |= 1;
                    } else {
                        if (bytes2[p2] != 120) break;
                        options2 |= 2;
                    }
                    ++p2;
                } while (--len > 0);
            }
            if (len > 1 && bytes2[p2] == 45) {
                ++p2;
                --len;
                do {
                    if (bytes2[p2] == 109) {
                        options2 &= 0xFFFFFFFB;
                    } else if (bytes2[p2] == 105) {
                        options2 &= 0xFFFFFFFE;
                    } else {
                        if (bytes2[p2] != 120) break;
                        options2 &= 0xFFFFFFFD;
                    }
                    ++p2;
                } while (--len > 0);
            }
            if (bytes2[p2] == 41) {
                --len;
                ++p2;
                continue;
            }
            if (bytes2[p2] == 58 && bytes2[p2 + len - 1] == 41) {
                try {
                    Regex regex = new Regex(bytes2, ++p2, p2 + (len -= 2), 0, this.kcode.getEncoding(), Syntax.DEFAULT);
                    err = false;
                }
                catch (JOniException e) {
                    err = true;
                }
            }
            if (!err) break;
            options2 = this.pattern.getOptions();
            p2 = this.str.getBegin();
            len = this.str.getRealSize();
            break;
        }
        RubyRegexp.appendOptions(result, options2);
        if ((options2 & 7) != 7) {
            result.append((byte)45);
            if ((options2 & 4) == 0) {
                result.append((byte)109);
            }
            if ((options2 & 1) == 0) {
                result.append((byte)105);
            }
            if ((options2 & 2) == 0) {
                result.append((byte)120);
            }
        }
        result.append((byte)58);
        RubyRegexp.appendRegexpString(this.getRuntime(), result, bytes2, p2, len, this.kcode.getEncoding());
        result.append((byte)41);
        return RubyString.newString(this.getRuntime(), result).infectBy(this);
    }

    private static void appendRegexpString(Ruby runtime2, ByteList to, byte[] bytes2, int start2, int len, Encoding enc) {
        int c;
        int p2;
        int end2 = p2 + len;
        boolean needEscape = false;
        for (p2 = start2; p2 < end2; p2 += enc.length(bytes2, p2, end2)) {
            c = bytes2[p2] & 0xFF;
            if (c != 47 && (enc.isPrint(c) || enc.length(bytes2, p2, end2) != 1)) continue;
            needEscape = true;
            break;
        }
        if (!needEscape) {
            to.append(bytes2, start2, len);
        } else {
            p2 = start2;
            while (p2 < end2) {
                c = bytes2[p2] & 0xFF;
                if (c == 92) {
                    int n = enc.length(bytes2, p2 + 1, end2) + 1;
                    to.append(bytes2, p2, n);
                    p2 += n;
                    continue;
                }
                if (c == 47) {
                    to.append((byte)92);
                    to.append(bytes2, p2, 1);
                } else {
                    if (enc.length(bytes2, p2, end2) != 1) {
                        to.append(bytes2, p2, enc.length(bytes2, p2, end2));
                        p2 += enc.length(bytes2, p2, end2);
                        continue;
                    }
                    if (enc.isPrint(c)) {
                        to.append(bytes2, p2, 1);
                    } else if (!enc.isSpace(c)) {
                        Sprintf.sprintf(runtime2, to, (CharSequence)"\\%03o", bytes2[p2] & 0xFF);
                    } else {
                        to.append(bytes2, p2, 1);
                    }
                }
                ++p2;
            }
        }
    }

    private static void appendRegexpString19(Ruby runtime2, ByteList to, byte[] bytes2, int start2, int len, Encoding enc) {
        int c;
        int cl;
        int p2 = start2;
        int end2 = p2 + len;
        boolean needEscape = false;
        while (p2 < end2) {
            if (enc.isAsciiCompatible()) {
                cl = 1;
                c = bytes2[p2] & 0xFF;
            } else {
                cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
                c = enc.mbcToCode(bytes2, p2, end2);
            }
            if (!Encoding.isAscii(c)) {
                p2 += StringSupport.length(enc, bytes2, p2, end2);
                continue;
            }
            if (c != 47 && enc.isPrint(c)) {
                p2 += cl;
                continue;
            }
            needEscape = true;
            break;
        }
        if (!needEscape) {
            to.append(bytes2, start2, len);
        } else {
            p2 = start2;
            while (p2 < end2) {
                if (enc.isAsciiCompatible()) {
                    cl = 1;
                    c = bytes2[p2] & 0xFF;
                } else {
                    cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
                    c = enc.mbcToCode(bytes2, p2, end2);
                }
                if (c == 92 && p2 + cl < end2) {
                    int n = cl + StringSupport.length(enc, bytes2, p2 + cl, end2);
                    to.append(bytes2, p2, n);
                    p2 += n;
                    continue;
                }
                if (c == 47) {
                    to.append((byte)92);
                    to.append(bytes2, p2, cl);
                } else {
                    if (!Encoding.isAscii(c)) {
                        int l = StringSupport.length(enc, bytes2, p2, end2);
                        to.append(bytes2, p2, l);
                        p2 += l;
                        continue;
                    }
                    if (enc.isPrint(c)) {
                        to.append(bytes2, p2, cl);
                    } else if (!enc.isSpace(c)) {
                        Sprintf.sprintf(runtime2, to, (CharSequence)"\\x%02X", c);
                    } else {
                        to.append(bytes2, p2, cl);
                    }
                }
                p2 += cl;
            }
        }
    }

    private static void appendOptions(ByteList to, int options2) {
        if ((options2 & 4) != 0) {
            to.append((byte)109);
        }
        if ((options2 & 1) != 0) {
            to.append((byte)105);
        }
        if ((options2 & 2) != 0) {
            to.append((byte)120);
        }
    }

    @JRubyMethod(name={"names"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject names(ThreadContext context) {
        if (this.pattern.numberOfNames() == 0) {
            return this.getRuntime().newEmptyArray();
        }
        RubyArray ary = context.getRuntime().newArray(this.pattern.numberOfNames());
        Iterator<NameEntry> i = this.pattern.namedBackrefIterator();
        while (i.hasNext()) {
            NameEntry e = i.next();
            ary.append(RubyString.newStringShared(this.getRuntime(), e.name, e.nameP, e.nameEnd - e.nameP));
        }
        return ary;
    }

    @JRubyMethod(name={"named_captures"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject named_captures(ThreadContext context) {
        RubyHash hash2 = RubyHash.newHash(this.getRuntime());
        if (this.pattern.numberOfNames() == 0) {
            return hash2;
        }
        Iterator<NameEntry> i = this.pattern.namedBackrefIterator();
        while (i.hasNext()) {
            NameEntry e = i.next();
            int[] backrefs = e.getBackRefs();
            RubyArray ary = this.getRuntime().newArray(backrefs.length);
            for (int backref : backrefs) {
                ary.append(RubyFixnum.newFixnum(this.getRuntime(), backref));
            }
            hash2.fastASet(RubyString.newStringShared(this.getRuntime(), e.name, e.nameP, e.nameEnd - e.nameP).freeze(context), ary);
        }
        return hash2;
    }

    @JRubyMethod(name={"encoding"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject encoding(ThreadContext context) {
        return context.getRuntime().getEncodingService().getEncoding(this.pattern.getEncoding());
    }

    @JRubyMethod(name={"fixed_encoding?"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject fixed_encoding_p(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        return this.isKCodeDefault() ? runtime2.getFalse() : runtime2.getTrue();
    }

    public static IRubyObject nth_match(int nth, IRubyObject match2) {
        int end2;
        int start2;
        if (match2.isNil()) {
            return match2;
        }
        RubyMatchData m = (RubyMatchData)match2;
        Ruby runtime2 = m.getRuntime();
        if (m.regs == null) {
            if (nth >= 1 || nth < 0 && ++nth <= 0) {
                return runtime2.getNil();
            }
            start2 = m.begin;
            end2 = m.end;
        } else {
            if (nth >= m.regs.numRegs || nth < 0 && (nth += m.regs.numRegs) <= 0) {
                return runtime2.getNil();
            }
            start2 = m.regs.beg[nth];
            end2 = m.regs.end[nth];
        }
        if (start2 == -1) {
            return runtime2.getNil();
        }
        RubyString str = m.str.makeShared(runtime2, start2, end2 - start2);
        str.infectBy(m);
        return str;
    }

    public static IRubyObject last_match(IRubyObject match2) {
        return RubyRegexp.nth_match(0, match2);
    }

    public static IRubyObject match_pre(IRubyObject match2) {
        if (match2.isNil()) {
            return match2;
        }
        RubyMatchData m = (RubyMatchData)match2;
        Ruby runtime2 = m.getRuntime();
        if (m.begin == -1) {
            runtime2.getNil();
        }
        return m.str.makeShared(runtime2, 0, m.begin).infectBy(m);
    }

    public static IRubyObject match_post(IRubyObject match2) {
        if (match2.isNil()) {
            return match2;
        }
        RubyMatchData m = (RubyMatchData)match2;
        Ruby runtime2 = m.getRuntime();
        if (m.begin == -1) {
            return runtime2.getNil();
        }
        return m.str.makeShared(runtime2, m.end, m.str.getByteList().getRealSize() - m.end).infectBy(m);
    }

    public static IRubyObject match_last(IRubyObject match2) {
        int i;
        if (match2.isNil()) {
            return match2;
        }
        RubyMatchData m = (RubyMatchData)match2;
        if (m.regs == null || m.regs.beg[0] == -1) {
            return match2.getRuntime().getNil();
        }
        for (i = m.regs.numRegs - 1; m.regs.beg[i] == -1 && i > 0; --i) {
        }
        if (i == 0) {
            return match2.getRuntime().getNil();
        }
        return RubyRegexp.nth_match(i, match2);
    }

    static RubyString regsub(RubyString str, RubyString src, Matcher matcher, Encoding enc) {
        int p2;
        Region regs = matcher.getRegion();
        int no = -1;
        ByteList bs = str.getByteList();
        int s = p2 = bs.getBegin();
        int end2 = p2 + bs.getRealSize();
        byte[] bytes2 = bs.getUnsafeBytes();
        ByteList srcbs = src.getByteList();
        ByteList val = null;
        block8: while (s < end2) {
            int l;
            int ss = s;
            int c = bytes2[s] & 0xFF;
            if ((l = enc.length(bytes2, s++, end2)) != 1) {
                s += l - 1;
                continue;
            }
            if (c != 92 || s == end2) continue;
            if (val == null) {
                val = new ByteList(ss - p2);
            }
            val.append(bytes2, p2, ss - p2);
            c = bytes2[s++] & 0xFF;
            p2 = s;
            switch (c) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    no = c - 48;
                    break;
                }
                case 38: {
                    no = 0;
                    break;
                }
                case 96: {
                    val.append(srcbs.getUnsafeBytes(), srcbs.getBegin(), matcher.getBegin());
                    continue block8;
                }
                case 39: {
                    val.append(srcbs.getUnsafeBytes(), srcbs.getBegin() + matcher.getEnd(), srcbs.getRealSize() - matcher.getEnd());
                    continue block8;
                }
                case 43: {
                    if (regs == null) {
                        if (matcher.getBegin() != -1) break;
                        no = 0;
                        continue block8;
                    }
                    for (no = regs.numRegs - 1; regs.beg[no] == -1 && no > 0; --no) {
                    }
                    if (no != 0) break;
                    continue block8;
                }
                case 92: {
                    val.append(bytes2, s - 1, 1);
                    continue block8;
                }
                default: {
                    val.append(bytes2, s - 2, 2);
                    continue block8;
                }
            }
            if (regs != null) {
                if (no < 0 || no >= regs.numRegs || regs.beg[no] == -1) continue;
                val.append(srcbs.getUnsafeBytes(), srcbs.getBegin() + regs.beg[no], regs.end[no] - regs.beg[no]);
                continue;
            }
            if (no != 0 || matcher.getBegin() == -1) continue;
            val.append(srcbs.getUnsafeBytes(), srcbs.getBegin() + matcher.getBegin(), matcher.getEnd() - matcher.getBegin());
        }
        if (p2 < end2) {
            if (val == null) {
                return RubyString.newString(str.getRuntime(), bs.makeShared(p2 - bs.getBegin(), end2 - p2));
            }
            val.append(bytes2, p2, end2 - p2);
        }
        if (val == null) {
            return str;
        }
        return RubyString.newString(str.getRuntime(), val);
    }

    static RubyString regsub19(RubyString str, RubyString src, Matcher matcher, Regex pattern) {
        int p2;
        Region regs = matcher.getRegion();
        int no = -1;
        ByteList bs = str.getByteList();
        int s = p2 = bs.getBegin();
        int end2 = p2 + bs.getRealSize();
        byte[] bytes2 = bs.getUnsafeBytes();
        Encoding strEnc = bs.getEncoding();
        ByteList srcbs = src.getByteList();
        Encoding srcEnc = srcbs.getEncoding();
        RubyString val = null;
        block11: while (s < end2) {
            int c;
            int cl;
            if (strEnc.isAsciiCompatible()) {
                cl = 1;
                c = bytes2[s] & 0xFF;
            } else {
                cl = StringSupport.preciseLength(strEnc, bytes2, s, end2);
                c = strEnc.mbcToCode(bytes2, s, end2);
            }
            if (!Encoding.isAscii(c)) {
                s += StringSupport.length(strEnc, bytes2, s, end2);
                continue;
            }
            int ss = s;
            if (c != 92 || (s += cl) == end2) continue;
            if (val == null) {
                val = RubyString.newString(str.getRuntime(), new ByteList(ss - p2));
            }
            val.cat(bytes2, p2, ss - p2, strEnc);
            if (strEnc.isAsciiCompatible()) {
                cl = 1;
                c = bytes2[s] & 0xFF;
            } else {
                cl = StringSupport.preciseLength(strEnc, bytes2, s, end2);
                c = strEnc.mbcToCode(bytes2, s, end2);
            }
            if (!Encoding.isAscii(c)) {
                s += StringSupport.length(strEnc, bytes2, s, end2);
                val.cat(bytes2, ss, s - ss, strEnc);
                p2 = s;
                continue;
            }
            p2 = s += cl;
            switch (c) {
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    if (!pattern.noNameGroupIsActive(Syntax.RUBY)) continue block11;
                    no = c - 48;
                    break;
                }
                case 107: {
                    if (s < end2) {
                        if (strEnc.isAsciiCompatible()) {
                            cl = 1;
                            c = bytes2[s] & 0xFF;
                        } else {
                            cl = StringSupport.preciseLength(strEnc, bytes2, s, end2);
                            c = strEnc.mbcToCode(bytes2, s, end2);
                        }
                        if (c == 60) {
                            int name2;
                            int nameEnd;
                            for (nameEnd = name2 = s + cl; nameEnd < end2; nameEnd += !Encoding.isAscii(c) ? StringSupport.length(strEnc, bytes2, nameEnd, end2) : cl) {
                                if (strEnc.isAsciiCompatible()) {
                                    cl = 1;
                                    c = bytes2[nameEnd] & 0xFF;
                                } else {
                                    cl = StringSupport.preciseLength(strEnc, bytes2, nameEnd, end2);
                                    c = strEnc.mbcToCode(bytes2, nameEnd, end2);
                                }
                                if (c == 62) break;
                            }
                            if (nameEnd < end2) {
                                try {
                                    no = pattern.nameToBackrefNumber(bytes2, name2, nameEnd, regs);
                                }
                                catch (JOniException je) {
                                    throw str.getRuntime().newIndexError(je.getMessage());
                                }
                                p2 = s = nameEnd + cl;
                                break;
                            }
                            throw str.getRuntime().newRuntimeError("invalid group name reference format");
                        }
                    }
                    val.cat(bytes2, ss, s - ss, strEnc);
                    continue block11;
                }
                case 38: 
                case 48: {
                    no = 0;
                    break;
                }
                case 96: {
                    val.cat(srcbs.getUnsafeBytes(), srcbs.getBegin(), matcher.getBegin(), srcEnc);
                    continue block11;
                }
                case 39: {
                    val.cat(srcbs.getUnsafeBytes(), srcbs.getBegin() + matcher.getEnd(), srcbs.getRealSize() - matcher.getEnd(), srcEnc);
                    continue block11;
                }
                case 43: {
                    if (regs == null) {
                        if (matcher.getBegin() != -1) break;
                        no = 0;
                        continue block11;
                    }
                    for (no = regs.numRegs - 1; regs.beg[no] == -1 && no > 0; --no) {
                    }
                    if (no != 0) break;
                    continue block11;
                }
                case 92: {
                    val.cat(bytes2, s - cl, cl, strEnc);
                    continue block11;
                }
                default: {
                    val.cat(bytes2, ss, s - ss, strEnc);
                    continue block11;
                }
            }
            if (regs != null) {
                if (no < 0 || no >= regs.numRegs || regs.beg[no] == -1) continue;
                val.cat(srcbs.getUnsafeBytes(), srcbs.getBegin() + regs.beg[no], regs.end[no] - regs.beg[no], srcEnc);
                continue;
            }
            if (no != 0 || matcher.getBegin() == -1) continue;
            val.cat(srcbs.getUnsafeBytes(), srcbs.getBegin() + matcher.getBegin(), matcher.getEnd() - matcher.getBegin(), srcEnc);
        }
        if (val == null) {
            return str;
        }
        if (p2 < end2) {
            val.cat(bytes2, p2, end2 - p2, strEnc);
        }
        return val;
    }

    final int adjustStartPos19(RubyString str, int pos2, boolean reverse2) {
        return this.adjustStartPosInternal(str, this.checkEncoding(str, false), pos2, reverse2);
    }

    final int adjustStartPos(RubyString str, int pos2, boolean reverse2) {
        return this.adjustStartPosInternal(str, this.pattern.getEncoding(), pos2, reverse2);
    }

    private final int adjustStartPosInternal(RubyString str, Encoding enc, int pos2, boolean reverse2) {
        this.check();
        ByteList value2 = str.getByteList();
        int len = value2.getRealSize();
        if (pos2 > 0 && enc.maxLength() != 1 && pos2 < len) {
            int start2 = value2.getBegin();
            if ((reverse2 ? -pos2 : len - pos2) > 0) {
                return enc.rightAdjustCharHead(value2.getUnsafeBytes(), start2, start2 + pos2, start2 + len) - start2;
            }
            return enc.leftAdjustCharHead(value2.getUnsafeBytes(), start2, start2 + pos2, start2 + len) - start2;
        }
        return pos2;
    }

    private static IRubyObject operandNoCheck(IRubyObject str) {
        if (str instanceof RubySymbol) {
            return ((RubySymbol)str).to_s();
        }
        return str.checkStringType();
    }

    private static RubyString operandCheck(Ruby runtime2, IRubyObject str) {
        if (str instanceof RubySymbol) {
            return (RubyString)((RubySymbol)str).to_s();
        }
        IRubyObject tmp = str.checkStringType();
        if (tmp.isNil()) {
            throw runtime2.newTypeError("can't convert " + str.getMetaClass() + "to String");
        }
        return (RubyString)tmp;
    }

    public static RubyRegexp unmarshalFrom(UnmarshalStream input) throws IOException {
        RubyRegexp result = RubyRegexp.newRegexp(input.getRuntime(), input.unmarshalString(), (int)input.readSignedByte());
        input.registerLinkTarget(result);
        return result;
    }

    public static void marshalTo(RubyRegexp regexp2, MarshalStream output) throws IOException {
        output.registerLinkTarget(regexp2);
        output.writeString(new String(regexp2.str.getUnsafeBytes(), regexp2.str.getBegin(), regexp2.str.getRealSize()));
        output.writeByte(regexp2.pattern.getOptions() & 7);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ErrorMode {
        RAISE,
        PREPROCESS,
        DESC;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RegexpCache {
        private volatile SoftReference<Map<ByteList, Regex>> cache = new SoftReference<Object>(null);

        private RegexpCache() {
        }

        private Map<ByteList, Regex> get() {
            Map<ByteList, Regex> patternCache = this.cache.get();
            if (patternCache == null) {
                patternCache = new ConcurrentHashMap<ByteList, Regex>(5);
                this.cache = new SoftReference<Map<ByteList, Regex>>(patternCache);
            }
            return patternCache;
        }
    }
}

