/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import java.util.Locale;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.ascii.AsciiTables;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jcodings.util.IntHash;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.Region;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyComplex;
import org.jruby.RubyEncoding;
import org.jruby.RubyEnumerable;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyRational;
import org.jruby.RubyRegexp;
import org.jruby.RubySymbol;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingCapable;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.ConvertBytes;
import org.jruby.util.Numeric;
import org.jruby.util.Pack;
import org.jruby.util.Sprintf;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;
import org.jruby.util.string.JavaCrypt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"String"}, include={"Enumerable", "Comparable"})
public class RubyString
extends RubyObject
implements EncodingCapable {
    private static final ASCIIEncoding ASCII = ASCIIEncoding.INSTANCE;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final int SHARE_LEVEL_NONE = 0;
    private static final int SHARE_LEVEL_BUFFER = 1;
    private static final int SHARE_LEVEL_BYTELIST = 2;
    private volatile int shareLevel = 0;
    private ByteList value;
    private static ObjectAllocator STRING_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return RubyString.newEmptyString(runtime2, klass);
        }
    };
    private static final EmptyByteListHolder[] EMPTY_BYTELISTS = new EmptyByteListHolder[4];
    private static final ByteList SPACE_BYTELIST = new ByteList(ByteList.plain(" "));
    private static final int TRANS_SIZE = 256;

    public static RubyClass createStringClass(Ruby runtime2) {
        RubyClass stringClass = runtime2.defineClass("String", runtime2.getObject(), STRING_ALLOCATOR);
        runtime2.setString(stringClass);
        stringClass.index = 4;
        stringClass.setReifiedClass(RubyString.class);
        stringClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof RubyString;
            }
        };
        stringClass.includeModule(runtime2.getComparable());
        if (!runtime2.is1_9()) {
            stringClass.includeModule(runtime2.getEnumerable());
        }
        stringClass.defineAnnotatedMethods(RubyString.class);
        return stringClass;
    }

    @Override
    public Encoding getEncoding() {
        return this.value.getEncoding();
    }

    public void associateEncoding(Encoding enc) {
        if (this.value.getEncoding() != enc) {
            if (!this.isCodeRangeAsciiOnly() || !enc.isAsciiCompatible()) {
                this.clearCodeRange();
            }
            this.value.setEncoding(enc);
        }
    }

    public final void setEncodingAndCodeRange(Encoding enc, int cr) {
        this.value.setEncoding(enc);
        this.setCodeRange(cr);
    }

    public final Encoding toEncoding(Ruby runtime2) {
        if (!this.value.getEncoding().isAsciiCompatible()) {
            throw runtime2.newArgumentError("invalid name encoding (non ASCII)");
        }
        EncodingDB.Entry entry = runtime2.getEncodingService().findEncodingOrAliasEntry(this.value);
        if (entry == null) {
            throw runtime2.newArgumentError("unknown encoding name - " + this.value);
        }
        return entry.getEncoding();
    }

    public final int getCodeRange() {
        return this.flags & 0x60;
    }

    public final void setCodeRange(int codeRange) {
        this.flags |= codeRange & 0x60;
    }

    public final void clearCodeRange() {
        this.flags &= 0xFFFFFF9F;
    }

    private void keepCodeRange() {
        if (this.getCodeRange() == 96) {
            this.clearCodeRange();
        }
    }

    public final boolean isCodeRangeAsciiOnly() {
        return this.getCodeRange() == 32;
    }

    public final boolean isAsciiOnly() {
        return this.value.getEncoding().isAsciiCompatible() && this.scanForCodeRange() == 32;
    }

    public final boolean isCodeRangeValid() {
        return (this.flags & 0x40) != 0;
    }

    public final boolean isCodeRangeBroken() {
        return (this.flags & 0x60) != 0;
    }

    static int codeRangeAnd(int cr1, int cr2) {
        if (cr1 == 32) {
            return cr2;
        }
        if (cr1 == 64) {
            return cr2 == 32 ? 64 : cr2;
        }
        return 0;
    }

    private void copyCodeRangeForSubstr(RubyString from, Encoding enc) {
        int fromCr = from.getCodeRange();
        if (fromCr == 32) {
            this.setCodeRange(fromCr);
        } else if (fromCr == 64) {
            if (!enc.isAsciiCompatible() || StringSupport.searchNonAscii(this.value) != -1) {
                this.setCodeRange(64);
            } else {
                this.setCodeRange(32);
            }
        } else if (this.value.getRealSize() == 0) {
            this.setCodeRange(!enc.isAsciiCompatible() ? 64 : 32);
        }
    }

    private void copyCodeRange(RubyString from) {
        this.value.setEncoding(from.value.getEncoding());
        this.setCodeRange(from.getCodeRange());
    }

    final int scanForCodeRange() {
        int cr = this.getCodeRange();
        if (cr == 0) {
            cr = StringSupport.codeRangeScan(this.value.getEncoding(), this.value);
            this.setCodeRange(cr);
        }
        return cr;
    }

    final boolean singleByteOptimizable() {
        return this.getCodeRange() == 32 || this.value.getEncoding().isSingleByte();
    }

    final boolean singleByteOptimizable(Encoding enc) {
        return this.getCodeRange() == 32 || enc.isSingleByte();
    }

    private Encoding isCompatibleWith(RubyString other) {
        Encoding enc2;
        Encoding enc1 = this.value.getEncoding();
        if (enc1 == (enc2 = other.value.getEncoding())) {
            return enc1;
        }
        if (other.value.getRealSize() == 0) {
            return enc1;
        }
        if (this.value.getRealSize() == 0) {
            return enc2;
        }
        if (!enc1.isAsciiCompatible() || !enc2.isAsciiCompatible()) {
            return null;
        }
        return RubyEncoding.areCompatible(enc1, this.scanForCodeRange(), enc2, other.scanForCodeRange());
    }

    final Encoding isCompatibleWith(EncodingCapable other) {
        Encoding enc2;
        if (other instanceof RubyString) {
            return this.checkEncoding((RubyString)other);
        }
        Encoding enc1 = this.value.getEncoding();
        if (enc1 == (enc2 = other.getEncoding())) {
            return enc1;
        }
        if (this.value.getRealSize() == 0) {
            return enc2;
        }
        if (!enc1.isAsciiCompatible() || !enc2.isAsciiCompatible()) {
            return null;
        }
        if (enc2 instanceof USASCIIEncoding) {
            return enc1;
        }
        if (this.scanForCodeRange() == 32) {
            return enc2;
        }
        return null;
    }

    final Encoding checkEncoding(RubyString other) {
        Encoding enc = this.isCompatibleWith(other);
        if (enc == null) {
            throw this.getRuntime().newEncodingCompatibilityError("incompatible character encodings: " + this.value.getEncoding() + " and " + other.value.getEncoding());
        }
        return enc;
    }

    final Encoding checkEncoding(EncodingCapable other) {
        Encoding enc = this.isCompatibleWith(other);
        if (enc == null) {
            throw this.getRuntime().newEncodingCompatibilityError("incompatible character encodings: " + this.value.getEncoding() + " and " + other.getEncoding());
        }
        return enc;
    }

    private Encoding checkDummyEncoding() {
        Encoding enc = this.value.getEncoding();
        if (enc.isDummy()) {
            throw this.getRuntime().newEncodingCompatibilityError("incompatible encoding with this operation: " + enc);
        }
        return enc;
    }

    private boolean isComparableWith(RubyString other) {
        ByteList otherValue = other.value;
        if (this.value.getEncoding() == otherValue.getEncoding() || this.value.getRealSize() == 0 || otherValue.getRealSize() == 0) {
            return true;
        }
        return this.isComparableViaCodeRangeWith(other);
    }

    private boolean isComparableViaCodeRangeWith(RubyString other) {
        int cr1 = this.scanForCodeRange();
        int cr2 = other.scanForCodeRange();
        if (cr1 == 32 && (cr2 == 32 || other.value.getEncoding().isAsciiCompatible())) {
            return true;
        }
        return cr2 == 32 && this.value.getEncoding().isAsciiCompatible();
    }

    private int strLength(Encoding enc) {
        if (this.singleByteOptimizable(enc)) {
            return this.value.getRealSize();
        }
        return this.strLength(this.value, enc);
    }

    final int strLength() {
        if (this.singleByteOptimizable()) {
            return this.value.getRealSize();
        }
        return this.strLength(this.value);
    }

    private int strLength(ByteList bytes2) {
        return this.strLength(bytes2, bytes2.getEncoding());
    }

    private int strLength(ByteList bytes2, Encoding enc) {
        if (this.isCodeRangeValid() && enc instanceof UTF8Encoding) {
            return StringSupport.utf8Length(this.value);
        }
        long lencr = StringSupport.strLengthWithCodeRange(bytes2, enc);
        int cr = StringSupport.unpackArg(lencr);
        if (cr != 0) {
            this.setCodeRange(cr);
        }
        return StringSupport.unpackResult(lencr);
    }

    final int subLength(int pos2) {
        if (this.singleByteOptimizable() || pos2 < 0) {
            return pos2;
        }
        return StringSupport.strLength(this.value.getEncoding(), this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getBegin() + pos2);
    }

    @Override
    public final boolean eql(IRubyObject other) {
        Ruby runtime2 = this.getRuntime();
        if (this.getMetaClass() != runtime2.getString() || this.getMetaClass() != other.getMetaClass()) {
            return super.eql(other);
        }
        return runtime2.is1_9() ? this.eql19(runtime2, other) : this.eql18(runtime2, other);
    }

    private boolean eql18(Ruby runtime2, IRubyObject other) {
        return this.value.equal(((RubyString)other).value);
    }

    private boolean eql19(Ruby runtime2, IRubyObject other) {
        RubyString otherString = (RubyString)other;
        return this.isComparableWith(otherString) && this.value.equal(((RubyString)other).value);
    }

    public RubyString(Ruby runtime2, RubyClass rubyClass) {
        this(runtime2, rubyClass, EMPTY_BYTE_ARRAY);
    }

    public RubyString(Ruby runtime2, RubyClass rubyClass, CharSequence value2) {
        super(runtime2, rubyClass);
        assert (value2 != null);
        byte[] bytes2 = null;
        try {
            bytes2 = ((Object)value2).toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            bytes2 = ByteList.plain(value2);
        }
        this.value = new ByteList(bytes2, false);
    }

    public RubyString(Ruby runtime2, RubyClass rubyClass, byte[] value2) {
        super(runtime2, rubyClass);
        assert (value2 != null);
        this.value = new ByteList(value2);
    }

    public RubyString(Ruby runtime2, RubyClass rubyClass, ByteList value2) {
        super(runtime2, rubyClass);
        assert (value2 != null);
        this.value = value2;
    }

    public RubyString(Ruby runtime2, RubyClass rubyClass, ByteList value2, boolean objectSpace) {
        super(runtime2, rubyClass, objectSpace);
        assert (value2 != null);
        this.value = value2;
    }

    protected RubyString(Ruby runtime2, RubyClass rubyClass, ByteList value2, Encoding enc, int cr) {
        this(runtime2, rubyClass, value2);
        value2.setEncoding(enc);
        this.flags |= cr;
    }

    protected RubyString(Ruby runtime2, RubyClass rubyClass, ByteList value2, Encoding enc) {
        this(runtime2, rubyClass, value2);
        value2.setEncoding(enc);
    }

    protected RubyString(Ruby runtime2, RubyClass rubyClass, ByteList value2, int cr) {
        this(runtime2, rubyClass, value2);
        this.flags |= cr;
    }

    @Deprecated
    public RubyString newString(CharSequence s) {
        return new RubyString(this.getRuntime(), this.getType(), s);
    }

    @Deprecated
    public RubyString newString(ByteList s) {
        return new RubyString(this.getRuntime(), this.getMetaClass(), s);
    }

    @Deprecated
    public static RubyString newString(Ruby runtime2, RubyClass clazz, CharSequence str) {
        return new RubyString(runtime2, clazz, str);
    }

    public static RubyString newStringLight(Ruby runtime2, ByteList bytes2) {
        return new RubyString(runtime2, runtime2.getString(), bytes2, false);
    }

    public static RubyString newStringLight(Ruby runtime2, int size2) {
        return new RubyString(runtime2, runtime2.getString(), new ByteList(size2), false);
    }

    public static RubyString newString(Ruby runtime2, CharSequence str) {
        return new RubyString(runtime2, runtime2.getString(), str);
    }

    public static RubyString newString(Ruby runtime2, String str) {
        return new RubyString(runtime2, runtime2.getString(), str);
    }

    public static RubyString newString(Ruby runtime2, byte[] bytes2) {
        return new RubyString(runtime2, runtime2.getString(), bytes2);
    }

    public static RubyString newString(Ruby runtime2, byte[] bytes2, int start2, int length2) {
        byte[] copy = new byte[length2];
        System.arraycopy(bytes2, start2, copy, 0, length2);
        return new RubyString(runtime2, runtime2.getString(), new ByteList(copy, false));
    }

    public static RubyString newString(Ruby runtime2, ByteList bytes2) {
        return new RubyString(runtime2, runtime2.getString(), bytes2);
    }

    public static RubyString newUnicodeString(Ruby runtime2, String str) {
        try {
            return new RubyString(runtime2, runtime2.getString(), new ByteList(str.getBytes("UTF8"), false));
        }
        catch (UnsupportedEncodingException uee) {
            return new RubyString(runtime2, runtime2.getString(), str);
        }
    }

    public static RubyString newStringShared(Ruby runtime2, RubyString orig) {
        orig.shareLevel = 2;
        RubyString str = new RubyString(runtime2, runtime2.getString(), orig.value);
        str.shareLevel = 2;
        return str;
    }

    public static RubyString newStringShared(Ruby runtime2, ByteList bytes2) {
        return RubyString.newStringShared(runtime2, runtime2.getString(), bytes2);
    }

    public static RubyString newStringShared(Ruby runtime2, RubyClass clazz, ByteList bytes2) {
        RubyString str = new RubyString(runtime2, clazz, bytes2);
        str.shareLevel = 2;
        return str;
    }

    public static RubyString newStringShared(Ruby runtime2, byte[] bytes2) {
        return RubyString.newStringShared(runtime2, new ByteList(bytes2, false));
    }

    public static RubyString newStringShared(Ruby runtime2, byte[] bytes2, int start2, int length2) {
        return RubyString.newStringShared(runtime2, new ByteList(bytes2, start2, length2, false));
    }

    public static RubyString newEmptyString(Ruby runtime2) {
        return RubyString.newEmptyString(runtime2, runtime2.getString());
    }

    public static RubyString newEmptyString(Ruby runtime2, RubyClass metaClass) {
        RubyString empty2 = new RubyString(runtime2, metaClass, ByteList.EMPTY_BYTELIST);
        empty2.shareLevel = 2;
        return empty2;
    }

    public static RubyString newStringNoCopy(Ruby runtime2, ByteList bytes2) {
        return RubyString.newStringNoCopy(runtime2, runtime2.getString(), bytes2);
    }

    public static RubyString newStringNoCopy(Ruby runtime2, RubyClass clazz, ByteList bytes2) {
        return new RubyString(runtime2, clazz, bytes2);
    }

    public static RubyString newStringNoCopy(Ruby runtime2, byte[] bytes2, int start2, int length2) {
        return RubyString.newStringNoCopy(runtime2, new ByteList(bytes2, start2, length2, false));
    }

    public static RubyString newStringNoCopy(Ruby runtime2, byte[] bytes2) {
        return RubyString.newStringNoCopy(runtime2, new ByteList(bytes2, false));
    }

    static EmptyByteListHolder getEmptyByteList(Encoding enc) {
        EmptyByteListHolder bytes2;
        int index2 = enc.getIndex();
        if (index2 < EMPTY_BYTELISTS.length && (bytes2 = EMPTY_BYTELISTS[index2]) != null) {
            return bytes2;
        }
        return RubyString.prepareEmptyByteList(enc);
    }

    private static EmptyByteListHolder prepareEmptyByteList(Encoding enc) {
        int index2 = enc.getIndex();
        if (index2 >= EMPTY_BYTELISTS.length) {
            EmptyByteListHolder[] tmp = new EmptyByteListHolder[index2 + 4];
            System.arraycopy(EMPTY_BYTELISTS, 0, tmp, 0, EMPTY_BYTELISTS.length);
        }
        RubyString.EMPTY_BYTELISTS[index2] = new EmptyByteListHolder(enc);
        return RubyString.EMPTY_BYTELISTS[index2];
    }

    public static RubyString newEmptyString(Ruby runtime2, RubyClass metaClass, Encoding enc) {
        EmptyByteListHolder holder = RubyString.getEmptyByteList(enc);
        RubyString empty2 = new RubyString(runtime2, metaClass, holder.bytes, holder.cr);
        empty2.shareLevel = 2;
        return empty2;
    }

    public static RubyString newEmptyString(Ruby runtime2, Encoding enc) {
        return RubyString.newEmptyString(runtime2, runtime2.getString(), enc);
    }

    public static RubyString newStringNoCopy(Ruby runtime2, RubyClass clazz, ByteList bytes2, Encoding enc, int cr) {
        return new RubyString(runtime2, clazz, bytes2, enc, cr);
    }

    public static RubyString newStringNoCopy(Ruby runtime2, ByteList bytes2, Encoding enc, int cr) {
        return RubyString.newStringNoCopy(runtime2, runtime2.getString(), bytes2, enc, cr);
    }

    public static RubyString newUsAsciiStringNoCopy(Ruby runtime2, ByteList bytes2) {
        return RubyString.newStringNoCopy(runtime2, bytes2, USASCIIEncoding.INSTANCE, 32);
    }

    public static RubyString newUsAsciiStringShared(Ruby runtime2, ByteList bytes2) {
        RubyString str = RubyString.newStringNoCopy(runtime2, bytes2, USASCIIEncoding.INSTANCE, 32);
        str.shareLevel = 2;
        return str;
    }

    public static RubyString newUsAsciiStringShared(Ruby runtime2, byte[] bytes2, int start2, int length2) {
        byte[] copy = new byte[length2];
        System.arraycopy(bytes2, start2, copy, 0, length2);
        return RubyString.newUsAsciiStringShared(runtime2, new ByteList(copy, false));
    }

    @Override
    public int getNativeTypeIndex() {
        return 4;
    }

    @Override
    public Class getJavaClass() {
        return String.class;
    }

    @Override
    public RubyString convertToString() {
        return this;
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    @Deprecated
    public final RubyString strDup() {
        return this.strDup(this.getRuntime(), this.getMetaClass());
    }

    public final RubyString strDup(Ruby runtime2) {
        return this.strDup(runtime2, this.getMetaClass());
    }

    @Deprecated
    final RubyString strDup(RubyClass clazz) {
        return this.strDup(this.getRuntime(), this.getMetaClass());
    }

    final RubyString strDup(Ruby runtime2, RubyClass clazz) {
        this.shareLevel = 2;
        RubyString dup2 = new RubyString(runtime2, clazz, this.value);
        dup2.shareLevel = 2;
        dup2.flags |= this.flags & 0x78;
        return dup2;
    }

    public final RubyString makeShared(Ruby runtime2, int index2, int len) {
        RubyString shared;
        RubyClass meta = this.getMetaClass();
        if (len == 0) {
            shared = RubyString.newEmptyString(runtime2, meta);
        } else if (len == 1) {
            shared = RubyString.newStringShared(runtime2, meta, RubyInteger.SINGLE_CHAR_BYTELISTS[this.value.getUnsafeBytes()[this.value.getBegin() + index2] & 0xFF]);
        } else {
            if (this.shareLevel == 0) {
                this.shareLevel = 1;
            }
            shared = new RubyString(runtime2, meta, this.value.makeShared(index2, len));
            shared.shareLevel = 1;
        }
        shared.infectBy(this);
        return shared;
    }

    public final RubyString makeShared19(Ruby runtime2, int index2, int len) {
        return this.makeShared19(runtime2, this.value, index2, len);
    }

    private RubyString makeShared19(Ruby runtime2, ByteList value2, int index2, int len) {
        RubyString shared;
        Encoding enc = value2.getEncoding();
        RubyClass meta = this.getMetaClass();
        if (len == 0) {
            shared = RubyString.newEmptyString(runtime2, meta, enc);
        } else {
            if (this.shareLevel == 0) {
                this.shareLevel = 1;
            }
            shared = new RubyString(runtime2, meta, value2.makeShared(index2, len));
            shared.shareLevel = 1;
            shared.copyCodeRangeForSubstr(this, enc);
        }
        shared.infectBy(this);
        return shared;
    }

    final void modifyCheck() {
        if ((this.flags & 4) != 0) {
            throw this.getRuntime().newFrozenError("string");
        }
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't modify string");
        }
    }

    private final void modifyCheck(byte[] b, int len) {
        if (this.value.getUnsafeBytes() != b || this.value.getRealSize() != len) {
            throw this.getRuntime().newRuntimeError("string modified");
        }
    }

    private final void modifyCheck(byte[] b, int len, Encoding enc) {
        if (this.value.getUnsafeBytes() != b || this.value.getRealSize() != len || this.value.getEncoding() != enc) {
            throw this.getRuntime().newRuntimeError("string modified");
        }
    }

    private final void frozenCheck() {
        if (this.isFrozen()) {
            throw this.getRuntime().newRuntimeError("string frozen");
        }
    }

    public final void modify() {
        this.modifyCheck();
        if (this.shareLevel != 0) {
            if (this.shareLevel == 2) {
                this.value = this.value.dup();
            } else {
                this.value.unshare();
            }
            this.shareLevel = 0;
        }
        this.value.invalidate();
    }

    public final void modify19() {
        this.modify();
        this.clearCodeRange();
    }

    private void modifyAndKeepCodeRange() {
        this.modify();
        this.keepCodeRange();
    }

    public final void modify(int length2) {
        this.modifyCheck();
        if (this.shareLevel != 0) {
            if (this.shareLevel == 2) {
                this.value = this.value.dup(length2);
            } else {
                this.value.unshare(length2);
            }
            this.shareLevel = 0;
        } else {
            this.value.ensure(length2);
        }
        this.value.invalidate();
    }

    public final void modify19(int length2) {
        this.modify(length2);
        this.clearCodeRange();
    }

    final void view(ByteList bytes2) {
        this.modifyCheck();
        this.value = bytes2;
        this.shareLevel = 0;
    }

    private final void view(byte[] bytes2) {
        this.modifyCheck();
        this.value.replace(bytes2);
        this.shareLevel = 0;
        this.value.invalidate();
    }

    private final void view(int index2, int len) {
        this.modifyCheck();
        if (this.shareLevel != 0) {
            if (this.shareLevel == 2) {
                this.value = this.value.makeShared(index2, len);
                this.shareLevel = 1;
            } else {
                this.value.view(index2, len);
            }
        } else {
            this.value.view(index2, len);
            this.shareLevel = 1;
        }
        this.value.invalidate();
    }

    public static String bytesToString(byte[] bytes2, int beg, int len) {
        return new String(ByteList.plain(bytes2, beg, len));
    }

    public static String byteListToString(ByteList bytes2) {
        return RubyString.bytesToString(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length());
    }

    public static String bytesToString(byte[] bytes2) {
        return RubyString.bytesToString(bytes2, 0, bytes2.length);
    }

    public static byte[] stringToBytes(String string2) {
        return ByteList.plain(string2);
    }

    @Override
    public RubyString asString() {
        return this;
    }

    @Override
    public IRubyObject checkStringType() {
        return this;
    }

    @Override
    public IRubyObject checkStringType19() {
        return this;
    }

    @JRubyMethod(name={"try_convert"}, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject try_convert(ThreadContext context, IRubyObject recv2, IRubyObject str) {
        return str.checkStringType();
    }

    @Override
    @JRubyMethod(name={"to_s", "to_str"})
    public IRubyObject to_s() {
        Ruby runtime2 = this.getRuntime();
        if (this.getMetaClass().getRealClass() != runtime2.getString()) {
            return this.strDup(runtime2, runtime2.getString());
        }
        return this;
    }

    @Override
    public final int compareTo(IRubyObject other) {
        Ruby runtime2 = this.getRuntime();
        if (other instanceof RubyString) {
            RubyString otherString = (RubyString)other;
            return runtime2.is1_9() ? this.op_cmp19(otherString) : this.op_cmp(otherString);
        }
        return (int)this.op_cmpCommon(runtime2.getCurrentContext(), other).convertToInteger().getLongValue();
    }

    @JRubyMethod(name={"<=>"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            return context.getRuntime().newFixnum(this.op_cmp((RubyString)other));
        }
        return this.op_cmpCommon(context, other);
    }

    @JRubyMethod(name={"<=>"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_cmp19(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            return context.getRuntime().newFixnum(this.op_cmp19((RubyString)other));
        }
        return this.op_cmpCommon(context, other);
    }

    private IRubyObject op_cmpCommon(ThreadContext context, IRubyObject other) {
        Ruby runtime2 = context.getRuntime();
        if (other.respondsTo("to_str") && other.respondsTo("<=>")) {
            IRubyObject result = other.callMethod(context, "<=>", this);
            if (result.isNil()) {
                return result;
            }
            if (result instanceof RubyFixnum) {
                return RubyFixnum.newFixnum(runtime2, -((RubyFixnum)result).getLongValue());
            }
            return RubyFixnum.zero(runtime2).callMethod(context, "-", result);
        }
        return runtime2.getNil();
    }

    @Override
    @JRubyMethod(name={"=="}, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        Ruby runtime2 = context.getRuntime();
        if (this == other) {
            return runtime2.getTrue();
        }
        if (other instanceof RubyString) {
            return this.value.equal(((RubyString)other).value) ? runtime2.getTrue() : runtime2.getFalse();
        }
        return this.op_equalCommon(context, other);
    }

    @JRubyMethod(name={"=="}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_equal19(ThreadContext context, IRubyObject other) {
        Ruby runtime2 = context.getRuntime();
        if (this == other) {
            return runtime2.getTrue();
        }
        if (other instanceof RubyString) {
            RubyString otherString = (RubyString)other;
            return this.isComparableWith(otherString) && this.value.equal(otherString.value) ? runtime2.getTrue() : runtime2.getFalse();
        }
        return this.op_equalCommon(context, other);
    }

    private IRubyObject op_equalCommon(ThreadContext context, IRubyObject other) {
        Ruby runtime2 = context.getRuntime();
        if (!other.respondsTo("to_str")) {
            return runtime2.getFalse();
        }
        return other.callMethod(context, "==", this).isTrue() ? runtime2.getTrue() : runtime2.getFalse();
    }

    @JRubyMethod(name={"+"}, required=1, compat=CompatVersion.RUBY1_8, argTypes={RubyString.class})
    public IRubyObject op_plus(ThreadContext context, RubyString str) {
        RubyString resultStr = RubyString.newString(context.getRuntime(), this.addByteLists(this.value, str.value));
        resultStr.infectBy(this.flags | str.flags);
        return resultStr;
    }

    public IRubyObject op_plus(ThreadContext context, IRubyObject other) {
        return this.op_plus(context, other.convertToString());
    }

    @JRubyMethod(name={"+"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_plus19(ThreadContext context, RubyString str) {
        Encoding enc = this.checkEncoding(str);
        RubyString resultStr = RubyString.newStringNoCopy(context.getRuntime(), this.addByteLists(this.value, str.value), enc, RubyString.codeRangeAnd(this.getCodeRange(), str.getCodeRange()));
        resultStr.infectBy(this.flags | str.flags);
        return resultStr;
    }

    public IRubyObject op_plus19(ThreadContext context, IRubyObject other) {
        return this.op_plus19(context, other.convertToString());
    }

    private ByteList addByteLists(ByteList value1, ByteList value2) {
        ByteList result = new ByteList(value1.getRealSize() + value2.getRealSize());
        result.setRealSize(value1.getRealSize() + value2.getRealSize());
        System.arraycopy(value1.getUnsafeBytes(), value1.getBegin(), result.getUnsafeBytes(), 0, value1.getRealSize());
        System.arraycopy(value2.getUnsafeBytes(), value2.getBegin(), result.getUnsafeBytes(), value1.getRealSize(), value2.getRealSize());
        return result;
    }

    @JRubyMethod(name={"*"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_mul(ThreadContext context, IRubyObject other) {
        return this.multiplyByteList(context, other);
    }

    @JRubyMethod(name={"*"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_mul19(ThreadContext context, IRubyObject other) {
        RubyString result = this.multiplyByteList(context, other);
        Encoding encoding2 = this.value.getEncoding();
        result.value.setEncoding(encoding2);
        result.copyCodeRangeForSubstr(this, encoding2);
        return result;
    }

    private RubyString multiplyByteList(ThreadContext context, IRubyObject arg2) {
        int len = RubyNumeric.num2int(arg2);
        if (len < 0) {
            throw context.getRuntime().newArgumentError("negative argument");
        }
        if (len > 0 && Integer.MAX_VALUE / len < this.value.getRealSize()) {
            throw context.getRuntime().newArgumentError("argument too big");
        }
        ByteList bytes2 = new ByteList(len *= this.value.getRealSize());
        if (len > 0) {
            int n;
            bytes2.setRealSize(len);
            System.arraycopy(this.value.getUnsafeBytes(), this.value.getBegin(), bytes2.getUnsafeBytes(), 0, n);
            for (n = this.value.getRealSize(); n <= len >> 1; n <<= 1) {
                System.arraycopy(bytes2.getUnsafeBytes(), 0, bytes2.getUnsafeBytes(), n, n);
            }
            System.arraycopy(bytes2.getUnsafeBytes(), 0, bytes2.getUnsafeBytes(), n, len - n);
        }
        RubyString result = new RubyString(context.getRuntime(), this.getMetaClass(), bytes2);
        result.infectBy(this);
        return result;
    }

    @JRubyMethod(name={"%"}, required=1)
    public IRubyObject op_format(ThreadContext context, IRubyObject arg2) {
        return this.opFormatCommon(context, arg2, context.getRuntime().getInstanceConfig().getCompatVersion());
    }

    private IRubyObject opFormatCommon(ThreadContext context, IRubyObject arg2, CompatVersion compat) {
        boolean tainted;
        IRubyObject tmp = arg2.checkArrayType();
        if (tmp.isNil()) {
            tmp = arg2;
        }
        ByteList out = new ByteList(this.value.getRealSize());
        switch (compat) {
            case RUBY1_8: {
                tainted = Sprintf.sprintf(out, Locale.US, (CharSequence)this.value, tmp);
                break;
            }
            case RUBY1_9: {
                tainted = Sprintf.sprintf1_9(out, Locale.US, this.value, tmp);
                break;
            }
            default: {
                throw new RuntimeException("invalid compat version for sprintf: " + (Object)((Object)compat));
            }
        }
        RubyString str = RubyString.newString(context.getRuntime(), out);
        str.setTaint(tainted || this.isTaint());
        return str;
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        Ruby runtime2 = this.getRuntime();
        return RubyFixnum.newFixnum(runtime2, this.strHashCode(runtime2));
    }

    @Override
    public int hashCode() {
        return this.strHashCode(this.getRuntime());
    }

    private int strHashCode(Ruby runtime2) {
        if (runtime2.is1_9()) {
            return this.value.hashCode() ^ (this.value.getEncoding().isAsciiCompatible() && this.scanForCodeRange() == 32 ? 0 : this.value.getEncoding().getIndex());
        }
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RubyString && ((RubyString)other).value.equal(this.value);
    }

    public static RubyString objAsString(ThreadContext context, IRubyObject obj) {
        if (obj instanceof RubyString) {
            return (RubyString)obj;
        }
        IRubyObject str = obj.callMethod(context, "to_s");
        if (!(str instanceof RubyString)) {
            return (RubyString)obj.anyToString();
        }
        if (obj.isTaint()) {
            str.setTaint(true);
        }
        return (RubyString)str;
    }

    public final int op_cmp(RubyString other) {
        return this.value.cmp(other.value);
    }

    public final int op_cmp19(RubyString other) {
        int ret = this.value.cmp(other.value);
        if (ret == 0 && !this.isComparableWith(other)) {
            return this.value.getEncoding().getIndex() > other.value.getEncoding().getIndex() ? 1 : -1;
        }
        return ret;
    }

    @Override
    public String asJavaString() {
        return this.toString();
    }

    public IRubyObject doClone() {
        return RubyString.newString(this.getRuntime(), this.value.dup());
    }

    public final RubyString cat(byte[] str) {
        this.modify(this.value.getRealSize() + str.length);
        System.arraycopy(str, 0, this.value.getUnsafeBytes(), this.value.getBegin() + this.value.getRealSize(), str.length);
        this.value.setRealSize(this.value.getRealSize() + str.length);
        return this;
    }

    public final RubyString cat(byte[] str, int beg, int len) {
        this.modify(this.value.getRealSize() + len);
        System.arraycopy(str, beg, this.value.getUnsafeBytes(), this.value.getBegin() + this.value.getRealSize(), len);
        this.value.setRealSize(this.value.getRealSize() + len);
        return this;
    }

    public final RubyString cat19(RubyString str) {
        ByteList strValue = str.value;
        int strCr = str.getCodeRange();
        strCr = this.cat(strValue.getUnsafeBytes(), strValue.getBegin(), strValue.getRealSize(), strValue.getEncoding(), strCr, strCr);
        this.infectBy(str);
        str.setCodeRange(strCr);
        return this;
    }

    public final RubyString cat(ByteList str) {
        this.modify(this.value.getRealSize() + str.getRealSize());
        System.arraycopy(str.getUnsafeBytes(), str.getBegin(), this.value.getUnsafeBytes(), this.value.getBegin() + this.value.getRealSize(), str.getRealSize());
        this.value.setRealSize(this.value.getRealSize() + str.getRealSize());
        return this;
    }

    public final RubyString cat(byte ch) {
        this.modify(this.value.getRealSize() + 1);
        this.value.getUnsafeBytes()[this.value.getBegin() + this.value.getRealSize()] = ch;
        this.value.setRealSize(this.value.getRealSize() + 1);
        return this;
    }

    public final RubyString cat(int ch) {
        return this.cat((byte)ch);
    }

    public final RubyString cat(int code, Encoding enc) {
        int n = StringSupport.codeLength(this.getRuntime(), enc, code);
        this.modify(this.value.getRealSize() + n);
        enc.codeToMbc(code, this.value.getUnsafeBytes(), this.value.getBegin() + this.value.getRealSize());
        this.value.setRealSize(this.value.getRealSize() + n);
        return this;
    }

    public final int cat(byte[] bytes2, int p2, int len, Encoding enc, int cr, int cr2) {
        int resCr;
        Encoding resEnc;
        this.modify(this.value.getRealSize() + len);
        int toCr = this.getCodeRange();
        Encoding toEnc = this.value.getEncoding();
        if (toEnc == enc) {
            if (toCr == 0 || toEnc == ASCIIEncoding.INSTANCE && toCr != 32) {
                cr = 0;
            } else if (cr == 0) {
                cr = StringSupport.codeRangeScan(enc, bytes2, p2, len);
            }
        } else {
            if (!toEnc.isAsciiCompatible() || !enc.isAsciiCompatible()) {
                if (len == 0) {
                    return cr2;
                }
                if (this.value.getRealSize() == 0) {
                    System.arraycopy(bytes2, p2, this.value.getUnsafeBytes(), this.value.getBegin() + this.value.getRealSize(), len);
                    this.value.setRealSize(this.value.getRealSize() + len);
                    this.setEncodingAndCodeRange(enc, cr);
                    return cr2;
                }
                throw this.getRuntime().newEncodingCompatibilityError("incompatible character encodings: " + toEnc + " and " + enc);
            }
            if (cr == 0) {
                cr = StringSupport.codeRangeScan(enc, bytes2, p2, len);
            }
            if (toCr == 0 && (toEnc == ASCIIEncoding.INSTANCE || cr != 32)) {
                toCr = this.scanForCodeRange();
            }
        }
        if (cr2 != 0) {
            cr2 = cr;
        }
        if (toEnc != enc && toCr != 32 && cr != 32) {
            throw this.getRuntime().newEncodingCompatibilityError("incompatible character encodings: " + toEnc + " and " + enc);
        }
        if (toCr == 0) {
            resEnc = toEnc;
            resCr = 0;
        } else if (toCr == 32) {
            if (cr == 32) {
                resEnc = toEnc == ASCIIEncoding.INSTANCE ? toEnc : enc;
                resCr = 32;
            } else {
                resEnc = enc;
                resCr = cr;
            }
        } else if (toCr == 64) {
            resEnc = toEnc;
            resCr = toCr;
        } else {
            resEnc = toEnc;
            int n = resCr = len > 0 ? 96 : toCr;
        }
        if (len < 0) {
            throw this.getRuntime().newArgumentError("negative string size (or size too big)");
        }
        System.arraycopy(bytes2, p2, this.value.getUnsafeBytes(), this.value.getBegin() + this.value.getRealSize(), len);
        this.value.setRealSize(this.value.getRealSize() + len);
        this.setEncodingAndCodeRange(resEnc, resCr);
        return cr2;
    }

    public final int cat(byte[] bytes2, int p2, int len, Encoding enc) {
        return this.cat(bytes2, p2, len, enc, 0, 0);
    }

    public final RubyString catAscii(byte[] bytes2, int p2, int len) {
        Encoding enc = this.value.getEncoding();
        if (enc.isAsciiCompatible()) {
            this.cat(bytes2, p2, len, enc, 32, 0);
        } else {
            byte[] buf = new byte[enc.maxLength()];
            int end2 = p2 + len;
            while (p2 < end2) {
                byte c = bytes2[p2];
                int cl = StringSupport.codeLength(this.getRuntime(), enc, c);
                enc.codeToMbc(c, buf, 0);
                this.cat(buf, 0, cl, enc, 64, 0);
                ++p2;
            }
        }
        return this;
    }

    @JRubyMethod(name={"replace", "initialize_copy"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject replace(IRubyObject other) {
        if (this == other) {
            return this;
        }
        this.replaceCommon(other);
        return this;
    }

    @JRubyMethod(name={"replace", "initialize_copy"}, required=1, compat=CompatVersion.RUBY1_9)
    public RubyString replace19(IRubyObject other) {
        if (this == other) {
            return this;
        }
        this.setCodeRange(this.replaceCommon(other).getCodeRange());
        return this;
    }

    private RubyString replaceCommon(IRubyObject other) {
        this.modifyCheck();
        RubyString otherStr = other.convertToString();
        this.shareLevel = 2;
        otherStr.shareLevel = 2;
        this.value = otherStr.value;
        this.infectBy(otherStr);
        return otherStr;
    }

    @JRubyMethod(name={"clear"}, compat=CompatVersion.RUBY1_9)
    public RubyString clear() {
        Encoding enc = this.value.getEncoding();
        EmptyByteListHolder holder = RubyString.getEmptyByteList(enc);
        this.value = holder.bytes;
        this.shareLevel = 2;
        this.setCodeRange(holder.cr);
        return this;
    }

    @JRubyMethod(name={"reverse"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject reverse(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (this.value.getRealSize() <= 1) {
            return this.strDup(context.getRuntime());
        }
        byte[] bytes2 = this.value.getUnsafeBytes();
        int p2 = this.value.getBegin();
        int len = this.value.getRealSize();
        byte[] obytes = new byte[len];
        for (int i = 0; i <= len >> 1; ++i) {
            obytes[i] = bytes2[p2 + len - i - 1];
            obytes[len - i - 1] = bytes2[p2 + i];
        }
        return new RubyString(runtime2, this.getMetaClass(), new ByteList(obytes, false)).infectBy(this);
    }

    @JRubyMethod(name={"reverse"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject reverse19(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (this.value.getRealSize() <= 1) {
            return this.strDup(context.getRuntime());
        }
        byte[] bytes2 = this.value.getUnsafeBytes();
        int p2 = this.value.getBegin();
        int len = this.value.getRealSize();
        byte[] obytes = new byte[len];
        boolean single = true;
        Encoding enc = this.value.getEncoding();
        if (this.singleByteOptimizable(enc)) {
            for (int i = 0; i <= len >> 1; ++i) {
                obytes[i] = bytes2[p2 + len - i - 1];
                obytes[len - i - 1] = bytes2[p2 + i];
            }
        } else {
            int end2 = p2 + len;
            int op = len;
            while (p2 < end2) {
                int cl = StringSupport.length(enc, bytes2, p2, end2);
                if (cl > 1 || (bytes2[p2] & 0x80) != 0) {
                    single = false;
                    System.arraycopy(bytes2, p2, obytes, op -= cl, cl);
                    p2 += cl;
                    continue;
                }
                obytes[--op] = bytes2[p2++];
            }
        }
        RubyString result = new RubyString(runtime2, this.getMetaClass(), new ByteList(obytes, false));
        if (this.getCodeRange() == 0) {
            this.setCodeRange(single ? 32 : 64);
        }
        Encoding encoding2 = this.value.getEncoding();
        result.value.setEncoding(encoding2);
        result.copyCodeRangeForSubstr(this, encoding2);
        return result.infectBy(this);
    }

    @JRubyMethod(name={"reverse!"}, compat=CompatVersion.RUBY1_8)
    public RubyString reverse_bang(ThreadContext context) {
        if (this.value.getRealSize() > 1) {
            this.modify();
            byte[] bytes2 = this.value.getUnsafeBytes();
            int p2 = this.value.getBegin();
            int len = this.value.getRealSize();
            for (int i = 0; i < len >> 1; ++i) {
                byte b = bytes2[p2 + i];
                bytes2[p2 + i] = bytes2[p2 + len - i - 1];
                bytes2[p2 + len - i - 1] = b;
            }
        }
        return this;
    }

    @JRubyMethod(name={"reverse!"}, compat=CompatVersion.RUBY1_9)
    public RubyString reverse_bang19(ThreadContext context) {
        if (this.value.getRealSize() > 1) {
            this.modifyAndKeepCodeRange();
            byte[] bytes2 = this.value.getUnsafeBytes();
            int p2 = this.value.getBegin();
            int len = this.value.getRealSize();
            Encoding enc = this.value.getEncoding();
            if (this.singleByteOptimizable(enc)) {
                for (int i = 0; i < len >> 1; ++i) {
                    byte b = bytes2[p2 + i];
                    bytes2[p2 + i] = bytes2[p2 + len - i - 1];
                    bytes2[p2 + len - i - 1] = b;
                }
            } else {
                int end2 = p2 + len;
                int op = len;
                byte[] obytes = new byte[len];
                boolean single = true;
                while (p2 < end2) {
                    int cl = StringSupport.length(enc, bytes2, p2, end2);
                    if (cl > 1 || (bytes2[p2] & 0x80) != 0) {
                        single = false;
                        System.arraycopy(bytes2, p2, obytes, op -= cl, cl);
                        p2 += cl;
                        continue;
                    }
                    obytes[--op] = bytes2[p2++];
                }
                this.value.setUnsafeBytes(obytes);
                if (this.getCodeRange() == 0) {
                    this.setCodeRange(single ? 32 : 64);
                }
            }
        }
        return this;
    }

    public static RubyString newInstance(IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyString newString = RubyString.newStringShared(recv2.getRuntime(), ByteList.EMPTY_BYTELIST);
        newString.setMetaClass((RubyClass)recv2);
        newString.callInit(args2, block);
        return newString;
    }

    @Override
    @JRubyMethod(frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize() {
        return this;
    }

    @JRubyMethod(frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject arg0) {
        this.replace(arg0);
        return this;
    }

    @JRubyMethod(name={"casecmp"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject casecmp(ThreadContext context, IRubyObject other) {
        return RubyFixnum.newFixnum(context.getRuntime(), this.value.caseInsensitiveCmp(other.convertToString().value));
    }

    @JRubyMethod(name={"casecmp"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject casecmp19(ThreadContext context, IRubyObject other) {
        Ruby runtime2 = context.getRuntime();
        RubyString otherStr = other.convertToString();
        Encoding enc = this.isCompatibleWith(otherStr);
        if (enc == null) {
            return runtime2.getNil();
        }
        if (this.singleByteOptimizable() && otherStr.singleByteOptimizable()) {
            return RubyFixnum.newFixnum(runtime2, this.value.caseInsensitiveCmp(otherStr.value));
        }
        return this.multiByteCasecmp(runtime2, enc, this.value, otherStr.value);
    }

    private IRubyObject multiByteCasecmp(Ruby runtime2, Encoding enc, ByteList value2, ByteList otherValue) {
        int ocl;
        int cl;
        int op;
        byte[] bytes2 = value2.getUnsafeBytes();
        int p2 = value2.getBegin();
        int end2 = p2 + value2.getRealSize();
        byte[] obytes = otherValue.getUnsafeBytes();
        int oend = op + otherValue.getRealSize();
        for (op = otherValue.getBegin(); p2 < end2 && op < oend; p2 += cl, op += ocl) {
            int oc;
            int c;
            if (enc.isAsciiCompatible()) {
                c = bytes2[p2] & 0xFF;
                oc = obytes[op] & 0xFF;
            } else {
                c = StringSupport.preciseCodePoint(enc, bytes2, p2, end2);
                oc = StringSupport.preciseCodePoint(enc, obytes, op, oend);
            }
            if (Encoding.isAscii(c) && Encoding.isAscii(oc)) {
                if (AsciiTables.ToUpperCaseTable[c] != AsciiTables.ToUpperCaseTable[oc]) {
                    return c < oc ? RubyFixnum.minus_one(runtime2) : RubyFixnum.one(runtime2);
                }
                ocl = 1;
                cl = 1;
                continue;
            }
            cl = StringSupport.length(enc, bytes2, p2, end2);
            int ret = StringSupport.caseCmp(bytes2, p2, obytes, op, cl < (ocl = StringSupport.length(enc, obytes, op, oend)) ? cl : ocl);
            if (ret != 0) {
                return ret < 0 ? RubyFixnum.minus_one(runtime2) : RubyFixnum.one(runtime2);
            }
            if (cl == ocl) continue;
            return cl < ocl ? RubyFixnum.minus_one(runtime2) : RubyFixnum.one(runtime2);
        }
        if (end2 - p2 == oend - op) {
            return RubyFixnum.zero(runtime2);
        }
        return end2 - p2 > oend - op ? RubyFixnum.one(runtime2) : RubyFixnum.minus_one(runtime2);
    }

    @Override
    @JRubyMethod(name={"=~"}, compat=CompatVersion.RUBY1_8, writes={FrameField.BACKREF})
    public IRubyObject op_match(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyRegexp) {
            return ((RubyRegexp)other).op_match(context, this);
        }
        if (other instanceof RubyString) {
            throw context.getRuntime().newTypeError("type mismatch: String given");
        }
        return other.callMethod(context, "=~", this);
    }

    @JRubyMethod(name={"=~"}, compat=CompatVersion.RUBY1_9, writes={FrameField.BACKREF})
    public IRubyObject op_match19(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyRegexp) {
            return ((RubyRegexp)other).op_match19(context, this);
        }
        if (other instanceof RubyString) {
            throw context.getRuntime().newTypeError("type mismatch: String given");
        }
        return other.callMethod(context, "=~", this);
    }

    @JRubyMethod(name={"match"}, compat=CompatVersion.RUBY1_8, reads={FrameField.BACKREF})
    public IRubyObject match(ThreadContext context, IRubyObject pattern) {
        return this.getPattern(pattern).callMethod(context, "match", (IRubyObject)this);
    }

    @JRubyMethod(name={"match"}, frame=true, compat=CompatVersion.RUBY1_9, reads={FrameField.BACKREF})
    public IRubyObject match19(ThreadContext context, IRubyObject pattern, Block block) {
        IRubyObject result = this.getPattern(pattern).callMethod(context, "match", (IRubyObject)this);
        return block.isGiven() && !result.isNil() ? block.yield(context, result) : result;
    }

    @JRubyMethod(name={"match"}, frame=true, required=2, rest=true, compat=CompatVersion.RUBY1_9, reads={FrameField.BACKREF})
    public IRubyObject match19(ThreadContext context, IRubyObject[] args2, Block block) {
        RubyRegexp pattern = this.getPattern(args2[0]);
        args2[0] = this;
        IRubyObject result = pattern.callMethod(context, "match", args2);
        return block.isGiven() && !result.isNil() ? block.yield(context, result) : result;
    }

    @JRubyMethod(name={"capitalize"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject capitalize(ThreadContext context) {
        RubyString str = this.strDup(context.getRuntime());
        str.capitalize_bang(context);
        return str;
    }

    @JRubyMethod(name={"capitalize!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject capitalize_bang(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime2.getNil();
        }
        this.modify();
        int s = this.value.getBegin();
        int end2 = s + this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        boolean modify = false;
        int c = bytes2[s] & 0xFF;
        if (ASCII.isLower(c)) {
            bytes2[s] = AsciiTables.ToUpperCaseTable[c];
            modify = true;
        }
        while (++s < end2) {
            c = bytes2[s] & 0xFF;
            if (!ASCII.isUpper(c)) continue;
            bytes2[s] = AsciiTables.ToLowerCaseTable[c];
            modify = true;
        }
        return modify ? this : runtime2.getNil();
    }

    @JRubyMethod(name={"capitalize"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject capitalize19(ThreadContext context) {
        RubyString str = this.strDup(context.getRuntime());
        str.capitalize_bang19(context);
        return str;
    }

    @JRubyMethod(name={"capitalize!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject capitalize_bang19(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        Encoding enc = this.checkDummyEncoding();
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime2.getNil();
        }
        this.modifyAndKeepCodeRange();
        int s = this.value.getBegin();
        int end2 = s + this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        boolean modify = false;
        int c = StringSupport.codePoint(runtime2, enc, bytes2, s, end2);
        if (enc.isLower(c)) {
            enc.codeToMbc(StringSupport.toUpper(enc, c), bytes2, s);
            modify = true;
        }
        s += StringSupport.codeLength(runtime2, enc, c);
        while (s < end2) {
            c = StringSupport.codePoint(runtime2, enc, bytes2, s, end2);
            if (enc.isUpper(c)) {
                enc.codeToMbc(StringSupport.toLower(enc, c), bytes2, s);
                modify = true;
            }
            s += StringSupport.codeLength(runtime2, enc, c);
        }
        return modify ? this : runtime2.getNil();
    }

    @JRubyMethod(name={">="}, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_ge(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            return context.getRuntime().newBoolean(this.op_cmp((RubyString)other) >= 0);
        }
        return RubyComparable.op_ge(context, this, other);
    }

    @JRubyMethod(name={">="}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_ge19(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            return context.getRuntime().newBoolean(this.op_cmp19((RubyString)other) >= 0);
        }
        return RubyComparable.op_ge(context, this, other);
    }

    @JRubyMethod(name={">"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_gt(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            return context.getRuntime().newBoolean(this.op_cmp((RubyString)other) > 0);
        }
        return RubyComparable.op_gt(context, this, other);
    }

    @JRubyMethod(name={">"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_gt19(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            return context.getRuntime().newBoolean(this.op_cmp19((RubyString)other) > 0);
        }
        return RubyComparable.op_gt(context, this, other);
    }

    @JRubyMethod(name={"<="}, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_le(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            return context.getRuntime().newBoolean(this.op_cmp((RubyString)other) <= 0);
        }
        return RubyComparable.op_le(context, this, other);
    }

    @JRubyMethod(name={"<="}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_le19(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            return context.getRuntime().newBoolean(this.op_cmp19((RubyString)other) <= 0);
        }
        return RubyComparable.op_le(context, this, other);
    }

    @JRubyMethod(name={"<"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_lt(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            return context.getRuntime().newBoolean(this.op_cmp((RubyString)other) < 0);
        }
        return RubyComparable.op_lt(context, this, other);
    }

    @JRubyMethod(name={"<"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_lt19(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString) {
            return context.getRuntime().newBoolean(this.op_cmp19((RubyString)other) < 0);
        }
        return RubyComparable.op_lt(context, this, other);
    }

    @JRubyMethod(name={"eql?"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject str_eql_p(ThreadContext context, IRubyObject other) {
        Ruby runtime2 = context.getRuntime();
        if (other instanceof RubyString && this.value.equal(((RubyString)other).value)) {
            return runtime2.getTrue();
        }
        return runtime2.getFalse();
    }

    @JRubyMethod(name={"eql?"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject str_eql_p19(ThreadContext context, IRubyObject other) {
        RubyString otherString;
        Ruby runtime2 = context.getRuntime();
        if (other instanceof RubyString && this.isComparableWith(otherString = (RubyString)other) && this.value.equal(otherString.value)) {
            return runtime2.getTrue();
        }
        return runtime2.getFalse();
    }

    @JRubyMethod(name={"upcase"}, compat=CompatVersion.RUBY1_8)
    public RubyString upcase(ThreadContext context) {
        RubyString str = this.strDup(context.getRuntime());
        str.upcase_bang(context);
        return str;
    }

    @JRubyMethod(name={"upcase!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject upcase_bang(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime2.getNil();
        }
        this.modify();
        return this.singleByteUpcase(runtime2, this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getBegin() + this.value.getRealSize());
    }

    @JRubyMethod(name={"upcase"}, compat=CompatVersion.RUBY1_9)
    public RubyString upcase19(ThreadContext context) {
        RubyString str = this.strDup(context.getRuntime());
        str.upcase_bang19(context);
        return str;
    }

    @JRubyMethod(name={"upcase!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject upcase_bang19(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        Encoding enc = this.checkDummyEncoding();
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime2.getNil();
        }
        this.modifyAndKeepCodeRange();
        int s = this.value.getBegin();
        int end2 = s + this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        if (this.singleByteOptimizable(enc)) {
            return this.singleByteUpcase(runtime2, bytes2, s, end2);
        }
        return this.multiByteUpcase(runtime2, enc, bytes2, s, end2);
    }

    private IRubyObject singleByteUpcase(Ruby runtime2, byte[] bytes2, int s, int end2) {
        boolean modify = false;
        while (s < end2) {
            int c = bytes2[s] & 0xFF;
            if (ASCII.isLower(c)) {
                bytes2[s] = AsciiTables.ToUpperCaseTable[c];
                modify = true;
            }
            ++s;
        }
        return modify ? this : runtime2.getNil();
    }

    private IRubyObject multiByteUpcase(Ruby runtime2, Encoding enc, byte[] bytes2, int s, int end2) {
        boolean modify = false;
        while (s < end2) {
            int c;
            if (enc.isAsciiCompatible() && Encoding.isAscii(c = bytes2[s] & 0xFF)) {
                if (ASCII.isLower(c)) {
                    bytes2[s] = AsciiTables.ToUpperCaseTable[c];
                    modify = true;
                }
                ++s;
                continue;
            }
            c = StringSupport.codePoint(runtime2, enc, bytes2, s, end2);
            if (enc.isLower(c)) {
                enc.codeToMbc(StringSupport.toUpper(enc, c), bytes2, s);
                modify = true;
            }
            s += StringSupport.codeLength(runtime2, enc, c);
        }
        return modify ? this : runtime2.getNil();
    }

    @JRubyMethod(name={"downcase"}, compat=CompatVersion.RUBY1_8)
    public RubyString downcase(ThreadContext context) {
        RubyString str = this.strDup(context.getRuntime());
        str.downcase_bang(context);
        return str;
    }

    @JRubyMethod(name={"downcase!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject downcase_bang(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime2.getNil();
        }
        this.modify();
        return this.singleByteDowncase(runtime2, this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getBegin() + this.value.getRealSize());
    }

    @JRubyMethod(name={"downcase"}, compat=CompatVersion.RUBY1_9)
    public RubyString downcase19(ThreadContext context) {
        RubyString str = this.strDup(context.getRuntime());
        str.downcase_bang19(context);
        return str;
    }

    @JRubyMethod(name={"downcase!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject downcase_bang19(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        Encoding enc = this.checkDummyEncoding();
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime2.getNil();
        }
        this.modifyAndKeepCodeRange();
        int s = this.value.getBegin();
        int end2 = s + this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        if (this.singleByteOptimizable(enc)) {
            return this.singleByteDowncase(runtime2, bytes2, s, end2);
        }
        return this.multiByteDowncase(runtime2, enc, bytes2, s, end2);
    }

    private IRubyObject singleByteDowncase(Ruby runtime2, byte[] bytes2, int s, int end2) {
        boolean modify = false;
        while (s < end2) {
            int c = bytes2[s] & 0xFF;
            if (ASCII.isUpper(c)) {
                bytes2[s] = AsciiTables.ToLowerCaseTable[c];
                modify = true;
            }
            ++s;
        }
        return modify ? this : runtime2.getNil();
    }

    private IRubyObject multiByteDowncase(Ruby runtime2, Encoding enc, byte[] bytes2, int s, int end2) {
        boolean modify = false;
        while (s < end2) {
            int c;
            if (enc.isAsciiCompatible() && Encoding.isAscii(c = bytes2[s] & 0xFF)) {
                if (ASCII.isUpper(c)) {
                    bytes2[s] = AsciiTables.ToLowerCaseTable[c];
                    modify = true;
                }
                ++s;
                continue;
            }
            c = StringSupport.codePoint(runtime2, enc, bytes2, s, end2);
            if (enc.isUpper(c)) {
                enc.codeToMbc(StringSupport.toLower(enc, c), bytes2, s);
                modify = true;
            }
            s += StringSupport.codeLength(runtime2, enc, c);
        }
        return modify ? this : runtime2.getNil();
    }

    @JRubyMethod(name={"swapcase"}, compat=CompatVersion.RUBY1_8)
    public RubyString swapcase(ThreadContext context) {
        RubyString str = this.strDup(context.getRuntime());
        str.swapcase_bang(context);
        return str;
    }

    @JRubyMethod(name={"swapcase!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject swapcase_bang(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime2.getNil();
        }
        this.modify();
        return this.singleByteSwapcase(runtime2, this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getBegin() + this.value.getRealSize());
    }

    @JRubyMethod(name={"swapcase"}, compat=CompatVersion.RUBY1_9)
    public RubyString swapcase19(ThreadContext context) {
        RubyString str = this.strDup(context.getRuntime());
        str.swapcase_bang19(context);
        return str;
    }

    @JRubyMethod(name={"swapcase!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject swapcase_bang19(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        Encoding enc = this.checkDummyEncoding();
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime2.getNil();
        }
        this.modifyAndKeepCodeRange();
        int s = this.value.getBegin();
        int end2 = s + this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        if (this.singleByteOptimizable(enc)) {
            return this.singleByteSwapcase(runtime2, bytes2, s, end2);
        }
        return this.multiByteSwapcase(runtime2, enc, bytes2, s, end2);
    }

    private IRubyObject singleByteSwapcase(Ruby runtime2, byte[] bytes2, int s, int end2) {
        boolean modify = false;
        while (s < end2) {
            int c = bytes2[s] & 0xFF;
            if (ASCII.isUpper(c)) {
                bytes2[s] = AsciiTables.ToLowerCaseTable[c];
                modify = true;
            } else if (ASCII.isLower(c)) {
                bytes2[s] = AsciiTables.ToUpperCaseTable[c];
                modify = true;
            }
            ++s;
        }
        return modify ? this : runtime2.getNil();
    }

    private IRubyObject multiByteSwapcase(Ruby runtime2, Encoding enc, byte[] bytes2, int s, int end2) {
        boolean modify = false;
        while (s < end2) {
            int c = StringSupport.codePoint(runtime2, enc, bytes2, s, end2);
            if (enc.isUpper(c)) {
                enc.codeToMbc(StringSupport.toLower(enc, c), bytes2, s);
                modify = true;
            } else if (enc.isLower(c)) {
                enc.codeToMbc(StringSupport.toUpper(enc, c), bytes2, s);
                modify = true;
            }
            s += StringSupport.codeLength(runtime2, enc, c);
        }
        return modify ? this : runtime2.getNil();
    }

    @JRubyMethod(name={"dump"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject dump() {
        return this.dumpCommon(false);
    }

    @JRubyMethod(name={"dump"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject dump19() {
        return this.dumpCommon(true);
    }

    private IRubyObject dumpCommon(boolean is1_9) {
        Ruby runtime2 = this.getRuntime();
        ByteList buf = null;
        Encoding enc = this.value.getEncoding();
        int p2 = this.value.getBegin();
        int end2 = p2 + this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        int len = 2;
        block4: while (p2 < end2) {
            int n;
            int c = bytes2[p2++] & 0xFF;
            switch (c) {
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 27: 
                case 34: 
                case 92: {
                    len += 2;
                    continue block4;
                }
                case 35: {
                    len += this.isEVStr(bytes2, p2, end2) ? 2 : 1;
                    continue block4;
                }
            }
            if (ASCII.isPrint(c)) {
                ++len;
                continue;
            }
            if (is1_9 && enc instanceof UTF8Encoding && (n = StringSupport.preciseLength(enc, bytes2, p2 - 1, end2) - 1) > 0) {
                if (buf == null) {
                    buf = new ByteList();
                }
                int cc = StringSupport.codePoint(runtime2, enc, bytes2, p2 - 1, end2);
                Sprintf.sprintf(runtime2, buf, (CharSequence)"%x", cc);
                len += buf.getRealSize() + 4;
                buf.setRealSize(0);
                p2 += n;
                continue;
            }
            len += 4;
        }
        if (is1_9 && !enc.isAsciiCompatible()) {
            len += ".force_encoding(\"".length() + enc.getName().length + "\")".length();
        }
        ByteList outBytes = new ByteList(len);
        byte[] out = outBytes.getUnsafeBytes();
        int q = 0;
        p2 = this.value.getBegin();
        end2 = p2 + this.value.getRealSize();
        out[q++] = 34;
        while (p2 < end2) {
            int c;
            if ((c = bytes2[p2++] & 0xFF) == 34 || c == 92) {
                out[q++] = 92;
                out[q++] = (byte)c;
                continue;
            }
            if (c == 35) {
                if (this.isEVStr(bytes2, p2, end2)) {
                    out[q++] = 92;
                }
                out[q++] = 35;
                continue;
            }
            if (!is1_9 && ASCII.isPrint(c)) {
                out[q++] = (byte)c;
                continue;
            }
            if (c == 10) {
                out[q++] = 92;
                out[q++] = 110;
                continue;
            }
            if (c == 13) {
                out[q++] = 92;
                out[q++] = 114;
                continue;
            }
            if (c == 9) {
                out[q++] = 92;
                out[q++] = 116;
                continue;
            }
            if (c == 12) {
                out[q++] = 92;
                out[q++] = 102;
                continue;
            }
            if (c == 11) {
                out[q++] = 92;
                out[q++] = 118;
                continue;
            }
            if (c == 8) {
                out[q++] = 92;
                out[q++] = 98;
                continue;
            }
            if (c == 7) {
                out[q++] = 92;
                out[q++] = 97;
                continue;
            }
            if (c == 27) {
                out[q++] = 92;
                out[q++] = 101;
                continue;
            }
            if (is1_9 && ASCII.isPrint(c)) {
                out[q++] = (byte)c;
                continue;
            }
            out[q++] = 92;
            if (is1_9) {
                int n;
                if (enc instanceof UTF8Encoding && (n = StringSupport.preciseLength(enc, bytes2, p2 - 1, end2) - 1) > 0) {
                    int cc = StringSupport.codePoint(runtime2, enc, bytes2, p2 - 1, end2);
                    p2 += n;
                    outBytes.setRealSize(q);
                    Sprintf.sprintf(runtime2, outBytes, (CharSequence)"u{%x}", cc);
                    q = outBytes.getRealSize();
                    continue;
                }
                outBytes.setRealSize(q);
                Sprintf.sprintf(runtime2, outBytes, (CharSequence)"x%02X", c);
                q = outBytes.getRealSize();
                continue;
            }
            outBytes.setRealSize(q);
            Sprintf.sprintf(runtime2, outBytes, (CharSequence)"%03o", c);
            q = outBytes.getRealSize();
        }
        out[q++] = 34;
        outBytes.setRealSize(q);
        assert (out == outBytes.getUnsafeBytes());
        RubyString result = new RubyString(runtime2, this.getMetaClass(), outBytes);
        if (is1_9) {
            if (!enc.isAsciiCompatible()) {
                result.cat(".force_encoding(\"".getBytes());
                result.cat(enc.getName());
                result.cat((byte)34).cat((byte)41);
                enc = ASCII;
            }
            result.associateEncoding(enc);
            result.setCodeRange(32);
        }
        return result.infectBy(this);
    }

    @JRubyMethod(name={"insert"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject insert(ThreadContext context, IRubyObject indexArg, IRubyObject stringArg) {
        assert (!context.getRuntime().is1_9());
        RubyString str = stringArg.convertToString();
        int index2 = RubyNumeric.num2int(indexArg);
        if (index2 == -1) {
            return this.append(stringArg);
        }
        if (index2 < 0) {
            ++index2;
        }
        this.replaceInternal(this.checkIndex(index2, this.value.getRealSize()), 0, str);
        return this;
    }

    @JRubyMethod(name={"insert"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject insert19(ThreadContext context, IRubyObject indexArg, IRubyObject stringArg) {
        RubyString str = stringArg.convertToString();
        int index2 = RubyNumeric.num2int(indexArg);
        if (index2 == -1) {
            return this.append19(stringArg);
        }
        if (index2 < 0) {
            ++index2;
        }
        this.replaceInternal19(this.checkIndex(index2, this.strLength()), 0, str);
        return this;
    }

    private int checkIndex(int beg, int len) {
        if (beg > len) {
            this.raiseIndexOutOfString(beg);
        }
        if (beg < 0) {
            if (-beg > len) {
                this.raiseIndexOutOfString(beg);
            }
            beg += len;
        }
        return beg;
    }

    private int checkIndexForRef(int beg, int len) {
        if (beg >= len) {
            this.raiseIndexOutOfString(beg);
        }
        if (beg < 0) {
            if (-beg > len) {
                this.raiseIndexOutOfString(beg);
            }
            beg += len;
        }
        return beg;
    }

    private int checkLength(int len) {
        if (len < 0) {
            throw this.getRuntime().newIndexError("negative length " + len);
        }
        return len;
    }

    private void raiseIndexOutOfString(int index2) {
        throw this.getRuntime().newIndexError("index " + index2 + " out of string");
    }

    @Override
    @JRubyMethod(name={"inspect"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject inspect() {
        int start2 = this.value.getBegin();
        int len = this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        try {
            return this.inspectCommon(false);
        }
        catch (ArrayIndexOutOfBoundsException x) {
            System.out.println("" + start2 + ", " + len + ", " + Arrays.toString(bytes2));
            throw x;
        }
    }

    @JRubyMethod(name={"inspect"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject inspect19() {
        return this.inspectCommon(true);
    }

    private void prefixEscapeCat(int c) {
        this.cat(92);
        this.cat(c);
    }

    private void escapeCodePointCat(Ruby runtime2, byte[] bytes2, int p2, int n) {
        for (int q = p2 - n; q < p2; ++q) {
            Sprintf.sprintf(runtime2, this.value, (CharSequence)"\\x%02X", bytes2[q] & 0xFF);
        }
    }

    final IRubyObject inspectCommon(boolean is1_9) {
        Encoding enc;
        Ruby runtime2 = this.getRuntime();
        byte[] bytes2 = this.value.getUnsafeBytes();
        int p2 = this.value.getBegin();
        int end2 = p2 + this.value.getRealSize();
        RubyString result = new RubyString(runtime2, runtime2.getString(), new ByteList(end2 - p2));
        if (is1_9) {
            enc = this.value.getEncoding().isAsciiCompatible() ? this.value.getEncoding() : USASCIIEncoding.INSTANCE;
            result.associateEncoding(enc);
        } else {
            enc = runtime2.getKCode().getEncoding();
        }
        result.cat(34);
        while (p2 < end2) {
            int c;
            int n;
            if (is1_9) {
                n = StringSupport.preciseLength(enc, bytes2, p2, end2);
                if (n <= 0) {
                    n = 1;
                    result.escapeCodePointCat(runtime2, bytes2, ++p2, n);
                    continue;
                }
                c = StringSupport.codePoint(runtime2, enc, bytes2, p2, end2);
                n = StringSupport.codeLength(runtime2, enc, c);
                p2 += n;
            } else {
                c = bytes2[p2++] & 0xFF;
                n = enc.length((byte)c);
            }
            if (!is1_9 && n > 1 && p2 - 1 <= end2 - n) {
                try {
                    result.cat(bytes2, p2 - 1, n);
                }
                catch (ArrayIndexOutOfBoundsException x) {
                    System.out.println("begin = " + (p2 - 1));
                    System.out.println("len = " + n);
                    System.out.println("bytes = " + Arrays.toString(bytes2));
                    throw x;
                }
                p2 += n - 1;
                continue;
            }
            if (c == 34 || c == 92) {
                result.prefixEscapeCat(c);
                continue;
            }
            if (c == 35) {
                if (is1_9) {
                    int cc;
                    if (p2 < end2 && StringSupport.preciseLength(enc, bytes2, p2, end2) > 0 && this.isEVStr(cc = StringSupport.codePoint(runtime2, enc, bytes2, p2, end2))) {
                        result.prefixEscapeCat(cc);
                        continue;
                    }
                } else if (this.isEVStr(bytes2, p2, end2)) {
                    result.prefixEscapeCat(c);
                    continue;
                }
            }
            if (!is1_9 && ASCII.isPrint(c)) {
                result.cat(c);
                continue;
            }
            if (c == 10) {
                result.prefixEscapeCat(110);
                continue;
            }
            if (c == 13) {
                result.prefixEscapeCat(114);
                continue;
            }
            if (c == 9) {
                result.prefixEscapeCat(116);
                continue;
            }
            if (c == 12) {
                result.prefixEscapeCat(102);
                continue;
            }
            if (c == 11) {
                result.prefixEscapeCat(118);
                continue;
            }
            if (c == 8) {
                result.prefixEscapeCat(98);
                continue;
            }
            if (c == 7) {
                result.prefixEscapeCat(97);
                continue;
            }
            if (c == 27) {
                result.prefixEscapeCat(101);
                continue;
            }
            if (is1_9 && enc.isPrint(c)) {
                result.cat(bytes2, p2 - n, n, enc);
                continue;
            }
            if (!is1_9) {
                Sprintf.sprintf(runtime2, result.value, (CharSequence)"\\%03o", c & 0xFF);
                continue;
            }
            result.escapeCodePointCat(runtime2, bytes2, p2, n);
        }
        result.cat(34);
        return result.infectBy(this);
    }

    private boolean isEVStr(byte[] bytes2, int p2, int end2) {
        return p2 < end2 ? this.isEVStr(bytes2[p2] & 0xFF) : false;
    }

    public boolean isEVStr(int c) {
        return c == 36 || c == 64 || c == 123;
    }

    @JRubyMethod(name={"length", "size"}, compat=CompatVersion.RUBY1_8)
    public RubyFixnum length() {
        return this.getRuntime().newFixnum(this.value.getRealSize());
    }

    @JRubyMethod(name={"length", "size"}, compat=CompatVersion.RUBY1_9)
    public RubyFixnum length19() {
        return this.getRuntime().newFixnum(this.strLength());
    }

    @JRubyMethod(name={"bytesize"})
    public RubyFixnum bytesize() {
        return this.length();
    }

    @JRubyMethod(name={"empty?"})
    public RubyBoolean empty_p(ThreadContext context) {
        return this.isEmpty() ? context.getRuntime().getTrue() : context.getRuntime().getFalse();
    }

    public boolean isEmpty() {
        return this.value.length() == 0;
    }

    public RubyString append(IRubyObject other) {
        RubyString otherStr = other.convertToString();
        this.infectBy(otherStr);
        return this.cat(otherStr.value);
    }

    public RubyString append19(IRubyObject other) {
        return this.cat19(other.convertToString());
    }

    @JRubyMethod(name={"concat", "<<"}, compat=CompatVersion.RUBY1_8)
    public RubyString concat(IRubyObject other) {
        long longValue;
        if (other instanceof RubyFixnum && (longValue = ((RubyFixnum)other).getLongValue()) >= 0L && longValue < 256L) {
            return this.cat((byte)longValue);
        }
        return this.append(other);
    }

    @JRubyMethod(name={"concat", "<<"}, backtrace=true, compat=CompatVersion.RUBY1_9)
    public RubyString concat19(ThreadContext context, IRubyObject other) {
        Ruby runtime2 = context.getRuntime();
        if (other instanceof RubyFixnum) {
            int c = RubyNumeric.num2int(other);
            if (c < 0) {
                throw runtime2.newRangeError("negative string size (or size too big)");
            }
            return this.concatNumeric(runtime2, c);
        }
        if (other instanceof RubyBignum) {
            if (((RubyBignum)other).getBigIntegerValue().signum() < 0) {
                throw runtime2.newRangeError("negative string size (or size too big)");
            }
            long c = ((RubyBignum)other).getLongValue();
            return this.concatNumeric(runtime2, (int)c);
        }
        return this.append19(other);
    }

    private RubyString concatNumeric(Ruby runtime2, int c) {
        Encoding enc = this.value.getEncoding();
        int cl = StringSupport.codeLength(runtime2, enc, c);
        this.modify19(this.value.getRealSize() + cl);
        enc.codeToMbc(c, this.value.getUnsafeBytes(), this.value.getBegin() + this.value.getRealSize());
        this.value.setRealSize(this.value.getRealSize() + cl);
        return this;
    }

    @JRubyMethod(name={"crypt"})
    public RubyString crypt(ThreadContext context, IRubyObject other) {
        RubyString otherStr = other.convertToString();
        ByteList salt = otherStr.getByteList();
        if (salt.getRealSize() < 2) {
            throw context.getRuntime().newArgumentError("salt too short(need >=2 bytes)");
        }
        salt = salt.makeShared(0, 2);
        RubyString result = RubyString.newStringShared(context.getRuntime(), JavaCrypt.crypt(salt, this.getByteList()));
        result.infectBy(this);
        result.infectBy(otherStr);
        return result;
    }

    public static RubyString stringValue(IRubyObject object) {
        return (RubyString)(object instanceof RubyString ? object : object.convertToString());
    }

    @JRubyMethod(name={"sub"}, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject sub(ThreadContext context, IRubyObject arg0, Block block) {
        RubyString str = this.strDup(context.getRuntime());
        str.sub_bang(context, arg0, block);
        return str;
    }

    @JRubyMethod(name={"sub"}, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject sub(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        RubyString str = this.strDup(context.getRuntime());
        str.sub_bang(context, arg0, arg1, block);
        return str;
    }

    @JRubyMethod(name={"sub!"}, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject sub_bang(ThreadContext context, IRubyObject arg0, Block block) {
        if (block.isGiven()) {
            return this.subBangIter(context, this.getQuotedPattern(arg0), block);
        }
        throw context.getRuntime().newArgumentError(1, 2);
    }

    @JRubyMethod(name={"sub!"}, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject sub_bang(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.subBangNoIter(context, this.getQuotedPattern(arg0), arg1.convertToString());
    }

    private IRubyObject subBangIter(ThreadContext context, Regex pattern, Block block) {
        int range = this.value.getBegin() + this.value.getRealSize();
        Matcher matcher = pattern.matcher(this.value.getUnsafeBytes(), this.value.getBegin(), range);
        DynamicScope scope = context.getCurrentScope();
        if (matcher.search(this.value.getBegin(), range, 0) >= 0) {
            byte[] bytes2 = this.value.getUnsafeBytes();
            int size2 = this.value.getRealSize();
            RubyMatchData match2 = RubyRegexp.updateBackRef(context, this, scope, matcher, pattern);
            RubyString repl = RubyString.objAsString(context, block.yield(context, this.makeShared(context.getRuntime(), matcher.getBegin(), matcher.getEnd() - matcher.getBegin())));
            this.modifyCheck(bytes2, size2);
            this.frozenCheck();
            scope.setBackRef(match2);
            return this.subBangCommon(context, pattern, matcher, repl, repl.flags);
        }
        return scope.setBackRef(context.getRuntime().getNil());
    }

    private IRubyObject subBangNoIter(ThreadContext context, Regex pattern, RubyString repl) {
        int tuFlags = repl.flags;
        int range = this.value.getBegin() + this.value.getRealSize();
        Matcher matcher = pattern.matcher(this.value.getUnsafeBytes(), this.value.getBegin(), range);
        DynamicScope scope = context.getCurrentScope();
        if (matcher.search(this.value.getBegin(), range, 0) >= 0) {
            repl = RubyRegexp.regsub(repl, this, matcher, context.getRuntime().getKCode().getEncoding());
            RubyRegexp.updateBackRef(context, this, scope, matcher, pattern);
            return this.subBangCommon(context, pattern, matcher, repl, tuFlags);
        }
        return scope.setBackRef(context.getRuntime().getNil());
    }

    private IRubyObject subBangCommon(ThreadContext context, Regex pattern, Matcher matcher, RubyString repl, int tuFlags) {
        int beg = matcher.getBegin();
        int plen = matcher.getEnd() - beg;
        ByteList replValue = repl.value;
        if (replValue.getRealSize() > plen) {
            this.modify(this.value.getRealSize() + replValue.getRealSize() - plen);
        } else {
            this.modify();
        }
        if (replValue.getRealSize() != plen) {
            int src = this.value.getBegin() + beg + plen;
            int dst = this.value.getBegin() + beg + replValue.getRealSize();
            int length2 = this.value.getRealSize() - beg - plen;
            System.arraycopy(this.value.getUnsafeBytes(), src, this.value.getUnsafeBytes(), dst, length2);
        }
        System.arraycopy(replValue.getUnsafeBytes(), replValue.getBegin(), this.value.getUnsafeBytes(), this.value.getBegin() + beg, replValue.getRealSize());
        this.value.setRealSize(this.value.getRealSize() + replValue.getRealSize() - plen);
        this.infectBy(tuFlags);
        return this;
    }

    @JRubyMethod(name={"sub"}, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject sub19(ThreadContext context, IRubyObject arg0, Block block) {
        RubyString str = this.strDup(context.getRuntime());
        str.sub_bang19(context, arg0, block);
        return str;
    }

    @JRubyMethod(name={"sub"}, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject sub19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        RubyString str = this.strDup(context.getRuntime());
        str.sub_bang19(context, arg0, arg1, block);
        return str;
    }

    @JRubyMethod(name={"sub!"}, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject sub_bang19(ThreadContext context, IRubyObject arg0, Block block) {
        Regex prepared;
        Regex pattern;
        RubyRegexp regexp2;
        Ruby runtime2 = context.getRuntime();
        if (arg0 instanceof RubyRegexp) {
            regexp2 = (RubyRegexp)arg0;
            pattern = regexp2.getPattern();
            prepared = regexp2.preparePattern(this);
        } else {
            regexp2 = null;
            pattern = this.getStringPattern19(runtime2, arg0);
            prepared = RubyRegexp.preparePattern(runtime2, pattern, this);
        }
        if (block.isGiven()) {
            return this.subBangIter19(runtime2, context, pattern, prepared, null, block, regexp2);
        }
        throw context.getRuntime().newArgumentError(1, 2);
    }

    @JRubyMethod(name={"sub!"}, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject sub_bang19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        Regex prepared;
        Regex pattern;
        RubyRegexp regexp2;
        Ruby runtime2 = context.getRuntime();
        IRubyObject hash2 = TypeConverter.convertToTypeWithCheck(arg1, runtime2.getHash(), "to_hash");
        if (arg0 instanceof RubyRegexp) {
            regexp2 = (RubyRegexp)arg0;
            pattern = regexp2.getPattern();
            prepared = regexp2.preparePattern(this);
        } else {
            regexp2 = null;
            pattern = this.getStringPattern19(runtime2, arg0);
            prepared = RubyRegexp.preparePattern(runtime2, pattern, this);
        }
        if (hash2.isNil()) {
            return this.subBangNoIter19(runtime2, context, pattern, prepared, arg1.convertToString(), regexp2);
        }
        return this.subBangIter19(runtime2, context, pattern, prepared, (RubyHash)hash2, block, regexp2);
    }

    private IRubyObject subBangIter19(Ruby runtime2, ThreadContext context, Regex pattern, Regex prepared, RubyHash hash2, Block block, RubyRegexp regexp2) {
        int begin2 = this.value.getBegin();
        int len = this.value.getRealSize();
        int range = begin2 + len;
        byte[] bytes2 = this.value.getUnsafeBytes();
        Encoding enc = this.value.getEncoding();
        Matcher matcher = prepared.matcher(bytes2, begin2, range);
        DynamicScope scope = context.getCurrentScope();
        if (matcher.search(begin2, range, 0) >= 0) {
            RubyString repl;
            int tuFlags;
            RubyMatchData match2 = RubyRegexp.updateBackRef19(context, this, scope, matcher, pattern);
            match2.regexp = regexp2;
            RubyString subStr = this.makeShared19(runtime2, matcher.getBegin(), matcher.getEnd() - matcher.getBegin());
            if (hash2 == null) {
                tuFlags = 0;
                repl = RubyString.objAsString(context, block.yield(context, subStr));
            } else {
                tuFlags = hash2.flags;
                repl = RubyString.objAsString(context, hash2.op_aref(context, subStr));
            }
            this.modifyCheck(bytes2, len, enc);
            this.frozenCheck();
            scope.setBackRef(match2);
            return this.subBangCommon19(context, pattern, matcher, repl, tuFlags | repl.flags);
        }
        return scope.setBackRef(runtime2.getNil());
    }

    private IRubyObject subBangNoIter19(Ruby runtime2, ThreadContext context, Regex pattern, Regex prepared, RubyString repl, RubyRegexp regexp2) {
        int begin2 = this.value.getBegin();
        int range = begin2 + this.value.getRealSize();
        Matcher matcher = prepared.matcher(this.value.getUnsafeBytes(), begin2, range);
        DynamicScope scope = context.getCurrentScope();
        if (matcher.search(begin2, range, 0) >= 0) {
            repl = RubyRegexp.regsub19(repl, this, matcher, pattern);
            RubyMatchData match2 = RubyRegexp.updateBackRef19(context, this, scope, matcher, pattern);
            match2.regexp = regexp2;
            return this.subBangCommon19(context, pattern, matcher, repl, repl.flags);
        }
        return scope.setBackRef(runtime2.getNil());
    }

    private IRubyObject subBangCommon19(ThreadContext context, Regex pattern, Matcher matcher, RubyString repl, int tuFlags) {
        int beg = matcher.getBegin();
        int end2 = matcher.getEnd();
        Encoding enc = this.isCompatibleWith(repl);
        if (enc == null) {
            enc = this.subBangVerifyEncoding(context, repl, beg, end2);
        }
        int plen = end2 - beg;
        ByteList replValue = repl.value;
        if (replValue.getRealSize() > plen) {
            this.modify19(this.value.getRealSize() + replValue.getRealSize() - plen);
        } else {
            this.modify19();
        }
        this.associateEncoding(enc);
        int cr = this.getCodeRange();
        if (cr > 0 && cr < 96) {
            int cr2 = repl.getCodeRange();
            cr = cr2 == 96 || cr == 64 && cr2 == 32 ? 0 : cr2;
        }
        if (replValue.getRealSize() != plen) {
            int src = this.value.getBegin() + beg + plen;
            int dst = this.value.getBegin() + beg + replValue.getRealSize();
            int length2 = this.value.getRealSize() - beg - plen;
            System.arraycopy(this.value.getUnsafeBytes(), src, this.value.getUnsafeBytes(), dst, length2);
        }
        System.arraycopy(replValue.getUnsafeBytes(), replValue.getBegin(), this.value.getUnsafeBytes(), this.value.getBegin() + beg, replValue.getRealSize());
        this.value.setRealSize(this.value.getRealSize() + replValue.getRealSize() - plen);
        this.setCodeRange(cr);
        return this.infectBy(tuFlags);
    }

    private Encoding subBangVerifyEncoding(ThreadContext context, RubyString repl, int beg, int end2) {
        byte[] bytes2 = this.value.getUnsafeBytes();
        int p2 = this.value.getBegin();
        int len = this.value.getRealSize();
        Encoding strEnc = this.value.getEncoding();
        if (StringSupport.codeRangeScan(strEnc, bytes2, p2, beg) != 32 || StringSupport.codeRangeScan(strEnc, bytes2, p2 + end2, len - end2) != 32) {
            throw context.getRuntime().newArgumentError("incompatible character encodings " + strEnc + " and " + repl.value.getEncoding());
        }
        return repl.value.getEncoding();
    }

    @JRubyMethod(name={"gsub"}, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject gsub(ThreadContext context, IRubyObject arg0, Block block) {
        return this.gsub(context, arg0, block, false);
    }

    @JRubyMethod(name={"gsub"}, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject gsub(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.gsub(context, arg0, arg1, block, false);
    }

    @JRubyMethod(name={"gsub!"}, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject gsub_bang(ThreadContext context, IRubyObject arg0, Block block) {
        return this.gsub(context, arg0, block, true);
    }

    @JRubyMethod(name={"gsub!"}, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject gsub_bang(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.gsub(context, arg0, arg1, block, true);
    }

    private final IRubyObject gsub(ThreadContext context, IRubyObject arg0, Block block, boolean bang) {
        if (block.isGiven()) {
            return this.gsubCommon(context, bang, this.getQuotedPattern(arg0), block, null, 0);
        }
        throw context.getRuntime().newArgumentError("wrong number of arguments (1 for 2)");
    }

    private final IRubyObject gsub(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block, boolean bang) {
        RubyString repl = arg1.convertToString();
        return this.gsubCommon(context, bang, this.getQuotedPattern(arg0), block, repl, repl.flags);
    }

    private IRubyObject gsubCommon(ThreadContext context, boolean bang, Regex pattern, Block block, RubyString repl, int tuFlags) {
        Ruby runtime2 = context.getRuntime();
        DynamicScope scope = context.getCurrentScope();
        int begin2 = this.value.getBegin();
        int slen = this.value.getRealSize();
        int range = begin2 + slen;
        byte[] bytes2 = this.value.getUnsafeBytes();
        Matcher matcher = pattern.matcher(bytes2, begin2, range);
        int beg = matcher.search(begin2, range, 0);
        if (beg < 0) {
            scope.setBackRef(runtime2.getNil());
            return bang ? runtime2.getNil() : this.strDup(runtime2);
        }
        int blen = slen + 30;
        ByteList dest = new ByteList(blen);
        dest.setRealSize(blen);
        int offset2 = 0;
        int buf = 0;
        int bp = 0;
        int cp = begin2;
        RubyMatchData match2 = null;
        while (beg >= 0) {
            RubyString val;
            int begz = matcher.getBegin();
            int endz = matcher.getEnd();
            if (repl == null) {
                match2 = RubyRegexp.updateBackRef(context, this, scope, matcher, pattern);
                val = RubyString.objAsString(context, block.yield(context, this.substr(runtime2, begz, endz - begz)));
                this.modifyCheck(bytes2, slen);
                if (bang) {
                    this.frozenCheck();
                }
            } else {
                val = RubyRegexp.regsub(repl, this, matcher, runtime2.getKCode().getEncoding());
            }
            tuFlags |= val.flags;
            ByteList vbuf = val.value;
            int len = bp - buf + (beg - offset2) + vbuf.getRealSize() + 3;
            if (blen < len) {
                while (blen < len) {
                    blen <<= 1;
                }
                len = bp - buf;
                dest.realloc(blen);
                dest.setRealSize(blen);
                bp = buf + len;
            }
            len = beg - offset2;
            System.arraycopy(bytes2, cp, dest.getUnsafeBytes(), bp, len);
            System.arraycopy(vbuf.getUnsafeBytes(), vbuf.getBegin(), dest.getUnsafeBytes(), bp += len, vbuf.getRealSize());
            bp += vbuf.getRealSize();
            offset2 = endz;
            if (begz == endz) {
                if (slen <= endz) break;
                len = pattern.getEncoding().length(bytes2, begin2 + endz, range);
                System.arraycopy(bytes2, begin2 + endz, dest.getUnsafeBytes(), bp, len);
                bp += len;
                offset2 = endz + len;
            }
            cp = begin2 + offset2;
            if (offset2 > slen) break;
            beg = matcher.search(cp, range, 0);
        }
        if (repl == null) {
            scope.setBackRef(match2);
        } else {
            RubyRegexp.updateBackRef(context, this, scope, matcher, pattern);
        }
        if (slen > offset2) {
            int len = bp - buf;
            if (blen - len < slen - offset2) {
                blen = len + slen - offset2;
                dest.realloc(blen);
                bp = buf + len;
            }
            System.arraycopy(bytes2, cp, dest.getUnsafeBytes(), bp, slen - offset2);
            bp += slen - offset2;
        }
        dest.setRealSize(bp - buf);
        if (bang) {
            this.view(dest);
            return this.infectBy(tuFlags);
        }
        return new RubyString(runtime2, this.getMetaClass(), dest).infectBy(tuFlags | this.flags);
    }

    @JRubyMethod(name={"gsub"}, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject gsub19(ThreadContext context, IRubyObject arg0, Block block) {
        return block.isGiven() ? this.gsubCommon19(context, block, null, null, arg0, false, 0) : RubyEnumerator.enumeratorize(context.getRuntime(), (IRubyObject)this, "gsub", arg0);
    }

    @JRubyMethod(name={"gsub"}, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject gsub19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.gsub19(context, arg0, arg1, block, false);
    }

    @JRubyMethod(name={"gsub!"}, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject gsub_bang19(ThreadContext context, IRubyObject arg0, Block block) {
        return block.isGiven() ? this.gsubCommon19(context, block, null, null, arg0, true, 0) : RubyEnumerator.enumeratorize(context.getRuntime(), (IRubyObject)this, "gsub!", arg0);
    }

    @JRubyMethod(name={"gsub!"}, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject gsub_bang19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.gsub19(context, arg0, arg1, block, true);
    }

    private final IRubyObject gsub19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block, boolean bang) {
        int tuFlags;
        RubyString str;
        RubyHash hash2;
        Ruby runtime2 = context.getRuntime();
        IRubyObject tryHash = TypeConverter.convertToTypeWithCheck(arg1, runtime2.getHash(), "to_hash");
        if (tryHash.isNil()) {
            hash2 = null;
            str = arg1.convertToString();
            tuFlags = str.flags;
        } else {
            hash2 = (RubyHash)tryHash;
            str = null;
            tuFlags = hash2.flags & 8;
        }
        return this.gsubCommon19(context, block, str, hash2, arg0, bang, tuFlags);
    }

    private IRubyObject gsubCommon19(ThreadContext context, Block block, RubyString repl, RubyHash hash2, IRubyObject arg0, boolean bang, int tuFlags) {
        Regex prepared;
        Regex pattern;
        RubyRegexp regexp2;
        Ruby runtime2 = context.getRuntime();
        if (arg0 instanceof RubyRegexp) {
            regexp2 = (RubyRegexp)arg0;
            pattern = regexp2.getPattern();
            prepared = regexp2.preparePattern(this);
        } else {
            regexp2 = null;
            pattern = this.getStringPattern19(runtime2, arg0);
            prepared = RubyRegexp.preparePattern(runtime2, pattern, this);
        }
        int begin2 = this.value.getBegin();
        int slen = this.value.getRealSize();
        int range = begin2 + slen;
        byte[] bytes2 = this.value.getUnsafeBytes();
        Matcher matcher = prepared.matcher(bytes2, begin2, range);
        DynamicScope scope = context.getCurrentScope();
        int beg = matcher.search(begin2, range, 0);
        if (beg < 0) {
            scope.setBackRef(runtime2.getNil());
            return bang ? runtime2.getNil() : this.strDup(runtime2);
        }
        RubyString dest = new RubyString(runtime2, this.getMetaClass(), new ByteList(slen + 30));
        int offset2 = 0;
        int cp = begin2;
        Encoding enc = this.value.getEncoding();
        RubyMatchData match2 = null;
        do {
            RubyString val;
            int begz = matcher.getBegin();
            int endz = matcher.getEnd();
            if (repl != null) {
                val = RubyRegexp.regsub19(repl, this, matcher, pattern);
            } else {
                RubyString substr = this.makeShared19(runtime2, begz, endz - begz);
                if (hash2 != null) {
                    val = RubyString.objAsString(context, hash2.op_aref(context, substr));
                } else {
                    match2 = RubyRegexp.updateBackRef19(context, this, scope, matcher, pattern);
                    match2.regexp = regexp2;
                    val = RubyString.objAsString(context, block.yield(context, substr));
                }
                this.modifyCheck(bytes2, slen, enc);
                if (bang) {
                    this.frozenCheck();
                }
            }
            tuFlags |= val.flags;
            int len = beg - offset2;
            if (len != 0) {
                dest.cat(bytes2, cp, len, enc);
            }
            dest.cat19(val);
            offset2 = endz;
            if (begz == endz) {
                if (slen <= endz) break;
                len = StringSupport.length(enc, bytes2, begin2 + endz, range);
                dest.cat(bytes2, begin2 + endz, len, enc);
                offset2 = endz + len;
            }
            cp = begin2 + offset2;
        } while (offset2 <= slen && (beg = matcher.search(cp, range, 0)) >= 0);
        if (slen > offset2) {
            dest.cat(bytes2, cp, slen - offset2, enc);
        }
        if (match2 != null) {
            scope.setBackRef(match2);
        } else {
            match2 = RubyRegexp.updateBackRef19(context, this, scope, matcher, pattern);
            match2.regexp = regexp2;
        }
        if (bang) {
            this.view(dest.value);
            this.setCodeRange(dest.getCodeRange());
            return this.infectBy(tuFlags);
        }
        return dest.infectBy(tuFlags | this.flags);
    }

    @JRubyMethod(name={"index"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject index(ThreadContext context, IRubyObject arg0) {
        return this.indexCommon(context.getRuntime(), context, arg0, 0);
    }

    @JRubyMethod(name={"index"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject index(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        int pos2 = RubyNumeric.num2int(arg1);
        Ruby runtime2 = context.getRuntime();
        if (pos2 < 0 && (pos2 += this.value.getRealSize()) < 0) {
            if (arg0 instanceof RubyRegexp) {
                context.getCurrentScope().setBackRef(runtime2.getNil());
            }
            return runtime2.getNil();
        }
        return this.indexCommon(runtime2, context, arg0, pos2);
    }

    private IRubyObject indexCommon(Ruby runtime2, ThreadContext context, IRubyObject sub3, int pos2) {
        if (sub3 instanceof RubyRegexp) {
            RubyRegexp regSub = (RubyRegexp)sub3;
            pos2 = regSub.adjustStartPos(this, pos2, false);
            pos2 = regSub.search(context, this, pos2, false);
        } else {
            if (sub3 instanceof RubyFixnum) {
                int c_int = RubyNumeric.fix2int((RubyFixnum)sub3);
                if (c_int < 0 || c_int > 255) {
                    return runtime2.getNil();
                }
                byte c = (byte)c_int;
                byte[] bytes2 = this.value.getUnsafeBytes();
                int end2 = this.value.getBegin() + this.value.getRealSize();
                pos2 += this.value.getBegin();
                while (pos2 < end2) {
                    if (bytes2[pos2] == c) {
                        return RubyFixnum.newFixnum(runtime2, pos2 - this.value.getBegin());
                    }
                    ++pos2;
                }
                return runtime2.getNil();
            }
            if (sub3 instanceof RubyString) {
                pos2 = this.strIndex((RubyString)sub3, pos2);
            } else {
                IRubyObject tmp = sub3.checkStringType();
                if (tmp.isNil()) {
                    throw runtime2.newTypeError("type mismatch: " + sub3.getMetaClass().getName() + " given");
                }
                pos2 = this.strIndex((RubyString)tmp, pos2);
            }
        }
        return pos2 == -1 ? runtime2.getNil() : RubyFixnum.newFixnum(runtime2, pos2);
    }

    private int strIndex(RubyString sub3, int offset2) {
        ByteList byteList = this.value;
        if (offset2 < 0 && (offset2 += byteList.getRealSize()) < 0) {
            return -1;
        }
        ByteList other = sub3.value;
        if (RubyString.sizeIsSmaller(byteList, offset2, other)) {
            return -1;
        }
        if (other.getRealSize() == 0) {
            return offset2;
        }
        return byteList.indexOf(other, offset2);
    }

    private static boolean sizeIsSmaller(ByteList byteList, int offset2, ByteList other) {
        return byteList.getRealSize() - offset2 < other.getRealSize();
    }

    @JRubyMethod(name={"index"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject index19(ThreadContext context, IRubyObject arg0) {
        return this.indexCommon19(context.getRuntime(), context, arg0, 0);
    }

    @JRubyMethod(name={"index"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject index19(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        int pos2 = RubyNumeric.num2int(arg1);
        Ruby runtime2 = context.getRuntime();
        if (pos2 < 0 && (pos2 += this.strLength()) < 0) {
            if (arg0 instanceof RubyRegexp) {
                context.getCurrentScope().setBackRef(runtime2.getNil());
            }
            return runtime2.getNil();
        }
        return this.indexCommon19(runtime2, context, arg0, pos2);
    }

    private IRubyObject indexCommon19(Ruby runtime2, ThreadContext context, IRubyObject sub3, int pos2) {
        if (sub3 instanceof RubyRegexp) {
            RubyRegexp regSub = (RubyRegexp)sub3;
            pos2 = this.singleByteOptimizable() ? pos2 : StringSupport.nth(this.checkEncoding(regSub), this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getBegin() + this.value.getRealSize(), pos2);
            pos2 = regSub.adjustStartPos19(this, pos2, false);
            pos2 = regSub.search19(context, this, pos2, false);
            pos2 = this.subLength(pos2);
        } else if (sub3 instanceof RubyString) {
            pos2 = this.strIndex19((RubyString)sub3, pos2);
            pos2 = this.subLength(pos2);
        } else {
            IRubyObject tmp = sub3.checkStringType();
            if (tmp.isNil()) {
                throw runtime2.newTypeError("type mismatch: " + sub3.getMetaClass().getName() + " given");
            }
            pos2 = this.strIndex19((RubyString)tmp, pos2);
            pos2 = this.subLength(pos2);
        }
        return pos2 == -1 ? runtime2.getNil() : RubyFixnum.newFixnum(runtime2, pos2);
    }

    private int strIndex19(RubyString sub3, int offset2) {
        Encoding enc = this.checkEncoding(sub3);
        if (sub3.scanForCodeRange() == 96) {
            return -1;
        }
        int len = this.strLength(enc);
        int slen = sub3.strLength(enc);
        if (offset2 < 0 && (offset2 += len) < 0) {
            return -1;
        }
        if (len - offset2 < slen) {
            return -1;
        }
        byte[] bytes2 = this.value.getUnsafeBytes();
        int p2 = this.value.getBegin();
        int end2 = p2 + this.value.getRealSize();
        if (offset2 != 0) {
            offset2 = this.singleByteOptimizable() ? offset2 : StringSupport.offset(enc, bytes2, p2, end2, offset2);
            p2 += offset2;
        }
        if (slen == 0) {
            return offset2;
        }
        int pos2;
        while ((pos2 = this.value.indexOf(sub3.value, p2 - this.value.getBegin())) >= 0) {
            int t = enc.rightAdjustCharHead(bytes2, p2, p2 + (pos2 -= p2 - this.value.getBegin()), end2);
            if (t == p2 + pos2) {
                return pos2 + offset2;
            }
            if ((len -= t - p2) <= 0) {
                return -1;
            }
            offset2 += t - p2;
            p2 = t;
        }
        return pos2;
    }

    @JRubyMethod(name={"rindex"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject rindex(ThreadContext context, IRubyObject arg0) {
        return this.rindexCommon(context.getRuntime(), context, arg0, this.value.getRealSize());
    }

    @JRubyMethod(name={"rindex"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject rindex(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        int pos2 = RubyNumeric.num2int(arg1);
        Ruby runtime2 = context.getRuntime();
        if (pos2 < 0 && (pos2 += this.value.getRealSize()) < 0) {
            if (arg0 instanceof RubyRegexp) {
                context.getCurrentScope().setBackRef(runtime2.getNil());
            }
            return runtime2.getNil();
        }
        if (pos2 > this.value.getRealSize()) {
            pos2 = this.value.getRealSize();
        }
        return this.rindexCommon(runtime2, context, arg0, pos2);
    }

    private IRubyObject rindexCommon(Ruby runtime2, ThreadContext context, IRubyObject sub3, int pos2) {
        if (sub3 instanceof RubyRegexp) {
            RubyRegexp regSub = (RubyRegexp)sub3;
            if (regSub.length() > 0) {
                pos2 = regSub.adjustStartPos(this, pos2, true);
                pos2 = regSub.search(context, this, pos2, true);
            }
        } else if (sub3 instanceof RubyString) {
            pos2 = this.strRindex((RubyString)sub3, pos2);
        } else {
            if (sub3 instanceof RubyFixnum) {
                int c_int = RubyNumeric.fix2int((RubyFixnum)sub3);
                if (c_int < 0 || c_int > 255) {
                    return runtime2.getNil();
                }
                byte c = (byte)c_int;
                byte[] bytes2 = this.value.getUnsafeBytes();
                int pbeg = this.value.getBegin();
                int p2 = pbeg + pos2;
                if (pos2 == this.value.getRealSize()) {
                    if (pos2 == 0) {
                        return runtime2.getNil();
                    }
                    --p2;
                }
                while (pbeg <= p2) {
                    if (bytes2[p2] == c) {
                        return RubyFixnum.newFixnum(runtime2, p2 - this.value.getBegin());
                    }
                    --p2;
                }
                return runtime2.getNil();
            }
            IRubyObject tmp = sub3.checkStringType();
            if (tmp.isNil()) {
                throw runtime2.newTypeError("type mismatch: " + sub3.getMetaClass().getName() + " given");
            }
            pos2 = this.strRindex((RubyString)tmp, pos2);
        }
        if (pos2 >= 0) {
            return RubyFixnum.newFixnum(runtime2, pos2);
        }
        return runtime2.getNil();
    }

    private int strRindex(RubyString sub3, int pos2) {
        int subLength = sub3.value.getRealSize();
        if (this.value.getRealSize() < subLength) {
            return -1;
        }
        if (this.value.getRealSize() - pos2 < subLength) {
            pos2 = this.value.getRealSize() - subLength;
        }
        return this.value.lastIndexOf(sub3.value, pos2);
    }

    @JRubyMethod(name={"rindex"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject rindex19(ThreadContext context, IRubyObject arg0) {
        return this.rindexCommon19(context.getRuntime(), context, arg0, this.strLength());
    }

    @JRubyMethod(name={"rindex"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject rindex19(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        int pos2 = RubyNumeric.num2int(arg1);
        Ruby runtime2 = context.getRuntime();
        int length2 = this.strLength();
        if (pos2 < 0 && (pos2 += length2) < 0) {
            if (arg0 instanceof RubyRegexp) {
                context.getCurrentScope().setBackRef(runtime2.getNil());
            }
            return runtime2.getNil();
        }
        if (pos2 > length2) {
            pos2 = length2;
        }
        return this.rindexCommon19(runtime2, context, arg0, pos2);
    }

    private IRubyObject rindexCommon19(Ruby runtime2, ThreadContext context, IRubyObject sub3, int pos2) {
        if (sub3 instanceof RubyRegexp) {
            RubyRegexp regSub = (RubyRegexp)sub3;
            int n = pos2 = this.singleByteOptimizable() ? pos2 : StringSupport.nth(this.value.getEncoding(), this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getBegin() + this.value.getRealSize(), pos2);
            if (regSub.length() > 0) {
                pos2 = regSub.adjustStartPos(this, pos2, true);
                pos2 = regSub.search(context, this, pos2, true);
                pos2 = this.subLength(pos2);
            }
        } else if (sub3 instanceof RubyString) {
            pos2 = this.strRindex19((RubyString)sub3, pos2);
        } else {
            IRubyObject tmp = sub3.checkStringType();
            if (tmp.isNil()) {
                throw runtime2.newTypeError("type mismatch: " + sub3.getMetaClass().getName() + " given");
            }
            pos2 = this.strRindex19((RubyString)tmp, pos2);
        }
        if (pos2 >= 0) {
            return RubyFixnum.newFixnum(runtime2, pos2);
        }
        return runtime2.getNil();
    }

    private int strRindex19(RubyString sub3, int pos2) {
        int slen;
        Encoding enc = this.checkEncoding(sub3);
        if (sub3.scanForCodeRange() == 96) {
            return -1;
        }
        int len = this.strLength(enc);
        if (len < (slen = sub3.strLength(enc))) {
            return -1;
        }
        if (len - pos2 < slen) {
            pos2 = len - slen;
        }
        if (len == 0) {
            return pos2;
        }
        byte[] bytes2 = this.value.getUnsafeBytes();
        int p2 = this.value.getBegin();
        int end2 = p2 + this.value.getRealSize();
        byte[] sbytes = sub3.value.getUnsafeBytes();
        int sp = sub3.value.getBegin();
        slen = sub3.value.getRealSize();
        boolean singlebyte = this.singleByteOptimizable();
        while (true) {
            int s;
            int n = s = singlebyte ? p2 + pos2 : StringSupport.nth(enc, bytes2, p2, end2, pos2);
            if (s == -1) {
                return -1;
            }
            if (ByteList.memcmp(bytes2, s, sbytes, sp, slen) == 0) {
                return pos2;
            }
            if (pos2 == 0) {
                return -1;
            }
            --pos2;
        }
    }

    @Deprecated
    public final IRubyObject substr(int beg, int len) {
        return this.substr(this.getRuntime(), beg, len);
    }

    public final IRubyObject substr(Ruby runtime2, int beg, int len) {
        int length2 = this.value.length();
        if (len < 0 || beg > length2) {
            return runtime2.getNil();
        }
        if (beg < 0 && (beg += length2) < 0) {
            return runtime2.getNil();
        }
        int end2 = Math.min(length2, beg + len);
        return this.makeShared(runtime2, beg, end2 - beg);
    }

    public final IRubyObject substr19(Ruby runtime2, int beg, int len) {
        Encoding enc;
        if (len < 0) {
            return runtime2.getNil();
        }
        int length2 = this.value.getRealSize();
        if (length2 == 0) {
            len = 0;
        }
        if (this.singleByteOptimizable(enc = this.value.getEncoding())) {
            if (beg > length2) {
                return runtime2.getNil();
            }
            if (beg < 0 && (beg += length2) < 0) {
                return runtime2.getNil();
            }
            if (beg + len > length2) {
                len = length2 - beg;
            }
            if (len <= 0) {
                beg = 0;
                len = 0;
            }
            return this.makeShared19(runtime2, beg, len);
        }
        return this.multibyteSubstr19(runtime2, enc, len, beg, length2);
    }

    private final IRubyObject multibyteSubstr19(Ruby runtime2, Encoding enc, int len, int beg, int length2) {
        int p2;
        int s = this.value.getBegin();
        int end2 = s + length2;
        byte[] bytes2 = this.value.getUnsafeBytes();
        if (beg < 0) {
            if (len > -beg) {
                len = -beg;
            }
            if (-beg * enc.maxLength() < length2 >>> 3) {
                beg = -beg;
                int e = end2;
                while (beg-- > len && (e = enc.prevCharHead(bytes2, s, e, e)) != -1) {
                }
                int p3 = e;
                if (p3 == -1) {
                    return runtime2.getNil();
                }
                while (len-- > 0 && (p3 = enc.prevCharHead(bytes2, s, p3, e)) != -1) {
                }
                if (p3 == -1) {
                    return runtime2.getNil();
                }
                return this.makeShared19(runtime2, p3 - s, e - p3);
            }
            if ((beg += this.strLength(enc)) < 0) {
                return runtime2.getNil();
            }
        } else if (beg > 0 && beg > this.strLength(enc)) {
            return runtime2.getNil();
        }
        if (len == 0) {
            p2 = 0;
        } else if (this.isCodeRangeValid() && enc instanceof UTF8Encoding) {
            p2 = StringSupport.utf8Nth(bytes2, s, end2, beg);
            len = StringSupport.utf8Offset(bytes2, p2, end2, len);
        } else if (enc.isFixedWidth()) {
            int w = enc.maxLength();
            p2 = s + beg * w;
            if (p2 > end2) {
                p2 = end2;
                len = 0;
            } else {
                len = len * w > end2 - p2 ? end2 - p2 : (len *= w);
            }
        } else {
            p2 = StringSupport.nth(enc, bytes2, s, end2, beg);
            len = p2 == end2 ? 0 : StringSupport.offset(enc, bytes2, p2, end2, len);
        }
        return this.makeShared19(runtime2, p2 - s, len);
    }

    private IRubyObject replaceInternal(int beg, int len, RubyString repl) {
        int oldLength = this.value.getRealSize();
        if (beg + len >= oldLength) {
            len = oldLength - beg;
        }
        ByteList replBytes = repl.value;
        int replLength = replBytes.getRealSize();
        int newLength = oldLength + replLength - len;
        byte[] oldBytes = this.value.getUnsafeBytes();
        int oldBegin = this.value.getBegin();
        this.modify(newLength);
        if (replLength != len) {
            System.arraycopy(oldBytes, oldBegin + beg + len, this.value.getUnsafeBytes(), beg + replLength, oldLength - (beg + len));
        }
        if (replLength > 0) {
            System.arraycopy(replBytes.getUnsafeBytes(), replBytes.getBegin(), this.value.getUnsafeBytes(), beg, replLength);
        }
        this.value.setRealSize(newLength);
        return this.infectBy(repl);
    }

    private void replaceInternal19(int beg, int len, RubyString repl) {
        int e;
        Encoding enc = this.checkEncoding(repl);
        int p2 = this.value.getBegin();
        if (this.singleByteOptimizable()) {
            e = (p2 += beg) + len;
        } else {
            int end2 = p2 + this.value.getRealSize();
            byte[] bytes2 = this.value.getUnsafeBytes();
            p2 = StringSupport.nth(enc, bytes2, p2, end2, beg);
            if (p2 == -1) {
                p2 = end2;
            }
            if ((e = StringSupport.nth(enc, bytes2, p2, end2, len)) == -1) {
                e = end2;
            }
        }
        int cr = this.getCodeRange();
        if (cr == 96) {
            this.clearCodeRange();
        }
        this.replaceInternal(p2 - this.value.getBegin(), e - p2, repl);
        this.associateEncoding(enc);
        cr = RubyString.codeRangeAnd(cr, repl.getCodeRange());
        if (cr != 96) {
            this.setCodeRange(cr);
        }
    }

    @JRubyMethod(name={"[]", "slice"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_aref(ThreadContext context, IRubyObject arg1, IRubyObject arg2) {
        Ruby runtime2 = context.getRuntime();
        if (arg1 instanceof RubyRegexp) {
            return this.subpat(runtime2, context, (RubyRegexp)arg1, RubyNumeric.num2int(arg2));
        }
        return this.substr(runtime2, RubyNumeric.num2int(arg1), RubyNumeric.num2int(arg2));
    }

    @JRubyMethod(name={"[]", "slice"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_aref(ThreadContext context, IRubyObject arg2) {
        Ruby runtime2 = context.getRuntime();
        if (arg2 instanceof RubyFixnum) {
            return this.op_aref(runtime2, RubyFixnum.fix2int((RubyFixnum)arg2));
        }
        if (arg2 instanceof RubyRegexp) {
            return this.subpat(runtime2, context, (RubyRegexp)arg2, 0);
        }
        if (arg2 instanceof RubyString) {
            RubyString str = (RubyString)arg2;
            return this.value.indexOf(str.value) != -1 ? str.strDup(runtime2) : runtime2.getNil();
        }
        if (arg2 instanceof RubyRange) {
            int[] begLen = ((RubyRange)arg2).begLenInt(this.value.length(), 0);
            return begLen == null ? runtime2.getNil() : this.substr(runtime2, begLen[0], begLen[1]);
        }
        return this.op_aref(runtime2, RubyFixnum.num2int(arg2));
    }

    private IRubyObject op_aref(Ruby runtime2, int idx) {
        if (idx < 0) {
            idx += this.value.getRealSize();
        }
        return idx < 0 || idx >= this.value.getRealSize() ? runtime2.getNil() : runtime2.newFixnum(this.value.get(idx) & 0xFF);
    }

    @JRubyMethod(name={"[]", "slice"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_aref19(ThreadContext context, IRubyObject arg1, IRubyObject arg2) {
        Ruby runtime2 = context.getRuntime();
        if (arg1 instanceof RubyRegexp) {
            return this.subpat19(runtime2, context, (RubyRegexp)arg1, arg2);
        }
        return this.substr19(runtime2, RubyNumeric.num2int(arg1), RubyNumeric.num2int(arg2));
    }

    @JRubyMethod(name={"[]", "slice"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_aref19(ThreadContext context, IRubyObject arg2) {
        Ruby runtime2 = context.getRuntime();
        if (arg2 instanceof RubyFixnum) {
            return this.op_aref19(runtime2, RubyNumeric.fix2int((RubyFixnum)arg2));
        }
        if (arg2 instanceof RubyRegexp) {
            return this.subpat19(runtime2, context, (RubyRegexp)arg2);
        }
        if (arg2 instanceof RubyString) {
            RubyString str = (RubyString)arg2;
            return this.strIndex19(str, 0) != -1 ? str.strDup(runtime2) : runtime2.getNil();
        }
        if (arg2 instanceof RubyRange) {
            int len = this.strLength();
            int[] begLen = ((RubyRange)arg2).begLenInt(len, 0);
            return begLen == null ? runtime2.getNil() : this.substr19(runtime2, begLen[0], begLen[1]);
        }
        return this.op_aref19(runtime2, RubyNumeric.num2int(arg2));
    }

    private IRubyObject op_aref19(Ruby runtime2, int idx) {
        IRubyObject str = this.substr19(runtime2, idx, 1);
        return !str.isNil() && ((RubyString)str).value.getRealSize() == 0 ? runtime2.getNil() : str;
    }

    private void subpatSet(ThreadContext context, RubyRegexp regexp2, int nth, IRubyObject repl) {
        int end2;
        int start2;
        Ruby runtime2 = context.getRuntime();
        if (regexp2.search(context, this, 0, false) < 0) {
            throw runtime2.newIndexError("regexp not matched");
        }
        RubyMatchData match2 = (RubyMatchData)context.getCurrentScope().getBackRef(runtime2);
        nth = this.subpatSetCheck(runtime2, nth, match2.regs);
        if (match2.regs == null) {
            start2 = match2.begin;
            end2 = match2.end;
        } else {
            start2 = match2.regs.beg[nth];
            end2 = match2.regs.end[nth];
        }
        if (start2 == -1) {
            throw runtime2.newIndexError("regexp group " + nth + " not matched");
        }
        this.replaceInternal(start2, end2 - start2, repl.convertToString());
    }

    private int subpatSetCheck(Ruby runtime2, int nth, Region regs) {
        int numRegs;
        int n = numRegs = regs == null ? 1 : regs.numRegs;
        if (nth < numRegs) {
            if (nth < 0) {
                if (-nth < numRegs) {
                    return nth + numRegs;
                }
            } else {
                return nth;
            }
        }
        throw runtime2.newIndexError("index " + nth + " out of regexp");
    }

    private IRubyObject subpat(Ruby runtime2, ThreadContext context, RubyRegexp regex, int nth) {
        if (regex.search(context, this, 0, false) >= 0) {
            return RubyRegexp.nth_match(nth, context.getCurrentScope().getBackRef(runtime2));
        }
        return runtime2.getNil();
    }

    private void subpatSet19(ThreadContext context, RubyRegexp regexp2, IRubyObject backref, IRubyObject repl) {
        int end2;
        int start2;
        int nth;
        Ruby runtime2 = context.getRuntime();
        if (regexp2.search19(context, this, 0, false) < 0) {
            throw runtime2.newIndexError("regexp not matched");
        }
        RubyMatchData match2 = (RubyMatchData)context.getCurrentScope().getBackRef(runtime2);
        int n = nth = backref == null ? 0 : this.subpatSetCheck(runtime2, match2.backrefNumber(backref), match2.regs);
        if (match2.regs == null) {
            start2 = match2.begin;
            end2 = match2.end;
        } else {
            start2 = match2.regs.beg[nth];
            end2 = match2.regs.end[nth];
        }
        if (start2 == -1) {
            throw runtime2.newIndexError("regexp group " + nth + " not matched");
        }
        RubyString replStr = repl.convertToString();
        Encoding enc = this.checkEncoding(replStr);
        this.replaceInternal(start2, end2 - start2, replStr);
        this.associateEncoding(enc);
    }

    private IRubyObject subpat19(Ruby runtime2, ThreadContext context, RubyRegexp regex, IRubyObject backref) {
        if (regex.search19(context, this, 0, false) >= 0) {
            RubyMatchData match2 = (RubyMatchData)context.getCurrentScope().getBackRef(runtime2);
            return RubyRegexp.nth_match(match2.backrefNumber(backref), context.getCurrentScope().getBackRef(runtime2));
        }
        return runtime2.getNil();
    }

    private IRubyObject subpat19(Ruby runtime2, ThreadContext context, RubyRegexp regex) {
        if (regex.search19(context, this, 0, false) >= 0) {
            return RubyRegexp.nth_match(0, context.getCurrentScope().getBackRef(runtime2));
        }
        return runtime2.getNil();
    }

    @JRubyMethod(name={"[]="}, reads={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_aset(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        if (arg0 instanceof RubyFixnum) {
            return this.op_aset(context, RubyNumeric.fix2int((RubyFixnum)arg0), arg1);
        }
        if (arg0 instanceof RubyRegexp) {
            this.subpatSet(context, (RubyRegexp)arg0, 0, arg1.convertToString());
            return arg1;
        }
        if (arg0 instanceof RubyString) {
            RubyString orig = (RubyString)arg0;
            int beg = this.value.indexOf(orig.value);
            if (beg < 0) {
                throw context.getRuntime().newIndexError("string not matched");
            }
            this.replaceInternal(beg, orig.value.getRealSize(), arg1.convertToString());
            return arg1;
        }
        if (arg0 instanceof RubyRange) {
            int[] begLen = ((RubyRange)arg0).begLenInt(this.value.getRealSize(), 2);
            this.replaceInternal(begLen[0], begLen[1], arg1.convertToString());
            return arg1;
        }
        return this.op_aset(context, RubyNumeric.num2int(arg0), arg1);
    }

    private IRubyObject op_aset(ThreadContext context, int idx, IRubyObject arg1) {
        idx = this.checkIndexForRef(idx, this.value.getRealSize());
        if (arg1 instanceof RubyFixnum) {
            this.modify();
            this.value.set(idx, RubyNumeric.fix2int((RubyFixnum)arg1));
        } else {
            this.replaceInternal(idx, 1, arg1.convertToString());
        }
        return arg1;
    }

    @JRubyMethod(name={"[]="}, reads={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_aset(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        if (arg0 instanceof RubyRegexp) {
            this.subpatSet(context, (RubyRegexp)arg0, RubyNumeric.num2int(arg1), arg2);
        } else {
            int beg = RubyNumeric.num2int(arg0);
            int len = RubyNumeric.num2int(arg1);
            this.checkLength(len);
            RubyString repl = arg2.convertToString();
            this.replaceInternal(this.checkIndex(beg, this.value.getRealSize()), len, repl);
        }
        return arg2;
    }

    @JRubyMethod(name={"[]="}, reads={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_aset19(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        if (arg0 instanceof RubyFixnum) {
            return this.op_aset19(context, RubyNumeric.fix2int((RubyFixnum)arg0), arg1);
        }
        if (arg0 instanceof RubyRegexp) {
            this.subpatSet19(context, (RubyRegexp)arg0, null, arg1);
            return arg1;
        }
        if (arg0 instanceof RubyString) {
            RubyString orig = (RubyString)arg0;
            int beg = this.strIndex19(orig, 0);
            if (beg < 0) {
                throw context.getRuntime().newIndexError("string not matched");
            }
            beg = this.subLength(beg);
            this.replaceInternal19(beg, orig.strLength(), arg1.convertToString());
            return arg1;
        }
        if (arg0 instanceof RubyRange) {
            int[] begLen = ((RubyRange)arg0).begLenInt(this.strLength(), 2);
            this.replaceInternal19(begLen[0], begLen[1], arg1.convertToString());
            return arg1;
        }
        return this.op_aset19(context, RubyNumeric.num2int(arg0), arg1);
    }

    private IRubyObject op_aset19(ThreadContext context, int idx, IRubyObject arg1) {
        this.replaceInternal19(this.checkIndex(idx, this.strLength()), 1, arg1.convertToString());
        return arg1;
    }

    @JRubyMethod(name={"[]="}, reads={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_aset19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        if (arg0 instanceof RubyRegexp) {
            this.subpatSet19(context, (RubyRegexp)arg0, arg1, arg2);
        } else {
            int beg = RubyNumeric.num2int(arg0);
            int len = RubyNumeric.num2int(arg1);
            this.checkLength(len);
            RubyString repl = arg2.convertToString();
            this.replaceInternal19(this.checkIndex(beg, this.strLength()), len, repl);
        }
        return arg2;
    }

    private final boolean isHeadSlice(int beg, int len) {
        return beg == 0 && len > 0 && len <= this.value.getRealSize();
    }

    private final boolean isTailSlice(int beg, int len) {
        return beg >= 0 && len > 0 && beg + len == this.value.getRealSize();
    }

    private final void exciseHead(int len) {
        this.view(len, this.value.getRealSize() - len);
    }

    private final void exciseTail(int len) {
        this.view(0, this.value.getRealSize() - len);
    }

    @JRubyMethod(name={"slice!"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject slice_bang(ThreadContext context, IRubyObject arg0) {
        IRubyObject result = this.op_aref(context, arg0);
        if (!result.isNil()) {
            int beg = -1;
            int len = 1;
            if (arg0 instanceof RubyFixnum) {
                beg = RubyNumeric.num2int(arg0);
            } else if (arg0 instanceof RubyRange) {
                int[] begLen = ((RubyRange)arg0).begLenInt(this.value.getRealSize(), 2);
                beg = begLen[0];
                len = begLen[1];
            }
            if (this.isHeadSlice(beg, len)) {
                this.exciseHead(len);
            } else if (this.isTailSlice(beg, len)) {
                this.exciseTail(len);
            } else {
                this.op_aset(context, arg0, (IRubyObject)RubyString.newEmptyString(context.getRuntime()));
            }
        }
        return result;
    }

    @JRubyMethod(name={"slice!"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject slice_bang(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        IRubyObject result = this.op_aref(context, arg0, arg1);
        if (!result.isNil()) {
            int beg = -1;
            int len = 0;
            if (arg0 instanceof RubyFixnum && arg1 instanceof RubyFixnum) {
                beg = RubyNumeric.num2int(arg0);
                len = RubyNumeric.num2int(arg1);
            }
            if (this.isHeadSlice(beg, len)) {
                this.exciseHead(len);
            } else if (this.isTailSlice(beg, len)) {
                this.exciseTail(len);
            } else {
                this.op_aset(context, arg0, arg1, RubyString.newEmptyString(context.getRuntime()));
            }
        }
        return result;
    }

    @JRubyMethod(name={"slice!"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject slice_bang19(ThreadContext context, IRubyObject arg0) {
        IRubyObject result = this.op_aref19(context, arg0);
        if (result.isNil()) {
            this.modifyCheck();
        } else {
            this.op_aset19(context, arg0, (IRubyObject)RubyString.newEmptyString(context.getRuntime()));
        }
        return result;
    }

    @JRubyMethod(name={"slice!"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject slice_bang19(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        IRubyObject result = this.op_aref19(context, arg0, arg1);
        if (result.isNil()) {
            this.modifyCheck();
        } else {
            this.op_aset19(context, arg0, arg1, RubyString.newEmptyString(context.getRuntime()));
        }
        return result;
    }

    @JRubyMethod(name={"succ", "next"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject succ(ThreadContext context) {
        RubyString str = this.strDup(context.getRuntime());
        str.succ_bang();
        return str;
    }

    @JRubyMethod(name={"succ!", "next!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject succ_bang() {
        int c;
        int i;
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return this;
        }
        this.modify();
        boolean alnumSeen = false;
        int pos2 = -1;
        int n = 0;
        int p2 = this.value.getBegin();
        int end2 = p2 + this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        for (i = end2 - 1; i >= p2; --i) {
            c = bytes2[i] & 0xFF;
            if (!ASCII.isAlnum(c)) continue;
            alnumSeen = true;
            if (ASCII.isDigit(c) && c < 57 || ASCII.isLower(c) && c < 122 || ASCII.isUpper(c) && c < 90) {
                bytes2[i] = (byte)(c + 1);
                pos2 = -1;
                break;
            }
            pos2 = i;
            int n2 = ASCII.isDigit(c) ? 49 : (n = ASCII.isLower(c) ? 97 : 65);
            bytes2[i] = ASCII.isDigit(c) ? 48 : (ASCII.isLower(c) ? 97 : 65);
        }
        if (!alnumSeen) {
            for (i = end2 - 1; i >= p2; --i) {
                c = bytes2[i] & 0xFF;
                if (c < 255) {
                    bytes2[i] = (byte)(c + 1);
                    pos2 = -1;
                    break;
                }
                pos2 = i;
                n = 1;
                bytes2[i] = 0;
            }
        }
        if (pos2 > -1) {
            this.value.insert(pos2, (byte)n);
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    private static NeighborChar succChar(Encoding enc, byte[] bytes, int p, int len) {
        while (true) lbl-1000:
        // 4 sources

        {
            for (i = len - 1; i >= 0 && bytes[p + i] == -1; --i) {
                bytes[p + i] = 0;
            }
            if (i < 0) {
                return NeighborChar.WRAPPED;
            }
            bytes[p + i] = (byte)((bytes[p + i] & 255) + 1);
            cl = StringSupport.preciseLength(enc, bytes, p, p + len);
            if (cl > 0) {
                if (cl == len) {
                    return NeighborChar.FOUND;
                }
                for (j = p + cl; j < p + len - cl; ++j) {
                    bytes[j] = -1;
                }
            }
            if (cl != -1 || i >= len - 1) ** continue;
            for (len2 = len - 1; len2 > 0 && StringSupport.preciseLength(enc, bytes, p, p + len2) == -1; --len2) {
            }
            j = p + len2 + 1;
            while (true) {
                if (j < p + len - (len2 + 1)) ** break;
                ** continue;
                bytes[j] = -1;
                ++j;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static NeighborChar predChar(Encoding enc, byte[] bytes, int p, int len) {
        while (true) lbl-1000:
        // 4 sources

        {
            for (i = len - 1; i >= 0 && bytes[p + i] == 0; --i) {
                bytes[p + i] = -1;
            }
            if (i < 0) {
                return NeighborChar.WRAPPED;
            }
            bytes[p + i] = (byte)((bytes[p + i] & 255) - 1);
            cl = StringSupport.preciseLength(enc, bytes, p, p + len);
            if (cl > 0) {
                if (cl == len) {
                    return NeighborChar.FOUND;
                }
                for (j = p + cl; j < p + len - cl; ++j) {
                    bytes[j] = 0;
                }
            }
            if (cl != -1 || i >= len - 1) ** continue;
            for (len2 = len - 1; len2 > 0 && StringSupport.preciseLength(enc, bytes, p, p + len2) == -1; --len2) {
            }
            j = p + len2 + 1;
            while (true) {
                if (j < p + len - (len2 + 1)) ** break;
                ** continue;
                bytes[j] = 0;
                ++j;
            }
            break;
        }
    }

    private static NeighborChar succAlnumChar(Encoding enc, byte[] bytes2, int p2, int len, byte[] carry, int carryP) {
        int cType;
        byte[] save = new byte[7];
        int c = enc.mbcToCode(bytes2, p2, p2 + len);
        if (enc.isDigit(c)) {
            cType = 4;
        } else if (enc.isAlpha(c)) {
            cType = 1;
        } else {
            return NeighborChar.NOT_CHAR;
        }
        System.arraycopy(bytes2, p2, save, 0, len);
        NeighborChar ret = RubyString.succChar(enc, bytes2, p2, len);
        if (ret == NeighborChar.FOUND && enc.isCodeCType(c = enc.mbcToCode(bytes2, p2, p2 + len), cType)) {
            return NeighborChar.FOUND;
        }
        System.arraycopy(save, 0, bytes2, p2, len);
        int range = 1;
        while (true) {
            System.arraycopy(bytes2, p2, save, 0, len);
            ret = RubyString.predChar(enc, bytes2, p2, len);
            if (ret == NeighborChar.FOUND) {
                c = enc.mbcToCode(bytes2, p2, p2 + len);
                if (!enc.isCodeCType(c, cType)) {
                    System.arraycopy(save, 0, bytes2, p2, len);
                    break;
                }
            } else {
                System.arraycopy(save, 0, bytes2, p2, len);
                break;
            }
            ++range;
        }
        if (range == 1) {
            return NeighborChar.NOT_CHAR;
        }
        if (cType != 4) {
            System.arraycopy(bytes2, p2, carry, carryP, len);
            return NeighborChar.WRAPPED;
        }
        System.arraycopy(bytes2, p2, carry, carryP, len);
        RubyString.succChar(enc, carry, carryP, len);
        return NeighborChar.WRAPPED;
    }

    @JRubyMethod(name={"succ", "next"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject succ19(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        RubyString str = this.value.getRealSize() > 0 ? new RubyString(runtime2, this.getMetaClass(), this.succCommon19(this.value)) : RubyString.newEmptyString(runtime2, this.value.getEncoding());
        return str.infectBy(this);
    }

    @JRubyMethod(name={"succ!", "next!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject succ_bang19() {
        this.modifyCheck();
        if (this.value.getRealSize() > 0) {
            this.value = this.succCommon19(this.value);
            this.shareLevel = 0;
        }
        return this;
    }

    private ByteList succCommon19(ByteList original) {
        int cl;
        int end2;
        byte[] carry = new byte[7];
        int carryP = 0;
        carry[0] = 1;
        int carryLen = 1;
        ByteList valueCopy = new ByteList(original);
        valueCopy.setEncoding(original.getEncoding());
        Encoding enc = original.getEncoding();
        int p2 = valueCopy.getBegin();
        int s = end2 = p2 + valueCopy.getRealSize();
        byte[] bytes2 = valueCopy.getUnsafeBytes();
        NeighborChar neighbor = NeighborChar.FOUND;
        int lastAlnum = -1;
        boolean alnumSeen = false;
        block5: while ((s = enc.prevCharHead(bytes2, p2, s, end2)) != -1) {
            if (neighbor == NeighborChar.NOT_CHAR && lastAlnum != -1 && (ASCII.isAlpha(bytes2[lastAlnum] & 0xFF) ? ASCII.isDigit(bytes2[s] & 0xFF) : ASCII.isDigit(bytes2[lastAlnum] & 0xFF) && ASCII.isAlpha(bytes2[s] & 0xFF))) {
                s = lastAlnum;
                break;
            }
            cl = StringSupport.preciseLength(enc, bytes2, s, end2);
            if (cl <= 0) continue;
            neighbor = RubyString.succAlnumChar(enc, bytes2, s, cl, carry, 0);
            switch (neighbor) {
                case NOT_CHAR: {
                    continue block5;
                }
                case FOUND: {
                    return valueCopy;
                }
                case WRAPPED: {
                    lastAlnum = s;
                }
            }
            alnumSeen = true;
            carryP = s - p2;
            carryLen = cl;
        }
        if (!alnumSeen) {
            s = end2;
            while ((s = enc.prevCharHead(bytes2, p2, s, end2)) != -1) {
                cl = StringSupport.preciseLength(enc, bytes2, s, end2);
                if (cl <= 0) continue;
                neighbor = RubyString.succChar(enc, bytes2, s, cl);
                if (neighbor == NeighborChar.FOUND) {
                    return valueCopy;
                }
                if (StringSupport.preciseLength(enc, bytes2, s, s + 1) != cl) {
                    RubyString.succChar(enc, bytes2, s, cl);
                }
                if (!enc.isAsciiCompatible()) {
                    System.arraycopy(bytes2, s, carry, 0, cl);
                    carryLen = cl;
                }
                carryP = s - p2;
            }
        }
        valueCopy.ensure(valueCopy.getBegin() + valueCopy.getRealSize() + carryLen);
        s = valueCopy.getBegin() + carryP;
        System.arraycopy(valueCopy.getUnsafeBytes(), s, valueCopy.getUnsafeBytes(), s + carryLen, valueCopy.getRealSize() - carryP);
        System.arraycopy(carry, 0, valueCopy.getUnsafeBytes(), s, carryLen);
        valueCopy.setRealSize(valueCopy.getRealSize() + carryLen);
        return valueCopy;
    }

    @JRubyMethod(name={"upto"}, frame=true, compat=CompatVersion.RUBY1_8)
    public IRubyObject upto18(ThreadContext context, IRubyObject end2, Block block) {
        return this.uptoCommon18(context, end2, false, block);
    }

    @JRubyMethod(name={"upto"}, frame=true, compat=CompatVersion.RUBY1_8)
    public IRubyObject upto18(ThreadContext context, IRubyObject end2, IRubyObject excl, Block block) {
        return this.uptoCommon18(context, end2, excl.isTrue(), block);
    }

    final IRubyObject uptoCommon18(ThreadContext context, IRubyObject arg2, boolean excl, Block block) {
        Ruby runtime2 = context.getRuntime();
        RubyString end2 = arg2.convertToString();
        Encoding enc = this.checkEncoding(end2);
        int n = this.op_cmp19(end2);
        if (n > 0 || excl && n == 0) {
            return this;
        }
        IRubyObject afterEnd = end2.callMethod(context, "succ");
        RubyString current2 = this;
        while (!current2.op_equal19(context, afterEnd).isTrue()) {
            block.yield(context, current2);
            if (!excl && current2.op_equal19(context, end2).isTrue()) break;
            current2 = current2.callMethod(context, "succ").convertToString();
            if ((!excl || !current2.op_equal19(context, end2).isTrue()) && current2.value.getRealSize() <= end2.value.getRealSize() && current2.value.getRealSize() != 0) continue;
            break;
        }
        return this;
    }

    @JRubyMethod(name={"upto"}, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject upto19(ThreadContext context, IRubyObject end2, Block block) {
        Ruby runtime2 = context.getRuntime();
        return block.isGiven() ? this.uptoCommon19(context, end2, false, block) : RubyEnumerator.enumeratorize(runtime2, (IRubyObject)this, "upto", end2);
    }

    @JRubyMethod(name={"upto"}, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject upto19(ThreadContext context, IRubyObject end2, IRubyObject excl, Block block) {
        return block.isGiven() ? this.uptoCommon19(context, end2, excl.isTrue(), block) : RubyEnumerator.enumeratorize(context.getRuntime(), (IRubyObject)this, "upto", new IRubyObject[]{end2, excl});
    }

    final IRubyObject uptoCommon19(ThreadContext context, IRubyObject arg2, boolean excl, Block block) {
        return this.uptoCommon19(context, arg2, excl, block, false);
    }

    final IRubyObject uptoCommon19(ThreadContext context, IRubyObject arg2, boolean excl, Block block, boolean asASymbol) {
        Ruby runtime2 = context.getRuntime();
        RubyString end2 = arg2.convertToString();
        Encoding enc = this.checkEncoding(end2);
        if (this.value.getRealSize() == 1 && end2.value.getRealSize() == 1 && this.scanForCodeRange() == 32 && end2.scanForCodeRange() == 32) {
            byte e;
            byte c = this.value.getUnsafeBytes()[this.value.getBegin()];
            if (c > (e = end2.value.getUnsafeBytes()[end2.value.getBegin()]) || excl && c == e) {
                return this;
            }
            do {
                RubyString s = new RubyString(runtime2, runtime2.getString(), RubyInteger.SINGLE_CHAR_BYTELISTS[c & 0xFF], enc, 32);
                s.shareLevel = 2;
                RubyObject argument = s;
                if (asASymbol) {
                    argument = runtime2.newSymbol(s.toString());
                }
                block.yield(context, argument);
                if (!excl && c == e) break;
                c = (byte)(c + 1);
            } while (!excl || c != e);
        } else {
            int n = this.op_cmp19(end2);
            if (n > 0 || excl && n == 0) {
                return this;
            }
            IRubyObject afterEnd = end2.callMethod(context, "succ");
            RubyString current2 = this;
            while (!current2.op_equal19(context, afterEnd).isTrue()) {
                RubyObject argument = current2;
                if (asASymbol) {
                    argument = runtime2.newSymbol(current2.toString());
                }
                block.yield(context, argument);
                if (!excl && current2.op_equal19(context, end2).isTrue()) break;
                current2 = current2.callMethod(context, "succ").convertToString();
                if ((!excl || !current2.op_equal19(context, end2).isTrue()) && current2.value.getRealSize() <= end2.value.getRealSize() && current2.value.getRealSize() != 0) continue;
                break;
            }
        }
        return this;
    }

    @JRubyMethod(name={"include?"}, compat=CompatVersion.RUBY1_8)
    public RubyBoolean include_p(ThreadContext context, IRubyObject obj) {
        Ruby runtime2 = context.getRuntime();
        if (obj instanceof RubyFixnum) {
            int c = RubyNumeric.fix2int((RubyFixnum)obj);
            for (int i = 0; i < this.value.getRealSize(); ++i) {
                if (this.value.get(i) != (byte)c) continue;
                return runtime2.getTrue();
            }
            return runtime2.getFalse();
        }
        return this.value.indexOf(obj.convertToString().value) == -1 ? runtime2.getFalse() : runtime2.getTrue();
    }

    @JRubyMethod(name={"include?"}, compat=CompatVersion.RUBY1_9)
    public RubyBoolean include_p19(ThreadContext context, IRubyObject obj) {
        Ruby runtime2 = context.getRuntime();
        return this.strIndex19(obj.convertToString(), 0) == -1 ? runtime2.getFalse() : runtime2.getTrue();
    }

    @JRubyMethod(name={"chr"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject chr(ThreadContext context) {
        return this.substr19(context.getRuntime(), 0, 1);
    }

    @JRubyMethod(name={"getbyte"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject getbyte(ThreadContext context, IRubyObject index2) {
        Ruby runtime2 = context.getRuntime();
        int i = RubyNumeric.num2int(index2);
        if (i < 0) {
            i += this.value.getRealSize();
        }
        if (i < 0 || i >= this.value.getRealSize()) {
            return runtime2.getNil();
        }
        return RubyFixnum.newFixnum(runtime2, this.value.getUnsafeBytes()[this.value.getBegin() + i] & 0xFF);
    }

    @JRubyMethod(name={"setbyte"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject setbyte(ThreadContext context, IRubyObject index2, IRubyObject val) {
        int i = RubyNumeric.num2int(index2);
        int b = RubyNumeric.num2int(val);
        this.value.getUnsafeBytes()[this.checkIndexForRef((int)i, (int)this.value.getRealSize())] = (byte)b;
        return val;
    }

    @JRubyMethod(name={"to_i"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject to_i() {
        return this.stringToInum(10, false);
    }

    @JRubyMethod(name={"to_i"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject to_i(IRubyObject arg0) {
        long base = this.checkBase(arg0);
        return this.stringToInum((int)base, false);
    }

    @JRubyMethod(name={"to_i"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_i19() {
        return this.stringToInum19(10, false);
    }

    @JRubyMethod(name={"to_i"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_i19(IRubyObject arg0) {
        long base = this.checkBase(arg0);
        return this.stringToInum19((int)base, false);
    }

    private long checkBase(IRubyObject arg0) {
        long base = arg0.convertToInteger().getLongValue();
        if (base < 0L) {
            throw this.getRuntime().newArgumentError("illegal radix " + base);
        }
        return base;
    }

    public IRubyObject stringToInum(int base, boolean badcheck) {
        ByteList s = this.value;
        return ConvertBytes.byteListToInum(this.getRuntime(), s, base, badcheck);
    }

    public IRubyObject stringToInum19(int base, boolean badcheck) {
        ByteList s = this.value;
        return ConvertBytes.byteListToInum19(this.getRuntime(), s, base, badcheck);
    }

    @JRubyMethod(name={"oct"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject oct(ThreadContext context) {
        return this.stringToInum(-8, false);
    }

    @JRubyMethod(name={"oct"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject oct19(ThreadContext context) {
        if (!this.value.getEncoding().isAsciiCompatible()) {
            throw context.getRuntime().newEncodingCompatibilityError("ASCII incompatible encoding: " + this.value.getEncoding());
        }
        return this.oct(context);
    }

    @JRubyMethod(name={"hex"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject hex(ThreadContext context) {
        return this.stringToInum(16, false);
    }

    @JRubyMethod(name={"hex"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject hex19(ThreadContext context) {
        if (!this.value.getEncoding().isAsciiCompatible()) {
            throw context.getRuntime().newEncodingCompatibilityError("ASCII incompatible encoding: " + this.value.getEncoding());
        }
        return this.stringToInum19(16, false);
    }

    @JRubyMethod(name={"to_f"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject to_f() {
        return RubyNumeric.str2fnum(this.getRuntime(), this);
    }

    @JRubyMethod(name={"to_f"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_f19() {
        return RubyNumeric.str2fnum19(this.getRuntime(), this, false);
    }

    @JRubyMethod(name={"split"}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public RubyArray split(ThreadContext context) {
        return this.split(context, context.getRuntime().getNil());
    }

    @JRubyMethod(name={"split"}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public RubyArray split(ThreadContext context, IRubyObject arg0) {
        return this.splitCommon(arg0, false, 0, 0, context);
    }

    @JRubyMethod(name={"split"}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public RubyArray split(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        int lim = RubyNumeric.num2int(arg1);
        if (lim <= 0) {
            return this.splitCommon(arg0, false, lim, 1, context);
        }
        if (lim == 1) {
            return this.value.getRealSize() == 0 ? context.getRuntime().newArray() : context.getRuntime().newArray((IRubyObject)this);
        }
        return this.splitCommon(arg0, true, lim, 1, context);
    }

    private RubyArray splitCommon(IRubyObject spat, boolean limit2, int lim, int i, ThreadContext context) {
        RubyArray result;
        if (spat.isNil() && (spat = context.getRuntime().getGlobalVariables().get("$;")).isNil()) {
            result = this.awkSplit(limit2, lim, i);
        } else if (spat instanceof RubyString && ((RubyString)spat).value.getRealSize() == 1) {
            RubyString strSpat = (RubyString)spat;
            result = strSpat.value.getUnsafeBytes()[strSpat.value.getBegin()] == 32 ? this.awkSplit(limit2, lim, i) : this.regexSplit(context, spat, limit2, lim, i);
        } else {
            result = this.regexSplit(context, spat, limit2, lim, i);
        }
        if (!limit2 && lim == 0) {
            while (result.size() > 0 && ((RubyString)result.eltInternal((int)(result.size() - 1))).value.getRealSize() == 0) {
                result.pop(context);
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private RubyArray regexSplit(ThreadContext context, IRubyObject pat, boolean limit2, int lim, int i) {
        int end2;
        Ruby runtime2 = context.getRuntime();
        Regex pattern = this.getQuotedPattern(pat);
        int begin2 = this.value.getBegin();
        int len = this.value.getRealSize();
        int range = begin2 + len;
        byte[] bytes2 = this.value.getUnsafeBytes();
        Matcher matcher = pattern.matcher(bytes2, begin2, range);
        RubyArray result = runtime2.newArray();
        Encoding enc = pattern.getEncoding();
        boolean captures2 = pattern.numberOfCaptures() != 0;
        int beg = 0;
        boolean lastNull = false;
        int start2 = begin2;
        while ((end2 = matcher.search(start2, range, 0)) >= 0) {
            block7: {
                if (start2 == end2 + begin2 && matcher.getBegin() == matcher.getEnd()) {
                    if (len == 0) {
                        result.append(RubyString.newEmptyString(runtime2, this.getMetaClass()));
                        break;
                    }
                    if (lastNull) {
                        result.append(this.makeShared(runtime2, beg, enc.length(bytes2, begin2 + beg, range)));
                        beg = start2 - begin2;
                        break block7;
                    } else {
                        start2 += start2 == range ? 1 : enc.length(bytes2, start2, range);
                        lastNull = true;
                        continue;
                    }
                }
                result.append(this.makeShared(runtime2, beg, end2 - beg));
                beg = matcher.getEnd();
                start2 = begin2 + beg;
            }
            lastNull = false;
            if (captures2) {
                this.populateCapturesForSplit(runtime2, result, matcher, false);
            }
            if (!limit2 || lim > ++i) continue;
        }
        context.getCurrentScope().setBackRef(runtime2.getNil());
        if (len > 0 && (limit2 || len > beg || lim < 0)) {
            result.append(this.makeShared(runtime2, beg, len - beg));
        }
        return result;
    }

    private void populateCapturesForSplit(Ruby runtime2, RubyArray result, Matcher matcher, boolean is19) {
        Region region = matcher.getRegion();
        for (int i = 1; i < region.numRegs; ++i) {
            int beg = region.beg[i];
            if (beg == -1) continue;
            result.append(is19 ? this.makeShared19(runtime2, beg, region.end[i] - beg) : this.makeShared(runtime2, beg, region.end[i] - beg));
        }
    }

    private RubyArray awkSplit(boolean limit2, int lim, int i) {
        Ruby runtime2 = this.getRuntime();
        RubyArray result = runtime2.newArray();
        byte[] bytes2 = this.value.getUnsafeBytes();
        int p2 = this.value.getBegin();
        int len = this.value.getRealSize();
        int end2 = p2 + len;
        boolean skip2 = true;
        int e = 0;
        int b = 0;
        while (p2 < end2) {
            int c = bytes2[p2++] & 0xFF;
            if (skip2) {
                if (ASCII.isSpace(c)) {
                    ++b;
                    continue;
                }
                e = b + 1;
                skip2 = false;
                if (!limit2 || lim > i) continue;
                break;
            }
            if (ASCII.isSpace(c)) {
                result.append(this.makeShared(runtime2, b, e - b));
                skip2 = true;
                b = e + 1;
                if (!limit2) continue;
                ++i;
                continue;
            }
            ++e;
        }
        if (len > 0 && (limit2 || len > b || lim < 0)) {
            result.append(this.makeShared(runtime2, b, len - b));
        }
        return result;
    }

    @JRubyMethod(name={"split"}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public RubyArray split19(ThreadContext context) {
        return this.split19(context, context.getRuntime().getNil());
    }

    @JRubyMethod(name={"split"}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public RubyArray split19(ThreadContext context, IRubyObject arg0) {
        return this.splitCommon19(arg0, false, 0, 0, context);
    }

    @JRubyMethod(name={"split"}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public RubyArray split19(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        int lim = RubyNumeric.num2int(arg1);
        if (lim <= 0) {
            return this.splitCommon19(arg0, false, lim, 1, context);
        }
        if (lim == 1) {
            return this.value.getRealSize() == 0 ? context.getRuntime().newArray() : context.getRuntime().newArray((IRubyObject)this);
        }
        return this.splitCommon19(arg0, true, lim, 1, context);
    }

    private RubyArray splitCommon19(IRubyObject spat, boolean limit2, int lim, int i, ThreadContext context) {
        RubyArray result;
        if (spat.isNil() && (spat = context.getRuntime().getGlobalVariables().get("$;")).isNil()) {
            result = this.awkSplit19(limit2, lim, i);
        } else if (spat instanceof RubyString) {
            ByteList spatValue = ((RubyString)spat).value;
            int len = spatValue.getRealSize();
            Encoding spatEnc = spatValue.getEncoding();
            if (len == 0) {
                Regex pattern = RubyRegexp.getRegexpFromCache(context.getRuntime(), spatValue, spatEnc, 0);
                result = this.regexSplit19(context, pattern, pattern, limit2, lim, i);
            } else {
                byte[] bytes2 = spatValue.getUnsafeBytes();
                int p2 = spatValue.getBegin();
                int c = spatEnc.isAsciiCompatible() ? (len == 1 ? bytes2[p2] & 0xFF : -1) : (len == StringSupport.preciseLength(spatEnc, bytes2, p2, p2 + len) ? spatEnc.mbcToCode(bytes2, p2, p2 + len) : -1);
                result = c == 32 ? this.awkSplit19(limit2, lim, i) : this.stringSplit19(context, (RubyString)spat, limit2, lim, i);
            }
        } else {
            Regex prepared;
            Regex pattern;
            RubyRegexp regexp2;
            Ruby runtime2 = context.getRuntime();
            if (spat instanceof RubyRegexp) {
                regexp2 = (RubyRegexp)spat;
                pattern = regexp2.getPattern();
                prepared = regexp2.preparePattern(this);
            } else {
                regexp2 = null;
                pattern = this.getStringPattern19(runtime2, spat);
                prepared = RubyRegexp.preparePattern(runtime2, pattern, this);
            }
            result = this.regexSplit19(context, pattern, prepared, limit2, lim, i);
        }
        if (!limit2 && lim == 0) {
            while (result.size() > 0 && ((RubyString)result.eltInternal((int)(result.size() - 1))).value.getRealSize() == 0) {
                result.pop(context);
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private RubyArray regexSplit19(ThreadContext context, Regex pattern, Regex prepared, boolean limit2, int lim, int i) {
        int end2;
        Ruby runtime2 = context.getRuntime();
        int begin2 = this.value.getBegin();
        int len = this.value.getRealSize();
        int range = begin2 + len;
        byte[] bytes2 = this.value.getUnsafeBytes();
        Matcher matcher = prepared.matcher(bytes2, begin2, range);
        RubyArray result = runtime2.newArray();
        Encoding enc = this.value.getEncoding();
        boolean captures2 = pattern.numberOfCaptures() != 0;
        int beg = 0;
        boolean lastNull = false;
        int start2 = begin2;
        while ((end2 = matcher.search(start2, range, 0)) >= 0) {
            block7: {
                if (start2 == end2 + begin2 && matcher.getBegin() == matcher.getEnd()) {
                    if (len == 0) {
                        result.append(RubyString.newEmptyString(runtime2, this.getMetaClass()));
                        break;
                    }
                    if (lastNull) {
                        result.append(this.makeShared19(runtime2, beg, StringSupport.length(enc, bytes2, begin2 + beg, range)));
                        beg = start2 - begin2;
                        break block7;
                    } else {
                        start2 += start2 == range ? 1 : StringSupport.length(enc, bytes2, start2, range);
                        lastNull = true;
                        continue;
                    }
                }
                result.append(this.makeShared19(runtime2, beg, end2 - beg));
                beg = matcher.getEnd();
                start2 = begin2 + beg;
            }
            lastNull = false;
            if (captures2) {
                this.populateCapturesForSplit(runtime2, result, matcher, true);
            }
            if (!limit2 || lim > ++i) continue;
        }
        context.getCurrentScope().setBackRef(runtime2.getNil());
        if (len > 0 && (limit2 || len > beg || lim < 0)) {
            result.append(this.makeShared19(runtime2, beg, len - beg));
        }
        return result;
    }

    private RubyArray awkSplit19(boolean limit2, int lim, int i) {
        int p2;
        Ruby runtime2 = this.getRuntime();
        RubyArray result = runtime2.newArray();
        byte[] bytes2 = this.value.getUnsafeBytes();
        int ptr = p2 = this.value.getBegin();
        int len = this.value.getRealSize();
        int end2 = p2 + len;
        Encoding enc = this.value.getEncoding();
        boolean skip2 = true;
        int e = 0;
        int b = 0;
        boolean singlebyte = this.singleByteOptimizable(enc);
        while (p2 < end2) {
            int c;
            if (singlebyte) {
                c = bytes2[p2++] & 0xFF;
            } else {
                c = StringSupport.codePoint(runtime2, enc, bytes2, p2, end2);
                p2 += StringSupport.length(enc, bytes2, p2, end2);
            }
            if (skip2) {
                if (enc.isSpace(c)) {
                    b = p2 - ptr;
                    continue;
                }
                e = p2 - ptr;
                skip2 = false;
                if (!limit2 || lim > i) continue;
                break;
            }
            if (enc.isSpace(c)) {
                result.append(this.makeShared19(runtime2, b, e - b));
                skip2 = true;
                b = p2 - ptr;
                if (!limit2) continue;
                ++i;
                continue;
            }
            e = p2 - ptr;
        }
        if (len > 0 && (limit2 || len > b || lim < 0)) {
            result.append(this.makeShared19(runtime2, b, len - b));
        }
        return result;
    }

    private RubyArray stringSplit19(ThreadContext context, RubyString spat, boolean limit2, int lim, int i) {
        int e;
        Ruby runtime2 = context.getRuntime();
        if (this.scanForCodeRange() == 96) {
            throw runtime2.newArgumentError("invalid byte sequence in " + this.value.getEncoding());
        }
        if (spat.scanForCodeRange() == 96) {
            throw runtime2.newArgumentError("invalid byte sequence in " + spat.value.getEncoding());
        }
        RubyArray result = runtime2.newArray();
        Encoding enc = this.checkEncoding(spat);
        ByteList pattern = spat.value;
        int p2 = 0;
        while (p2 < this.value.getRealSize() && (e = this.value.indexOf(pattern, p2)) >= 0) {
            int t = enc.rightAdjustCharHead(this.value.getUnsafeBytes(), p2 + this.value.getBegin(), e, p2 + this.value.getRealSize());
            if (t != e) {
                p2 = t;
                continue;
            }
            result.append(this.makeShared19(runtime2, p2, e - p2));
            p2 = e + pattern.getRealSize();
            if (!limit2 || lim > ++i) continue;
            break;
        }
        if (this.value.getRealSize() > 0 && (limit2 || this.value.getRealSize() > p2 || lim < 0)) {
            result.append(this.makeShared19(runtime2, p2, this.value.getRealSize() - p2));
        }
        return result;
    }

    private RubyString getStringForPattern(IRubyObject obj) {
        if (obj instanceof RubyString) {
            return (RubyString)obj;
        }
        IRubyObject val = obj.checkStringType();
        if (val.isNil()) {
            throw this.getRuntime().newTypeError("wrong argument type " + obj.getMetaClass() + " (expected Regexp)");
        }
        return (RubyString)val;
    }

    private RubyRegexp getPattern(IRubyObject obj) {
        if (obj instanceof RubyRegexp) {
            return (RubyRegexp)obj;
        }
        return RubyRegexp.newRegexp(this.getRuntime(), this.getStringForPattern((IRubyObject)obj).value);
    }

    private Regex getQuotedPattern(IRubyObject obj) {
        if (obj instanceof RubyRegexp) {
            return ((RubyRegexp)obj).getPattern();
        }
        Ruby runtime2 = this.getRuntime();
        return RubyRegexp.getQuotedRegexpFromCache(runtime2, this.getStringForPattern((IRubyObject)obj).value, runtime2.getKCode().getEncoding(), 0);
    }

    private Regex getStringPattern(Ruby runtime2, Encoding enc, IRubyObject obj) {
        return RubyRegexp.getQuotedRegexpFromCache(runtime2, this.getStringForPattern((IRubyObject)obj).value, enc, 0);
    }

    private Regex getStringPattern19(Ruby runtime2, IRubyObject obj) {
        RubyString str = this.getStringForPattern(obj);
        if (str.scanForCodeRange() == 96) {
            throw runtime2.newRegexpError("invalid multybyte character: " + RubyRegexp.regexpDescription19(runtime2, str.value, 0, str.value.getEncoding()).toString());
        }
        if (str.value.getEncoding().isDummy()) {
            throw runtime2.newArgumentError("can't make regexp with dummy encoding");
        }
        return RubyRegexp.getQuotedRegexpFromCache19(runtime2, str.value, 0, str.isAsciiOnly());
    }

    @JRubyMethod(name={"scan"}, required=1, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_8)
    public IRubyObject scan(ThreadContext context, IRubyObject arg2, Block block) {
        int tuFlags;
        Regex pattern;
        Ruby runtime2 = context.getRuntime();
        Encoding enc = runtime2.getKCode().getEncoding();
        if (arg2 instanceof RubyRegexp) {
            RubyRegexp regex = (RubyRegexp)arg2;
            pattern = regex.getPattern();
            tuFlags = regex.flags;
        } else {
            pattern = this.getStringPattern(runtime2, enc, arg2);
            tuFlags = 0;
        }
        int begin2 = this.value.getBegin();
        int range = begin2 + this.value.getRealSize();
        Matcher matcher = pattern.matcher(this.value.getUnsafeBytes(), begin2, range);
        if (block.isGiven()) {
            return this.scanIter(context, pattern, matcher, enc, block, begin2, range, tuFlags);
        }
        return this.scanNoIter(context, pattern, matcher, enc, begin2, range, tuFlags);
    }

    private IRubyObject scanIter(ThreadContext context, Regex pattern, Matcher matcher, Encoding enc, Block block, int begin2, int range, int tuFlags) {
        Ruby runtime2 = context.getRuntime();
        byte[] bytes2 = this.value.getUnsafeBytes();
        int size2 = this.value.getRealSize();
        IRubyObject match2 = null;
        DynamicScope scope = context.getCurrentScope();
        int end2 = 0;
        if (pattern.numberOfCaptures() == 0) {
            while (matcher.search(begin2 + end2, range, 0) >= 0) {
                end2 = this.positionEnd(matcher, enc, begin2, range);
                match2 = RubyRegexp.updateBackRef(context, this, scope, matcher, pattern);
                RubyString substr = this.makeShared(runtime2, matcher.getBegin(), matcher.getEnd() - matcher.getBegin());
                substr.infectBy(tuFlags);
                ((RubyBasicObject)match2).infectBy(tuFlags);
                block.yield(context, substr);
                this.modifyCheck(bytes2, size2);
            }
        } else {
            while (matcher.search(begin2 + end2, range, 0) >= 0) {
                end2 = this.positionEnd(matcher, enc, begin2, range);
                match2 = RubyRegexp.updateBackRef(context, this, scope, matcher, pattern);
                ((RubyBasicObject)match2).infectBy(tuFlags);
                block.yield(context, this.populateCapturesForScan(runtime2, matcher, range, tuFlags, false));
                this.modifyCheck(bytes2, size2);
            }
        }
        scope.setBackRef(match2 == null ? runtime2.getNil() : match2);
        return this;
    }

    private IRubyObject scanNoIter(ThreadContext context, Regex pattern, Matcher matcher, Encoding enc, int begin2, int range, int tuFlags) {
        Ruby runtime2 = context.getRuntime();
        RubyArray ary = runtime2.newArray();
        int end2 = 0;
        if (pattern.numberOfCaptures() == 0) {
            while (matcher.search(begin2 + end2, range, 0) >= 0) {
                end2 = this.positionEnd(matcher, enc, begin2, range);
                RubyString substr = this.makeShared(runtime2, matcher.getBegin(), matcher.getEnd() - matcher.getBegin());
                substr.infectBy(tuFlags);
                ary.append(substr);
            }
        } else {
            while (matcher.search(begin2 + end2, range, 0) >= 0) {
                end2 = this.positionEnd(matcher, enc, begin2, range);
                ary.append(this.populateCapturesForScan(runtime2, matcher, range, tuFlags, false));
            }
        }
        DynamicScope scope = context.getCurrentScope();
        if (ary.size() > 0) {
            RubyMatchData match2 = RubyRegexp.updateBackRef(context, this, scope, matcher, pattern);
            match2.infectBy(tuFlags);
        } else {
            scope.setBackRef(runtime2.getNil());
        }
        return ary;
    }

    private int positionEnd(Matcher matcher, Encoding enc, int begin2, int range) {
        int end2 = matcher.getEnd();
        if (matcher.getBegin() == end2) {
            if (this.value.getRealSize() > end2) {
                return end2 + enc.length(this.value.getUnsafeBytes(), begin2 + end2, range);
            }
            return end2 + 1;
        }
        return end2;
    }

    private IRubyObject populateCapturesForScan(Ruby runtime2, Matcher matcher, int range, int tuFlags, boolean is19) {
        Region region = matcher.getRegion();
        RubyArray result = this.getRuntime().newArray(region.numRegs);
        for (int i = 1; i < region.numRegs; ++i) {
            int beg = region.beg[i];
            if (beg == -1) {
                result.append(runtime2.getNil());
                continue;
            }
            RubyString substr = is19 ? this.makeShared19(runtime2, beg, region.end[i] - beg) : this.makeShared(runtime2, beg, region.end[i] - beg);
            substr.infectBy(tuFlags);
            result.append(substr);
        }
        return result;
    }

    @JRubyMethod(name={"scan"}, required=1, frame=true, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject scan19(ThreadContext context, IRubyObject arg2, Block block) {
        Regex prepared;
        Regex pattern;
        int tuFlags;
        RubyRegexp regexp2;
        Ruby runtime2 = context.getRuntime();
        Encoding enc = this.value.getEncoding();
        if (arg2 instanceof RubyRegexp) {
            regexp2 = (RubyRegexp)arg2;
            tuFlags = regexp2.flags;
            pattern = regexp2.getPattern();
            prepared = regexp2.preparePattern(this);
        } else {
            regexp2 = null;
            tuFlags = 0;
            pattern = this.getStringPattern19(runtime2, arg2);
            prepared = RubyRegexp.preparePattern(runtime2, pattern, this);
        }
        if (block.isGiven()) {
            return this.scanIter19(context, pattern, prepared, enc, block, regexp2, tuFlags);
        }
        return this.scanNoIter19(context, pattern, prepared, enc, regexp2, tuFlags);
    }

    private IRubyObject scanIter19(ThreadContext context, Regex pattern, Regex prepared, Encoding enc, Block block, RubyRegexp regexp2, int tuFlags) {
        Ruby runtime2 = context.getRuntime();
        byte[] bytes2 = this.value.getUnsafeBytes();
        int begin2 = this.value.getBegin();
        int len = this.value.getRealSize();
        int range = begin2 + len;
        Matcher matcher = prepared.matcher(bytes2, begin2, range);
        DynamicScope scope = context.getCurrentScope();
        int end2 = 0;
        IRubyObject match2 = null;
        if (pattern.numberOfCaptures() == 0) {
            while (matcher.search(begin2 + end2, range, 0) >= 0) {
                end2 = this.positionEnd(matcher, enc, begin2, range);
                match2 = RubyRegexp.updateBackRef19(context, this, scope, matcher, pattern);
                ((RubyMatchData)match2).regexp = regexp2;
                RubyString substr = this.makeShared19(runtime2, matcher.getBegin(), matcher.getEnd() - matcher.getBegin());
                substr.infectBy(tuFlags);
                ((RubyBasicObject)match2).infectBy(tuFlags);
                block.yield(context, substr);
                this.modifyCheck(bytes2, len, enc);
            }
        } else {
            while (matcher.search(begin2 + end2, range, 0) >= 0) {
                end2 = this.positionEnd(matcher, enc, begin2, range);
                match2 = RubyRegexp.updateBackRef19(context, this, scope, matcher, pattern);
                ((RubyMatchData)match2).regexp = regexp2;
                ((RubyBasicObject)match2).infectBy(tuFlags);
                block.yield(context, this.populateCapturesForScan(runtime2, matcher, range, tuFlags, true));
                this.modifyCheck(bytes2, len, enc);
            }
        }
        scope.setBackRef(match2 == null ? runtime2.getNil() : match2);
        return this;
    }

    private IRubyObject scanNoIter19(ThreadContext context, Regex pattern, Regex prepared, Encoding enc, RubyRegexp regexp2, int tuFlags) {
        Ruby runtime2 = context.getRuntime();
        byte[] bytes2 = this.value.getUnsafeBytes();
        int begin2 = this.value.getBegin();
        int range = begin2 + this.value.getRealSize();
        Matcher matcher = prepared.matcher(bytes2, begin2, range);
        RubyArray ary = runtime2.newArray();
        int end2 = 0;
        if (pattern.numberOfCaptures() == 0) {
            while (matcher.search(begin2 + end2, range, 0) >= 0) {
                end2 = this.positionEnd(matcher, enc, begin2, range);
                RubyString substr = this.makeShared19(runtime2, matcher.getBegin(), matcher.getEnd() - matcher.getBegin());
                substr.infectBy(tuFlags);
                ary.append(substr);
            }
        } else {
            while (matcher.search(begin2 + end2, range, 0) >= 0) {
                end2 = this.positionEnd(matcher, enc, begin2, range);
                ary.append(this.populateCapturesForScan(runtime2, matcher, range, tuFlags, true));
            }
        }
        DynamicScope scope = context.getCurrentScope();
        if (ary.size() > 0) {
            RubyMatchData match2 = RubyRegexp.updateBackRef19(context, this, scope, matcher, pattern);
            match2.regexp = regexp2;
            match2.infectBy(tuFlags);
        } else {
            scope.setBackRef(runtime2.getNil());
        }
        return ary;
    }

    @JRubyMethod(name={"start_with?"})
    public IRubyObject start_with_p(ThreadContext context) {
        return context.getRuntime().getFalse();
    }

    @JRubyMethod(name={"start_with?"})
    public IRubyObject start_with_p(ThreadContext context, IRubyObject arg2) {
        return this.start_with_pCommon(arg2) ? context.getRuntime().getTrue() : context.getRuntime().getFalse();
    }

    @JRubyMethod(name={"start_with?"}, rest=true)
    public IRubyObject start_with_p(ThreadContext context, IRubyObject[] args2) {
        for (int i = 0; i < args2.length; ++i) {
            if (!this.start_with_pCommon(args2[i])) continue;
            return context.getRuntime().getTrue();
        }
        return context.getRuntime().getFalse();
    }

    private boolean start_with_pCommon(IRubyObject arg2) {
        IRubyObject tmp = arg2.checkStringType();
        if (tmp.isNil()) {
            return false;
        }
        RubyString otherString = (RubyString)tmp;
        this.checkEncoding(otherString);
        if (this.value.getRealSize() < otherString.value.getRealSize()) {
            return false;
        }
        return this.value.startsWith(otherString.value);
    }

    @JRubyMethod(name={"end_with?"})
    public IRubyObject end_with_p(ThreadContext context) {
        return context.getRuntime().getFalse();
    }

    @JRubyMethod(name={"end_with?"})
    public IRubyObject end_with_p(ThreadContext context, IRubyObject arg2) {
        return this.end_with_pCommon(arg2) ? context.getRuntime().getTrue() : context.getRuntime().getFalse();
    }

    @JRubyMethod(name={"end_with?"}, rest=true)
    public IRubyObject end_with_p(ThreadContext context, IRubyObject[] args2) {
        for (int i = 0; i < args2.length; ++i) {
            if (!this.end_with_pCommon(args2[i])) continue;
            return context.getRuntime().getTrue();
        }
        return context.getRuntime().getFalse();
    }

    private boolean end_with_pCommon(IRubyObject arg2) {
        IRubyObject tmp = arg2.checkStringType();
        if (tmp.isNil()) {
            return false;
        }
        RubyString otherString = (RubyString)tmp;
        Encoding enc = this.checkEncoding(otherString);
        if (this.value.getRealSize() < otherString.value.getRealSize()) {
            return false;
        }
        int p2 = this.value.getBegin();
        int end2 = p2 + this.value.getRealSize();
        int s = end2 - otherString.value.getRealSize();
        if (enc.leftAdjustCharHead(this.value.getUnsafeBytes(), p2, s, end2) != s) {
            return false;
        }
        return this.value.endsWith(otherString.value);
    }

    private IRubyObject justify(IRubyObject arg0, int jflag) {
        Ruby runtime2 = this.getRuntime();
        return this.justifyCommon(runtime2, SPACE_BYTELIST, RubyFixnum.num2int(arg0), jflag);
    }

    private IRubyObject justify(IRubyObject arg0, IRubyObject arg1, int jflag) {
        Ruby runtime2 = this.getRuntime();
        RubyString padStr = arg1.convertToString();
        ByteList pad = padStr.value;
        if (pad.getRealSize() == 0) {
            throw runtime2.newArgumentError("zero width padding");
        }
        return this.justifyCommon(runtime2, pad, RubyFixnum.num2int(arg0), jflag).infectBy(padStr);
    }

    private RubyString justifyCommon(Ruby runtime2, ByteList pad, int width, int jflag) {
        if (width < 0 || this.value.getRealSize() >= width) {
            return this.strDup(runtime2);
        }
        ByteList res = new ByteList(width);
        res.setRealSize(width);
        int padP = pad.getBegin();
        int padLen = pad.getRealSize();
        byte[] padBytes = pad.getUnsafeBytes();
        int p2 = res.getBegin();
        byte[] bytes2 = res.getUnsafeBytes();
        if (jflag != 108) {
            int n = width - this.value.getRealSize();
            int end2 = p2 + (jflag == 114 ? n : n / 2);
            if (padLen <= 1) {
                while (p2 < end2) {
                    bytes2[p2++] = padBytes[padP];
                }
            } else {
                int q = padP;
                while (p2 + padLen <= end2) {
                    System.arraycopy(padBytes, padP, bytes2, p2, padLen);
                    p2 += padLen;
                }
                while (p2 < end2) {
                    bytes2[p2++] = padBytes[q++];
                }
            }
        }
        System.arraycopy(this.value.getUnsafeBytes(), this.value.getBegin(), bytes2, p2, this.value.getRealSize());
        if (jflag != 114) {
            p2 += this.value.getRealSize();
            int end3 = res.getBegin() + width;
            if (padLen <= 1) {
                while (p2 < end3) {
                    bytes2[p2++] = padBytes[padP];
                }
            } else {
                while (p2 + padLen <= end3) {
                    System.arraycopy(padBytes, padP, bytes2, p2, padLen);
                    p2 += padLen;
                }
                while (p2 < end3) {
                    bytes2[p2++] = padBytes[padP++];
                }
            }
        }
        RubyString result = new RubyString(runtime2, this.getMetaClass(), res);
        result.infectBy(this);
        return result;
    }

    private IRubyObject justify19(IRubyObject arg0, int jflag) {
        Ruby runtime2 = this.getRuntime();
        RubyString result = this.justifyCommon(runtime2, SPACE_BYTELIST, 1, true, this.value.getEncoding(), RubyFixnum.num2int(arg0), jflag);
        if (this.getCodeRange() != 96) {
            result.setCodeRange(this.getCodeRange());
        }
        return result;
    }

    private IRubyObject justify19(IRubyObject arg0, IRubyObject arg1, int jflag) {
        Ruby runtime2 = this.getRuntime();
        RubyString padStr = arg1.convertToString();
        ByteList pad = padStr.value;
        Encoding enc = this.checkEncoding(padStr);
        int padCharLen = padStr.strLength(enc);
        if (pad.getRealSize() == 0 || padCharLen == 0) {
            throw runtime2.newArgumentError("zero width padding");
        }
        RubyString result = this.justifyCommon(runtime2, pad, padCharLen, padStr.singleByteOptimizable(), enc, RubyFixnum.num2int(arg0), jflag);
        result.infectBy(padStr);
        int cr = RubyString.codeRangeAnd(this.getCodeRange(), padStr.getCodeRange());
        if (cr != 96) {
            result.setCodeRange(cr);
        }
        return result;
    }

    private RubyString justifyCommon(Ruby runtime2, ByteList pad, int padCharLen, boolean padSinglebyte, Encoding enc, int width, int jflag) {
        int padPP;
        int len = this.strLength(enc);
        if (width < 0 || len >= width) {
            return this.strDup(runtime2);
        }
        int n = width - len;
        int llen = jflag == 108 ? 0 : (jflag == 114 ? n : n / 2);
        int rlen = n - llen;
        int padP = pad.getBegin();
        int padLen = pad.getRealSize();
        byte[] padBytes = pad.getUnsafeBytes();
        ByteList res = new ByteList(this.value.getRealSize() + n * padLen / padCharLen + 2);
        int p2 = res.getBegin();
        byte[] bytes2 = res.getUnsafeBytes();
        while (llen > 0) {
            if (padLen <= 1) {
                bytes2[p2++] = padBytes[padP];
                --llen;
                continue;
            }
            if (llen > padCharLen) {
                System.arraycopy(padBytes, padP, bytes2, p2, padLen);
                p2 += padLen;
                llen -= padCharLen;
                continue;
            }
            padPP = padSinglebyte ? padP + llen : StringSupport.nth(enc, padBytes, padP, padP + padLen, llen);
            n = padPP - padP;
            System.arraycopy(padBytes, padP, bytes2, p2, n);
            p2 += n;
            break;
        }
        System.arraycopy(this.value.getUnsafeBytes(), this.value.getBegin(), bytes2, p2, this.value.getRealSize());
        p2 += this.value.getRealSize();
        while (rlen > 0) {
            if (padLen <= 1) {
                bytes2[p2++] = padBytes[padP];
                --rlen;
                continue;
            }
            if (rlen > padCharLen) {
                System.arraycopy(padBytes, padP, bytes2, p2, padLen);
                p2 += padLen;
                rlen -= padCharLen;
                continue;
            }
            padPP = padSinglebyte ? padP + rlen : StringSupport.nth(enc, padBytes, padP, padP + padLen, rlen);
            n = padPP - padP;
            System.arraycopy(padBytes, padP, bytes2, p2, n);
            p2 += n;
            break;
        }
        res.setRealSize(p2);
        RubyString result = new RubyString(runtime2, this.getMetaClass(), res);
        result.infectBy(this);
        result.associateEncoding(enc);
        return result;
    }

    @JRubyMethod(name={"ljust"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject ljust(IRubyObject arg0) {
        return this.justify(arg0, 108);
    }

    @JRubyMethod(name={"ljust"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject ljust(IRubyObject arg0, IRubyObject arg1) {
        return this.justify(arg0, arg1, 108);
    }

    @JRubyMethod(name={"ljust"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject ljust19(IRubyObject arg0) {
        return this.justify19(arg0, 108);
    }

    @JRubyMethod(name={"ljust"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject ljust19(IRubyObject arg0, IRubyObject arg1) {
        return this.justify19(arg0, arg1, 108);
    }

    @JRubyMethod(name={"rjust"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject rjust(IRubyObject arg0) {
        return this.justify(arg0, 114);
    }

    @JRubyMethod(name={"rjust"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject rjust(IRubyObject arg0, IRubyObject arg1) {
        return this.justify(arg0, arg1, 114);
    }

    @JRubyMethod(name={"rjust"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject rjust19(IRubyObject arg0) {
        return this.justify19(arg0, 114);
    }

    @JRubyMethod(name={"rjust"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject rjust19(IRubyObject arg0, IRubyObject arg1) {
        return this.justify19(arg0, arg1, 114);
    }

    @JRubyMethod(name={"center"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject center(IRubyObject arg0) {
        return this.justify(arg0, 99);
    }

    @JRubyMethod(name={"center"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject center(IRubyObject arg0, IRubyObject arg1) {
        return this.justify(arg0, arg1, 99);
    }

    @JRubyMethod(name={"center"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject center19(IRubyObject arg0) {
        return this.justify19(arg0, 99);
    }

    @JRubyMethod(name={"center"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject center19(IRubyObject arg0, IRubyObject arg1) {
        return this.justify19(arg0, arg1, 99);
    }

    @JRubyMethod(name={"partition"}, frame=true)
    public IRubyObject partition(ThreadContext context, Block block) {
        return RubyEnumerable.partition(context, this, block);
    }

    @JRubyMethod(name={"partition"}, frame=true)
    public IRubyObject partition(ThreadContext context, IRubyObject arg2, Block block) {
        RubyString sep;
        int pos2;
        Ruby runtime2 = context.getRuntime();
        if (arg2 instanceof RubyRegexp) {
            RubyRegexp regex = (RubyRegexp)arg2;
            pos2 = regex.search19(context, this, 0, false);
            if (pos2 < 0) {
                return this.partitionMismatch(runtime2);
            }
            sep = (RubyString)this.subpat19(runtime2, context, regex);
            if (pos2 == 0 && sep.value.getRealSize() == 0) {
                return this.partitionMismatch(runtime2);
            }
        } else {
            IRubyObject tmp = arg2.checkStringType();
            if (tmp.isNil()) {
                throw runtime2.newTypeError("type mismatch: " + arg2.getMetaClass().getName() + " given");
            }
            sep = (RubyString)tmp;
            pos2 = this.strIndex19(sep, 0);
            if (pos2 < 0) {
                return this.partitionMismatch(runtime2);
            }
        }
        return RubyArray.newArray(runtime2, new IRubyObject[]{this.makeShared19(runtime2, 0, pos2), sep, this.makeShared19(runtime2, pos2 + sep.value.getRealSize(), this.value.getRealSize() - pos2 - sep.value.getRealSize())});
    }

    private IRubyObject partitionMismatch(Ruby runtime2) {
        return RubyArray.newArray(runtime2, new IRubyObject[]{this, RubyString.newEmptyString(runtime2), RubyString.newEmptyString(runtime2)});
    }

    @JRubyMethod(name={"rpartition"})
    public IRubyObject rpartition(ThreadContext context, IRubyObject arg2) {
        RubyString sep;
        int pos2;
        Ruby runtime2 = context.getRuntime();
        if (arg2 instanceof RubyRegexp) {
            RubyRegexp regex = (RubyRegexp)arg2;
            pos2 = regex.search19(context, this, this.value.getRealSize(), true);
            if (pos2 < 0) {
                return this.rpartitionMismatch(runtime2);
            }
            sep = (RubyString)RubyRegexp.nth_match(0, context.getCurrentScope().getBackRef(runtime2));
        } else {
            IRubyObject tmp = arg2.checkStringType();
            if (tmp.isNil()) {
                throw runtime2.newTypeError("type mismatch: " + arg2.getMetaClass().getName() + " given");
            }
            sep = (RubyString)tmp;
            pos2 = this.strRindex19(sep, this.subLength(this.value.getRealSize()));
            if (pos2 < 0) {
                return this.rpartitionMismatch(runtime2);
            }
        }
        return RubyArray.newArray(runtime2, new IRubyObject[]{this.substr19(runtime2, 0, pos2), sep, this.substr19(runtime2, pos2 + sep.strLength(), this.value.getRealSize())});
    }

    private IRubyObject rpartitionMismatch(Ruby runtime2) {
        return RubyArray.newArray(runtime2, new IRubyObject[]{RubyString.newEmptyString(runtime2), RubyString.newEmptyString(runtime2), this});
    }

    @JRubyMethod(name={"chop"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject chop(ThreadContext context) {
        if (this.value.getRealSize() == 0) {
            return RubyString.newEmptyString(context.getRuntime(), this.getMetaClass()).infectBy(this);
        }
        return this.makeShared(context.getRuntime(), 0, this.choppedLength());
    }

    @JRubyMethod(name={"chop!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject chop_bang(ThreadContext context) {
        if (this.value.getRealSize() == 0) {
            return context.getRuntime().getNil();
        }
        this.view(0, this.choppedLength());
        return this;
    }

    private int choppedLength() {
        int end2 = this.value.getRealSize() - 1;
        if (this.value.getUnsafeBytes()[this.value.getBegin() + end2] == 10 && end2 > 0 && this.value.getUnsafeBytes()[this.value.getBegin() + end2 - 1] == 13) {
            --end2;
        }
        return end2;
    }

    @JRubyMethod(name={"chop"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject chop19(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (this.value.getRealSize() == 0) {
            return RubyString.newEmptyString(runtime2, this.getMetaClass(), this.value.getEncoding()).infectBy(this);
        }
        return this.makeShared19(runtime2, 0, this.choppedLength19(runtime2));
    }

    @JRubyMethod(name={"chop!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject chop_bang19(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (this.value.getRealSize() == 0) {
            return runtime2.getNil();
        }
        this.keepCodeRange();
        this.view(0, this.choppedLength19(runtime2));
        return this;
    }

    private int choppedLength19(Ruby runtime2) {
        int s2;
        int end2;
        int p2 = this.value.getBegin();
        if (p2 > (end2 = p2 + this.value.getRealSize())) {
            return 0;
        }
        byte[] bytes2 = this.value.getUnsafeBytes();
        Encoding enc = this.value.getEncoding();
        int s = enc.prevCharHead(bytes2, p2, end2, end2);
        if (s == -1) {
            return 0;
        }
        if (s > p2 && StringSupport.codePoint(runtime2, enc, bytes2, s, end2) == 10 && (s2 = enc.prevCharHead(bytes2, p2, s, end2)) != -1 && StringSupport.codePoint(runtime2, enc, bytes2, s2, end2) == 13) {
            s = s2;
        }
        return s - p2;
    }

    @JRubyMethod(name={"chomp"}, compat=CompatVersion.RUBY1_8)
    public RubyString chomp(ThreadContext context) {
        RubyString str = this.strDup(context.getRuntime());
        str.chomp_bang(context);
        return str;
    }

    @JRubyMethod(name={"chomp"}, compat=CompatVersion.RUBY1_8)
    public RubyString chomp(ThreadContext context, IRubyObject arg0) {
        RubyString str = this.strDup(context.getRuntime());
        str.chomp_bang(context, arg0);
        return str;
    }

    @JRubyMethod(name={"chomp!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject chomp_bang(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (this.value.getRealSize() == 0) {
            return runtime2.getNil();
        }
        IRubyObject rsObj = runtime2.getGlobalVariables().get("$/");
        if (rsObj == runtime2.getGlobalVariables().getDefaultSeparator()) {
            return this.smartChopBangCommon(runtime2);
        }
        return this.chompBangCommon(runtime2, rsObj);
    }

    @JRubyMethod(name={"chomp!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject chomp_bang(ThreadContext context, IRubyObject arg0) {
        Ruby runtime2 = context.getRuntime();
        if (this.value.getRealSize() == 0) {
            return runtime2.getNil();
        }
        return this.chompBangCommon(runtime2, arg0);
    }

    private IRubyObject chompBangCommon(Ruby runtime2, IRubyObject rsObj) {
        if (rsObj.isNil()) {
            return rsObj;
        }
        RubyString rs = rsObj.convertToString();
        int p2 = this.value.getBegin();
        int len = this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        int rslen = rs.value.getRealSize();
        if (rslen == 0) {
            while (len > 0 && bytes2[p2 + len - 1] == 10) {
                if (--len <= 0 || bytes2[p2 + len - 1] != 13) continue;
                --len;
            }
            if (len < this.value.getRealSize()) {
                this.view(0, len);
                return this;
            }
            return runtime2.getNil();
        }
        if (rslen > len) {
            return runtime2.getNil();
        }
        byte newline = rs.value.getUnsafeBytes()[rslen - 1];
        if (rslen == 1 && newline == 10) {
            return this.smartChopBangCommon(runtime2);
        }
        if (bytes2[p2 + len - 1] == newline && rslen <= 1 || this.value.endsWith(rs.value)) {
            this.view(0, this.value.getRealSize() - rslen);
            return this;
        }
        return runtime2.getNil();
    }

    private IRubyObject smartChopBangCommon(Ruby runtime2) {
        int len = this.value.getRealSize();
        int p2 = this.value.getBegin();
        byte[] bytes2 = this.value.getUnsafeBytes();
        if (bytes2[p2 + len - 1] == 10) {
            if (--len > 0 && bytes2[p2 + len - 1] == 13) {
                --len;
            }
            this.view(0, len);
        } else if (bytes2[p2 + len - 1] == 13) {
            this.view(0, --len);
        } else {
            this.modifyCheck();
            return runtime2.getNil();
        }
        return this;
    }

    @JRubyMethod(name={"chomp"}, compat=CompatVersion.RUBY1_9)
    public RubyString chomp19(ThreadContext context) {
        RubyString str = this.strDup(context.getRuntime());
        str.chomp_bang19(context);
        return str;
    }

    @JRubyMethod(name={"chomp"}, compat=CompatVersion.RUBY1_9)
    public RubyString chomp19(ThreadContext context, IRubyObject arg0) {
        RubyString str = this.strDup(context.getRuntime());
        str.chomp_bang19(context, arg0);
        return str;
    }

    @JRubyMethod(name={"chomp!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject chomp_bang19(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (this.value.getRealSize() == 0) {
            return runtime2.getNil();
        }
        IRubyObject rsObj = runtime2.getGlobalVariables().get("$/");
        if (rsObj == runtime2.getGlobalVariables().getDefaultSeparator()) {
            return this.smartChopBangCommon19(runtime2);
        }
        return this.chompBangCommon19(runtime2, rsObj);
    }

    @JRubyMethod(name={"chomp!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject chomp_bang19(ThreadContext context, IRubyObject arg0) {
        Ruby runtime2 = context.getRuntime();
        if (this.value.getRealSize() == 0) {
            return runtime2.getNil();
        }
        return this.chompBangCommon19(runtime2, arg0);
    }

    private IRubyObject chompBangCommon19(Ruby runtime2, IRubyObject rsObj) {
        if (rsObj.isNil()) {
            return rsObj;
        }
        RubyString rs = rsObj.convertToString();
        int p2 = this.value.getBegin();
        int len = this.value.getRealSize();
        int end2 = p2 + len;
        byte[] bytes2 = this.value.getUnsafeBytes();
        int rslen = rs.value.getRealSize();
        if (rslen == 0) {
            while (len > 0 && bytes2[p2 + len - 1] == 10) {
                if (--len <= 0 || bytes2[p2 + len - 1] != 13) continue;
                --len;
            }
            if (len < this.value.getRealSize()) {
                this.keepCodeRange();
                this.view(0, len);
                return this;
            }
            return runtime2.getNil();
        }
        if (rslen > len) {
            return runtime2.getNil();
        }
        byte newline = rs.value.getUnsafeBytes()[rslen - 1];
        if (rslen == 1 && newline == 10) {
            return this.smartChopBangCommon19(runtime2);
        }
        Encoding enc = this.checkEncoding(rs);
        if (rs.scanForCodeRange() == 96) {
            return runtime2.getNil();
        }
        int pp = end2 - rslen;
        if (bytes2[p2 + len - 1] == newline && rslen <= 1 || this.value.endsWith(rs.value)) {
            if (enc.leftAdjustCharHead(bytes2, p2, pp, end2) != pp) {
                return runtime2.getNil();
            }
            if (this.getCodeRange() != 32) {
                this.clearCodeRange();
            }
            this.view(0, this.value.getRealSize() - rslen);
            return this;
        }
        return runtime2.getNil();
    }

    private IRubyObject smartChopBangCommon19(Ruby runtime2) {
        int p2 = this.value.getBegin();
        int len = this.value.getRealSize();
        int end2 = p2 + len;
        byte[] bytes2 = this.value.getUnsafeBytes();
        Encoding enc = this.value.getEncoding();
        this.keepCodeRange();
        if (enc.minLength() > 1) {
            int pp = enc.leftAdjustCharHead(bytes2, p2, end2 - enc.minLength(), end2);
            if (enc.isNewLine(bytes2, pp, end2)) {
                end2 = pp;
            }
            if ((pp = end2 - enc.minLength()) >= p2 && StringSupport.preciseLength(enc, bytes2, pp = enc.leftAdjustCharHead(bytes2, p2, pp, end2), end2) > 0 && enc.mbcToCode(bytes2, pp, end2) == 13) {
                end2 = pp;
            }
            if (end2 == p2 + this.value.getRealSize()) {
                this.modifyCheck();
                return runtime2.getNil();
            }
            len = end2 - p2;
            this.view(0, len);
        } else if (bytes2[p2 + len - 1] == 10) {
            if (--len > 0 && bytes2[p2 + len - 1] == 13) {
                --len;
            }
            this.view(0, len);
        } else if (bytes2[p2 + len - 1] == 13) {
            this.view(0, --len);
        } else {
            this.modifyCheck();
            return runtime2.getNil();
        }
        return this;
    }

    @JRubyMethod(name={"lstrip"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject lstrip(ThreadContext context) {
        RubyString str = this.strDup(context.getRuntime());
        str.lstrip_bang(context);
        return str;
    }

    @JRubyMethod(name={"lstrip!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject lstrip_bang(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (this.value.getRealSize() == 0) {
            return runtime2.getNil();
        }
        return this.singleByteLStrip(runtime2, ASCII, this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getBegin() + this.value.getRealSize());
    }

    @JRubyMethod(name={"lstrip"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject lstrip19(ThreadContext context) {
        RubyString str = this.strDup(context.getRuntime());
        str.lstrip_bang19(context);
        return str;
    }

    @JRubyMethod(name={"lstrip!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject lstrip_bang19(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime2.getNil();
        }
        Encoding enc = this.value.getEncoding();
        int s = this.value.getBegin();
        int end2 = s + this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        IRubyObject result = this.singleByteOptimizable(enc) ? this.singleByteLStrip(runtime2, enc, bytes2, s, end2) : this.multiByteLStrip(runtime2, enc, bytes2, s, end2);
        this.keepCodeRange();
        return result;
    }

    private IRubyObject singleByteLStrip(Ruby runtime2, Encoding enc, byte[] bytes2, int s, int end2) {
        int p2;
        for (p2 = s; p2 < end2 && enc.isSpace(bytes2[p2] & 0xFF); ++p2) {
        }
        if (p2 > s) {
            this.view(p2 - s, end2 - p2);
            return this;
        }
        return runtime2.getNil();
    }

    private IRubyObject multiByteLStrip(Ruby runtime2, Encoding enc, byte[] bytes2, int s, int end2) {
        int p2;
        int c;
        for (p2 = s; p2 < end2 && enc.isSpace(c = StringSupport.codePoint(runtime2, enc, bytes2, p2, end2)); p2 += StringSupport.codeLength(runtime2, enc, c)) {
        }
        if (p2 > s) {
            this.view(p2 - s, end2 - p2);
            return this;
        }
        return runtime2.getNil();
    }

    @JRubyMethod(name={"rstrip"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject rstrip(ThreadContext context) {
        RubyString str = this.strDup(context.getRuntime());
        str.rstrip_bang(context);
        return str;
    }

    @JRubyMethod(name={"rstrip!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject rstrip_bang(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (this.value.getRealSize() == 0) {
            return runtime2.getNil();
        }
        return this.singleByteRStrip(runtime2, ASCII, this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getBegin() + this.value.getRealSize());
    }

    @JRubyMethod(name={"rstrip"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject rstrip19(ThreadContext context) {
        RubyString str = this.strDup(context.getRuntime());
        str.rstrip_bang19(context);
        return str;
    }

    @JRubyMethod(name={"rstrip!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject rstrip_bang19(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime2.getNil();
        }
        Encoding enc = this.value.getEncoding();
        int s = this.value.getBegin();
        int end2 = s + this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        IRubyObject result = this.singleByteOptimizable(enc) ? this.singleByteRStrip(runtime2, enc, bytes2, s, end2) : this.multiByteRStrip(runtime2, enc, bytes2, s, end2);
        this.keepCodeRange();
        return result;
    }

    private IRubyObject singleByteRStrip2(Ruby runtime2, Encoding enc, byte[] bytes2, int s, int end2) {
        int endp = end2;
        while (endp - 1 >= s && bytes2[endp - 1] == 0) {
            --endp;
        }
        while (endp - 1 >= s && enc.isSpace(bytes2[endp - 1] & 0xFF)) {
            --endp;
        }
        if (endp < end2) {
            this.view(0, endp - s);
            return this;
        }
        return runtime2.getNil();
    }

    private IRubyObject singleByteRStrip(Ruby runtime2, Encoding enc, byte[] bytes2, int s, int end2) {
        int endp;
        for (endp = end2 - 1; endp >= s && bytes2[endp] == 0; --endp) {
        }
        while (endp >= s && enc.isSpace(bytes2[endp] & 0xFF)) {
            --endp;
        }
        if (endp < end2 - 1) {
            this.view(0, endp - s + 1);
            return this;
        }
        return runtime2.getNil();
    }

    private IRubyObject multiByteRStrip(Ruby runtime2, Encoding enc, byte[] bytes2, int s, int end2) {
        int prev;
        int endp = end2;
        while ((prev = enc.prevCharHead(bytes2, s, endp, end2)) != -1 && enc.isSpace(StringSupport.codePoint(runtime2, enc, bytes2, prev, end2))) {
            endp = prev;
        }
        if (prev < end2) {
            this.view(0, prev - s + 1);
            return this;
        }
        return runtime2.getNil();
    }

    @JRubyMethod(name={"strip"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject strip(ThreadContext context) {
        RubyString str = this.strDup(context.getRuntime());
        str.strip_bang(context);
        return str;
    }

    @JRubyMethod(name={"strip!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject strip_bang(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (this.value.getRealSize() == 0) {
            return runtime2.getNil();
        }
        return this.singleByteStrip(runtime2, ASCII, this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getBegin() + this.value.getRealSize());
    }

    @JRubyMethod(name={"strip"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject strip19(ThreadContext context) {
        RubyString str = this.strDup(context.getRuntime());
        str.strip_bang19(context);
        return str;
    }

    @JRubyMethod(name={"strip!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject strip_bang19(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime2.getNil();
        }
        Encoding enc = this.value.getEncoding();
        int s = this.value.getBegin();
        int end2 = s + this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        IRubyObject result = this.singleByteOptimizable(enc) ? this.singleByteStrip(runtime2, enc, bytes2, s, end2) : this.multiByteStrip(runtime2, enc, bytes2, s, end2);
        this.keepCodeRange();
        return result;
    }

    private IRubyObject singleByteStrip(Ruby runtime2, Encoding enc, byte[] bytes2, int s, int end2) {
        int endp;
        int p2;
        for (p2 = s; p2 < end2 && enc.isSpace(bytes2[p2] & 0xFF); ++p2) {
        }
        for (endp = end2 - 1; endp >= p2 && bytes2[endp] == 0; --endp) {
        }
        while (endp >= p2 && enc.isSpace(bytes2[endp] & 0xFF)) {
            --endp;
        }
        if (p2 > s || endp < end2 - 1) {
            this.view(p2 - s, endp - p2 + 1);
            return this;
        }
        return runtime2.getNil();
    }

    private IRubyObject multiByteStrip(Ruby runtime2, Encoding enc, byte[] bytes2, int s, int end2) {
        int prev;
        int p2;
        int c;
        for (p2 = s; p2 < end2 && enc.isSpace(c = StringSupport.codePoint(runtime2, enc, bytes2, p2, end2)); p2 += StringSupport.codeLength(runtime2, enc, c)) {
        }
        int endp = end2;
        while ((prev = enc.prevCharHead(bytes2, s, endp, end2)) != -1 && enc.isSpace(StringSupport.codePoint(runtime2, enc, bytes2, prev, end2))) {
            endp = prev;
        }
        if (p2 > s || prev < end2) {
            this.view(p2 - s, endp - p2);
            return this;
        }
        return runtime2.getNil();
    }

    @JRubyMethod(name={"count"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject count(ThreadContext context) {
        throw context.getRuntime().newArgumentError("wrong number of arguments");
    }

    @JRubyMethod(name={"count"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject count(ThreadContext context, IRubyObject arg2) {
        boolean[] table = new boolean[256];
        arg2.convertToString().trSetupTable(table, true);
        return this.countCommon(context.getRuntime(), table);
    }

    @JRubyMethod(name={"count"}, required=1, rest=true, compat=CompatVersion.RUBY1_8)
    public IRubyObject count(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        if (this.value.getRealSize() == 0) {
            return RubyFixnum.zero(runtime2);
        }
        boolean[] table = new boolean[256];
        args2[0].convertToString().trSetupTable(table, true);
        for (int i = 1; i < args2.length; ++i) {
            args2[i].convertToString().trSetupTable(table, false);
        }
        return this.countCommon(runtime2, table);
    }

    private IRubyObject countCommon(Ruby runtime2, boolean[] table) {
        int i = 0;
        byte[] bytes2 = this.value.getUnsafeBytes();
        int p2 = this.value.getBegin();
        int end2 = p2 + this.value.getRealSize();
        while (p2 < end2) {
            if (!table[bytes2[p2++] & 0xFF]) continue;
            ++i;
        }
        return runtime2.newFixnum(i);
    }

    @JRubyMethod(name={"count"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject count19(ThreadContext context) {
        throw context.getRuntime().newArgumentError("wrong number of arguments");
    }

    @JRubyMethod(name={"count"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject count19(ThreadContext context, IRubyObject arg2) {
        Ruby runtime2 = context.getRuntime();
        if (this.value.getRealSize() == 0) {
            return RubyFixnum.zero(runtime2);
        }
        RubyString otherStr = arg2.convertToString();
        Encoding enc = this.checkEncoding(otherStr);
        boolean[] table = new boolean[256];
        TrTables tables = otherStr.trSetupTable(context.getRuntime(), table, null, true, enc);
        return this.countCommon19(runtime2, table, tables, enc);
    }

    @JRubyMethod(name={"count"}, required=1, rest=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject count19(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        if (this.value.getRealSize() == 0) {
            return RubyFixnum.zero(runtime2);
        }
        RubyString otherStr = args2[0].convertToString();
        Encoding enc = this.checkEncoding(otherStr);
        boolean[] table = new boolean[256];
        TrTables tables = otherStr.trSetupTable(runtime2, table, null, true, enc);
        for (int i = 1; i < args2.length; ++i) {
            otherStr = args2[i].convertToString();
            enc = this.checkEncoding(otherStr);
            tables = otherStr.trSetupTable(runtime2, table, tables, false, enc);
        }
        return this.countCommon19(runtime2, table, tables, enc);
    }

    private IRubyObject countCommon19(Ruby runtime2, boolean[] table, TrTables tables, Encoding enc) {
        int i = 0;
        byte[] bytes2 = this.value.getUnsafeBytes();
        int p2 = this.value.getBegin();
        int end2 = p2 + this.value.getRealSize();
        while (p2 < end2) {
            int c;
            if (enc.isAsciiCompatible() && Encoding.isAscii(c = bytes2[p2] & 0xFF)) {
                if (table[c]) {
                    ++i;
                }
                ++p2;
                continue;
            }
            c = StringSupport.codePoint(runtime2, enc, bytes2, p2, end2);
            int cl = StringSupport.codeLength(runtime2, enc, c);
            if (this.trFind(c, table, tables)) {
                ++i;
            }
            p2 += cl;
        }
        return runtime2.newFixnum(i);
    }

    @JRubyMethod(name={"delete"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject delete(ThreadContext context) {
        throw context.getRuntime().newArgumentError("wrong number of arguments");
    }

    @JRubyMethod(name={"delete"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject delete(ThreadContext context, IRubyObject arg2) {
        RubyString str = this.strDup(context.getRuntime());
        str.delete_bang(context, arg2);
        return str;
    }

    @JRubyMethod(name={"delete"}, required=1, rest=true, compat=CompatVersion.RUBY1_8)
    public IRubyObject delete(ThreadContext context, IRubyObject[] args2) {
        RubyString str = this.strDup(context.getRuntime());
        str.delete_bang(context, args2);
        return str;
    }

    @JRubyMethod(name={"delete!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject delete_bang(ThreadContext context) {
        throw context.getRuntime().newArgumentError("wrong number of arguments");
    }

    @JRubyMethod(name={"delete!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject delete_bang(ThreadContext context, IRubyObject arg2) {
        Ruby runtime2 = context.getRuntime();
        if (this.value.getRealSize() == 0) {
            return runtime2.getNil();
        }
        boolean[] squeeze2 = new boolean[256];
        arg2.convertToString().trSetupTable(squeeze2, true);
        return this.delete_bangCommon(runtime2, squeeze2);
    }

    @JRubyMethod(name={"delete!"}, required=1, rest=true, compat=CompatVersion.RUBY1_8)
    public IRubyObject delete_bang(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        if (this.value.getRealSize() == 0) {
            return runtime2.getNil();
        }
        boolean[] squeeze2 = new boolean[256];
        args2[0].convertToString().trSetupTable(squeeze2, true);
        for (int i = 1; i < args2.length; ++i) {
            args2[i].convertToString().trSetupTable(squeeze2, false);
        }
        return this.delete_bangCommon(runtime2, squeeze2);
    }

    private IRubyObject delete_bangCommon(Ruby runtime2, boolean[] squeeze2) {
        int s;
        this.modify();
        int t = s = this.value.getBegin();
        int send2 = s + this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        boolean modify = false;
        while (s < send2) {
            if (squeeze2[bytes2[s] & 0xFF]) {
                modify = true;
            } else {
                bytes2[t++] = bytes2[s];
            }
            ++s;
        }
        this.value.setRealSize(t - this.value.getBegin());
        return modify ? this : runtime2.getNil();
    }

    @JRubyMethod(name={"delete"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject delete19(ThreadContext context) {
        throw context.getRuntime().newArgumentError("wrong number of arguments");
    }

    @JRubyMethod(name={"delete"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject delete19(ThreadContext context, IRubyObject arg2) {
        RubyString str = this.strDup(context.getRuntime());
        str.delete_bang19(context, arg2);
        return str;
    }

    @JRubyMethod(name={"delete"}, required=1, rest=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject delete19(ThreadContext context, IRubyObject[] args2) {
        RubyString str = this.strDup(context.getRuntime());
        str.delete_bang19(context, args2);
        return str;
    }

    @JRubyMethod(name={"delete!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject delete_bang19(ThreadContext context) {
        throw context.getRuntime().newArgumentError("wrong number of arguments");
    }

    @JRubyMethod(name={"delete!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject delete_bang19(ThreadContext context, IRubyObject arg2) {
        Ruby runtime2 = context.getRuntime();
        if (this.value.getRealSize() == 0) {
            return runtime2.getNil();
        }
        RubyString otherStr = arg2.convertToString();
        Encoding enc = this.checkEncoding(otherStr);
        boolean[] squeeze2 = new boolean[256];
        TrTables tables = otherStr.trSetupTable(runtime2, squeeze2, null, true, enc);
        return this.delete_bangCommon19(runtime2, squeeze2, tables, enc);
    }

    @JRubyMethod(name={"delete!"}, required=1, rest=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject delete_bang19(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        if (this.value.getRealSize() == 0) {
            return runtime2.getNil();
        }
        RubyString otherStr = args2[0].convertToString();
        Encoding enc = this.checkEncoding(otherStr);
        boolean[] squeeze2 = new boolean[256];
        TrTables tables = otherStr.trSetupTable(runtime2, squeeze2, null, true, enc);
        for (int i = 1; i < args2.length; ++i) {
            otherStr = args2[i].convertToString();
            enc = this.checkEncoding(otherStr);
            tables = otherStr.trSetupTable(runtime2, squeeze2, tables, false, enc);
        }
        return this.delete_bangCommon19(runtime2, squeeze2, tables, enc);
    }

    private IRubyObject delete_bangCommon19(Ruby runtime2, boolean[] squeeze2, TrTables tables, Encoding enc) {
        int cr;
        int s;
        this.modifyAndKeepCodeRange();
        int t = s = this.value.getBegin();
        int send2 = s + this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        boolean modify = false;
        boolean asciiCompatible = enc.isAsciiCompatible();
        int n = cr = asciiCompatible ? 32 : 64;
        while (s < send2) {
            int c;
            if (asciiCompatible && Encoding.isAscii(c = bytes2[s] & 0xFF)) {
                if (squeeze2[c]) {
                    modify = true;
                } else {
                    if (t != s) {
                        bytes2[t] = (byte)c;
                    }
                    ++t;
                }
                ++s;
                continue;
            }
            c = StringSupport.codePoint(runtime2, enc, bytes2, s, send2);
            int cl = StringSupport.codeLength(runtime2, enc, c);
            if (this.trFind(c, squeeze2, tables)) {
                modify = true;
            } else {
                if (t != s) {
                    enc.codeToMbc(c, bytes2, t);
                }
                t += cl;
                if (cr == 32) {
                    cr = 64;
                }
            }
            s += cl;
        }
        this.value.setRealSize(t - this.value.getBegin());
        this.setCodeRange(cr);
        return modify ? this : runtime2.getNil();
    }

    @JRubyMethod(name={"squeeze"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject squeeze(ThreadContext context) {
        RubyString str = this.strDup(context.getRuntime());
        str.squeeze_bang(context);
        return str;
    }

    @JRubyMethod(name={"squeeze"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject squeeze(ThreadContext context, IRubyObject arg2) {
        RubyString str = this.strDup(context.getRuntime());
        str.squeeze_bang(context, arg2);
        return str;
    }

    @JRubyMethod(name={"squeeze"}, rest=true, compat=CompatVersion.RUBY1_8)
    public IRubyObject squeeze(ThreadContext context, IRubyObject[] args2) {
        RubyString str = this.strDup(context.getRuntime());
        str.squeeze_bang(context, args2);
        return str;
    }

    @JRubyMethod(name={"squeeze!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject squeeze_bang(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime2.getNil();
        }
        boolean[] squeeze2 = new boolean[256];
        for (int i = 0; i < 256; ++i) {
            squeeze2[i] = true;
        }
        this.modify();
        return this.squeezeCommon(runtime2, squeeze2);
    }

    @JRubyMethod(name={"squeeze!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject squeeze_bang(ThreadContext context, IRubyObject arg2) {
        Ruby runtime2 = context.getRuntime();
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime2.getNil();
        }
        boolean[] squeeze2 = new boolean[256];
        arg2.convertToString().trSetupTable(squeeze2, true);
        this.modify();
        return this.squeezeCommon(runtime2, squeeze2);
    }

    @JRubyMethod(name={"squeeze!"}, rest=true, compat=CompatVersion.RUBY1_8)
    public IRubyObject squeeze_bang(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime2.getNil();
        }
        boolean[] squeeze2 = new boolean[256];
        args2[0].convertToString().trSetupTable(squeeze2, true);
        for (int i = 1; i < args2.length; ++i) {
            args2[i].convertToString().trSetupTable(squeeze2, false);
        }
        this.modify();
        return this.squeezeCommon(runtime2, squeeze2);
    }

    private IRubyObject squeezeCommon(Ruby runtime2, boolean[] squeeze2) {
        int s;
        int t = s = this.value.getBegin();
        int send2 = s + this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        int save = -1;
        while (s < send2) {
            int c;
            if ((c = bytes2[s++] & 0xFF) == save && squeeze2[c]) continue;
            int n = t++;
            save = c;
            bytes2[n] = (byte)save;
        }
        if (t - this.value.getBegin() != this.value.getRealSize()) {
            this.value.setRealSize(t - this.value.getBegin());
            return this;
        }
        return runtime2.getNil();
    }

    @JRubyMethod(name={"squeeze"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject squeeze19(ThreadContext context) {
        RubyString str = this.strDup(context.getRuntime());
        str.squeeze_bang19(context);
        return str;
    }

    @JRubyMethod(name={"squeeze"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject squeeze19(ThreadContext context, IRubyObject arg2) {
        RubyString str = this.strDup(context.getRuntime());
        str.squeeze_bang19(context, arg2);
        return str;
    }

    @JRubyMethod(name={"squeeze"}, rest=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject squeeze19(ThreadContext context, IRubyObject[] args2) {
        RubyString str = this.strDup(context.getRuntime());
        str.squeeze_bang19(context, args2);
        return str;
    }

    @JRubyMethod(name={"squeeze!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject squeeze_bang19(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime2.getNil();
        }
        boolean[] squeeze2 = new boolean[256];
        for (int i = 0; i < 256; ++i) {
            squeeze2[i] = true;
        }
        this.modifyAndKeepCodeRange();
        if (this.singleByteOptimizable()) {
            return this.squeezeCommon(runtime2, squeeze2);
        }
        return this.squeezeCommon19(runtime2, squeeze2, null, this.value.getEncoding(), false);
    }

    @JRubyMethod(name={"squeeze!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject squeeze_bang19(ThreadContext context, IRubyObject arg2) {
        Ruby runtime2 = context.getRuntime();
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime2.getNil();
        }
        RubyString otherStr = arg2.convertToString();
        boolean[] squeeze2 = new boolean[256];
        TrTables tables = otherStr.trSetupTable(runtime2, squeeze2, null, true, this.checkEncoding(otherStr));
        this.modifyAndKeepCodeRange();
        if (this.singleByteOptimizable() && otherStr.singleByteOptimizable()) {
            return this.squeezeCommon(runtime2, squeeze2);
        }
        return this.squeezeCommon19(runtime2, squeeze2, tables, this.value.getEncoding(), true);
    }

    @JRubyMethod(name={"squeeze!"}, rest=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject squeeze_bang19(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime2.getNil();
        }
        RubyString otherStr = args2[0].convertToString();
        Encoding enc = this.checkEncoding(otherStr);
        boolean[] squeeze2 = new boolean[256];
        TrTables tables = otherStr.trSetupTable(runtime2, squeeze2, null, true, enc);
        boolean singlebyte = this.singleByteOptimizable() && otherStr.singleByteOptimizable();
        for (int i = 1; i < args2.length; ++i) {
            otherStr = args2[i].convertToString();
            enc = this.checkEncoding(otherStr);
            singlebyte = singlebyte && otherStr.singleByteOptimizable();
            tables = otherStr.trSetupTable(runtime2, squeeze2, tables, false, enc);
        }
        this.modifyAndKeepCodeRange();
        if (singlebyte) {
            return this.squeezeCommon(runtime2, squeeze2);
        }
        return this.squeezeCommon19(runtime2, squeeze2, tables, enc, true);
    }

    private IRubyObject squeezeCommon19(Ruby runtime2, boolean[] squeeze2, TrTables tables, Encoding enc, boolean isArg) {
        int s;
        int t = s = this.value.getBegin();
        int send2 = s + this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        int save = -1;
        while (s < send2) {
            int c;
            if (enc.isAsciiCompatible() && Encoding.isAscii(c = bytes2[s] & 0xFF)) {
                if (c != save || isArg && !squeeze2[c]) {
                    int n = t++;
                    save = c;
                    bytes2[n] = (byte)save;
                }
                ++s;
                continue;
            }
            c = StringSupport.codePoint(runtime2, enc, bytes2, s, send2);
            int cl = StringSupport.codeLength(runtime2, enc, c);
            if (c != save || isArg && !this.trFind(c, squeeze2, tables)) {
                if (t != s) {
                    enc.codeToMbc(c, bytes2, t);
                }
                save = c;
                t += cl;
            }
            s += cl;
        }
        if (t - this.value.getBegin() != this.value.getRealSize()) {
            this.value.setRealSize(t - this.value.getBegin());
            return this;
        }
        return runtime2.getNil();
    }

    @JRubyMethod(name={"tr"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject tr(ThreadContext context, IRubyObject src, IRubyObject repl) {
        RubyString str = this.strDup(context.getRuntime());
        str.trTrans(context, src, repl, false);
        return str;
    }

    @JRubyMethod(name={"tr!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject tr_bang(ThreadContext context, IRubyObject src, IRubyObject repl) {
        return this.trTrans(context, src, repl, false);
    }

    @JRubyMethod(name={"tr"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject tr19(ThreadContext context, IRubyObject src, IRubyObject repl) {
        RubyString str = this.strDup(context.getRuntime());
        str.trTrans19(context, src, repl, false);
        return str;
    }

    @JRubyMethod(name={"tr!"})
    public IRubyObject tr_bang19(ThreadContext context, IRubyObject src, IRubyObject repl) {
        return this.trTrans19(context, src, repl, false);
    }

    private void trSetupTable(boolean[] table, boolean init) {
        int c;
        TR tr2 = new TR(this.value);
        boolean cflag = false;
        if (this.value.getRealSize() > 1 && this.value.getUnsafeBytes()[this.value.getBegin()] == 94) {
            cflag = true;
            ++tr2.p;
        }
        if (init) {
            for (int i = 0; i < 256; ++i) {
                table[i] = true;
            }
        }
        boolean[] buf = new boolean[256];
        for (int i = 0; i < 256; ++i) {
            buf[i] = cflag;
        }
        while ((c = this.trNext(tr2)) >= 0) {
            buf[c & 0xFF] = !cflag;
        }
        for (int i = 0; i < 256; ++i) {
            table[i] = table[i] && buf[i];
        }
    }

    private TrTables trSetupTable(Ruby runtime2, boolean[] table, TrTables tables, boolean init, Encoding enc) {
        int c;
        TR tr2 = new TR(this.value);
        boolean cflag = false;
        if (this.value.getRealSize() > 1) {
            if (enc.isAsciiCompatible()) {
                if ((this.value.getUnsafeBytes()[this.value.getBegin()] & 0xFF) == 94) {
                    cflag = true;
                    ++tr2.p;
                }
            } else {
                int l = StringSupport.preciseLength(enc, tr2.buf, tr2.p, tr2.pend);
                if (enc.mbcToCode(tr2.buf, tr2.p, tr2.pend) == 94) {
                    cflag = true;
                    tr2.p += l;
                }
            }
        }
        if (init) {
            for (int i = 0; i < 256; ++i) {
                table[i] = true;
            }
        }
        boolean[] buf = new boolean[256];
        for (int i = 0; i < 256; ++i) {
            buf[i] = cflag;
        }
        IntHash<IRubyObject> hash2 = null;
        IntHash phash = null;
        while ((c = this.trNext(tr2, runtime2, enc)) >= 0) {
            if (c < 256) {
                buf[c & 0xFF] = !cflag;
                continue;
            }
            if (hash2 == null) {
                hash2 = new IntHash<IRubyObject>();
                if (tables == null) {
                    tables = new TrTables();
                }
                if (cflag) {
                    phash = tables.noDel;
                    tables.noDel = hash2;
                } else {
                    phash = tables.del;
                    tables.del = hash2;
                }
            }
            if (phash != null && phash.get(c) == null) continue;
            hash2.put(c, NEVER);
        }
        for (int i = 0; i < 256; ++i) {
            table[i] = table[i] && buf[i];
        }
        return tables;
    }

    private boolean trFind(int c, boolean[] table, TrTables tables) {
        return c < 256 ? table[c] : tables != null && tables.del != null && tables.del.get(c) != null && (tables.noDel == null || tables.noDel.get(c) == null);
    }

    private IRubyObject trTrans(ThreadContext context, IRubyObject src, IRubyObject repl, boolean sflag) {
        int s;
        int c;
        int i;
        Ruby runtime2 = context.getRuntime();
        if (this.value.getRealSize() == 0) {
            return runtime2.getNil();
        }
        ByteList replList = repl.convertToString().value;
        if (replList.getRealSize() == 0) {
            return this.delete_bang(context, src);
        }
        ByteList srcList = src.convertToString().value;
        TR trSrc = new TR(srcList);
        boolean cflag = false;
        if (srcList.getRealSize() >= 2 && srcList.getUnsafeBytes()[srcList.getBegin()] == 94) {
            cflag = true;
            ++trSrc.p;
        }
        int[] trans = new int[256];
        TR trRepl = new TR(replList);
        if (cflag) {
            for (i = 0; i < 256; ++i) {
                trans[i] = 1;
            }
            while ((c = this.trNext(trSrc)) >= 0) {
                trans[c & 0xFF] = -1;
            }
            while ((c = this.trNext(trRepl)) >= 0) {
            }
            for (i = 0; i < 256; ++i) {
                if (trans[i] < 0) continue;
                trans[i] = trRepl.now;
            }
        } else {
            for (i = 0; i < 256; ++i) {
                trans[i] = -1;
            }
            while ((c = this.trNext(trSrc)) >= 0) {
                int r = this.trNext(trRepl);
                if (r == -1) {
                    r = trRepl.now;
                }
                trans[c & 0xFF] = r;
            }
        }
        this.modify();
        int send2 = s + this.value.getRealSize();
        byte[] sbytes = this.value.getUnsafeBytes();
        boolean modify = false;
        if (sflag) {
            int t = s;
            int last2 = -1;
            while (s < send2) {
                byte c0;
                if ((c = trans[(c0 = sbytes[s++]) & 0xFF]) >= 0) {
                    if (last2 == c) continue;
                    last2 = c;
                    sbytes[t++] = (byte)(c & 0xFF);
                    modify = true;
                    continue;
                }
                last2 = -1;
                sbytes[t++] = c0;
            }
            if (this.value.getRealSize() > t - this.value.getBegin()) {
                this.value.setRealSize(t - this.value.getBegin());
                modify = true;
            }
        } else {
            for (s = this.value.getBegin(); s < send2; ++s) {
                c = trans[sbytes[s] & 0xFF];
                if (c < 0) continue;
                sbytes[s] = (byte)(c & 0xFF);
                modify = true;
            }
        }
        return modify ? this : runtime2.getNil();
    }

    private IRubyObject trTrans19(ThreadContext context, IRubyObject src, IRubyObject repl, boolean sflag) {
        int s;
        int c;
        int i;
        Encoding e2;
        Ruby runtime2 = context.getRuntime();
        if (this.value.getRealSize() == 0) {
            return runtime2.getNil();
        }
        RubyString replStr = repl.convertToString();
        ByteList replList = replStr.value;
        if (replList.getRealSize() == 0) {
            return this.delete_bang19(context, src);
        }
        RubyString srcStr = src.convertToString();
        ByteList srcList = srcStr.value;
        Encoding e1 = this.checkEncoding(srcStr);
        Encoding enc = e1 == (e2 = this.checkEncoding(replStr)) ? e1 : srcStr.checkEncoding(replStr);
        int cr = this.getCodeRange();
        TR trSrc = new TR(srcList);
        boolean cflag = false;
        if (this.value.getRealSize() > 1) {
            if (enc.isAsciiCompatible()) {
                if (trSrc.buf.length > 0 && (trSrc.buf[trSrc.p] & 0xFF) == 94 && trSrc.p + 1 < trSrc.pend) {
                    cflag = true;
                    ++trSrc.p;
                }
            } else {
                int cl = StringSupport.preciseLength(enc, trSrc.buf, trSrc.p, trSrc.pend);
                if (enc.mbcToCode(trSrc.buf, trSrc.p, trSrc.pend) == 94 && trSrc.p + cl < trSrc.pend) {
                    cflag = true;
                    trSrc.p += cl;
                }
            }
        }
        boolean singlebyte = true;
        int[] trans = new int[256];
        IntHash<Integer> hash2 = null;
        TR trRepl = new TR(replList);
        if (cflag) {
            for (i = 0; i < 256; ++i) {
                trans[i] = 1;
            }
            while ((c = this.trNext(trSrc, runtime2, enc)) >= 0) {
                if (c < 256) {
                    trans[c & 0xFF] = -1;
                    continue;
                }
                if (hash2 == null) {
                    hash2 = new IntHash<Integer>();
                }
                hash2.put(c, 1);
            }
            while ((c = this.trNext(trRepl, runtime2, enc)) >= 0) {
            }
            int last2 = trRepl.now;
            for (int i2 = 0; i2 < 256; ++i2) {
                if (trans[i2] < 0) continue;
                trans[i2] = last2;
            }
        } else {
            for (i = 0; i < 256; ++i) {
                trans[i] = -1;
            }
            while ((c = this.trNext(trSrc, runtime2, enc)) >= 0) {
                int r = this.trNext(trRepl, runtime2, enc);
                if (r == -1) {
                    r = trRepl.now;
                }
                if (c < 256) {
                    trans[c & 0xFF] = r;
                    if (r <= 255) continue;
                    singlebyte = false;
                    continue;
                }
                if (hash2 == null) {
                    hash2 = new IntHash();
                }
                hash2.put(c, r);
            }
        }
        if (cr == 64) {
            cr = 32;
        }
        this.modifyAndKeepCodeRange();
        int send2 = s + this.value.getRealSize();
        byte[] sbytes = this.value.getUnsafeBytes();
        int max2 = this.value.getRealSize();
        boolean modify = false;
        int last3 = -1;
        if (sflag) {
            int save = -1;
            byte[] buf = new byte[max2];
            int t = 0;
            while (s < send2) {
                boolean mayModify = false;
                int c0 = c = StringSupport.codePoint(runtime2, e1, sbytes, s, send2);
                int clen = StringSupport.codeLength(runtime2, e1, c);
                int tlen = enc == e1 ? clen : StringSupport.codeLength(runtime2, enc, c);
                s += clen;
                if ((c = this.trCode(c, trans, hash2, cflag, last3)) != -1) {
                    if (save == c) {
                        if (cr != 32 || Encoding.isAscii(c)) continue;
                        cr = 64;
                        continue;
                    }
                    save = c;
                    tlen = StringSupport.codeLength(runtime2, enc, c);
                    modify = true;
                } else {
                    save = -1;
                    c = c0;
                    if (enc != e1) {
                        mayModify = true;
                    }
                }
                while (t + tlen >= max2) {
                    byte[] tbuf = new byte[max2 <<= 1];
                    System.arraycopy(buf, 0, tbuf, 0, buf.length);
                    buf = tbuf;
                }
                enc.codeToMbc(c, buf, t);
                if (mayModify && (tlen == 1 ? sbytes[s] != buf[t] : ByteList.memcmp(sbytes, s, buf, t, tlen) != 0)) {
                    modify = true;
                }
                if (cr == 32 && !Encoding.isAscii(c)) {
                    cr = 64;
                }
                t += tlen;
            }
            this.value.setUnsafeBytes(buf);
            this.value.setRealSize(t);
        } else if (enc.isSingleByte() || singlebyte && hash2 == null) {
            for (s = this.value.getBegin(); s < send2; ++s) {
                c = sbytes[s] & 0xFF;
                if (trans[c] != -1) {
                    if (!cflag) {
                        c = trans[c];
                        sbytes[s] = (byte)c;
                    } else {
                        sbytes[s] = (byte)last3;
                    }
                    modify = true;
                }
                if (cr != 32 || Encoding.isAscii(c)) continue;
                cr = 64;
            }
        } else {
            max2 += max2 >> 1;
            byte[] buf = new byte[max2];
            int t = 0;
            while (s < send2) {
                boolean mayModify = false;
                int c0 = c = StringSupport.codePoint(runtime2, e1, sbytes, s, send2);
                int clen = StringSupport.codeLength(runtime2, e1, c);
                int tlen = enc == e1 ? clen : StringSupport.codeLength(runtime2, enc, c);
                if ((c = this.trCode(c, trans, hash2, cflag, last3)) != -1) {
                    tlen = StringSupport.codeLength(runtime2, enc, c);
                    modify = true;
                } else {
                    c = c0;
                    if (enc != e1) {
                        mayModify = true;
                    }
                }
                while (t + tlen >= max2) {
                    byte[] tbuf = new byte[max2 <<= 1];
                    System.arraycopy(buf, 0, tbuf, 0, buf.length);
                    buf = tbuf;
                }
                enc.codeToMbc(c, buf, t);
                if (mayModify && (tlen == 1 ? sbytes[s] != buf[t] : ByteList.memcmp(sbytes, s, buf, t, tlen) != 0)) {
                    modify = true;
                }
                if (cr == 32 && !Encoding.isAscii(c)) {
                    cr = 64;
                }
                s += clen;
                t += tlen;
            }
            this.value.setUnsafeBytes(buf);
            this.value.setRealSize(t);
        }
        if (modify) {
            if (cr != 96) {
                this.setCodeRange(cr);
            }
            this.associateEncoding(enc);
            return this;
        }
        return runtime2.getNil();
    }

    private int trCode(int c, int[] trans, IntHash<Integer> hash2, boolean cflag, int last2) {
        if (c < 256) {
            return trans[c];
        }
        if (hash2 != null) {
            Integer tmp = hash2.get(c);
            if (tmp == null) {
                return cflag ? last2 : -1;
            }
            return cflag ? -1 : tmp;
        }
        return -1;
    }

    private int trNext(TR t) {
        byte[] buf = t.buf;
        while (!t.gen) {
            if (t.p == t.pend) {
                return -1;
            }
            if (t.p < t.pend - 1 && buf[t.p] == 92) {
                ++t.p;
            }
            t.now = buf[t.p++] & 0xFF;
            if (t.p < t.pend - 1 && buf[t.p] == 45) {
                ++t.p;
                if (t.p < t.pend) {
                    if (t.now > (buf[t.p] & 0xFF)) {
                        ++t.p;
                        continue;
                    }
                    t.gen = true;
                    t.max = buf[t.p++] & 0xFF;
                }
            }
            return t.now;
        }
        if (++t.now < t.max) {
            return t.now;
        }
        t.gen = false;
        return t.max;
    }

    private int trNext(TR t, Ruby runtime2, Encoding enc) {
        byte[] buf = t.buf;
        while (!t.gen) {
            if (t.p == t.pend) {
                return -1;
            }
            if (t.p < t.pend - 1 && buf[t.p] == 92) {
                ++t.p;
            }
            t.now = StringSupport.codePoint(runtime2, enc, buf, t.p, t.pend);
            t.p += StringSupport.codeLength(runtime2, enc, t.now);
            if (t.p < t.pend - 1 && buf[t.p] == 45) {
                ++t.p;
                if (t.p < t.pend) {
                    int c = StringSupport.codePoint(runtime2, enc, buf, t.p, t.pend);
                    t.p += StringSupport.codeLength(runtime2, enc, c);
                    if (t.now > c) continue;
                    t.gen = true;
                    t.max = c;
                }
            }
            return t.now;
        }
        if (++t.now < t.max) {
            return t.now;
        }
        t.gen = false;
        return t.max;
    }

    @JRubyMethod(name={"tr_s"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject tr_s(ThreadContext context, IRubyObject src, IRubyObject repl) {
        RubyString str = this.strDup(context.getRuntime());
        str.trTrans(context, src, repl, true);
        return str;
    }

    @JRubyMethod(name={"tr_s!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject tr_s_bang(ThreadContext context, IRubyObject src, IRubyObject repl) {
        return this.trTrans(context, src, repl, true);
    }

    @JRubyMethod(name={"tr_s"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject tr_s19(ThreadContext context, IRubyObject src, IRubyObject repl) {
        RubyString str = this.strDup(context.getRuntime());
        str.trTrans19(context, src, repl, true);
        return str;
    }

    @JRubyMethod(name={"tr_s!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject tr_s_bang19(ThreadContext context, IRubyObject src, IRubyObject repl) {
        return this.trTrans19(context, src, repl, true);
    }

    public IRubyObject each_line(ThreadContext context, Block block) {
        return this.each_lineCommon(context, context.getRuntime().getGlobalVariables().get("$/"), block);
    }

    public IRubyObject each_line(ThreadContext context, IRubyObject arg2, Block block) {
        return this.each_lineCommon(context, arg2, block);
    }

    public IRubyObject each_lineCommon(ThreadContext context, IRubyObject sep, Block block) {
        Ruby runtime2 = context.getRuntime();
        if (sep.isNil()) {
            block.yield(context, this);
            return this;
        }
        RubyString sepStr = sep.convertToString();
        ByteList sepValue = sepStr.value;
        int rslen = sepValue.getRealSize();
        byte newline = rslen == 0 ? (byte)10 : sepValue.getUnsafeBytes()[sepValue.getBegin() + rslen - 1];
        int p2 = this.value.getBegin();
        int end2 = p2 + this.value.getRealSize();
        int ptr = p2;
        int s = p2;
        int len = this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        p2 += rslen;
        while (p2 < end2) {
            if (rslen == 0 && bytes2[p2] == 10) {
                if (bytes2[++p2] == 10) {
                    while (p2 < end2 && bytes2[p2] == 10) {
                        ++p2;
                    }
                }
            } else if (ptr < p2 && bytes2[p2 - 1] == newline && (rslen <= 1 || ByteList.memcmp(sepValue.getUnsafeBytes(), sepValue.getBegin(), rslen, bytes2, p2 - rslen, rslen) == 0)) {
                block.yield(context, this.makeShared(runtime2, s - ptr, p2 - s).infectBy(this));
                this.modifyCheck(bytes2, len);
                s = p2;
            }
            ++p2;
        }
        if (s != end2) {
            if (p2 > end2) {
                p2 = end2;
            }
            block.yield(context, this.makeShared(runtime2, s - ptr, p2 - s).infectBy(this));
        }
        return this;
    }

    @JRubyMethod(name={"each"}, frame=true, compat=CompatVersion.RUBY1_8)
    public IRubyObject each18(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_line(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "each");
    }

    @JRubyMethod(name={"each"}, frame=true, compat=CompatVersion.RUBY1_8)
    public IRubyObject each18(ThreadContext context, IRubyObject arg2, Block block) {
        return block.isGiven() ? this.each_lineCommon(context, arg2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), (IRubyObject)this, "each", arg2);
    }

    @JRubyMethod(name={"each_line"}, frame=true, compat=CompatVersion.RUBY1_8)
    public IRubyObject each_line18(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_line(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "each_line");
    }

    @JRubyMethod(name={"each_line"}, frame=true, compat=CompatVersion.RUBY1_8)
    public IRubyObject each_line18(ThreadContext context, IRubyObject arg2, Block block) {
        return block.isGiven() ? this.each_lineCommon(context, arg2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), (IRubyObject)this, "each_line", arg2);
    }

    @JRubyMethod(name={"lines"}, frame=true, compat=CompatVersion.RUBY1_8)
    public IRubyObject lines18(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_line(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "lines");
    }

    @JRubyMethod(name={"lines"}, frame=true, compat=CompatVersion.RUBY1_8)
    public IRubyObject lines18(ThreadContext context, IRubyObject arg2, Block block) {
        return block.isGiven() ? this.each_lineCommon(context, arg2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), (IRubyObject)this, "lines", arg2);
    }

    @JRubyMethod(name={"each_line"}, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject each_line19(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_lineCommon19(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "each_line");
    }

    @JRubyMethod(name={"each_line"}, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject each_line19(ThreadContext context, IRubyObject arg2, Block block) {
        return block.isGiven() ? this.each_lineCommon19(context, arg2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), (IRubyObject)this, "each_line", arg2);
    }

    @JRubyMethod(name={"lines"}, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject lines(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_lineCommon19(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "lines");
    }

    @JRubyMethod(name={"lines"}, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject lines(ThreadContext context, IRubyObject arg2, Block block) {
        return block.isGiven() ? this.each_lineCommon19(context, arg2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), (IRubyObject)this, "lines", arg2);
    }

    private IRubyObject each_lineCommon19(ThreadContext context, Block block) {
        return this.each_lineCommon19(context, context.getRuntime().getGlobalVariables().get("$/"), block);
    }

    private IRubyObject each_lineCommon19(ThreadContext context, IRubyObject sep, Block block) {
        int p2;
        Ruby runtime2 = context.getRuntime();
        if (sep.isNil()) {
            block.yield(context, this);
            return this;
        }
        ByteList val = this.value.shallowDup();
        int s = p2 = val.getBegin();
        int len = val.getRealSize();
        int end2 = p2 + len;
        byte[] bytes2 = val.getUnsafeBytes();
        RubyString sepStr = sep.convertToString();
        if (sepStr == runtime2.getGlobalVariables().getDefaultSeparator()) {
            Encoding enc = val.getEncoding();
            while (p2 < end2) {
                int p0;
                if (bytes2[p2] == 10 && enc.isNewLine(bytes2, p0 = enc.leftAdjustCharHead(bytes2, s, p2, end2), end2)) {
                    p2 = p0 + StringSupport.length(enc, bytes2, p0, end2);
                    block.yield(context, this.makeShared19(runtime2, val, s, p2 - s).infectBy(this));
                    s = p2++;
                }
                ++p2;
            }
        } else {
            Encoding enc = this.checkEncoding(sepStr);
            ByteList sepValue = sepStr.value;
            int rslen = sepValue.getRealSize();
            int newLine = rslen == 0 ? 10 : StringSupport.codePoint(runtime2, enc, sepValue.getUnsafeBytes(), sepValue.getBegin(), sepValue.getBegin() + sepValue.getRealSize());
            while (p2 < end2) {
                int c = StringSupport.codePoint(runtime2, enc, bytes2, p2, end2);
                int n = StringSupport.codeLength(runtime2, enc, c);
                if (rslen == 0 && c == newLine) {
                    if ((p2 += n) < end2 && (c = StringSupport.codePoint(runtime2, enc, bytes2, p2, end2)) != newLine) continue;
                    while (p2 < end2 && StringSupport.codePoint(runtime2, enc, bytes2, p2, end2) == newLine) {
                        p2 += n;
                    }
                    p2 -= n;
                }
                if (c == newLine && (rslen <= 1 || ByteList.memcmp(sepValue.getUnsafeBytes(), sepValue.getBegin(), rslen, bytes2, p2, rslen) == 0)) {
                    block.yield(context, this.makeShared19(runtime2, val, s, p2 - s + (rslen != 0 ? rslen : n)).infectBy(this));
                    s = p2 + (rslen != 0 ? rslen : n);
                }
                p2 += n;
            }
        }
        if (s != end2) {
            block.yield(context, this.makeShared19(runtime2, val, s, end2 - s).infectBy(this));
        }
        return this;
    }

    public RubyString each_byte(ThreadContext context, Block block) {
        Ruby runtime2 = context.getRuntime();
        for (int i = 0; i < this.value.length(); ++i) {
            block.yield(context, runtime2.newFixnum(this.value.get(i) & 0xFF));
        }
        return this;
    }

    @JRubyMethod(name={"each_byte"}, frame=true)
    public IRubyObject each_byte19(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_byte(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "each_byte");
    }

    @JRubyMethod(name={"bytes"}, frame=true)
    public IRubyObject bytes(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_byte(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "bytes");
    }

    @JRubyMethod(name={"each_char"}, frame=true, compat=CompatVersion.RUBY1_8)
    public IRubyObject each_char18(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_charCommon18(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "each_char");
    }

    @JRubyMethod(name={"chars"}, frame=true, compat=CompatVersion.RUBY1_8)
    public IRubyObject chars18(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_charCommon18(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "chars");
    }

    private IRubyObject each_charCommon18(ThreadContext context, Block block) {
        int n;
        int p2;
        byte[] bytes2 = this.value.getUnsafeBytes();
        int end2 = p2 + this.value.getRealSize();
        Ruby runtime2 = context.getRuntime();
        Encoding enc = runtime2.getKCode().getEncoding();
        ByteList val = this.value.shallowDup();
        for (p2 = this.value.getBegin(); p2 < end2; p2 += n) {
            n = StringSupport.length(enc, bytes2, p2, end2);
            block.yield(context, this.makeShared19(runtime2, val, p2 - val.getBegin(), n));
        }
        return this;
    }

    @JRubyMethod(name={"each_char"}, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject each_char19(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_charCommon19(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "each_char");
    }

    @JRubyMethod(name={"chars"}, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject chars19(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_charCommon19(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "chars");
    }

    private IRubyObject each_charCommon19(ThreadContext context, Block block) {
        int n;
        int p2;
        byte[] bytes2 = this.value.getUnsafeBytes();
        int end2 = p2 + this.value.getRealSize();
        Encoding enc = this.value.getEncoding();
        Ruby runtime2 = context.getRuntime();
        ByteList val = this.value.shallowDup();
        for (p2 = this.value.getBegin(); p2 < end2; p2 += n) {
            n = StringSupport.length(enc, bytes2, p2, end2);
            block.yield(context, this.makeShared19(runtime2, val, p2 - this.value.getBegin(), n));
        }
        return this;
    }

    @JRubyMethod(name={"each_codepoint"}, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject each_codepoint(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.getRuntime(), this, "each_codepoint");
        }
        return this.singleByteOptimizable() ? this.each_byte(context, block) : this.each_codepointCommon(context, block);
    }

    @JRubyMethod(name={"codepoints"}, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject codepoints(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.getRuntime(), this, "codepoints");
        }
        return this.singleByteOptimizable() ? this.each_byte(context, block) : this.each_codepointCommon(context, block);
    }

    private IRubyObject each_codepointCommon(ThreadContext context, Block block) {
        int n;
        int p2;
        Ruby runtime2 = context.getRuntime();
        byte[] bytes2 = this.value.getUnsafeBytes();
        int end2 = p2 + this.value.getRealSize();
        Encoding enc = this.value.getEncoding();
        for (p2 = this.value.getBegin(); p2 < end2; p2 += n) {
            int c = StringSupport.codePoint(runtime2, enc, bytes2, p2, end2);
            n = StringSupport.codeLength(runtime2, enc, c);
            block.yield(context, runtime2.newFixnum(c));
        }
        return this;
    }

    private RubySymbol to_sym() {
        RubySymbol symbol = this.getRuntime().getSymbolTable().getSymbol(this.value);
        if (symbol.getBytes() == this.value) {
            this.shareLevel = 2;
        }
        return symbol;
    }

    @JRubyMethod(name={"to_sym", "intern"}, compat=CompatVersion.RUBY1_8)
    public RubySymbol intern() {
        if (this.value.getRealSize() == 0) {
            throw this.getRuntime().newArgumentError("interning empty string");
        }
        for (int i = 0; i < this.value.getRealSize(); ++i) {
            if (this.value.getUnsafeBytes()[this.value.getBegin() + i] != 0) continue;
            throw this.getRuntime().newArgumentError("symbol string may not contain '\\0'");
        }
        return this.to_sym();
    }

    @JRubyMethod(name={"to_sym", "intern"}, compat=CompatVersion.RUBY1_9)
    public RubySymbol intern19() {
        return this.to_sym();
    }

    @JRubyMethod(name={"ord"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject ord(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        return RubyFixnum.newFixnum(runtime2, StringSupport.codePoint(runtime2, this.value.getEncoding(), this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getBegin() + this.value.getRealSize()));
    }

    @JRubyMethod(name={"sum"})
    public IRubyObject sum(ThreadContext context) {
        return this.sumCommon(context, 16L);
    }

    @JRubyMethod(name={"sum"})
    public IRubyObject sum(ThreadContext context, IRubyObject arg2) {
        return this.sumCommon(context, RubyNumeric.num2long(arg2));
    }

    public IRubyObject sumCommon(ThreadContext context, long bits) {
        Ruby runtime2 = context.getRuntime();
        byte[] bytes2 = this.value.getUnsafeBytes();
        int p2 = this.value.getBegin();
        int len = this.value.getRealSize();
        int end2 = p2 + len;
        if (bits >= 64L) {
            RubyFixnum one = RubyFixnum.one(runtime2);
            IRubyObject sum2 = RubyFixnum.zero(runtime2);
            while (p2 < end2) {
                this.modifyCheck(bytes2, len);
                sum2 = sum2.callMethod(context, "+", RubyFixnum.newFixnum(runtime2, bytes2[p2++] & 0xFF));
            }
            if (bits != 0L) {
                IRubyObject mod = one.callMethod(context, "<<", (IRubyObject)RubyFixnum.newFixnum(runtime2, bits));
                sum2 = sum2.callMethod(context, "&", mod.callMethod(context, "-", one));
            }
            return sum2;
        }
        long sum3 = 0L;
        while (p2 < end2) {
            this.modifyCheck(bytes2, len);
            sum3 += (long)(bytes2[p2++] & 0xFF);
        }
        return RubyFixnum.newFixnum(runtime2, bits == 0L ? sum3 : sum3 & (1L << (int)bits) - 1L);
    }

    @JRubyMethod(name={"to_c"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_c(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        DynamicScope scope = context.getCurrentScope();
        IRubyObject backref = scope.getBackRef(runtime2);
        if (backref instanceof RubyMatchData) {
            ((RubyMatchData)backref).use();
        }
        IRubyObject s = RuntimeHelpers.invoke(context, (IRubyObject)this, "gsub", (IRubyObject)RubyRegexp.newDummyRegexp(runtime2, Numeric.ComplexPatterns.underscores_pat), runtime2.newString(new ByteList(new byte[]{95})));
        RubyArray a = RubyComplex.str_to_c_internal(context, s);
        scope.setBackRef(backref);
        if (!a.eltInternal(0).isNil()) {
            return a.eltInternal(0);
        }
        return RubyComplex.newComplexCanonicalize(context, RubyFixnum.zero(runtime2));
    }

    @JRubyMethod(name={"to_r"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_r(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        DynamicScope scope = context.getCurrentScope();
        IRubyObject backref = scope.getBackRef(runtime2);
        if (backref instanceof RubyMatchData) {
            ((RubyMatchData)backref).use();
        }
        IRubyObject s = RuntimeHelpers.invoke(context, (IRubyObject)this, "gsub", (IRubyObject)RubyRegexp.newDummyRegexp(runtime2, Numeric.ComplexPatterns.underscores_pat), runtime2.newString(new ByteList(new byte[]{95})));
        RubyArray a = RubyRational.str_to_r_internal(context, s);
        scope.setBackRef(backref);
        if (!a.eltInternal(0).isNil()) {
            return a.eltInternal(0);
        }
        return RubyRational.newRationalCanonicalize(context, RubyFixnum.zero(runtime2));
    }

    public static RubyString unmarshalFrom(UnmarshalStream input) throws IOException {
        RubyString result = RubyString.newString(input.getRuntime(), input.unmarshalString());
        input.registerLinkTarget(result);
        return result;
    }

    @JRubyMethod(name={"unpack"})
    public RubyArray unpack(IRubyObject obj) {
        return Pack.unpack(this.getRuntime(), this.value, RubyString.stringValue((IRubyObject)obj).value);
    }

    public void empty() {
        this.value = ByteList.EMPTY_BYTELIST;
        this.shareLevel = 2;
    }

    @JRubyMethod(name={"encoding"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject encoding(ThreadContext context) {
        return context.getRuntime().getEncodingService().getEncoding(this.value.getEncoding());
    }

    @JRubyMethod(name={"encode!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject encode_bang(ThreadContext context) {
        this.modify19();
        IRubyObject defaultInternal = RubyEncoding.getDefaultInternal(context.getRuntime());
        if (!defaultInternal.isNil()) {
            this.encode_bang(context, defaultInternal);
        }
        return this;
    }

    @JRubyMethod(name={"encode!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject encode_bang(ThreadContext context, IRubyObject enc) {
        this.modify19();
        Ruby runtime2 = context.getRuntime();
        this.value = this.encodeCommon(context, runtime2, this.value, enc, runtime2.getNil(), runtime2.getNil());
        return this;
    }

    @JRubyMethod(name={"encode!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject encode_bang(ThreadContext context, IRubyObject enc, IRubyObject arg2) {
        this.modify19();
        Ruby runtime2 = context.getRuntime();
        IRubyObject fromEnc = arg2;
        IRubyObject opts = runtime2.getNil();
        if (arg2 instanceof RubyHash) {
            fromEnc = runtime2.getNil();
            opts = arg2;
        }
        this.value = this.encodeCommon(context, runtime2, this.value, enc, fromEnc, opts);
        return this;
    }

    @JRubyMethod(name={"encode!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject encode_bang(ThreadContext context, IRubyObject enc, IRubyObject fromEnc, IRubyObject opts) {
        this.modify19();
        this.value = this.encodeCommon(context, context.getRuntime(), this.value, enc, fromEnc, opts);
        return this;
    }

    @JRubyMethod(name={"encode"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject encode(ThreadContext context) {
        this.modify19();
        Ruby runtime2 = context.getRuntime();
        IRubyObject defaultInternal = RubyEncoding.getDefaultInternal(runtime2);
        if (!defaultInternal.isNil()) {
            ByteList encoded = this.encodeCommon(context, runtime2, this.value, defaultInternal, runtime2.getNil(), runtime2.getNil());
            return runtime2.newString(encoded);
        }
        return this.dup();
    }

    @JRubyMethod(name={"encode"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject encode(ThreadContext context, IRubyObject enc) {
        this.modify19();
        Ruby runtime2 = context.getRuntime();
        ByteList encoded = this.encodeCommon(context, runtime2, this.value, enc, runtime2.getNil(), runtime2.getNil());
        return runtime2.newString(encoded);
    }

    @JRubyMethod(name={"encode"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject encode(ThreadContext context, IRubyObject enc, IRubyObject arg2) {
        this.modify19();
        Ruby runtime2 = context.getRuntime();
        IRubyObject fromEnc = arg2;
        IRubyObject opts = runtime2.getNil();
        if (arg2 instanceof RubyHash) {
            fromEnc = runtime2.getNil();
            opts = arg2;
        }
        ByteList encoded = this.encodeCommon(context, runtime2, this.value, enc, fromEnc, opts);
        return runtime2.newString(encoded);
    }

    @JRubyMethod(name={"encode"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject encode(ThreadContext context, IRubyObject enc, IRubyObject fromEnc, IRubyObject opts) {
        this.modify19();
        Ruby runtime2 = context.getRuntime();
        ByteList encoded = this.encodeCommon(context, runtime2, this.value, enc, fromEnc, opts);
        return runtime2.newString(encoded);
    }

    private ByteList encodeCommon(ThreadContext context, Ruby runtime2, ByteList value2, IRubyObject toEnc, IRubyObject fromEnc, IRubyObject opts) {
        ByteBuffer toBytes;
        Charset from = fromEnc.isNil() ? this.getCharset(runtime2, value2.getEncoding()) : this.getCharset(runtime2, fromEnc);
        Encoding encoding2 = this.getEncoding(runtime2, toEnc);
        Charset to = this.getCharset(runtime2, encoding2);
        CharsetEncoder encoder = this.getEncoder(context, runtime2, to, opts);
        ByteBuffer fromBytes = ByteBuffer.wrap(value2.getUnsafeBytes(), value2.begin(), value2.length());
        try {
            toBytes = encoder.encode(from.decode(fromBytes));
        }
        catch (CharacterCodingException e) {
            throw runtime2.newInvalidByteSequenceError("");
        }
        ByteList result = new ByteList(toBytes.array(), toBytes.arrayOffset(), toBytes.limit() - toBytes.arrayOffset(), false);
        result.setEncoding(encoding2);
        return result;
    }

    private CharsetEncoder getEncoder(ThreadContext context, Ruby runtime2, Charset charset, IRubyObject opts) {
        CharsetEncoder encoder = charset.newEncoder();
        if (!opts.isNil()) {
            IRubyObject undef;
            IRubyObject invalid;
            RubyHash hash2 = (RubyHash)opts;
            CodingErrorAction action = CodingErrorAction.REPLACE;
            IRubyObject replace2 = hash2.fastARef(runtime2.newSymbol("replace"));
            if (replace2 != null && !replace2.isNil()) {
                String replaceWith = replace2.toString();
                if (replaceWith.length() > 0) {
                    encoder.replaceWith(replaceWith.getBytes());
                } else {
                    action = CodingErrorAction.IGNORE;
                }
            }
            if ((invalid = hash2.fastARef(runtime2.newSymbol("invalid"))) != null && invalid.op_equal(context, runtime2.newSymbol("replace")).isTrue()) {
                encoder.onMalformedInput(action);
            }
            if ((undef = hash2.fastARef(runtime2.newSymbol("undef"))) != null && undef.op_equal(context, runtime2.newSymbol("replace")).isTrue()) {
                encoder.onUnmappableCharacter(action);
            }
        }
        return encoder;
    }

    private Encoding getEncoding(Ruby runtime2, IRubyObject toEnc) {
        try {
            return RubyEncoding.getEncodingFromObject(runtime2, toEnc);
        }
        catch (Exception e) {
            throw runtime2.newConverterNotFoundError("code converter not found (" + toEnc.toString() + ")");
        }
    }

    private Charset getCharset(Ruby runtime2, IRubyObject toEnc) {
        try {
            Encoding encoding2 = RubyEncoding.getEncodingFromObject(runtime2, toEnc);
            return this.getCharset(runtime2, encoding2);
        }
        catch (Exception e) {
            throw runtime2.newConverterNotFoundError("code converter not found (" + toEnc.toString() + ")");
        }
    }

    private Charset getCharset(Ruby runtime2, Encoding encoding2) {
        try {
            return encoding2.toString().startsWith("ASCII") ? Charset.forName("ASCII") : Charset.forName(encoding2.toString());
        }
        catch (Exception e) {
            throw runtime2.newConverterNotFoundError("code converter not found (" + encoding2.toString() + ")");
        }
    }

    @JRubyMethod(name={"force_encoding"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject force_encoding(ThreadContext context, IRubyObject enc) {
        this.modify19();
        Encoding encoding2 = RubyEncoding.getEncodingFromObject(context.getRuntime(), enc);
        this.associateEncoding(encoding2);
        return this;
    }

    @JRubyMethod(name={"valid_encoding?"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject valid_encoding_p(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        return this.scanForCodeRange() == 96 ? runtime2.getFalse() : runtime2.getTrue();
    }

    @JRubyMethod(name={"ascii_only?"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject ascii_only_p(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        return this.scanForCodeRange() == 32 ? runtime2.getTrue() : runtime2.getFalse();
    }

    public void setValue(CharSequence value2) {
        this.view(ByteList.plain(value2));
    }

    public void setValue(ByteList value2) {
        this.view(value2);
    }

    public CharSequence getValue() {
        return this.toString();
    }

    public byte[] getBytes() {
        return this.value.bytes();
    }

    public ByteList getByteList() {
        return this.value;
    }

    public String getUnicodeValue() {
        try {
            return new String(this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getRealSize(), "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("Something's seriously broken with encodings", e);
        }
    }

    @Override
    public Object toJava(Class target) {
        return JavaUtil.coerceStringToType(this, target);
    }

    @Deprecated
    public IRubyObject initialize(IRubyObject[] args2, Block unusedBlock) {
        switch (args2.length) {
            case 0: {
                return this;
            }
            case 1: {
                return this.initialize(args2[0]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 0, 1);
        return null;
    }

    @Deprecated
    public IRubyObject sub(ThreadContext context, IRubyObject[] args2, Block block) {
        RubyString str = this.strDup(context.getRuntime());
        str.sub_bang(context, args2, block);
        return str;
    }

    @Deprecated
    public IRubyObject sub_bang(ThreadContext context, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 1: {
                return this.sub_bang(context, args2[0], block);
            }
            case 2: {
                return this.sub_bang(context, args2[0], args2[1], block);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args2.length, 1, 2);
        return null;
    }

    @Deprecated
    public IRubyObject gsub(ThreadContext context, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 1: {
                return this.gsub(context, args2[0], block);
            }
            case 2: {
                return this.gsub(context, args2[0], args2[1], block);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args2.length, 1, 2);
        return null;
    }

    @Deprecated
    public IRubyObject gsub_bang(ThreadContext context, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 1: {
                return this.gsub_bang(context, args2[0], block);
            }
            case 2: {
                return this.gsub_bang(context, args2[0], args2[1], block);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args2.length, 1, 2);
        return null;
    }

    @Deprecated
    public IRubyObject index(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return this.index(context, args2[0]);
            }
            case 2: {
                return this.index(context, args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args2.length, 1, 2);
        return null;
    }

    @Deprecated
    public IRubyObject rindex(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return this.rindex(context, args2[0]);
            }
            case 2: {
                return this.rindex(context, args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args2.length, 1, 2);
        return null;
    }

    @Deprecated
    public IRubyObject op_aref(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return this.op_aref(context, args2[0]);
            }
            case 2: {
                return this.op_aref(context, args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args2.length, 1, 2);
        return null;
    }

    @Deprecated
    public IRubyObject op_aset(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 2: {
                return this.op_aset(context, args2[0], args2[1]);
            }
            case 3: {
                return this.op_aset(context, args2[0], args2[1], args2[2]);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args2.length, 2, 3);
        return null;
    }

    @Deprecated
    public IRubyObject slice_bang(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return this.slice_bang(context, args2[0]);
            }
            case 2: {
                return this.slice_bang(context, args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args2.length, 1, 2);
        return null;
    }

    @Deprecated
    public IRubyObject to_i(IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.to_i();
            }
            case 1: {
                return this.to_i(args2[0]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 0, 1);
        return null;
    }

    @Deprecated
    public RubyArray split(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.split(context);
            }
            case 1: {
                return this.split(context, args2[0]);
            }
            case 2: {
                return this.split(context, args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args2.length, 0, 2);
        return null;
    }

    @Deprecated
    public IRubyObject ljust(IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return this.ljust(args2[0]);
            }
            case 2: {
                return this.ljust(args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 1, 2);
        return null;
    }

    @Deprecated
    public IRubyObject rjust(IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return this.rjust(args2[0]);
            }
            case 2: {
                return this.rjust(args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 1, 2);
        return null;
    }

    @Deprecated
    public IRubyObject center(IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return this.center(args2[0]);
            }
            case 2: {
                return this.center(args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 1, 2);
        return null;
    }

    @Deprecated
    public RubyString chomp(IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.chomp(this.getRuntime().getCurrentContext());
            }
            case 1: {
                return this.chomp(this.getRuntime().getCurrentContext(), args2[0]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 0, 1);
        return null;
    }

    @Deprecated
    public IRubyObject chomp_bang(IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.chomp_bang(this.getRuntime().getCurrentContext());
            }
            case 1: {
                return this.chomp_bang(this.getRuntime().getCurrentContext(), args2[0]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 0, 1);
        return null;
    }

    private static final class TrTables {
        private IntHash<IRubyObject> del;
        private IntHash<IRubyObject> noDel;

        private TrTables() {
        }
    }

    private static final class TR {
        int p;
        int pend;
        int now;
        int max;
        boolean gen;
        byte[] buf;

        TR(ByteList bytes2) {
            this.p = bytes2.getBegin();
            this.pend = bytes2.getRealSize() + this.p;
            this.buf = bytes2.getUnsafeBytes();
            this.max = 0;
            this.now = 0;
            this.gen = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NeighborChar {
        NOT_CHAR,
        FOUND,
        WRAPPED;

    }

    private static final class EmptyByteListHolder {
        final ByteList bytes;
        final int cr;

        EmptyByteListHolder(Encoding enc) {
            this.bytes = new ByteList(ByteList.NULL_ARRAY, enc);
            this.cr = this.bytes.getEncoding().isAsciiCompatible() ? 32 : 64;
        }
    }
}

