/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.jsr223;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.jruby.RubyNil;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.jsr223.JRubyEngine;
import org.jruby.embed.jsr223.Utils;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class JRubyCompiledScript
extends CompiledScript {
    private ScriptingContainer container;
    private JRubyEngine engine;
    private final EmbedEvalUnit unit;

    JRubyCompiledScript(ScriptingContainer container, JRubyEngine engine, String script) {
        this.container = container;
        this.engine = engine;
        this.unit = container.parse(script, new int[0]);
    }

    JRubyCompiledScript(ScriptingContainer container, JRubyEngine engine, Reader reader) {
        this.container = container;
        this.engine = engine;
        String filename2 = System.getProperty("javax.script.filename");
        this.unit = container.parse(reader, filename2, Utils.getLineNumber(engine));
    }

    public Object eval() throws ScriptException {
        try {
            IRubyObject ret = this.unit.run();
            return JavaEmbedUtils.rubyToJava(ret);
        }
        catch (Exception e) {
            throw this.wrapException(e);
        }
    }

    public Object eval(Bindings bindings) throws ScriptException {
        if (bindings == null) {
            throw new NullPointerException("bindings is null");
        }
        this.engine.getContext().setBindings(bindings, 100);
        try {
            IRubyObject ret = this.unit.run();
            return JavaEmbedUtils.rubyToJava(ret);
        }
        catch (Exception e) {
            throw this.wrapException(e);
        }
    }

    public Object eval(ScriptContext context) throws ScriptException {
        try {
            this.engine.setContext(context);
            IRubyObject ret = this.unit.run();
            if (!(ret instanceof RubyNil)) {
                return JavaEmbedUtils.rubyToJava(ret);
            }
            return null;
        }
        catch (Exception e) {
            throw this.wrapException(e);
        }
    }

    private ScriptException wrapException(Exception e) throws ScriptException {
        Writer w = this.container.getErrorWriter();
        if (w instanceof PrintWriter) {
            e.printStackTrace((PrintWriter)w);
        } else {
            try {
                w.write(e.getMessage());
            }
            catch (IOException ex) {
                return new ScriptException(ex);
            }
        }
        if (e.getCause() instanceof Exception) {
            return new ScriptException((Exception)e.getCause());
        }
        return new ScriptException(e);
    }

    public ScriptEngine getEngine() {
        return this.engine;
    }
}

