/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.jsr223;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.jsr223.JRubyEngine;
import org.jruby.embed.util.SystemPropertyCatcher;

public class JRubyEngineFactory
implements ScriptEngineFactory {
    private static final String jsr223Props = "org/jruby/embed/jsr223/Jsr223JRubyEngine.properties";
    private final ScriptingContainer container;
    private final String engineName;
    private final String engineVersion;
    private final List<String> extensions;
    private final String languageName;
    private String languageVersion;
    private final List<String> mimeTypes;
    private final List<String> engineIds;
    private Map<String, Object> parameters;

    public JRubyEngineFactory() {
        LocalContextScope scope = SystemPropertyCatcher.getScope(LocalContextScope.SINGLETON);
        LocalVariableBehavior behavior = SystemPropertyCatcher.getBehavior(LocalVariableBehavior.GLOBAL);
        this.container = new ScriptingContainer(scope, behavior, jsr223Props);
        SystemPropertyCatcher.setConfiguration(this.container);
        this.engineName = this.getSingleValue("engine.name").trim();
        this.engineVersion = this.getSingleValue("engine.version").trim();
        this.extensions = Collections.unmodifiableList(this.getMultipleValue("language.extension"));
        this.languageName = this.getSingleValue("language.name").trim();
        this.mimeTypes = Collections.unmodifiableList(this.getMultipleValue("language.mimetypes"));
        this.engineIds = Collections.unmodifiableList(this.getMultipleValue("engine.ids"));
    }

    private String getSingleValue(String key2) {
        String[] array = this.container.getProperty(key2);
        if (array == null) {
            throw new NullPointerException(key2 + "is not defined");
        }
        return array[0];
    }

    private List getMultipleValue(String key2) {
        String[] array = this.container.getProperty(key2);
        if (array == null) {
            throw new NullPointerException(key2 + "is not defined");
        }
        ArrayList<String> list2 = new ArrayList<String>();
        for (String s : array) {
            list2.add(s);
        }
        return list2;
    }

    private void initParameters() {
        this.parameters = new HashMap<String, Object>();
        this.parameters.put("javax.script.engine", this.getEngineName());
        this.parameters.put("javax.script.engine_version", this.getEngineVersion());
        this.parameters.put("javax.script.name", this.getEngineName());
        this.parameters.put("javax.script.language", this.getLanguageName());
        this.parameters.put("javax.script.language_version", this.getLanguageVersion());
        this.parameters.put("THREADING", "THREAD-ISOLATED");
    }

    public String getEngineName() {
        return this.engineName;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public List getExtensions() {
        return this.extensions;
    }

    public String getLanguageName() {
        return this.languageName;
    }

    public String getLanguageVersion() {
        if (this.languageVersion == null) {
            this.languageVersion = this.container.getSupportedRubyVersion();
        }
        return this.languageVersion;
    }

    public String getMethodCallSyntax(String obj, String m, String ... args2) {
        if (m == null || m.length() == 0) {
            return "";
        }
        if (args2 == null || args2.length == 0) {
            if (obj == null || obj.length() == 0) {
                return MessageFormat.format("{0}", m);
            }
            return MessageFormat.format("{0}.{1}", obj, m);
        }
        String argsString = "";
        for (String arg2 : args2) {
            argsString = argsString + arg2 + ", ";
        }
        argsString = argsString.substring(0, argsString.length() - 2);
        if (obj == null || obj.length() == 0) {
            return MessageFormat.format("{0}({1})", m, argsString);
        }
        return MessageFormat.format("{0}.{1}({2})", obj, m, argsString);
    }

    public List getMimeTypes() {
        return this.mimeTypes;
    }

    public List getNames() {
        return this.engineIds;
    }

    public String getOutputStatement(String toDisplay) {
        if (toDisplay == null || toDisplay.length() == 0) {
            return "";
        }
        return "puts " + toDisplay + "\nor\nprint " + toDisplay;
    }

    public Object getParameter(String key2) {
        if (this.parameters == null) {
            this.initParameters();
        }
        return this.parameters.get(key2);
    }

    public String getProgram(String ... statements) {
        if (statements == null || statements.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (String s : statements) {
            sb.append(s);
            sb.append("\n");
        }
        return new String(sb);
    }

    public ScriptEngine getScriptEngine() {
        JRubyEngine engine = new JRubyEngine(this.container, this);
        return engine;
    }
}

