/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.marshal;

import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jruby.RubySymbol;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;

public class MarshalCache {
    private final Map linkCache = new IdentityHashMap();
    private final Map symbolCache = new IdentityHashMap();

    public boolean isRegistered(IRubyObject value2) {
        return this.selectCache(value2).containsKey(value2);
    }

    public void register(IRubyObject value2) {
        Map cache = this.selectCache(value2);
        cache.put(value2, cache.size());
    }

    private int registeredIndex(IRubyObject value2) {
        return (Integer)this.selectCache(value2).get(value2);
    }

    private Map selectCache(IRubyObject value2) {
        return value2 instanceof RubySymbol ? this.symbolCache : this.linkCache;
    }

    public void writeLink(MarshalStream output, IRubyObject value2) throws IOException {
        output.write(MarshalCache.linkType(value2));
        output.writeInt(this.registeredIndex(value2));
    }

    private static char linkType(IRubyObject value2) {
        return value2 instanceof RubySymbol ? (char)';' : '@';
    }
}

