/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.jruby.util.CompoundJarURLStreamHandler;
import org.jruby.util.SafePropertyAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRubyClassLoader
extends URLClassLoader {
    private static final ProtectionDomain DEFAULT_DOMAIN = JRubyClassLoader.class.getProtectionDomain();

    public JRubyClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public Class<?> defineClass(String name2, byte[] bytes2) {
        return super.defineClass(name2, bytes2, 0, bytes2.length, DEFAULT_DOMAIN);
    }

    public Class<?> defineClass(String name2, byte[] bytes2, ProtectionDomain domain) {
        return super.defineClass(name2, bytes2, 0, bytes2.length, domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL findResource(String resourceName) {
        URL result = super.findResource(resourceName);
        if (result == null && JRubyClassLoader.embeddedResourcesEnabled()) {
            for (URL jarUrl : this.getURLs()) {
                try {
                    InputStream baseInputStream = jarUrl.openStream();
                    try {
                        JarInputStream baseJar = new JarInputStream(baseInputStream);
                        List<String> path2 = this.findEmbeddedResource(baseJar, resourceName, new ArrayList<String>(), 0);
                        if (path2 == null) continue;
                        result = CompoundJarURLStreamHandler.createUrl(jarUrl, path2);
                    }
                    finally {
                        JRubyClassLoader.close(baseInputStream);
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<URL> findResources(String resourceName) throws IOException {
        if (!JRubyClassLoader.embeddedResourcesEnabled()) {
            return super.findResources(resourceName);
        }
        final ArrayList<URL> embeddedUrls = new ArrayList<URL>();
        for (URL jarUrl : this.getURLs()) {
            try {
                InputStream baseInputStream = jarUrl.openStream();
                try {
                    JarInputStream baseJar = new JarInputStream(baseInputStream);
                    ArrayList<List<String>> result = new ArrayList<List<String>>();
                    this.collectEmbeddedResources(result, baseJar, resourceName, new ArrayList<String>(), 0);
                    for (List list2 : result) {
                        embeddedUrls.add(CompoundJarURLStreamHandler.createUrl(jarUrl, list2));
                    }
                }
                finally {
                    JRubyClassLoader.close(baseInputStream);
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (embeddedUrls.isEmpty()) {
            return super.findResources(resourceName);
        }
        final Enumeration<URL> originalResult = super.findResources(resourceName);
        return new Enumeration<URL>(){
            private Iterator<URL> extendedResult;

            @Override
            public URL nextElement() {
                if (this.extendedResult == null) {
                    return (URL)originalResult.nextElement();
                }
                return this.extendedResult.next();
            }

            @Override
            public boolean hasMoreElements() {
                if (this.extendedResult == null) {
                    boolean result = originalResult.hasMoreElements();
                    if (!result) {
                        this.extendedResult = embeddedUrls.iterator();
                        result = this.extendedResult.hasNext();
                    }
                    return result;
                }
                return this.extendedResult.hasNext();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private List<String> findEmbeddedResource(JarInputStream currentJar, String resourceName, List<String> currentPath, int level) throws IOException {
        entry = currentJar.getNextJarEntry();
        while (entry != null) {
            block9: {
                entryName = entry.getName();
                result /* !! */  = null;
                if (!entryName.equals(resourceName)) break block9;
                result /* !! */  = new ArrayList<String>(currentPath);
                result /* !! */ .add(resourceName);
                ** GOTO lbl-1000
            }
            if (JRubyClassLoader.isJarFile(entry)) {
                embeddedResourceName = resourceName;
                if (resourceName.startsWith(entryName + "!")) {
                    embeddedResourceName = resourceName.substring(entryName.length() + 1);
                    embeddedJar = new JarInputStream(currentJar);
                    currentPath.add(entryName);
                    try {
                        result /* !! */  = this.findEmbeddedResource(embeddedJar, embeddedResourceName, currentPath, level + 1);
                        ** break block8
                    }
                    finally {
                        currentPath.remove(entryName);
                    }
                }
            } else lbl-1000:
            // 3 sources

            {
                if (result /* !! */  != null) {
                    return result /* !! */ ;
                }
            }
            entry = currentJar.getNextJarEntry();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectEmbeddedResources(List<List<String>> result, JarInputStream currentJar, String resourceName, List<String> currentPath, int level2) throws IOException {
        JarEntry entry = currentJar.getNextJarEntry();
        while (entry != null) {
            String entryName = entry.getName();
            if (entryName.equals(resourceName)) {
                ArrayList<String> path2 = new ArrayList<String>(currentPath);
                path2.add(resourceName);
                result.add(path2);
            }
            if (JRubyClassLoader.isJarFile(entry)) {
                String embeddedResourceName = resourceName;
                if (resourceName.startsWith(entryName + "!")) {
                    embeddedResourceName = resourceName.substring(entryName.length() + 1);
                    JarInputStream embeddedJar = new JarInputStream(currentJar);
                    currentPath.add(entryName);
                    try {
                        this.collectEmbeddedResources(result, embeddedJar, embeddedResourceName, currentPath, level2 + 1);
                    }
                    finally {
                        currentPath.remove(entryName);
                    }
                }
            }
            entry = currentJar.getNextJarEntry();
        }
    }

    private static boolean embeddedResourcesEnabled() {
        return SafePropertyAccessor.getBoolean("jruby.embedded.resources", false);
    }

    private static boolean isJarFile(JarEntry entry) {
        return !entry.isDirectory() && entry.getName().endsWith(".jar");
    }

    private static void close(Closeable resource2) {
        if (resource2 != null) {
            try {
                resource2.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

