# PDF-O-Matic is copyright (c) 2009, Brett Neumeier.
#
# PDF-O-Matic may be used under the terms of the GPL.  See
# COPYING.GPL, provided in this distribution, for full details.
#
# DOJ and CompNet Design, Inc., are granted a perpetual license to
# use, extend, modify, and redistribute the PDF-O-Matic software as
# they wish, without restriction.

require 'pdf_helpers'
require 'item_box'

class DisadBox < ItemBox

  class DisadItem < ItemBoxItem
    def initialize(pdf, item)
      super(pdf, item)
      @cost = item['cost'] || ''
      @roll = ''
      t = item['text'] || ''
      @text = cleanup_string(t)
      # Roll for disads is buried in the adders. Maybe it's
      # always in APPEARANCE?
      return unless Enumerable === item['adders']
      item['adders'].each { |a|
        if a['xmlid'] == 'APPEARANCE'
          @roll = a['option_alias']
        end
      }
    end
    attr_reader :cost, :roll
  end

  def add_all(character)
    return self unless Enumerable === character["disads"]
    character["disads"].each { |item|
      if item['separator']
        items << SeparatorItem.new
      else
        items << DisadItem.new(pdf, item)
      end
    }
    self
  end

  def contents
    'disadvantage'
  end

end
