/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.jcodings.exception.CharacterPropertyException;
import org.joni.Option;
import org.joni.ScanEnvironment;
import org.joni.ScannerSupport;
import org.joni.Syntax;
import org.joni.Token;
import org.joni.ast.QuantifierNode;
import org.joni.constants.TokenType;

class Lexer
extends ScannerSupport {
    protected final ScanEnvironment env;
    protected final Syntax syntax;
    protected final Token token = new Token();
    private static final int[] send = new int[]{58, 93};

    protected Lexer(ScanEnvironment scanEnvironment, byte[] byArray, int n, int n2) {
        super(scanEnvironment.enc, byArray, n, n2);
        this.env = scanEnvironment;
        this.syntax = scanEnvironment.syntax;
    }

    private int fetchRangeQuantifier() {
        int n;
        int n2;
        this.mark();
        boolean bl = this.syntax.allowInvalidInterval();
        if (!this.left()) {
            if (bl) {
                return 1;
            }
            this.newSyntaxException("end pattern at left brace");
        }
        if (!bl) {
            this.c = this.peek();
            if (this.c == 41 || this.c == 40 || this.c == 124) {
                this.newSyntaxException("end pattern at left brace");
            }
        }
        if ((n2 = this.scanUnsignedNumber()) < 0) {
            this.newSyntaxException("too big number for repeat range");
        }
        if (n2 > 100000) {
            this.newSyntaxException("too big number for repeat range");
        }
        boolean bl2 = false;
        if (this.p == this._p) {
            if (this.syntax.allowIntervalLowAbbrev()) {
                n2 = 0;
                bl2 = true;
            } else {
                return this.invalidRangeQuantifier(bl);
            }
        }
        if (!this.left()) {
            return this.invalidRangeQuantifier(bl);
        }
        this.fetch();
        int n3 = 0;
        if (this.c == 44) {
            int n4 = this.p;
            n = this.scanUnsignedNumber();
            if (n < 0) {
                this.newValueException("too big number for repeat range");
            }
            if (n > 100000) {
                this.newValueException("too big number for repeat range");
            }
            if (this.p == n4) {
                if (bl2) {
                    return this.invalidRangeQuantifier(bl);
                }
                n = -1;
            }
        } else {
            if (bl2) {
                return this.invalidRangeQuantifier(bl);
            }
            this.unfetch();
            n = n2;
            n3 = 2;
        }
        if (!this.left()) {
            return this.invalidRangeQuantifier(bl);
        }
        this.fetch();
        if (this.syntax.opEscBraceInterval()) {
            if (this.c != this.syntax.metaCharTable.esc) {
                return this.invalidRangeQuantifier(bl);
            }
            this.fetch();
        }
        if (this.c != 125) {
            return this.invalidRangeQuantifier(bl);
        }
        if (!QuantifierNode.isRepeatInfinite(n) && n2 > n) {
            this.newValueException("upper is smaller than lower in repeat range");
        }
        this.token.type = TokenType.INTERVAL;
        this.token.setRepeatLower(n2);
        this.token.setRepeatUpper(n);
        return n3;
    }

    private int invalidRangeQuantifier(boolean bl) {
        if (bl) {
            this.restore();
            return 1;
        }
        this.newSyntaxException("invalid repeat range {lower,upper}");
        return 0;
    }

    private int fetchEscapedValue() {
        if (!this.left()) {
            this.newSyntaxException("end pattern at escape");
        }
        this.fetch();
        switch (this.c) {
            case 77: {
                if (this.syntax.op2EscCapitalMBarMeta()) {
                    if (!this.left()) {
                        this.newSyntaxException("end pattern at meta");
                    }
                    this.fetch();
                    if (this.c != 45) {
                        this.newSyntaxException("invalid meta-code syntax");
                    }
                    if (!this.left()) {
                        this.newSyntaxException("end pattern at meta");
                    }
                    this.fetch();
                    if (this.c == this.syntax.metaCharTable.esc) {
                        this.c = this.fetchEscapedValue();
                    }
                    this.c = this.c & 0xFF | 0x80;
                    break;
                }
                this.fetchEscapedValueBackSlash();
                break;
            }
            case 67: {
                if (this.syntax.op2EscCapitalCBarControl()) {
                    if (!this.left()) {
                        this.newSyntaxException("end pattern at control");
                    }
                    this.fetch();
                    if (this.c != 45) {
                        this.newSyntaxException("invalid control-code syntax");
                    }
                    this.fetchEscapedValueControl();
                    break;
                }
                this.fetchEscapedValueBackSlash();
                break;
            }
            case 99: {
                if (this.syntax.opEscCControl()) {
                    this.fetchEscapedValueControl();
                }
            }
            default: {
                this.fetchEscapedValueBackSlash();
            }
        }
        return this.c;
    }

    private void fetchEscapedValueBackSlash() {
        this.c = this.env.convertBackslashValue(this.c);
    }

    private void fetchEscapedValueControl() {
        if (!this.left()) {
            this.newSyntaxException("end pattern at control");
        }
        this.fetch();
        if (this.c == 63) {
            this.c = 127;
        } else {
            if (this.c == this.syntax.metaCharTable.esc) {
                this.c = this.fetchEscapedValue();
            }
            this.c &= 0x9F;
        }
    }

    private int nameEndCodePoint(int n) {
        switch (n) {
            case 60: {
                return 62;
            }
            case 39: {
                return 39;
            }
        }
        return 0;
    }

    private boolean fetchNameWithLevel(int n, int[] nArray, int[] nArray2) {
        int n2;
        int n3 = this.p;
        boolean bl = false;
        int n4 = 0;
        int n5 = 1;
        int n6 = this.nameEndCodePoint(n);
        int n7 = this.p;
        int n8 = this.stop;
        String string2 = null;
        if (!this.left()) {
            this.newValueException("group name is empty");
        } else {
            this.fetch();
            if (this.c == n6) {
                this.newValueException("group name is empty");
            }
            if (this.enc.isDigit(this.c)) {
                n4 = 1;
            } else if (this.c == 45) {
                n4 = 2;
                n5 = -1;
                n7 = this.p;
            } else if (!this.enc.isWord(this.c)) {
                string2 = "invalid group name <%n>";
            }
        }
        while (this.left()) {
            n8 = this.p;
            this.fetch();
            if (this.c == n6 || this.c == 41 || this.c == 43 || this.c == 45) {
                if (n4 != 2) break;
                string2 = "invalid group name <%n>";
                break;
            }
            if (n4 != 0) {
                if (this.enc.isDigit(this.c)) {
                    n4 = 1;
                    continue;
                }
                string2 = "invalid group name <%n>";
                continue;
            }
            if (this.enc.isWord(this.c)) continue;
            string2 = "invalid char in group name <%n>";
        }
        boolean bl2 = false;
        if (string2 == null && this.c != n6) {
            if (this.c == 43 || this.c == 45) {
                n2 = this.c == 45 ? -1 : 1;
                this.fetch();
                if (!this.enc.isDigit(this.c)) {
                    this.newValueException("invalid group name <%n>", n3, this.stop);
                }
                this.unfetch();
                int n9 = this.scanUnsignedNumber();
                if (n9 < 0) {
                    this.newValueException("too big number");
                }
                nArray2[0] = n9 * n2;
                bl = true;
                this.fetch();
                boolean bl3 = bl2 = this.c == n6;
            }
            if (!bl2) {
                string2 = "invalid group name <%n>";
                n8 = this.stop;
            }
        }
        if (string2 == null) {
            if (n4 != 0) {
                this.mark();
                this.p = n7;
                n2 = this.scanUnsignedNumber();
                this.restore();
                if (n2 < 0) {
                    this.newValueException("too big number");
                } else if (n2 == 0) {
                    this.newValueException("invalid group name <%n>", n3, this.stop);
                }
                nArray[0] = n2 * n5;
            }
            this.value = n8;
            return bl;
        }
        this.newValueException("invalid group name <%n>", n3, n8);
        return false;
    }

    private int fetchNameForNamedGroup(int n, boolean bl) {
        int n2 = this.p;
        this.value = 0;
        int n3 = 0;
        int n4 = 1;
        int n5 = this.nameEndCodePoint(n);
        int n6 = this.p;
        int n7 = this.stop;
        String string2 = null;
        if (!this.left()) {
            this.newValueException("group name is empty");
        } else {
            this.fetch();
            if (this.c == n5) {
                this.newValueException("group name is empty");
            }
            if (this.enc.isDigit(this.c)) {
                if (bl) {
                    n3 = 1;
                } else {
                    string2 = "invalid group name <%n>";
                }
            } else if (this.c == 45) {
                if (bl) {
                    n3 = 2;
                    n4 = -1;
                    n6 = this.p;
                } else {
                    string2 = "invalid group name <%n>";
                }
            } else if (!this.enc.isWord(this.c)) {
                string2 = "invalid char in group name <%n>";
            }
        }
        if (string2 == null) {
            while (this.left()) {
                n7 = this.p;
                this.fetch();
                if (this.c == n5 || this.c == 41) {
                    if (n3 != 2) break;
                    string2 = "invalid group name <%n>";
                    break;
                }
                if (n3 != 0) {
                    if (this.enc.isDigit(this.c)) {
                        n3 = 1;
                        continue;
                    }
                    if (!this.enc.isWord(this.c)) {
                        string2 = "invalid char in group name <%n>";
                        continue;
                    }
                    string2 = "invalid group name <%n>";
                    continue;
                }
                if (this.enc.isWord(this.c)) continue;
                string2 = "invalid char in group name <%n>";
            }
            if (this.c != n5) {
                string2 = "invalid group name <%n>";
                n7 = this.stop;
            }
            int n8 = 0;
            if (n3 != 0) {
                this.mark();
                this.p = n6;
                n8 = this.scanUnsignedNumber();
                this.restore();
                if (n8 < 0) {
                    this.newValueException("too big number");
                } else if (n8 == 0) {
                    this.newValueException("invalid group name <%n>", n2, n7);
                }
                n8 *= n4;
            }
            this.value = n7;
            return n8;
        }
        while (this.left()) {
            n7 = this.p;
            this.fetch();
            if (this.c != n5 && this.c != 41) continue;
        }
        if (!this.left()) {
            n7 = this.stop;
        }
        this.newValueException(string2, n2, n7);
        return 0;
    }

    private final int fetchNameForNoNamedGroup(int n, boolean bl) {
        int n2 = this.p;
        this.value = 0;
        int n3 = 0;
        int n4 = 1;
        int n5 = this.nameEndCodePoint(n);
        int n6 = this.p;
        int n7 = this.stop;
        String string2 = null;
        if (!this.left()) {
            this.newValueException("group name is empty");
        } else {
            this.fetch();
            if (this.c == n5) {
                this.newValueException("group name is empty");
            }
            if (this.enc.isDigit(this.c)) {
                n3 = 1;
            } else if (this.c == 45) {
                n3 = 2;
                n4 = -1;
                n6 = this.p;
            } else {
                string2 = "invalid char in group name <%n>";
            }
        }
        while (this.left()) {
            n7 = this.p;
            this.fetch();
            if (this.c == n5 || this.c == 41) break;
            if (this.enc.isDigit(this.c)) continue;
            string2 = "invalid char in group name <%n>";
        }
        if (string2 == null && this.c != n5) {
            string2 = "invalid group name <%n>";
            n7 = this.stop;
        }
        if (string2 == null) {
            this.mark();
            this.p = n6;
            int n8 = this.scanUnsignedNumber();
            this.restore();
            if (n8 < 0) {
                this.newValueException("too big number");
            } else if (n8 == 0) {
                this.newValueException("invalid group name <%n>", n2, n7);
            }
            this.value = n7;
            return n8 *= n4;
        }
        this.newValueException(string2, n2, n7);
        return 0;
    }

    protected final int fetchName(int n, boolean bl) {
        return this.fetchNameForNamedGroup(n, bl);
    }

    private boolean strExistCheckWithEsc(int[] nArray, int n, int n2) {
        int n3 = this.p;
        int n4 = this.stop;
        boolean bl = false;
        int n5 = 0;
        while (n3 < n4) {
            if (bl) {
                bl = false;
                n3 += this.enc.length(this.bytes, n3, n4);
                continue;
            }
            int n6 = this.enc.mbcToCode(this.bytes, n3, n4);
            int n7 = n3 + this.enc.length(this.bytes, n3, n4);
            if (n6 == nArray[0]) {
                for (n5 = 1; n5 < n && n7 < n4 && (n6 = this.enc.mbcToCode(this.bytes, n7, n4)) == nArray[n5]; n7 += this.enc.length(this.bytes, n7, n4), ++n5) {
                }
                if (n5 >= n) {
                    return true;
                }
                n3 += this.enc.length(this.bytes, n3, n4);
                continue;
            }
            n6 = this.enc.mbcToCode(this.bytes, n3, n4);
            if (n6 == n2) {
                return false;
            }
            if (n6 == this.syntax.metaCharTable.esc) {
                bl = true;
            }
            n3 = n7;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final TokenType fetchTokenInCC() {
        if (!this.left()) {
            this.token.type = TokenType.EOT;
            return this.token.type;
        }
        this.fetch();
        this.token.type = TokenType.CHAR;
        this.token.base = 0;
        this.token.setC(this.c);
        this.token.escaped = false;
        if (this.c == 93) {
            this.token.type = TokenType.CC_CLOSE;
            return this.token.type;
        } else if (this.c == 45) {
            this.token.type = TokenType.CC_RANGE;
            return this.token.type;
        } else if (this.c == this.syntax.metaCharTable.esc) {
            if (!this.syntax.backSlashEscapeInCC()) {
                return this.token.type;
            }
            if (!this.left()) {
                this.newSyntaxException("end pattern at escape");
            }
            this.fetch();
            this.token.escaped = true;
            this.token.setC(this.c);
            switch (this.c) {
                case 119: {
                    this.token.type = TokenType.CHAR_TYPE;
                    this.token.setPropCType(12);
                    this.token.setPropNot(false);
                    return this.token.type;
                }
                case 87: {
                    this.token.type = TokenType.CHAR_TYPE;
                    this.token.setPropCType(12);
                    this.token.setPropNot(true);
                    return this.token.type;
                }
                case 100: {
                    this.token.type = TokenType.CHAR_TYPE;
                    this.token.setPropCType(4);
                    this.token.setPropNot(false);
                    return this.token.type;
                }
                case 68: {
                    this.token.type = TokenType.CHAR_TYPE;
                    this.token.setPropCType(4);
                    this.token.setPropNot(true);
                    return this.token.type;
                }
                case 115: {
                    this.token.type = TokenType.CHAR_TYPE;
                    this.token.setPropCType(9);
                    this.token.setPropNot(false);
                    return this.token.type;
                }
                case 83: {
                    this.token.type = TokenType.CHAR_TYPE;
                    this.token.setPropCType(9);
                    this.token.setPropNot(true);
                    return this.token.type;
                }
                case 104: {
                    if (!this.syntax.op2EscHXDigit()) return this.token.type;
                    this.token.type = TokenType.CHAR_TYPE;
                    this.token.setPropCType(11);
                    this.token.setPropNot(false);
                    return this.token.type;
                }
                case 72: {
                    if (!this.syntax.op2EscHXDigit()) return this.token.type;
                    this.token.type = TokenType.CHAR_TYPE;
                    this.token.setPropCType(11);
                    this.token.setPropNot(true);
                    return this.token.type;
                }
                case 80: 
                case 112: {
                    int n = this.peek();
                    if (n != 123 || !this.syntax.op2EscPBraceCharProperty()) return this.token.type;
                    this.inc();
                    this.token.type = TokenType.CHAR_PROPERTY;
                    this.token.setPropNot(this.c == 80);
                    if (!this.syntax.op2EscPBraceCircumflexNot()) return this.token.type;
                    n = this.fetchTo();
                    if (n == 94) {
                        this.token.setPropNot(!this.token.getPropNot());
                        return this.token.type;
                    }
                    this.unfetch();
                    return this.token.type;
                }
                case 120: {
                    if (!this.left()) return this.token.type;
                    int n = this.p;
                    if (this.peekIs(123) && this.syntax.opEscXBraceHex8()) {
                        int n2;
                        this.inc();
                        int n3 = this.scanUnsignedHexadecimalNumber(8);
                        if (n3 < 0) {
                            this.newValueException("too big wide-char value");
                        }
                        if (this.left() && this.enc.isXDigit(n2 = this.peek())) {
                            this.newValueException("too long wide-char value");
                        }
                        if (this.p > n + this.enc.length(this.bytes, n, this.stop) && this.left() && this.peekIs(125)) {
                            this.inc();
                            this.token.type = TokenType.CODE_POINT;
                            this.token.base = 16;
                            this.token.setCode(n3);
                            return this.token.type;
                        }
                        this.p = n;
                        return this.token.type;
                    }
                    if (!this.syntax.opEscXHex2()) return this.token.type;
                    int n4 = this.scanUnsignedHexadecimalNumber(2);
                    if (n4 < 0) {
                        this.newValueException("too big number");
                    }
                    if (this.p == n) {
                        n4 = 0;
                    }
                    this.token.type = TokenType.RAW_BYTE;
                    this.token.base = 16;
                    this.token.setC(n4);
                    return this.token.type;
                }
                case 117: {
                    if (!this.left()) return this.token.type;
                    int n = this.p;
                    if (!this.syntax.op2EscUHex4()) return this.token.type;
                    int n5 = this.scanUnsignedHexadecimalNumber(4);
                    if (n5 < 0) {
                        this.newValueException("too big number");
                    }
                    if (this.p == n) {
                        n5 = 0;
                    }
                    this.token.type = TokenType.CODE_POINT;
                    this.token.base = 16;
                    this.token.setCode(n5);
                    return this.token.type;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    if (!this.syntax.opEscOctal3()) return this.token.type;
                    this.unfetch();
                    int n = this.p;
                    int n6 = this.scanUnsignedOctalNumber(3);
                    if (n6 < 0) {
                        this.newValueException("too big number");
                    }
                    if (this.p == n) {
                        n6 = 0;
                    }
                    this.token.type = TokenType.RAW_BYTE;
                    this.token.base = 8;
                    this.token.setC(n6);
                    return this.token.type;
                }
                default: {
                    this.unfetch();
                    int n = this.fetchEscapedValue();
                    if (this.token.getC() == n) return this.token.type;
                    this.token.setCode(n);
                    this.token.type = TokenType.CODE_POINT;
                }
            }
            return this.token.type;
        } else if (this.c == 91) {
            if (this.syntax.opPosixBracket() && this.peekIs(58)) {
                this.token.backP = this.p;
                this.inc();
                if (this.strExistCheckWithEsc(send, send.length, 93)) {
                    this.token.type = TokenType.POSIX_BRACKET_OPEN;
                    return this.token.type;
                } else {
                    this.unfetch();
                    if (this.syntax.op2CClassSetOp()) {
                        this.token.type = TokenType.CC_CC_OPEN;
                        return this.token.type;
                    } else {
                        this.env.ccEscWarn("[");
                    }
                }
                return this.token.type;
            } else if (this.syntax.op2CClassSetOp()) {
                this.token.type = TokenType.CC_CC_OPEN;
                return this.token.type;
            } else {
                this.env.ccEscWarn("[");
            }
            return this.token.type;
        } else {
            if (this.c != 38 || !this.syntax.op2CClassSetOp() || !this.left() || !this.peekIs(38)) return this.token.type;
            this.inc();
            this.token.type = TokenType.CC_AND;
        }
        return this.token.type;
    }

    protected final int backrefRelToAbs(int n) {
        return this.env.numMem + 1 + n;
    }

    protected final TokenType fetchToken() {
        block59: while (true) {
            if (!this.left()) {
                this.token.type = TokenType.EOT;
                return this.token.type;
            }
            this.token.type = TokenType.STRING;
            this.token.base = 0;
            this.token.backP = this.p;
            this.fetch();
            if (this.c == this.syntax.metaCharTable.esc && !this.syntax.op2IneffectiveEscape()) {
                if (!this.left()) {
                    this.newSyntaxException("end pattern at escape");
                }
                this.token.backP = this.p;
                this.fetch();
                this.token.setC(this.c);
                this.token.escaped = true;
                block0 : switch (this.c) {
                    case 42: {
                        if (!this.syntax.opEscAsteriskZeroInf()) break;
                        this.token.type = TokenType.OP_REPEAT;
                        this.token.setRepeatLower(0);
                        this.token.setRepeatUpper(-1);
                        this.greedyCheck();
                        break;
                    }
                    case 43: {
                        if (!this.syntax.opEscPlusOneInf()) break;
                        this.token.type = TokenType.OP_REPEAT;
                        this.token.setRepeatLower(1);
                        this.token.setRepeatUpper(-1);
                        this.greedyCheck();
                        break;
                    }
                    case 63: {
                        if (!this.syntax.opEscQMarkZeroOne()) break;
                        this.token.type = TokenType.OP_REPEAT;
                        this.token.setRepeatLower(0);
                        this.token.setRepeatUpper(1);
                        this.greedyCheck();
                        break;
                    }
                    case 123: {
                        if (!this.syntax.opEscBraceInterval()) break;
                        switch (this.fetchRangeQuantifier()) {
                            case 0: {
                                this.greedyCheck();
                                break block0;
                            }
                            case 2: {
                                if (this.syntax.fixedIntervalIsGreedyOnly()) {
                                    this.possessiveCheck();
                                    break block0;
                                }
                                this.greedyCheck();
                                break block0;
                            }
                        }
                        break;
                    }
                    case 124: {
                        if (!this.syntax.opEscVBarAlt()) break;
                        this.token.type = TokenType.ALT;
                        break;
                    }
                    case 40: {
                        if (!this.syntax.opEscLParenSubexp()) break;
                        this.token.type = TokenType.SUBEXP_OPEN;
                        break;
                    }
                    case 41: {
                        if (!this.syntax.opEscLParenSubexp()) break;
                        this.token.type = TokenType.SUBEXP_CLOSE;
                        break;
                    }
                    case 119: {
                        if (!this.syntax.opEscWWord()) break;
                        this.token.type = TokenType.CHAR_TYPE;
                        this.token.setPropCType(12);
                        this.token.setPropNot(false);
                        break;
                    }
                    case 87: {
                        if (!this.syntax.opEscWWord()) break;
                        this.token.type = TokenType.CHAR_TYPE;
                        this.token.setPropCType(12);
                        this.token.setPropNot(true);
                        break;
                    }
                    case 98: {
                        if (!this.syntax.opEscBWordBound()) break;
                        this.token.type = TokenType.ANCHOR;
                        this.token.setAnchor(64);
                        break;
                    }
                    case 66: {
                        if (!this.syntax.opEscBWordBound()) break;
                        this.token.type = TokenType.ANCHOR;
                        this.token.setAnchor(128);
                        break;
                    }
                    case 60: {
                        if (!this.syntax.opEscLtGtWordBeginEnd()) break;
                        this.token.type = TokenType.ANCHOR;
                        this.token.setAnchor(256);
                        break;
                    }
                    case 62: {
                        if (!this.syntax.opEscLtGtWordBeginEnd()) break;
                        this.token.type = TokenType.ANCHOR;
                        this.token.setAnchor(512);
                        break;
                    }
                    case 115: {
                        if (!this.syntax.opEscSWhiteSpace()) break;
                        this.token.type = TokenType.CHAR_TYPE;
                        this.token.setPropCType(9);
                        this.token.setPropNot(false);
                        break;
                    }
                    case 83: {
                        if (!this.syntax.opEscSWhiteSpace()) break;
                        this.token.type = TokenType.CHAR_TYPE;
                        this.token.setPropCType(9);
                        this.token.setPropNot(true);
                        break;
                    }
                    case 100: {
                        if (!this.syntax.opEscDDigit()) break;
                        this.token.type = TokenType.CHAR_TYPE;
                        this.token.setPropCType(4);
                        this.token.setPropNot(false);
                        break;
                    }
                    case 68: {
                        if (!this.syntax.opEscDDigit()) break;
                        this.token.type = TokenType.CHAR_TYPE;
                        this.token.setPropCType(4);
                        this.token.setPropNot(true);
                        break;
                    }
                    case 104: {
                        if (!this.syntax.op2EscHXDigit()) break;
                        this.token.type = TokenType.CHAR_TYPE;
                        this.token.setPropCType(11);
                        this.token.setPropNot(false);
                        break;
                    }
                    case 72: {
                        if (!this.syntax.op2EscHXDigit()) break;
                        this.token.type = TokenType.CHAR_TYPE;
                        this.token.setPropCType(11);
                        this.token.setPropNot(true);
                        break;
                    }
                    case 65: {
                        if (!this.syntax.opEscAZBufAnchor()) break;
                        this.token.type = TokenType.ANCHOR;
                        this.token.setSubtype(1);
                        break;
                    }
                    case 90: {
                        if (!this.syntax.opEscAZBufAnchor()) break;
                        this.token.type = TokenType.ANCHOR;
                        this.token.setSubtype(16);
                        break;
                    }
                    case 122: {
                        if (!this.syntax.opEscAZBufAnchor()) break;
                        this.token.type = TokenType.ANCHOR;
                        this.token.setSubtype(8);
                        break;
                    }
                    case 71: {
                        if (!this.syntax.opEscCapitalGBeginAnchor()) break;
                        this.token.type = TokenType.ANCHOR;
                        this.token.setSubtype(4);
                        break;
                    }
                    case 96: {
                        if (!this.syntax.op2EscGnuBufAnchor()) break;
                        this.token.type = TokenType.ANCHOR;
                        this.token.setSubtype(1);
                        break;
                    }
                    case 39: {
                        if (!this.syntax.op2EscGnuBufAnchor()) break;
                        this.token.type = TokenType.ANCHOR;
                        this.token.setSubtype(8);
                        break;
                    }
                    case 120: {
                        if (!this.left()) break;
                        int n = this.p;
                        if (this.peekIs(123) && this.syntax.opEscXBraceHex8()) {
                            this.inc();
                            int n2 = this.scanUnsignedHexadecimalNumber(8);
                            if (n2 < 0) {
                                this.newValueException("too big wide-char value");
                            }
                            if (this.left() && this.enc.isXDigit(this.peek())) {
                                this.newValueException("too long wide-char value");
                            }
                            if (this.p > n + this.enc.length(this.bytes, n, this.stop) && this.left() && this.peekIs(125)) {
                                this.inc();
                                this.token.type = TokenType.CODE_POINT;
                                this.token.setCode(n2);
                                break;
                            }
                            this.p = n;
                            break;
                        }
                        if (!this.syntax.opEscXHex2()) break block59;
                        int n3 = this.scanUnsignedHexadecimalNumber(2);
                        if (n3 < 0) {
                            this.newValueException("too big number");
                        }
                        if (this.p == n) {
                            n3 = 0;
                        }
                        this.token.type = TokenType.RAW_BYTE;
                        this.token.base = 16;
                        this.token.setC(n3);
                        break;
                    }
                    case 117: {
                        if (!this.left()) break;
                        int n = this.p;
                        if (!this.syntax.op2EscUHex4()) break block59;
                        int n4 = this.scanUnsignedHexadecimalNumber(4);
                        if (n4 < 0) {
                            this.newValueException("too big number");
                        }
                        if (this.p == n) {
                            n4 = 0;
                        }
                        this.token.type = TokenType.CODE_POINT;
                        this.token.base = 16;
                        this.token.setCode(n4);
                        break;
                    }
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        this.unfetch();
                        int n = this.p;
                        int n5 = this.scanUnsignedNumber();
                        if (n5 >= 0 && n5 <= 1000 && this.syntax.opDecimalBackref() && (n5 <= this.env.numMem || n5 <= 9)) {
                            if (this.syntax.strictCheckBackref() && (n5 > this.env.numMem || this.env.memNodes == null || this.env.memNodes[n5] == null)) {
                                this.newValueException("invalid backref number/name");
                            }
                            this.token.type = TokenType.BACKREF;
                            this.token.setBackrefNum(1);
                            this.token.setBackrefRef1(n5);
                            this.token.setBackrefByName(false);
                            this.token.setBackrefExistLevel(false);
                            break;
                        }
                        if (this.c == 56 || this.c == 57) {
                            this.p = n;
                            this.inc();
                            break;
                        }
                        this.p = n;
                    }
                    case 48: {
                        int n5;
                        int n;
                        if (this.syntax.opEscOctal3()) {
                            n = this.p;
                            n5 = this.scanUnsignedOctalNumber(this.c == 48 ? 2 : 3);
                            if (n5 < 0) {
                                this.newValueException("too big number");
                            }
                            if (this.p == n) {
                                n5 = 0;
                            }
                            this.token.type = TokenType.RAW_BYTE;
                            this.token.base = 8;
                            this.token.setC(n5);
                            break;
                        }
                        if (this.c == 48) break block59;
                        this.inc();
                        break;
                    }
                    case 107: {
                        if (!this.syntax.op2EscKNamedBackref()) break block59;
                        this.fetch();
                        if (this.c == 60 || this.c == 39) {
                            int n = this.p;
                            int[] nArray = new int[1];
                            Object object = new int[1];
                            this.token.setBackrefExistLevel(this.fetchNameWithLevel(this.c, nArray, (int[])object));
                            this.token.setBackrefLevel(object[0]);
                            int n6 = nArray[0];
                            int n7 = this.value;
                            if (n6 != 0) {
                                if (n6 < 0 && (n6 = this.backrefRelToAbs(n6)) <= 0) {
                                    this.newValueException("invalid backref number/name");
                                }
                                if (this.syntax.strictCheckBackref() && (n6 > this.env.numMem || this.env.memNodes == null)) {
                                    this.newValueException("invalid backref number/name");
                                }
                                this.token.type = TokenType.BACKREF;
                                this.token.setBackrefByName(false);
                                this.token.setBackrefNum(1);
                                this.token.setBackrefRef1(n6);
                                break;
                            }
                            object = this.env.reg.nameToGroupNumbers(this.bytes, n, n7);
                            if (object == null) {
                                this.newValueException("undefined name <%n> reference", n, n7);
                            }
                            if (this.syntax.strictCheckBackref()) {
                                if (object.backNum == 1) {
                                    if (object.backRef1 > this.env.numMem || this.env.memNodes == null || this.env.memNodes[object.backRef1] == null) {
                                        this.newValueException("invalid backref number/name");
                                    }
                                } else {
                                    for (int i = 0; i < object.backNum; ++i) {
                                        if (object.backRefs[i] <= this.env.numMem && this.env.memNodes != null && this.env.memNodes[object.backRefs[i]] != null) continue;
                                        this.newValueException("invalid backref number/name");
                                    }
                                }
                            }
                            this.token.type = TokenType.BACKREF;
                            this.token.setBackrefByName(true);
                            if (object.backNum == 1) {
                                this.token.setBackrefNum(1);
                                this.token.setBackrefRef1(object.backRef1);
                                break;
                            }
                            this.token.setBackrefNum(object.backNum);
                            this.token.setBackrefRefs(object.backRefs);
                            break;
                        }
                        this.unfetch();
                        break;
                    }
                    case 103: {
                        if (!this.syntax.op2EscGSubexpCall()) break block59;
                        this.fetch();
                        if (this.c == 60 || this.c == 39) {
                            int n = this.p;
                            int n8 = this.fetchName(this.c, true);
                            int n9 = this.value;
                            this.token.type = TokenType.CALL;
                            this.token.setCallNameP(n);
                            this.token.setCallNameEnd(n9);
                            this.token.setCallGNum(n8);
                            break;
                        }
                        this.unfetch();
                        break;
                    }
                    case 81: {
                        if (!this.syntax.op2EscCapitalQQuote()) break block59;
                        this.token.type = TokenType.QUOTE_OPEN;
                        break;
                    }
                    case 80: 
                    case 112: {
                        if (!this.peekIs(123) || !this.syntax.op2EscPBraceCharProperty()) break block59;
                        this.inc();
                        this.token.type = TokenType.CHAR_PROPERTY;
                        this.token.setPropNot(this.c == 80);
                        if (!this.syntax.op2EscPBraceCircumflexNot()) break block59;
                        this.fetch();
                        if (this.c == 94) {
                            this.token.setPropNot(!this.token.getPropNot());
                            break;
                        }
                        this.unfetch();
                        break;
                    }
                    default: {
                        this.unfetch();
                        int n = this.fetchEscapedValue();
                        if (this.token.getC() != n) {
                            this.token.type = TokenType.CODE_POINT;
                            this.token.setCode(n);
                            break;
                        }
                        this.p = this.token.backP + this.enc.length(this.bytes, this.token.backP, this.stop);
                    }
                }
                break;
            }
            this.token.setC(this.c);
            this.token.escaped = false;
            if (this.c != 0 && this.syntax.opVariableMetaCharacters()) {
                if (this.c == this.syntax.metaCharTable.anyChar) {
                    this.token.type = TokenType.ANYCHAR;
                    break;
                }
                if (this.c == this.syntax.metaCharTable.anyTime) {
                    this.token.type = TokenType.OP_REPEAT;
                    this.token.setRepeatLower(0);
                    this.token.setRepeatUpper(-1);
                    this.greedyCheck();
                    break;
                }
                if (this.c == this.syntax.metaCharTable.zeroOrOneTime) {
                    this.token.type = TokenType.OP_REPEAT;
                    this.token.setRepeatLower(0);
                    this.token.setRepeatUpper(1);
                    this.greedyCheck();
                    break;
                }
                if (this.c == this.syntax.metaCharTable.oneOrMoreTime) {
                    this.token.type = TokenType.OP_REPEAT;
                    this.token.setRepeatLower(1);
                    this.token.setRepeatUpper(-1);
                    this.greedyCheck();
                    break;
                }
                if (this.c == this.syntax.metaCharTable.anyCharAnyTime) {
                    this.token.type = TokenType.ANYCHAR_ANYTIME;
                    break;
                }
            }
            switch (this.c) {
                case 46: {
                    if (!this.syntax.opDotAnyChar()) break block59;
                    this.token.type = TokenType.ANYCHAR;
                    break block59;
                }
                case 42: {
                    if (!this.syntax.opAsteriskZeroInf()) break block59;
                    this.token.type = TokenType.OP_REPEAT;
                    this.token.setRepeatLower(0);
                    this.token.setRepeatUpper(-1);
                    this.greedyCheck();
                    break block59;
                }
                case 43: {
                    if (!this.syntax.opPlusOneInf()) break block59;
                    this.token.type = TokenType.OP_REPEAT;
                    this.token.setRepeatLower(1);
                    this.token.setRepeatUpper(-1);
                    this.greedyCheck();
                    break block59;
                }
                case 63: {
                    if (!this.syntax.opQMarkZeroOne()) break block59;
                    this.token.type = TokenType.OP_REPEAT;
                    this.token.setRepeatLower(0);
                    this.token.setRepeatUpper(1);
                    this.greedyCheck();
                    break block59;
                }
                case 123: {
                    if (!this.syntax.opBraceInterval()) break block59;
                    switch (this.fetchRangeQuantifier()) {
                        case 0: {
                            this.greedyCheck();
                            break block59;
                        }
                        case 2: {
                            if (this.syntax.fixedIntervalIsGreedyOnly()) {
                                this.possessiveCheck();
                                break block59;
                            }
                            this.greedyCheck();
                            break block59;
                        }
                    }
                    break block59;
                }
                case 124: {
                    if (!this.syntax.opVBarAlt()) break block59;
                    this.token.type = TokenType.ALT;
                    break block59;
                }
                case 40: {
                    if (this.peekIs(63) && this.syntax.op2QMarkGroupEffect()) {
                        this.inc();
                        if (this.peekIs(35)) {
                            this.fetch();
                            while (true) {
                                if (!this.left()) {
                                    this.newSyntaxException("end pattern in group");
                                }
                                this.fetch();
                                if (this.c == this.syntax.metaCharTable.esc) {
                                    if (!this.left()) continue;
                                    this.fetch();
                                    continue;
                                }
                                if (this.c == 41) break;
                            }
                            continue block59;
                        }
                        this.unfetch();
                    }
                    if (!this.syntax.opLParenSubexp()) break block59;
                    this.token.type = TokenType.SUBEXP_OPEN;
                    break block59;
                }
                case 41: {
                    if (!this.syntax.opLParenSubexp()) break block59;
                    this.token.type = TokenType.SUBEXP_CLOSE;
                    break block59;
                }
                case 94: {
                    if (!this.syntax.opLineAnchor()) break block59;
                    this.token.type = TokenType.ANCHOR;
                    this.token.setSubtype(Option.isSingleline(this.env.option) ? 1 : 2);
                    break block59;
                }
                case 36: {
                    if (!this.syntax.opLineAnchor()) break block59;
                    this.token.type = TokenType.ANCHOR;
                    this.token.setSubtype(Option.isSingleline(this.env.option) ? 16 : 32);
                    break block59;
                }
                case 91: {
                    if (!this.syntax.opBracketCC()) break block59;
                    this.token.type = TokenType.CC_CC_OPEN;
                    break block59;
                }
                case 93: {
                    break block59;
                }
                case 35: {
                    if (!Option.isExtend(this.env.option)) break block59;
                    do {
                        if (!this.left()) continue block59;
                        this.fetch();
                    } while (!this.enc.isNewLine(this.c));
                    continue block59;
                }
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 32: {
                    if (!Option.isExtend(this.env.option)) break block59;
                    continue block59;
                }
            }
            break;
        }
        return this.token.type;
    }

    private void greedyCheck() {
        if (this.left() && this.peekIs(63) && this.syntax.opQMarkNonGreedy()) {
            this.fetch();
            this.token.setRepeatGreedy(false);
            this.token.setRepeatPossessive(false);
        } else {
            this.possessiveCheck();
        }
    }

    private void possessiveCheck() {
        if (this.left() && this.peekIs(43) && (this.syntax.op2PlusPossessiveRepeat() && this.token.type != TokenType.INTERVAL || this.syntax.op2PlusPossessiveInterval() && this.token.type == TokenType.INTERVAL)) {
            this.fetch();
            this.token.setRepeatGreedy(true);
            this.token.setRepeatPossessive(true);
        } else {
            this.token.setRepeatGreedy(true);
            this.token.setRepeatPossessive(false);
        }
    }

    protected final int fetchCharPropertyToCType() {
        this.mark();
        while (this.left()) {
            int n = this.p;
            this.fetch();
            if (this.c == 125) {
                return this.enc.propertyNameToCType(this.bytes, this._p, n);
            }
            if (this.c != 40 && this.c != 41 && this.c != 123 && this.c != 124) continue;
            throw new CharacterPropertyException("invalid character property name {%n}", this.bytes, this._p, n);
        }
        this.newInternalException("internal parser error (bug)");
        return 0;
    }
}

