/*
 * Decompiled with CFR 0.152.
 */
package org.joni.ast;

import org.joni.ast.Node;
import org.joni.constants.AnchorType;

public final class AnchorNode
extends Node
implements AnchorType {
    public int type;
    public Node target;
    public int charLength;

    public AnchorNode(int n) {
        this.type = n;
        this.charLength = -1;
    }

    public int getType() {
        return 7;
    }

    protected void setChild(Node node) {
        this.target = node;
    }

    protected Node getChild() {
        return this.target;
    }

    public void setTarget(Node node) {
        this.target = node;
        node.parent = this;
    }

    public String getName() {
        return "Anchor";
    }

    public String toString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n  type: " + this.typeToString());
        stringBuilder.append("\n  target: " + AnchorNode.pad(this.target, n + 1));
        return stringBuilder.toString();
    }

    public String typeToString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isType(1)) {
            stringBuilder.append("BEGIN_BUF ");
        }
        if (this.isType(2)) {
            stringBuilder.append("BEGIN_LINE ");
        }
        if (this.isType(4)) {
            stringBuilder.append("BEGIN_POSITION ");
        }
        if (this.isType(8)) {
            stringBuilder.append("END_BUF ");
        }
        if (this.isType(16)) {
            stringBuilder.append("SEMI_END_BUF ");
        }
        if (this.isType(32)) {
            stringBuilder.append("END_LINE ");
        }
        if (this.isType(64)) {
            stringBuilder.append("WORD_BOUND ");
        }
        if (this.isType(128)) {
            stringBuilder.append("NOT_WORD_BOUND ");
        }
        if (this.isType(256)) {
            stringBuilder.append("WORD_BEGIN ");
        }
        if (this.isType(512)) {
            stringBuilder.append("WORD_END ");
        }
        if (this.isType(1024)) {
            stringBuilder.append("PREC_READ ");
        }
        if (this.isType(2048)) {
            stringBuilder.append("PREC_READ_NOT ");
        }
        if (this.isType(4096)) {
            stringBuilder.append("LOOK_BEHIND ");
        }
        if (this.isType(8192)) {
            stringBuilder.append("LOOK_BEHIND_NOT ");
        }
        if (this.isType(16384)) {
            stringBuilder.append("ANYCHAR_STAR ");
        }
        if (this.isType(32768)) {
            stringBuilder.append("ANYCHAR_STAR_ML ");
        }
        return stringBuilder.toString();
    }

    private boolean isType(int n) {
        return (this.type & n) != 0;
    }
}

