/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Continuation"})
public class RubyContinuation
extends RubyObject {
    private final Continuation continuation;
    private boolean disabled;

    public static void createContinuation(Ruby runtime2) {
        RubyClass cContinuation = runtime2.defineClass("Continuation", runtime2.getObject(), runtime2.getObject().getAllocator());
        cContinuation.index = 37;
        cContinuation.setReifiedClass(RubyContinuation.class);
        cContinuation.defineAnnotatedMethods(RubyContinuation.class);
        cContinuation.getSingletonClass().undefineMethod("new");
        runtime2.setContinuation(cContinuation);
    }

    public RubyContinuation(Ruby runtime2) {
        super(runtime2, runtime2.getContinuation());
        this.continuation = new Continuation();
    }

    public RubyContinuation(Ruby runtime2, String tag) {
        super(runtime2, runtime2.getContinuation());
        this.continuation = new Continuation(tag);
    }

    public Continuation getContinuation() {
        return this.continuation;
    }

    @JRubyMethod(name={"call", "[]"}, rest=true, frame=true)
    public IRubyObject call(ThreadContext context, IRubyObject[] args2) {
        if (this.disabled) {
            throw context.getRuntime().newLocalJumpError(RubyLocalJumpError.Reason.NOREASON, this, "continuations can not be called from outside their scope");
        }
        this.continuation.args = args2;
        throw this.continuation;
    }

    public IRubyObject enter(ThreadContext context, Block block) {
        try {
            IRubyObject iRubyObject = block.yield(context, this);
            return iRubyObject;
        }
        catch (Continuation c) {
            if (c == this.continuation) {
                if (this.continuation.args.length == 0) {
                    IRubyObject iRubyObject = context.getRuntime().getNil();
                    return iRubyObject;
                }
                if (this.continuation.args.length == 1) {
                    IRubyObject iRubyObject = this.continuation.args[0];
                    return iRubyObject;
                }
                RubyArray rubyArray = context.getRuntime().newArrayNoCopy(this.continuation.args);
                return rubyArray;
            }
            throw c;
        }
        finally {
            this.disabled = true;
        }
    }

    public static class Continuation
    extends Error {
        public IRubyObject[] args = IRubyObject.NULL_ARRAY;
        public final String tag;

        public Continuation() {
            this.tag = null;
        }

        public Continuation(String tag) {
            this.tag = tag.intern();
        }

        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

