/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.nio.charset.Charset;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.util.CaseInsensitiveBytesHash;
import org.jcodings.util.Hash;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingCapable;
import org.jruby.runtime.encoding.EncodingService;
import org.jruby.util.ByteList;

@JRubyClass(name={"Encoding"})
public class RubyEncoding
extends RubyObject {
    private Encoding encoding;
    private final ByteList name;
    private final boolean isDummy;

    public static RubyClass createEncodingClass(Ruby runtime2) {
        RubyClass encodingc = runtime2.defineClass("Encoding", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime2.setEncoding(encodingc);
        encodingc.index = 22;
        encodingc.setReifiedClass(RubyEncoding.class);
        encodingc.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof RubyEncoding;
            }
        };
        encodingc.getSingletonClass().undefineMethod("allocate");
        encodingc.defineAnnotatedMethods(RubyEncoding.class);
        return encodingc;
    }

    private RubyEncoding(Ruby runtime2, byte[] name2, int p2, int end2, boolean isDummy) {
        super(runtime2, runtime2.getEncoding());
        this.name = new ByteList(name2, p2, end2);
        this.isDummy = isDummy;
    }

    private RubyEncoding(Ruby runtime2, byte[] name2, boolean isDummy) {
        this(runtime2, name2, 0, name2.length, isDummy);
    }

    private RubyEncoding(Ruby runtime2, Encoding encoding2) {
        super(runtime2, runtime2.getEncoding());
        this.name = new ByteList(encoding2.getName());
        this.isDummy = false;
        this.encoding = encoding2;
    }

    public static RubyEncoding newEncoding(Ruby runtime2, byte[] name2, int p2, int end2, boolean isDummy) {
        return new RubyEncoding(runtime2, name2, p2, end2, isDummy);
    }

    public static RubyEncoding newEncoding(Ruby runtime2, byte[] name2, boolean isDummy) {
        return new RubyEncoding(runtime2, name2, isDummy);
    }

    public final Encoding getEncoding() {
        if (this.encoding == null) {
            this.encoding = this.getRuntime().getEncodingService().loadEncoding(this.name);
        }
        return this.encoding;
    }

    public static final Encoding areCompatible(IRubyObject obj1, IRubyObject obj2) {
        if (obj1 instanceof EncodingCapable && obj2 instanceof EncodingCapable) {
            Encoding enc2;
            Encoding enc1 = ((EncodingCapable)((Object)obj1)).getEncoding();
            if (enc1 == (enc2 = ((EncodingCapable)((Object)obj2)).getEncoding())) {
                return enc1;
            }
            if (obj2 instanceof RubyString && ((RubyString)obj2).getByteList().getRealSize() == 0) {
                return enc1;
            }
            if (obj1 instanceof RubyString && ((RubyString)obj1).getByteList().getRealSize() == 0) {
                return enc2;
            }
            if (!enc1.isAsciiCompatible() || !enc2.isAsciiCompatible()) {
                return null;
            }
            if (!(obj2 instanceof RubyString) && enc2 instanceof USASCIIEncoding) {
                return enc1;
            }
            if (!(obj1 instanceof RubyString) && enc1 instanceof USASCIIEncoding) {
                return enc2;
            }
            if (!(obj1 instanceof RubyString)) {
                IRubyObject objTmp = obj1;
                obj1 = obj2;
                obj1 = objTmp;
                Encoding encTmp = enc1;
                enc1 = enc2;
                enc2 = encTmp;
            }
            if (obj1 instanceof RubyString) {
                int cr1 = ((RubyString)obj1).scanForCodeRange();
                if (obj2 instanceof RubyString) {
                    int cr2 = ((RubyString)obj2).scanForCodeRange();
                    return RubyEncoding.areCompatible(enc1, cr1, enc2, cr2);
                }
                if (cr1 == 32) {
                    return enc2;
                }
            }
        }
        return null;
    }

    static Encoding areCompatible(Encoding enc1, int cr1, Encoding enc2, int cr2) {
        if (cr1 != cr2) {
            if (cr1 == 32) {
                return enc2;
            }
            if (cr2 == 32) {
                return enc1;
            }
        }
        if (cr2 == 32) {
            if (enc1 instanceof ASCIIEncoding) {
                return enc2;
            }
            return enc1;
        }
        if (cr1 == 32) {
            return enc2;
        }
        return null;
    }

    @JRubyMethod(name={"list"}, meta=true)
    public static IRubyObject list(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.getRuntime();
        return RubyArray.newArrayNoCopy(runtime2, runtime2.getEncodingService().getEncodingList(), 0);
    }

    @JRubyMethod(name={"locale_charmap"}, meta=true)
    public static IRubyObject locale_charmap(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.getRuntime();
        EncodingService service = runtime2.getEncodingService();
        EncodingDB.Entry entry = service.findEncodingOrAliasEntry(new ByteList(Charset.defaultCharset().name().getBytes()));
        return RubyString.newUsAsciiStringNoCopy(runtime2, new ByteList(entry.getEncoding().getName()));
    }

    @JRubyMethod(name={"name_list"}, meta=true)
    public static IRubyObject name_list(ThreadContext context, IRubyObject recv2) {
        CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry e;
        Ruby runtime2 = context.getRuntime();
        EncodingService service = runtime2.getEncodingService();
        RubyArray result = runtime2.newArray(service.getEncodings().size() + service.getAliases().size());
        Hash.HashEntryIterator i = service.getEncodings().entryIterator();
        while (i.hasNext()) {
            e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)i.next();
            result.append(RubyString.newUsAsciiStringShared(runtime2, e.bytes, e.p, e.end - e.p).freeze(context));
        }
        i = service.getAliases().entryIterator();
        while (i.hasNext()) {
            e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)i.next();
            result.append(RubyString.newUsAsciiStringShared(runtime2, e.bytes, e.p, e.end - e.p).freeze(context));
        }
        return result;
    }

    @JRubyMethod(name={"aliases"}, meta=true)
    public static IRubyObject aliases(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.getRuntime();
        EncodingService service = runtime2.getEncodingService();
        IRubyObject[] list2 = service.getEncodingList();
        Hash.HashEntryIterator i = service.getAliases().entryIterator();
        RubyHash result = RubyHash.newHash(runtime2);
        while (i.hasNext()) {
            CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)i.next();
            IRubyObject alias = RubyString.newUsAsciiStringShared(runtime2, e.bytes, e.p, e.end - e.p).freeze(context);
            IRubyObject name2 = RubyString.newUsAsciiStringShared(runtime2, ((RubyEncoding)list2[((EncodingDB.Entry)e.value).getIndex()]).name).freeze(context);
            result.fastASet(alias, name2);
        }
        return result;
    }

    @JRubyMethod(name={"find"}, meta=true)
    public static IRubyObject find(ThreadContext context, IRubyObject recv2, IRubyObject str) {
        ByteList name2;
        Ruby runtime2 = context.getRuntime();
        EncodingService service = runtime2.getEncodingService();
        EncodingDB.Entry e = service.findEncodingOrAliasEntry(name2 = str.convertToString().getByteList());
        if (e == null) {
            throw context.getRuntime().newArgumentError("unknown encoding name - " + name2);
        }
        return service.getEncodingList()[e.getIndex()];
    }

    @JRubyMethod(name={"_dump"})
    public IRubyObject _dump(ThreadContext context) {
        return this.to_s(context);
    }

    @JRubyMethod(name={"_load"}, meta=true)
    public static IRubyObject _load(ThreadContext context, IRubyObject recv2, IRubyObject str) {
        return RubyEncoding.find(context, recv2, str);
    }

    @JRubyMethod(name={"to_s", "name"})
    public IRubyObject to_s(ThreadContext context) {
        return RubyString.newUsAsciiStringShared(context.getRuntime(), this.name);
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        ByteList bytes2 = new ByteList();
        bytes2.append("#<Encoding:".getBytes());
        bytes2.append(this.name);
        if (this.isDummy) {
            bytes2.append(" (dummy)".getBytes());
        }
        bytes2.append(62);
        return RubyString.newUsAsciiStringNoCopy(context.getRuntime(), bytes2);
    }

    @JRubyMethod(name={"names"})
    public IRubyObject names(ThreadContext context) {
        CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry e;
        Ruby runtime2 = context.getRuntime();
        EncodingService service = runtime2.getEncodingService();
        EncodingDB.Entry entry = service.findEncodingOrAliasEntry(this.name);
        RubyArray result = runtime2.newArray();
        Hash.HashEntryIterator i = service.getEncodings().entryIterator();
        while (i.hasNext()) {
            e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)i.next();
            if (e.value != entry) continue;
            result.append(RubyString.newUsAsciiStringShared(runtime2, e.bytes, e.p, e.end - e.p).freeze(context));
        }
        i = service.getAliases().entryIterator();
        while (i.hasNext()) {
            e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)i.next();
            if (e.value != entry) continue;
            result.append(RubyString.newUsAsciiStringShared(runtime2, e.bytes, e.p, e.end - e.p).freeze(context));
        }
        return result;
    }

    @JRubyMethod(name={"dummy?"})
    public IRubyObject dummy_p(ThreadContext context) {
        return context.getRuntime().newBoolean(this.isDummy);
    }

    @JRubyMethod(name={"compatible?"}, meta=true)
    public static IRubyObject compatible_p(ThreadContext context, IRubyObject self, IRubyObject first2, IRubyObject second) {
        Ruby runtime2 = context.getRuntime();
        Encoding enc = RubyEncoding.areCompatible(first2, second);
        return enc == null ? runtime2.getNil() : new RubyEncoding(runtime2, enc);
    }

    @JRubyMethod(name={"default_external"}, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject getDefaultExternal(IRubyObject recv2) {
        return RubyEncoding.getDefaultExternal(recv2.getRuntime());
    }

    public static IRubyObject getDefaultExternal(Ruby runtime2) {
        IRubyObject defaultExternal = RubyEncoding.convertEncodingToRubyEncoding(runtime2, runtime2.getDefaultExternalEncoding());
        if (defaultExternal.isNil()) {
            ByteList encodingName = ByteList.create(Charset.defaultCharset().name());
            Encoding encoding2 = runtime2.getEncodingService().loadEncoding(encodingName);
            runtime2.setDefaultExternalEncoding(encoding2);
            defaultExternal = RubyEncoding.convertEncodingToRubyEncoding(runtime2, encoding2);
        }
        return defaultExternal;
    }

    @JRubyMethod(name={"default_external="}, required=1, frame=true, meta=true, compat=CompatVersion.RUBY1_9)
    public static void setDefaultExternal(IRubyObject recv2, IRubyObject encoding2) {
        if (encoding2.isNil()) {
            recv2.getRuntime().newArgumentError("default_external can not be nil");
        }
        recv2.getRuntime().setDefaultExternalEncoding(RubyEncoding.getEncodingFromObject(recv2.getRuntime(), encoding2));
    }

    @JRubyMethod(name={"default_internal"}, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject getDefaultInternal(IRubyObject recv2) {
        return RubyEncoding.getDefaultInternal(recv2.getRuntime());
    }

    public static IRubyObject getDefaultInternal(Ruby runtime2) {
        return RubyEncoding.convertEncodingToRubyEncoding(runtime2, runtime2.getDefaultInternalEncoding());
    }

    @JRubyMethod(name={"default_internal="}, required=1, frame=true, meta=true, compat=CompatVersion.RUBY1_9)
    public static void setDefaultInternal(IRubyObject recv2, IRubyObject encoding2) {
        if (encoding2.isNil()) {
            recv2.getRuntime().newArgumentError("default_internal can not be nil");
        }
        recv2.getRuntime().setDefaultInternalEncoding(RubyEncoding.getEncodingFromObject(recv2.getRuntime(), encoding2));
    }

    public static IRubyObject convertEncodingToRubyEncoding(Ruby runtime2, Encoding defaultEncoding) {
        if (defaultEncoding != null) {
            return new RubyEncoding(runtime2, defaultEncoding);
        }
        return runtime2.getNil();
    }

    public static Encoding getEncodingFromObject(Ruby runtime2, IRubyObject arg2) {
        Encoding encoding2 = null;
        if (arg2 instanceof RubyEncoding) {
            encoding2 = ((RubyEncoding)arg2).getEncoding();
        } else if (!arg2.isNil()) {
            encoding2 = arg2.convertToString().toEncoding(runtime2);
        }
        return encoding2;
    }
}

