/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.KCode;
import org.jruby.util.Pack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyModule(name={"NKF"})
public class RubyNKF {
    public static final NKFCharset AUTO = new NKFCharset(0, "x-JISAutoDetect");
    public static final NKFCharset JIS = new NKFCharset(1, "iso-2022-jp");
    public static final NKFCharset EUC = new NKFCharset(2, "EUC-JP");
    public static final NKFCharset SJIS = new NKFCharset(3, "Windows-31J");
    public static final NKFCharset BINARY = new NKFCharset(4, null);
    public static final NKFCharset NOCONV = new NKFCharset(4, null);
    public static final NKFCharset UNKNOWN = new NKFCharset(0, null);
    public static final NKFCharset ASCII = new NKFCharset(5, "iso-8859-1");
    public static final NKFCharset UTF8 = new NKFCharset(6, "UTF-8");
    public static final NKFCharset UTF16 = new NKFCharset(8, "UTF-16");
    public static final NKFCharset UTF32 = new NKFCharset(12, "UTF-32");
    public static final NKFCharset OTHER = new NKFCharset(16, null);
    public static final NKFCharset BASE64 = new NKFCharset(20, "base64");
    public static final NKFCharset QENCODE = new NKFCharset(21, "qencode");
    public static final NKFCharset MIME_DETECT = new NKFCharset(22, "MimeAutoDetect");
    private static final ByteList BEGIN_MIME_STRING = new ByteList(ByteList.plain("=?"));
    private static final ByteList END_MIME_STRING = new ByteList(ByteList.plain("?="));
    private static final ByteList MIME_ASCII = new ByteList(ByteList.plain(ASCII.getCharset()));
    private static final ByteList MIME_UTF8 = new ByteList(ByteList.plain(UTF8.getCharset()));
    private static final ByteList MIME_JIS = new ByteList(ByteList.plain(JIS.getCharset()));
    private static final ByteList MIME_EUC_JP = new ByteList(ByteList.plain(EUC.getCharset()));

    public static void createNKF(Ruby runtime2) {
        RubyModule nkfModule = runtime2.defineModule("NKF");
        nkfModule.defineConstant("AUTO", RubyFixnum.newFixnum(runtime2, AUTO.getValue()));
        nkfModule.defineConstant("JIS", RubyFixnum.newFixnum(runtime2, JIS.getValue()));
        nkfModule.defineConstant("EUC", RubyFixnum.newFixnum(runtime2, EUC.getValue()));
        nkfModule.defineConstant("SJIS", RubyFixnum.newFixnum(runtime2, SJIS.getValue()));
        nkfModule.defineConstant("BINARY", RubyFixnum.newFixnum(runtime2, BINARY.getValue()));
        nkfModule.defineConstant("NOCONV", RubyFixnum.newFixnum(runtime2, NOCONV.getValue()));
        nkfModule.defineConstant("UNKNOWN", RubyFixnum.newFixnum(runtime2, UNKNOWN.getValue()));
        nkfModule.defineConstant("ASCII", RubyFixnum.newFixnum(runtime2, ASCII.getValue()));
        nkfModule.defineConstant("UTF8", RubyFixnum.newFixnum(runtime2, UTF8.getValue()));
        nkfModule.defineConstant("UTF16", RubyFixnum.newFixnum(runtime2, UTF16.getValue()));
        nkfModule.defineConstant("UTF32", RubyFixnum.newFixnum(runtime2, UTF32.getValue()));
        nkfModule.defineConstant("OTHER", RubyFixnum.newFixnum(runtime2, OTHER.getValue()));
        RubyString version = runtime2.newString("2.0.7 (JRuby 2007-05-11)");
        RubyString nkfVersion = runtime2.newString("2.0.7");
        RubyString nkfDate = runtime2.newString("2007-05-11");
        ThreadContext context = runtime2.getCurrentContext();
        version.freeze(context);
        nkfVersion.freeze(context);
        nkfDate.freeze(context);
        nkfModule.defineAnnotatedMethods(RubyNKF.class);
    }

    @JRubyMethod(name={"guess"}, required=1, module=true)
    public static IRubyObject guess(ThreadContext context, IRubyObject recv2, IRubyObject s) {
        CharsetDecoder decoder;
        Ruby runtime2 = context.getRuntime();
        if (!s.respondsTo("to_str")) {
            throw runtime2.newTypeError("can't convert " + s.getMetaClass() + " into String");
        }
        ByteList bytes2 = s.convertToString().getByteList();
        ByteBuffer buf = ByteBuffer.wrap(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length());
        try {
            decoder = Charset.forName("x-JISAutoDetect").newDecoder();
        }
        catch (UnsupportedCharsetException e) {
            throw runtime2.newStandardError("charsets.jar is required to use NKF#guess. Please install JRE which supports m17n.");
        }
        try {
            decoder.decode(buf);
        }
        catch (CharacterCodingException e) {
            return runtime2.newFixnum(UNKNOWN.getValue());
        }
        if (!decoder.isCharsetDetected()) {
            return runtime2.newFixnum(UNKNOWN.getValue());
        }
        Charset charset = decoder.detectedCharset();
        String name2 = charset.name();
        if ("Shift_JIS".equals(name2)) {
            return runtime2.newFixnum(SJIS.getValue());
        }
        if ("windows-31j".equals(name2)) {
            return runtime2.newFixnum(SJIS.getValue());
        }
        if ("EUC-JP".equals(name2)) {
            return runtime2.newFixnum(EUC.getValue());
        }
        if ("ISO-2022-JP".equals(name2)) {
            return runtime2.newFixnum(JIS.getValue());
        }
        return runtime2.newFixnum(UNKNOWN.getValue());
    }

    @JRubyMethod(name={"guess1"}, required=1, module=true)
    public static IRubyObject guess1(ThreadContext context, IRubyObject recv2, IRubyObject str) {
        return RubyNKF.guess(context, recv2, str);
    }

    @JRubyMethod(name={"guess2"}, required=1, module=true)
    public static IRubyObject guess2(ThreadContext context, IRubyObject recv2, IRubyObject str) {
        return RubyNKF.guess(context, recv2, str);
    }

    @JRubyMethod(name={"nkf"}, required=2, module=true)
    public static IRubyObject nkf(ThreadContext context, IRubyObject recv2, IRubyObject opt, IRubyObject str) {
        Ruby runtime2 = context.getRuntime();
        if (!opt.respondsTo("to_str")) {
            throw runtime2.newTypeError("can't convert " + opt.getMetaClass() + " into String");
        }
        if (!str.respondsTo("to_str")) {
            throw runtime2.newTypeError("can't convert " + str.getMetaClass() + " into String");
        }
        Map<String, NKFCharset> options2 = RubyNKF.parseOpt(opt.convertToString().toString());
        if (options2.get("input").getValue() == AUTO.getValue()) {
            KCode kcode2 = runtime2.getKCode();
            if (kcode2 == KCode.SJIS) {
                options2.put("input", SJIS);
            } else if (kcode2 == KCode.EUC) {
                options2.put("input", EUC);
            } else if (kcode2 == KCode.UTF8) {
                options2.put("input", UTF8);
            }
        }
        ByteList mimeString = str.convertToString().getByteList();
        ByteList mimeText = null;
        NKFCharset mimeState = RubyNKF.detectMimeString(mimeString, options2);
        if (mimeState == NOCONV) {
            mimeText = mimeString;
        } else {
            mimeText = RubyNKF.getMimeText(mimeString);
            RubyArray array = null;
            if (mimeState == BASE64) {
                array = Pack.unpack(runtime2, mimeText, new ByteList(ByteList.plain("m")));
            } else if (mimeState == QENCODE) {
                array = Pack.unpack(runtime2, mimeText, new ByteList(ByteList.plain("M")));
            }
            RubyString s = (RubyString)array.entry(0);
            mimeText = s.asString().getByteList();
        }
        String decodeCharset = options2.get("input").getCharset();
        String encodeCharset = options2.get("output").getCharset();
        RubyString result = RubyNKF.convert(context, decodeCharset, encodeCharset, mimeText);
        if (options2.get("mime-encode") == BASE64) {
            result = RubyNKF.encodeMimeString(runtime2, result, "m");
        } else if (options2.get("mime-encode") == QENCODE) {
            result = RubyNKF.encodeMimeString(runtime2, result, "M");
        }
        return result;
    }

    private static RubyString convert(ThreadContext context, String decodeCharset, String encodeCharset, ByteList str) {
        CharsetEncoder encoder;
        CharsetDecoder decoder;
        Ruby runtime2 = context.getRuntime();
        try {
            decoder = Charset.forName(decodeCharset).newDecoder();
            encoder = Charset.forName(encodeCharset).newEncoder();
        }
        catch (UnsupportedCharsetException e) {
            throw runtime2.newArgumentError("invalid encoding");
        }
        ByteBuffer buf = ByteBuffer.wrap(str.getUnsafeBytes(), str.begin(), str.length());
        try {
            CharBuffer cbuf = decoder.decode(buf);
            buf = encoder.encode(cbuf);
        }
        catch (CharacterCodingException e) {
            throw runtime2.newArgumentError("invalid encoding");
        }
        byte[] arr = buf.array();
        return runtime2.newString(new ByteList(arr, 0, buf.limit()));
    }

    private static RubyString encodeMimeString(Ruby runtime2, RubyString str, String format) {
        RubyArray array = RubyArray.newArray(runtime2, str);
        return Pack.pack(runtime2, array, new ByteList(ByteList.plain(format))).chomp(runtime2.getCurrentContext());
    }

    private static NKFCharset detectMimeString(ByteList str, Map<String, NKFCharset> options2) {
        if (str.length() <= 6) {
            return NOCONV;
        }
        if (options2.get("mime-decode") == NOCONV) {
            return NOCONV;
        }
        if (!str.startsWith(BEGIN_MIME_STRING)) {
            return NOCONV;
        }
        if (!str.endsWith(END_MIME_STRING)) {
            return NOCONV;
        }
        int pos2 = str.indexOf(63, 3);
        if (pos2 < 0) {
            return NOCONV;
        }
        ByteList charset = new ByteList(str, 2, pos2 - 2);
        if (charset.caseInsensitiveCmp(MIME_UTF8) == 0) {
            options2.put("input", UTF8);
        } else if (charset.caseInsensitiveCmp(MIME_JIS) == 0) {
            options2.put("input", JIS);
        } else if (charset.caseInsensitiveCmp(MIME_EUC_JP) == 0) {
            options2.put("input", EUC);
        } else {
            options2.put("input", ASCII);
        }
        int prev = pos2;
        pos2 = str.indexOf(63, pos2 + 1);
        if (pos2 < 0) {
            return NOCONV;
        }
        char encode2 = str.charAt(pos2 - 1);
        switch (encode2) {
            case 'Q': 
            case 'q': {
                return QENCODE;
            }
            case 'B': 
            case 'b': {
                return BASE64;
            }
        }
        return NOCONV;
    }

    private static ByteList getMimeText(ByteList str) {
        int pos2 = 0;
        for (int i = 3; i >= 1; --i) {
            pos2 = str.indexOf(63, pos2 + 1);
        }
        return new ByteList(str, pos2 + 1, str.length() - pos2 - 3);
    }

    private static int optionUTF(String s, int pos2) {
        int n = 8;
        int first2 = pos2 + 1;
        int second = pos2 + 2;
        if (first2 < s.length() && Character.isDigit(s.charAt(first2))) {
            n = Character.digit(s.charAt(first2), 10);
            if (second < s.length() && Character.isDigit(s.charAt(second))) {
                n *= 10;
                n += Character.digit(s.charAt(second), 10);
            }
        }
        return n;
    }

    private static Map<String, NKFCharset> parseOpt(String s) {
        HashMap<String, NKFCharset> options2 = new HashMap<String, NKFCharset>();
        options2.put("input", AUTO);
        options2.put("output", JIS);
        options2.put("mime-decode", MIME_DETECT);
        options2.put("mime-encode", NOCONV);
        block40: for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case 'b': {
                    continue block40;
                }
                case 'u': {
                    continue block40;
                }
                case 'j': {
                    options2.put("output", JIS);
                    continue block40;
                }
                case 's': {
                    options2.put("output", SJIS);
                    continue block40;
                }
                case 'e': {
                    options2.put("output", EUC);
                    continue block40;
                }
                case 'w': {
                    int n = RubyNKF.optionUTF(s, i);
                    if (n == 32) {
                        options2.put("output", UTF32);
                        continue block40;
                    }
                    if (n == 16) {
                        options2.put("output", UTF16);
                        continue block40;
                    }
                    options2.put("output", UTF8);
                    continue block40;
                }
                case 'J': {
                    options2.put("input", JIS);
                    continue block40;
                }
                case 'S': {
                    options2.put("input", SJIS);
                    continue block40;
                }
                case 'E': {
                    options2.put("input", EUC);
                    continue block40;
                }
                case 'W': {
                    int n = RubyNKF.optionUTF(s, i);
                    if (n == 32) {
                        options2.put("input", UTF32);
                        continue block40;
                    }
                    if (n == 16) {
                        options2.put("input", UTF16);
                        continue block40;
                    }
                    options2.put("input", UTF8);
                    continue block40;
                }
                case 't': {
                    continue block40;
                }
                case 'r': {
                    continue block40;
                }
                case 'h': {
                    continue block40;
                }
                case 'm': {
                    if (i + 1 >= s.length()) {
                        options2.put("mime-decode", MIME_DETECT);
                        continue block40;
                    }
                    switch (s.charAt(i + 1)) {
                        case 'B': {
                            options2.put("mime-decode", BASE64);
                            break;
                        }
                        case 'Q': {
                            options2.put("mime-decode", QENCODE);
                            break;
                        }
                        case 'N': {
                            break;
                        }
                        case '0': {
                            options2.put("mime-decode", NOCONV);
                        }
                    }
                    continue block40;
                }
                case 'M': {
                    if (i + 1 >= s.length()) {
                        options2.put("mime-encode", NOCONV);
                    }
                    switch (s.charAt(i + 1)) {
                        case 'B': {
                            options2.put("mime-encode", BASE64);
                            break;
                        }
                        case 'Q': {
                            options2.put("mime-encode", QENCODE);
                        }
                    }
                    continue block40;
                }
                case 'l': {
                    continue block40;
                }
                case 'f': {
                    continue block40;
                }
                case 'F': {
                    continue block40;
                }
                case 'Z': {
                    continue block40;
                }
                case 'X': {
                    continue block40;
                }
                case 'x': {
                    continue block40;
                }
                case 'B': {
                    continue block40;
                }
                case 'T': {
                    continue block40;
                }
                case 'd': {
                    continue block40;
                }
                case 'c': {
                    continue block40;
                }
                case 'I': {
                    continue block40;
                }
                case 'L': {
                    continue block40;
                }
                case '-': {
                    if (s.charAt(i + 1) != '-') continue block40;
                }
            }
        }
        return options2;
    }

    public static class NKFCharset {
        private final int value;
        private final String charset;

        public NKFCharset(int v, String c) {
            this.value = v;
            this.charset = c;
        }

        public int getValue() {
            return this.value;
        }

        public String getCharset() {
            return this.charset;
        }
    }
}

