/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jcodings.Encoding;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.Region;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.StringSupport;

@JRubyClass(name={"StringScanner"})
public class RubyStringScanner
extends RubyObject {
    private RubyString str;
    private int pos = 0;
    private int lastPos = -1;
    private Region regs;
    private int beg = -1;
    private int end = -1;
    private int scannerFlags;
    private static final int MATCHED_STR_SCN_F = 2048;
    private static ObjectAllocator STRINGSCANNER_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyStringScanner(runtime2, klass);
        }
    };
    private static final int INSPECT_LENGTH = 5;

    public static RubyClass createScannerClass(Ruby runtime2) {
        RubyClass scannerClass = runtime2.defineClass("StringScanner", runtime2.getObject(), STRINGSCANNER_ALLOCATOR);
        scannerClass.defineAnnotatedMethods(RubyStringScanner.class);
        ThreadContext context = runtime2.getCurrentContext();
        scannerClass.setConstant("Version", runtime2.newString("0.7.0").freeze(context));
        scannerClass.setConstant("Id", runtime2.newString("$Id: strscan.c 13506 2007-09-24 08:56:24Z nobu $").freeze(context));
        RubyClass standardError = runtime2.getStandardError();
        RubyClass error2 = scannerClass.defineClassUnder("Error", standardError, standardError.getAllocator());
        RubyClass objClass = runtime2.getObject();
        if (!objClass.isConstantDefined("ScanError")) {
            objClass.defineConstant("ScanError", error2);
        }
        return scannerClass;
    }

    private void clearMatched() {
        this.scannerFlags &= 0xFFFFF7FF;
    }

    private void setMatched() {
        this.scannerFlags |= 0x800;
    }

    private boolean isMatched() {
        return (this.scannerFlags & 0x800) != 0;
    }

    private void check() {
        if (this.str == null) {
            throw this.getRuntime().newArgumentError("uninitialized StringScanner object");
        }
    }

    protected RubyStringScanner(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    @JRubyMethod(name={"initialize"}, required=1, optional=1, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args2, Block unusedBlock) {
        this.str = args2[0].convertToString();
        return this;
    }

    @JRubyMethod(name={"initialize_copy"}, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject other) {
        if (this == other) {
            return this;
        }
        if (!(other instanceof RubyStringScanner)) {
            throw this.getRuntime().newTypeError("wrong argument type " + other.getMetaClass() + " (expected StringScanner)");
        }
        RubyStringScanner otherScanner = (RubyStringScanner)other;
        this.str = otherScanner.str;
        this.pos = otherScanner.pos;
        this.lastPos = otherScanner.lastPos;
        this.scannerFlags = otherScanner.scannerFlags;
        this.regs = otherScanner.regs != null ? otherScanner.regs.clone() : null;
        this.beg = otherScanner.beg;
        this.end = otherScanner.end;
        return this;
    }

    @JRubyMethod(name={"reset"})
    public IRubyObject reset() {
        this.check();
        this.pos = 0;
        this.clearMatched();
        return this;
    }

    @JRubyMethod(name={"terminate"})
    public IRubyObject terminate() {
        this.check();
        this.pos = this.str.getByteList().getRealSize();
        this.clearMatched();
        return this;
    }

    @JRubyMethod(name={"clear"})
    public IRubyObject clear(ThreadContext context) {
        this.check();
        Ruby runtime2 = context.getRuntime();
        if (runtime2.isVerbose()) {
            runtime2.getWarnings().warning(IRubyWarnings.ID.DEPRECATED_METHOD, "StringScanner#clear is obsolete; use #terminate instead", "StringScanner#clear", "#terminate");
        }
        return this.terminate();
    }

    @JRubyMethod(name={"string"})
    public RubyString string() {
        return this.str;
    }

    @JRubyMethod(name={"string="}, required=1)
    public IRubyObject set_string(ThreadContext context, IRubyObject str) {
        this.str = (RubyString)str.convertToString().strDup(context.getRuntime()).freeze(context);
        this.pos = 0;
        this.clearMatched();
        return str;
    }

    @JRubyMethod(name={"concat", "<<"}, required=1)
    public IRubyObject concat(IRubyObject obj) {
        this.check();
        this.str.append(obj);
        return this;
    }

    @JRubyMethod(name={"pos", "pointer"})
    public RubyFixnum pos() {
        this.check();
        return RubyFixnum.newFixnum(this.getRuntime(), this.pos);
    }

    @JRubyMethod(name={"pos=", "pointer="})
    public IRubyObject set_pos(IRubyObject pos2) {
        this.check();
        int i = RubyNumeric.num2int(pos2);
        int size2 = this.str.getByteList().getRealSize();
        if (i < 0) {
            i += size2;
        }
        if (i < 0 || i > size2) {
            throw this.getRuntime().newRangeError("index out of range.");
        }
        this.pos = i;
        return RubyFixnum.newFixnum(this.getRuntime(), i);
    }

    private IRubyObject extractRange(Ruby runtime2, int beg, int end2) {
        int size2 = this.str.getByteList().getRealSize();
        if (beg > size2) {
            return this.getRuntime().getNil();
        }
        if (end2 > size2) {
            end2 = size2;
        }
        return this.str.makeShared(runtime2, beg, end2 - beg);
    }

    private IRubyObject extractBegLen(Ruby runtime2, int beg, int len) {
        assert (len >= 0);
        int size2 = this.str.getByteList().getRealSize();
        if (beg > size2) {
            return this.getRuntime().getNil();
        }
        if (beg + len > size2) {
            len = size2 - beg;
        }
        return this.str.makeShared(runtime2, beg, len);
    }

    private IRubyObject scan(IRubyObject regex, boolean succptr, boolean getstr, boolean headonly) {
        if (!(regex instanceof RubyRegexp)) {
            throw this.getRuntime().newTypeError("wrong argument type " + regex.getMetaClass() + " (expected Regexp)");
        }
        this.check();
        Regex pattern = ((RubyRegexp)regex).getPattern();
        this.clearMatched();
        int rest2 = this.str.getByteList().getRealSize() - this.pos;
        if (rest2 < 0) {
            return this.getRuntime().getNil();
        }
        ByteList value2 = this.str.getByteList();
        Matcher matcher = pattern.matcher(value2.getUnsafeBytes(), value2.getBegin() + this.pos, value2.getBegin() + value2.getRealSize());
        int ret = headonly ? matcher.match(value2.getBegin() + this.pos, value2.getBegin() + value2.getRealSize(), 0) : matcher.search(value2.getBegin() + this.pos, value2.getBegin() + value2.getRealSize(), 0);
        this.regs = matcher.getRegion();
        if (this.regs == null) {
            this.beg = matcher.getBegin();
            this.end = matcher.getEnd();
        } else {
            this.beg = this.regs.beg[0];
            this.end = this.regs.end[0];
        }
        if (ret < 0) {
            return this.getRuntime().getNil();
        }
        this.setMatched();
        this.lastPos = this.pos;
        if (succptr) {
            this.pos += this.end;
        }
        return getstr ? this.extractBegLen(this.getRuntime(), this.lastPos, this.end) : RubyFixnum.newFixnum(this.getRuntime(), this.end);
    }

    @JRubyMethod(name={"scan"}, required=1)
    public IRubyObject scan(IRubyObject regex) {
        return this.scan(regex, true, true, true);
    }

    @JRubyMethod(name={"match?"}, required=1)
    public IRubyObject match_p(IRubyObject regex) {
        return this.scan(regex, false, false, true);
    }

    @JRubyMethod(name={"skip"}, required=1)
    public IRubyObject skip(IRubyObject regex) {
        return this.scan(regex, true, false, true);
    }

    @JRubyMethod(name={"check"}, required=1)
    public IRubyObject check(IRubyObject regex) {
        return this.scan(regex, false, true, true);
    }

    @JRubyMethod(name={"scan_full"}, required=3)
    public IRubyObject scan_full(IRubyObject regex, IRubyObject s, IRubyObject f) {
        return this.scan(regex, s.isTrue(), f.isTrue(), true);
    }

    @JRubyMethod(name={"scan_until"}, required=1)
    public IRubyObject scan_until(IRubyObject regex) {
        return this.scan(regex, true, true, false);
    }

    @JRubyMethod(name={"exist?"}, required=1)
    public IRubyObject exist_p(IRubyObject regex) {
        return this.scan(regex, false, false, false);
    }

    @JRubyMethod(name={"skip_until"}, required=1)
    public IRubyObject skip_until(IRubyObject regex) {
        return this.scan(regex, true, false, false);
    }

    @JRubyMethod(name={"check_until"}, required=1)
    public IRubyObject check_until(IRubyObject regex) {
        return this.scan(regex, false, true, false);
    }

    @JRubyMethod(name={"search_full"}, required=3)
    public IRubyObject search_full(IRubyObject regex, IRubyObject s, IRubyObject f) {
        return this.scan(regex, s.isTrue(), f.isTrue(), false);
    }

    private void adjustRegisters() {
        this.beg = 0;
        this.end = this.pos - this.lastPos;
        this.regs = null;
    }

    @JRubyMethod(name={"getch"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject getch(ThreadContext context) {
        return this.getchCommon(context, false);
    }

    @JRubyMethod(name={"getch"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject getch19(ThreadContext context) {
        return this.getchCommon(context, true);
    }

    public IRubyObject getchCommon(ThreadContext context, boolean is1_9) {
        int len;
        this.check();
        this.clearMatched();
        Ruby runtime2 = context.getRuntime();
        ByteList value2 = this.str.getByteList();
        if (this.pos >= value2.getRealSize()) {
            return runtime2.getNil();
        }
        if (is1_9) {
            Encoding enc = this.str.getEncoding();
            len = enc.isSingleByte() ? 1 : StringSupport.length(enc, value2.getUnsafeBytes(), value2.getBegin() + this.pos, value2.getBegin() + value2.getRealSize());
        } else {
            Encoding enc = runtime2.getKCode().getEncoding();
            int n = len = enc.isSingleByte() ? 1 : enc.length(value2.getUnsafeBytes(), value2.getBegin() + this.pos, value2.getBegin() + value2.getRealSize());
        }
        if (this.pos + len > value2.getRealSize()) {
            len = value2.getRealSize() - this.pos;
        }
        this.lastPos = this.pos;
        this.pos += len;
        this.setMatched();
        this.adjustRegisters();
        return this.extractRange(runtime2, this.lastPos + this.beg, this.lastPos + this.end);
    }

    @JRubyMethod(name={"get_byte"})
    public IRubyObject get_byte(ThreadContext context) {
        this.check();
        this.clearMatched();
        if (this.pos >= this.str.getByteList().getRealSize()) {
            return this.getRuntime().getNil();
        }
        this.lastPos = this.pos++;
        this.setMatched();
        this.adjustRegisters();
        return this.extractRange(context.getRuntime(), this.lastPos + this.beg, this.lastPos + this.end);
    }

    @JRubyMethod(name={"getbyte"})
    public IRubyObject getbyte(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (runtime2.isVerbose()) {
            runtime2.getWarnings().warning(IRubyWarnings.ID.DEPRECATED_METHOD, "StringScanner#getbyte is obsolete; use #get_byte instead", "StringScanner#getbyte", "#get_byte");
        }
        return this.get_byte(context);
    }

    @JRubyMethod(name={"peek"}, required=1)
    public IRubyObject peek(ThreadContext context, IRubyObject length2) {
        this.check();
        int len = RubyNumeric.num2int(length2);
        if (len < 0) {
            throw context.getRuntime().newArgumentError("negative string size (or size too big)");
        }
        ByteList value2 = this.str.getByteList();
        if (this.pos >= value2.getRealSize()) {
            return RubyString.newEmptyString(this.getRuntime()).infectBy(this.str);
        }
        if (this.pos + len > value2.getRealSize()) {
            len = value2.getRealSize() - this.pos;
        }
        return this.extractBegLen(context.getRuntime(), this.pos, len);
    }

    @JRubyMethod(name={"peep"}, required=1)
    public IRubyObject peep(ThreadContext context, IRubyObject length2) {
        Ruby runtime2 = context.getRuntime();
        if (runtime2.isVerbose()) {
            runtime2.getWarnings().warning(IRubyWarnings.ID.DEPRECATED_METHOD, "StringScanner#peep is obsolete; use #peek instead", "StringScanner#peep", "#peek");
        }
        return this.peek(context, length2);
    }

    @JRubyMethod(name={"unscan"})
    public IRubyObject unscan() {
        this.check();
        Ruby runtime2 = this.getRuntime();
        if (!this.isMatched()) {
            RubyClass errorClass = runtime2.fastGetClass("StringScanner").fastGetClass("Error");
            throw new RaiseException(RubyException.newException(runtime2, errorClass, "unscan failed: previous match had failed"));
        }
        this.pos = this.lastPos;
        this.clearMatched();
        return this;
    }

    @JRubyMethod(name={"beginning_of_line?"}, alias={"bol?"})
    public IRubyObject bol_p() {
        this.check();
        ByteList value2 = this.str.getByteList();
        if (this.pos > value2.getRealSize()) {
            return this.getRuntime().getNil();
        }
        if (this.pos == 0) {
            return this.getRuntime().getTrue();
        }
        return value2.getUnsafeBytes()[value2.getBegin() + this.pos - 1] == 10 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"eos?"})
    public RubyBoolean eos_p(ThreadContext context) {
        this.check();
        return this.pos >= this.str.getByteList().getRealSize() ? context.getRuntime().getTrue() : context.getRuntime().getFalse();
    }

    @JRubyMethod(name={"empty?"})
    public RubyBoolean empty_p(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (runtime2.isVerbose()) {
            runtime2.getWarnings().warning(IRubyWarnings.ID.DEPRECATED_METHOD, "StringScanner#empty? is obsolete; use #eos? instead", "StringScanner#empty?", "#eos?");
        }
        return this.eos_p(context);
    }

    @JRubyMethod(name={"rest?"})
    public RubyBoolean rest_p(ThreadContext context) {
        this.check();
        return this.pos >= this.str.getByteList().getRealSize() ? context.getRuntime().getFalse() : context.getRuntime().getTrue();
    }

    @JRubyMethod(name={"matched?"})
    public RubyBoolean matched_p(ThreadContext context) {
        this.check();
        return this.isMatched() ? context.getRuntime().getTrue() : context.getRuntime().getFalse();
    }

    @JRubyMethod(name={"matched"})
    public IRubyObject matched(ThreadContext context) {
        this.check();
        if (!this.isMatched()) {
            return this.getRuntime().getNil();
        }
        return this.extractRange(context.getRuntime(), this.lastPos + this.beg, this.lastPos + this.end);
    }

    @JRubyMethod(name={"matched_size"})
    public IRubyObject matched_size() {
        this.check();
        if (!this.isMatched()) {
            return this.getRuntime().getNil();
        }
        return RubyFixnum.newFixnum(this.getRuntime(), this.end - this.beg);
    }

    @JRubyMethod(name={"matchedsize"})
    public IRubyObject matchedsize(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (runtime2.isVerbose()) {
            runtime2.getWarnings().warning(IRubyWarnings.ID.DEPRECATED_METHOD, "StringScanner#matchedsize is obsolete; use #matched_size instead", "StringScanner#matchedize", "#matched_size");
        }
        return this.matched_size();
    }

    @JRubyMethod(name={"[]"}, required=1)
    public IRubyObject op_aref(ThreadContext context, IRubyObject idx) {
        int numRegs;
        this.check();
        if (!this.isMatched()) {
            return context.getRuntime().getNil();
        }
        int i = RubyNumeric.num2int(idx);
        int n = numRegs = this.regs == null ? 1 : this.regs.numRegs;
        if (i < 0) {
            i += numRegs;
        }
        if (i < 0 || i >= numRegs) {
            return context.getRuntime().getNil();
        }
        if (this.regs == null) {
            assert (i == 0);
            if (this.beg == -1) {
                return this.getRuntime().getNil();
            }
            return this.extractRange(context.getRuntime(), this.lastPos + this.beg, this.lastPos + this.end);
        }
        if (this.regs.beg[i] == -1) {
            return this.getRuntime().getNil();
        }
        return this.extractRange(context.getRuntime(), this.lastPos + this.regs.beg[i], this.lastPos + this.regs.end[i]);
    }

    @JRubyMethod(name={"pre_match"})
    public IRubyObject pre_match(ThreadContext context) {
        this.check();
        if (!this.isMatched()) {
            return context.getRuntime().getNil();
        }
        return this.extractRange(context.getRuntime(), 0, this.lastPos + this.beg);
    }

    @JRubyMethod(name={"post_match"})
    public IRubyObject post_match(ThreadContext context) {
        this.check();
        if (!this.isMatched()) {
            return context.getRuntime().getNil();
        }
        return this.extractRange(context.getRuntime(), this.lastPos + this.end, this.str.getByteList().getRealSize());
    }

    @JRubyMethod(name={"rest"})
    public IRubyObject rest(ThreadContext context) {
        this.check();
        ByteList value2 = this.str.getByteList();
        if (this.pos >= value2.getRealSize()) {
            return RubyString.newEmptyString(context.getRuntime()).infectBy(this.str);
        }
        return this.extractRange(context.getRuntime(), this.pos, value2.getRealSize());
    }

    @JRubyMethod(name={"rest_size"})
    public RubyFixnum rest_size() {
        this.check();
        ByteList value2 = this.str.getByteList();
        if (this.pos >= value2.getRealSize()) {
            return RubyFixnum.zero(this.getRuntime());
        }
        return RubyFixnum.newFixnum(this.getRuntime(), value2.getRealSize() - this.pos);
    }

    @JRubyMethod(name={"restsize"})
    public RubyFixnum restsize(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (runtime2.isVerbose()) {
            runtime2.getWarnings().warning(IRubyWarnings.ID.DEPRECATED_METHOD, "StringScanner#restsize is obsolete; use #rest_size instead", "StringScanner#restsize", "#rest_size");
        }
        return this.rest_size();
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        if (this.str == null) {
            return this.inspect("(uninitialized)");
        }
        if (this.pos >= this.str.getByteList().getRealSize()) {
            return this.inspect("fin");
        }
        if (this.pos == 0) {
            return this.inspect(this.pos + "/" + this.str.getByteList().getRealSize() + " @ " + this.inspect2());
        }
        return this.inspect(this.pos + "/" + this.str.getByteList().getRealSize() + " " + this.inspect1() + " @ " + this.inspect2());
    }

    private IRubyObject inspect(String msg) {
        RubyString result = this.getRuntime().newString("#<" + this.getMetaClass() + " " + msg + ">");
        if (this.str != null) {
            result.infectBy(this.str);
        }
        return result;
    }

    private IRubyObject inspect1() {
        if (this.pos == 0) {
            return RubyString.newEmptyString(this.getRuntime());
        }
        if (this.pos > 5) {
            return RubyString.newStringNoCopy(this.getRuntime(), "...".getBytes()).append(this.str.substr(this.getRuntime(), this.pos - 5, 5)).inspect();
        }
        return this.str.substr(this.getRuntime(), 0, this.pos).inspect();
    }

    private IRubyObject inspect2() {
        if (this.pos >= this.str.getByteList().getRealSize()) {
            return RubyString.newEmptyString(this.getRuntime());
        }
        int len = this.str.getByteList().getRealSize() - this.pos;
        if (len > 5) {
            return ((RubyString)this.str.substr(this.getRuntime(), this.pos, 5)).cat("...".getBytes()).inspect();
        }
        return this.str.substr(this.getRuntime(), this.pos, len).inspect();
    }

    @JRubyMethod(name={"must_C_version"}, meta=true)
    public static IRubyObject mustCversion(IRubyObject recv2) {
        return recv2;
    }
}

