/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.Enum;
import org.jruby.ext.ffi.Factory;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.MemoryOp;
import org.jruby.ext.ffi.MemoryPointer;
import org.jruby.ext.ffi.MemoryUtil;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.Struct;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.Util;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"StructLayout"}, parent="Object")
public final class StructLayout
extends Type {
    static final Storage nullStorage = new NullStorage();
    static final String CLASS_NAME = "StructLayout";
    private final Map<IRubyObject, Member> fieldMap;
    private final List<RubySymbol> fieldNames;
    private final List<Member> fields;
    private final int cacheableFieldCount;
    private final int[] cacheIndexMap;
    private final int referenceFieldCount;
    private final int[] referenceIndexMap;

    public static RubyClass createStructLayoutClass(Ruby runtime2, RubyModule module) {
        RubyClass layoutClass = runtime2.defineClassUnder(CLASS_NAME, module.fastGetClass("Type"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR, module);
        layoutClass.defineAnnotatedMethods(StructLayout.class);
        layoutClass.defineAnnotatedConstants(StructLayout.class);
        RubyClass arrayClass = runtime2.defineClassUnder("Array", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR, layoutClass);
        arrayClass.includeModule(runtime2.getEnumerable());
        arrayClass.defineAnnotatedMethods(Array.class);
        RubyClass charArrayClass = runtime2.defineClassUnder("CharArray", arrayClass, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR, layoutClass);
        charArrayClass.defineAnnotatedMethods(CharArray.class);
        RubyClass fieldClass = runtime2.defineClassUnder("Field", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR, layoutClass);
        fieldClass.defineAnnotatedMethods(Member.class);
        return layoutClass;
    }

    StructLayout(Ruby runtime2, Collection<RubySymbol> fieldNames, Map<IRubyObject, Member> fields2, int size2, int minAlign) {
        super(runtime2, runtime2.fastGetModule("FFI").fastGetClass(CLASS_NAME), NativeType.STRUCT, size2, minAlign);
        this.fieldMap = StructLayout.immutableMap(fields2);
        this.cacheIndexMap = new int[fieldNames.size()];
        this.referenceIndexMap = new int[fieldNames.size()];
        int cfCount = 0;
        int refCount = 0;
        ArrayList<Member> fieldList = new ArrayList<Member>(fieldNames.size());
        for (RubySymbol fieldName : fieldNames) {
            Member m = fields2.get(fieldName);
            fieldList.add(m);
            this.cacheIndexMap[m.index] = m.isCacheable() ? cfCount++ : -1;
            if (m.isValueReferenceNeeded()) {
                this.referenceIndexMap[m.index] = refCount++;
                continue;
            }
            this.referenceIndexMap[m.index] = -1;
        }
        this.cacheableFieldCount = cfCount;
        this.referenceFieldCount = refCount;
        this.fieldNames = Collections.unmodifiableList(new ArrayList<RubySymbol>(fieldNames));
        this.fields = Collections.unmodifiableList(fieldList);
    }

    private static Map<IRubyObject, Member> immutableMap(Map<IRubyObject, Member> fields2) {
        return Collections.unmodifiableMap(new LinkedHashMap<IRubyObject, Member>(fields2));
    }

    @JRubyMethod(name={"get"}, required=2)
    public IRubyObject get(ThreadContext context, IRubyObject ptr, IRubyObject name2) {
        return this.getMember(context.getRuntime(), name2).get(context.getRuntime(), nullStorage, ptr);
    }

    @JRubyMethod(name={"put"}, required=3)
    public IRubyObject put(ThreadContext context, IRubyObject ptr, IRubyObject name2, IRubyObject value2) {
        this.getMember(context.getRuntime(), name2).put(context.getRuntime(), nullStorage, ptr, value2);
        return value2;
    }

    @JRubyMethod(name={"members"})
    public IRubyObject members(ThreadContext context) {
        RubyArray members2 = RubyArray.newArray(context.getRuntime());
        for (RubySymbol name2 : this.fieldNames) {
            members2.append(name2);
        }
        return members2;
    }

    @JRubyMethod(name={"offsets"})
    public IRubyObject offsets(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        RubyArray offsets2 = RubyArray.newArray(runtime2);
        for (RubySymbol name2 : this.fieldNames) {
            RubyArray offset2 = RubyArray.newArray(runtime2);
            offset2.append(name2);
            offset2.append(runtime2.newFixnum(this.fieldMap.get((Object)name2).offset));
            offsets2.append(offset2);
        }
        return offsets2;
    }

    @Override
    @JRubyMethod(name={"size"})
    public IRubyObject size(ThreadContext context) {
        return RubyFixnum.newFixnum(context.getRuntime(), this.getNativeSize());
    }

    @Override
    @JRubyMethod(name={"alignment"})
    public IRubyObject alignment(ThreadContext context) {
        return RubyFixnum.newFixnum(context.getRuntime(), this.getNativeAlignment());
    }

    @JRubyMethod(name={"offset_of"})
    public IRubyObject offset_of(ThreadContext context, IRubyObject fieldName) {
        Member member = this.getMember(context.getRuntime(), fieldName);
        return RubyFixnum.newFixnum(context.getRuntime(), member.offset);
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject aref(ThreadContext context, IRubyObject fieldName) {
        return this.getMember(context.getRuntime(), fieldName);
    }

    @JRubyMethod
    public IRubyObject fields(ThreadContext context) {
        return RubyArray.newArray(context.getRuntime(), this.fields);
    }

    final Member getMember(Ruby runtime2, IRubyObject name2) {
        Member f = this.fieldMap.get(name2);
        if (f != null) {
            return f;
        }
        throw runtime2.newArgumentError("Unknown field: " + name2);
    }

    public final int getMinimumAlignment() {
        return this.getNativeAlignment();
    }

    public final int getSize() {
        return this.getNativeSize();
    }

    final int getReferenceFieldCount() {
        return this.referenceFieldCount;
    }

    final int getReferenceFieldIndex(Member member) {
        return this.referenceIndexMap[member.index];
    }

    final int getCacheableFieldCount() {
        return this.cacheableFieldCount;
    }

    final int getCacheableFieldIndex(Member member) {
        return this.cacheIndexMap[member.index];
    }

    public final int getFieldCount() {
        return this.fields.size();
    }

    public final Collection<Member> getFields() {
        return this.fields;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CharArrayMember
    extends Member
    implements Aggregate {
        private final int length;

        CharArrayMember(IRubyObject name2, Type type2, int index2, long offset2, int size2) {
            super(name2, type2, index2, offset2);
            this.length = size2;
        }

        @Override
        public void put(Ruby runtime2, Storage cache, IRubyObject ptr, IRubyObject value2) {
            ByteList bl = value2.convertToString().getByteList();
            CharArrayMember.getMemoryIO(ptr).putZeroTerminatedByteArray(this.offset, bl.getUnsafeBytes(), bl.begin(), Math.min(bl.length(), this.length - 1));
        }

        @Override
        public IRubyObject get(Ruby runtime2, Storage cache, IRubyObject ptr) {
            return MemoryUtil.getTaintedString(runtime2, CharArrayMember.getMemoryIO(ptr), this.getOffset(ptr), this.length);
        }

        @Override
        public Collection<Member> getMembers() {
            ArrayList<Member> members2 = new ArrayList<Member>(this.length);
            for (int i = 0; i < this.length; ++i) {
                members2.add(new PrimitiveMember(this.type.getRuntime().getNil(), this.type, i, i * this.type.getNativeSize()));
            }
            return members2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ArrayMember
    extends Member
    implements Aggregate {
        private final MemoryOp op;
        private final Type.Array arrayType;

        ArrayMember(IRubyObject name2, Type.Array arrayType, int index2, long offset2, MemoryOp op) {
            super(name2, arrayType, index2, offset2);
            this.op = op;
            this.arrayType = arrayType;
        }

        @Override
        public void put(Ruby runtime2, Storage cache, IRubyObject ptr, IRubyObject value2) {
            if (!this.isCharArray() || !(value2 instanceof RubyString)) {
                throw runtime2.newNotImplementedError("cannot set array field");
            }
            ByteList bl = value2.convertToString().getByteList();
            ArrayMember.getMemoryIO(ptr).putZeroTerminatedByteArray(this.offset, bl.getUnsafeBytes(), bl.begin(), Math.min(bl.length(), this.arrayType.length() - 1));
        }

        @Override
        public IRubyObject get(Ruby runtime2, Storage cache, IRubyObject ptr) {
            IRubyObject s = cache.getCachedValue(this);
            if (s == null) {
                s = this.isCharArray() ? new CharArray(runtime2, ptr, this.offset, this.arrayType, this.op) : new Array(runtime2, ptr, this.offset, this.arrayType, this.op);
                cache.putCachedValue(this, s);
            }
            return s;
        }

        @Override
        protected boolean isCacheable() {
            return true;
        }

        @Override
        public Collection<Member> getMembers() {
            ArrayList<Member> members2 = new ArrayList<Member>(this.arrayType.length());
            Type elemType = this.arrayType.getComponentType();
            for (int i = 0; i < this.arrayType.length(); ++i) {
                members2.add(new PrimitiveMember(this.getRuntime().getNil(), elemType, i, i * elemType.getNativeSize()));
            }
            return members2;
        }

        private final boolean isCharArray() {
            return this.arrayType.getComponentType().nativeType == NativeType.CHAR || this.arrayType.getComponentType().nativeType == NativeType.UCHAR;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StructMember
    extends Member
    implements Aggregate {
        private final RubyClass klass;
        private final StructLayout layout;

        StructMember(IRubyObject name2, StructLayout layout, RubyClass klass, int index2, long offset2) {
            super(name2, layout, index2, offset2);
            this.klass = klass;
            this.layout = layout;
        }

        @Override
        public void put(Ruby runtime2, Storage cache, IRubyObject ptr, IRubyObject value2) {
            throw runtime2.newNotImplementedError("Cannot set Struct fields");
        }

        @Override
        public IRubyObject get(Ruby runtime2, Storage cache, IRubyObject ptr) {
            IRubyObject s = cache.getCachedValue(this);
            if (s == null) {
                s = this.klass.newInstance(runtime2.getCurrentContext(), new IRubyObject[]{((AbstractMemory)ptr).slice(runtime2, this.getOffset(ptr))}, Block.NULL_BLOCK);
                cache.putCachedValue(this, s);
            }
            return s;
        }

        @Override
        protected boolean isCacheable() {
            return true;
        }

        @Override
        protected boolean isValueReferenceNeeded() {
            return true;
        }

        @Override
        public Collection<Member> getMembers() {
            return this.layout.getFields();
        }
    }

    static final class CallbackMember
    extends Member {
        private final CallbackInfo cbInfo;

        CallbackMember(IRubyObject name2, CallbackInfo cbInfo, int index2, long offset2) {
            super(name2, cbInfo, index2, offset2);
            this.cbInfo = cbInfo;
        }

        protected boolean isCacheable() {
            return true;
        }

        protected boolean isValueReferenceNeeded() {
            return true;
        }

        public void put(Ruby runtime2, Storage cache, IRubyObject ptr, IRubyObject value2) {
            if (value2.isNil()) {
                CallbackMember.getMemoryIO(ptr).putAddress(this.getOffset(ptr), 0L);
            } else {
                Pointer cb = Factory.getInstance().getCallbackManager().getCallback(runtime2, this.cbInfo, value2);
                CallbackMember.getMemoryIO(ptr).putMemoryIO(this.getOffset(ptr), cb.getMemoryIO());
                cache.putCachedValue(this, cb);
                cache.putReference(this, cb);
            }
        }

        public IRubyObject get(Ruby runtime2, Storage cache, IRubyObject ptr) {
            return Factory.getInstance().newFunction(runtime2, ((Pointer)ptr).getPointer(runtime2, this.getOffset(ptr)), this.cbInfo);
        }
    }

    static final class StringMember
    extends Member {
        StringMember(IRubyObject name2, Type type2, int index2, long offset2) {
            super(name2, type2, index2, offset2);
        }

        protected boolean isCacheable() {
            return true;
        }

        protected boolean isValueReferenceNeeded() {
            return true;
        }

        public IRubyObject get(Ruby runtime2, Storage cache, IRubyObject ptr) {
            DirectMemoryIO io2 = StringMember.getMemoryIO(ptr).getMemoryIO(this.getOffset(ptr));
            if (io2 == null || io2.isNull()) {
                return runtime2.getNil();
            }
            return RubyString.newStringNoCopy(runtime2, io2.getZeroTerminatedByteArray(0L));
        }

        public void put(Ruby runtime2, Storage cache, IRubyObject ptr, IRubyObject value2) {
            ByteList bl = value2.convertToString().getByteList();
            MemoryPointer mem = MemoryPointer.allocate(runtime2, 1, bl.length() + 1, false);
            cache.putReference(this, mem);
            MemoryIO io2 = mem.getMemoryIO();
            io2.put(0L, bl.getUnsafeBytes(), bl.begin(), bl.length());
            io2.putByte(bl.length(), (byte)0);
            StringMember.getMemoryIO(ptr).putMemoryIO(this.getOffset(ptr), io2);
        }
    }

    static final class PointerMember
    extends Member {
        PointerMember(IRubyObject name2, Type type2, int index2, long offset2) {
            super(name2, type2, index2, offset2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void put(Ruby runtime2, Storage cache, IRubyObject ptr, IRubyObject value2) {
            if (value2 instanceof Pointer) {
                PointerMember.getMemoryIO(ptr).putMemoryIO(this.getOffset(ptr), ((Pointer)value2).getMemoryIO());
            } else if (value2 instanceof Struct) {
                MemoryIO mem = ((Struct)value2).getMemoryIO();
                if (!(mem instanceof DirectMemoryIO)) {
                    throw runtime2.newArgumentError("Struct memory not backed by a native pointer");
                }
                PointerMember.getMemoryIO(ptr).putMemoryIO(this.getOffset(ptr), mem);
            } else if (value2 instanceof RubyInteger) {
                PointerMember.getMemoryIO(ptr).putAddress(this.offset, Util.int64Value(ptr));
            } else if (value2.respondsTo("to_ptr")) {
                IRubyObject addr2 = value2.callMethod(runtime2.getCurrentContext(), "to_ptr");
                if (!(addr2 instanceof Pointer)) throw runtime2.newArgumentError("Invalid pointer value");
                PointerMember.getMemoryIO(ptr).putMemoryIO(this.offset, ((Pointer)addr2).getMemoryIO());
            } else {
                if (!value2.isNil()) throw runtime2.newArgumentError("Invalid pointer value");
                PointerMember.getMemoryIO(ptr).putAddress(this.offset, 0L);
            }
            cache.putReference(this, value2);
        }

        public IRubyObject get(Ruby runtime2, Storage cache, IRubyObject ptr) {
            MemoryIO oldMemory;
            DirectMemoryIO memory = ((AbstractMemory)ptr).getMemoryIO().getMemoryIO(this.getOffset(ptr));
            IRubyObject old = cache.getCachedValue(this);
            if (old instanceof Pointer && memory.equals(oldMemory = ((Pointer)old).getMemoryIO())) {
                return old;
            }
            Pointer retval = new Pointer(runtime2, memory);
            cache.putCachedValue(this, retval);
            return retval;
        }

        protected boolean isCacheable() {
            return true;
        }

        protected boolean isValueReferenceNeeded() {
            return true;
        }
    }

    static final class EnumMember
    extends Member {
        EnumMember(IRubyObject name2, Enum type2, int index2, long offset2) {
            super(name2, type2, index2, offset2);
        }

        public void put(Ruby runtime2, Storage cache, IRubyObject ptr, IRubyObject value2) {
            EnumMember.getMemoryIO(ptr).putInt(this.offset, RubyNumeric.num2int(this.type.callMethod(runtime2.getCurrentContext(), "find", value2)));
        }

        public IRubyObject get(Ruby runtime2, Storage cache, IRubyObject ptr) {
            return this.type.callMethod(runtime2.getCurrentContext(), "find", (IRubyObject)runtime2.newFixnum(EnumMember.getMemoryIO(ptr).getInt(this.offset)));
        }
    }

    static final class PrimitiveMember
    extends Member {
        private final MemoryOp op;

        PrimitiveMember(IRubyObject name2, Type type2, int index2, long offset2) {
            super(name2, type2, index2, offset2);
            this.op = MemoryOp.getMemoryOp(type2);
        }

        public void put(Ruby runtime2, Storage cache, IRubyObject ptr, IRubyObject value2) {
            this.op.put(runtime2, PrimitiveMember.getMemoryIO(ptr), this.offset, value2);
        }

        public IRubyObject get(Ruby runtime2, Storage cache, IRubyObject ptr) {
            return this.op.get(runtime2, PrimitiveMember.getMemoryIO(ptr), this.offset);
        }
    }

    @JRubyClass(name={"FFI::StructLayout::CharArray"}, parent="FFI::StructLayout::Array")
    public static final class CharArray
    extends Array {
        CharArray(Ruby runtime2, IRubyObject ptr, long offset2, Type.Array type2, MemoryOp aio) {
            super(runtime2, runtime2.fastGetModule("FFI").fastGetClass(StructLayout.CLASS_NAME).fastGetClass("CharArray"), ptr, offset2, type2, aio);
        }

        @JRubyMethod(name={"to_s"})
        public IRubyObject to_s(ThreadContext context) {
            return MemoryUtil.getTaintedString(context.getRuntime(), this.ptr.getMemoryIO(), 0L, this.arrayType.length());
        }
    }

    @JRubyClass(name={"FFI::StructLayout::Array"}, parent="Object")
    public static class Array
    extends RubyObject {
        protected final AbstractMemory ptr;
        protected final MemoryOp aio;
        protected final Type.Array arrayType;

        Array(Ruby runtime2, IRubyObject ptr, long offset2, Type.Array type2, MemoryOp aio) {
            this(runtime2, runtime2.fastGetModule("FFI").fastGetClass(StructLayout.CLASS_NAME).fastGetClass("Array"), ptr, offset2, type2, aio);
        }

        Array(Ruby runtime2, RubyClass klass, IRubyObject ptr, long offset2, Type.Array type2, MemoryOp aio) {
            super(runtime2, klass);
            this.ptr = ((AbstractMemory)ptr).slice(runtime2, offset2, type2.getNativeSize());
            this.arrayType = type2;
            this.aio = aio;
        }

        private final long getOffset(IRubyObject index2) {
            return this.getOffset(Util.int32Value(index2));
        }

        private final long getOffset(int index2) {
            if (index2 < 0 || index2 >= this.arrayType.length()) {
                throw this.getRuntime().newIndexError("index " + index2 + " out of bounds");
            }
            return index2 * this.arrayType.getComponentType().getNativeSize();
        }

        private IRubyObject get(Ruby runtime2, int index2) {
            return this.aio.get(runtime2, this.ptr, this.getOffset(index2));
        }

        @JRubyMethod(name={"[]"})
        public IRubyObject get(ThreadContext context, IRubyObject index2) {
            return this.aio.get(context.getRuntime(), this.ptr, this.getOffset(index2));
        }

        @JRubyMethod(name={"[]="})
        public IRubyObject put(ThreadContext context, IRubyObject index2, IRubyObject value2) {
            this.aio.put(context.getRuntime(), this.ptr, this.getOffset(index2), value2);
            return value2;
        }

        @JRubyMethod(name={"to_a", "to_ary"})
        public IRubyObject get(ThreadContext context) {
            Ruby runtime2 = context.getRuntime();
            IRubyObject[] elems = new IRubyObject[this.arrayType.length()];
            for (int i = 0; i < elems.length; ++i) {
                elems[i] = this.get(runtime2, i);
            }
            return RubyArray.newArrayNoCopy(runtime2, elems);
        }

        @JRubyMethod(name={"to_ptr"})
        public IRubyObject to_ptr(ThreadContext context) {
            return this.ptr;
        }

        @JRubyMethod(name={"size"})
        public IRubyObject size(ThreadContext context) {
            return context.getRuntime().newFixnum(this.arrayType.getNativeSize());
        }

        @JRubyMethod(name={"each"}, frame=true)
        public IRubyObject each(ThreadContext context, Block block) {
            if (!block.isGiven()) {
                throw context.getRuntime().newLocalJumpErrorNoBlock();
            }
            for (int i = 0; i < this.arrayType.length(); ++i) {
                block.yield(context, this.get(context.getRuntime(), i));
            }
            return this;
        }
    }

    static class NullStorage
    implements Storage {
        NullStorage() {
        }

        public IRubyObject getCachedValue(Member member) {
            return null;
        }

        public void putCachedValue(Member member, IRubyObject value2) {
        }

        public void putReference(Member member, IRubyObject value2) {
        }
    }

    public static interface Storage {
        public IRubyObject getCachedValue(Member var1);

        public void putCachedValue(Member var1, IRubyObject var2);

        public void putReference(Member var1, IRubyObject var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Aggregate {
        public Collection<Member> getMembers();
    }

    @JRubyClass(name={"FFI::StructLayout::Field"}, parent="Object")
    public static abstract class Member
    extends RubyObject {
        protected final IRubyObject name;
        protected final Type type;
        protected final long offset;
        protected final int index;

        protected Member(IRubyObject name2, Type type2, int index2, long offset2) {
            super(type2.getRuntime(), type2.getRuntime().fastGetModule("FFI").fastGetClass(StructLayout.CLASS_NAME).fastGetClass("Field"));
            this.name = name2;
            this.type = type2;
            this.index = index2;
            this.offset = offset2;
        }

        static final MemoryIO getMemoryIO(IRubyObject ptr) {
            return ((AbstractMemory)ptr).getMemoryIO();
        }

        final long getOffset(IRubyObject ptr) {
            return this.offset;
        }

        final int getIndex() {
            return this.index;
        }

        public final NativeType getNativeType() {
            return this.type.getNativeType();
        }

        public boolean equals(Object obj) {
            return obj instanceof Member && ((Member)obj).offset == this.offset;
        }

        public int hashCode() {
            return 265 + (int)(this.offset ^ this.offset >>> 32);
        }

        public abstract void put(Ruby var1, Storage var2, IRubyObject var3, IRubyObject var4);

        public abstract IRubyObject get(Ruby var1, Storage var2, IRubyObject var3);

        protected boolean isCacheable() {
            return false;
        }

        protected boolean isValueReferenceNeeded() {
            return false;
        }

        @JRubyMethod
        public IRubyObject size(ThreadContext context) {
            return context.getRuntime().newFixnum(this.type.getNativeSize());
        }

        @JRubyMethod
        public IRubyObject alignment(ThreadContext context) {
            return context.getRuntime().newFixnum(this.type.getNativeAlignment());
        }

        @JRubyMethod
        public IRubyObject offset(ThreadContext context) {
            return context.getRuntime().newFixnum(this.offset);
        }

        @JRubyMethod(name={"type", "ffi_type"})
        public IRubyObject ffi_type(ThreadContext context) {
            return this.type;
        }
    }
}

