/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.proxies;

import java.lang.reflect.Method;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtilities;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaInterfaceTemplate {
    public static RubyModule createJavaInterfaceTemplateModule(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        RubyModule javaInterfaceTemplate = runtime2.defineModule("JavaInterfaceTemplate");
        RubyClass singleton = javaInterfaceTemplate.getSingletonClass();
        singleton.addReadAttribute(context, "java_class");
        singleton.defineAnnotatedMethods(JavaInterfaceTemplate.class);
        return javaInterfaceTemplate;
    }

    @JRubyMethod(backtrace=true, visibility=Visibility.PRIVATE)
    public static IRubyObject implement(ThreadContext context, IRubyObject self, IRubyObject clazz) {
        Ruby runtime2 = context.getRuntime();
        if (!(clazz instanceof RubyModule)) {
            throw runtime2.newTypeError(clazz, runtime2.getModule());
        }
        RubyModule targetModule = (RubyModule)clazz;
        JavaClass javaClass = (JavaClass)self.getInstanceVariables().fastGetInstanceVariable("@java_class");
        Method[] javaInstanceMethods = javaClass.javaClass().getMethods();
        JavaMethod dummyMethod = new JavaMethod(targetModule, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                return context.getRuntime().getNil();
            }
        };
        for (int i = 0; i < javaInstanceMethods.length; ++i) {
            Method method2 = javaInstanceMethods[i];
            String name2 = method2.getName();
            if (targetModule.searchMethod(name2) != UndefinedMethod.INSTANCE) continue;
            targetModule.addMethod(name2, dummyMethod);
        }
        return runtime2.getNil();
    }

    @JRubyMethod(frame=true)
    public static IRubyObject append_features(ThreadContext context, IRubyObject self, IRubyObject clazz, Block block) {
        if (clazz instanceof RubyClass) {
            JavaInterfaceTemplate.appendFeaturesToClass(context, self, (RubyClass)clazz);
        } else if (clazz instanceof RubyModule) {
            JavaInterfaceTemplate.appendFeaturesToModule(context, self, (RubyModule)clazz);
        } else {
            throw context.getRuntime().newTypeError("received " + clazz + ", expected Class/Module");
        }
        return RuntimeHelpers.invokeSuper(context, self, clazz, block);
    }

    private static void appendFeaturesToClass(ThreadContext context, IRubyObject self, RubyClass clazz) {
        Ruby runtime2 = context.getRuntime();
        JavaInterfaceTemplate.checkAlreadyReified(clazz, runtime2);
        IRubyObject javaClassObj = RuntimeHelpers.getInstanceVariable(self, runtime2, "@java_class");
        if (!clazz.hasInstanceVariable("@java_interfaces")) {
            RubyArray javaInterfaces = RubyArray.newArray(runtime2, javaClassObj);
            RuntimeHelpers.setInstanceVariable(javaInterfaces, clazz, "@java_interfaces");
            JavaInterfaceTemplate.initInterfaceImplMethods(context, clazz);
        } else {
            IRubyObject javaInterfaces = RuntimeHelpers.getInstanceVariable(clazz, runtime2, "@java_interfaces");
            if (!javaInterfaces.isFrozen() && !((RubyArray)javaInterfaces).includes(context, javaClassObj)) {
                ((RubyArray)javaInterfaces).append(javaClassObj);
            }
        }
    }

    private static void checkAlreadyReified(RubyClass clazz, Ruby runtime2) throws RaiseException {
        if (Java.NEW_STYLE_EXTENSION && clazz.getReifiedClass() != null || clazz.hasInstanceVariable("@java_class") && clazz.getInstanceVariable("@java_class").isTrue() && !clazz.getSingletonClass().isMethodBound("java_proxy_class", false) || clazz.hasInstanceVariable("@java_proxy_class") && clazz.getInstanceVariable("@java_proxy_class").isTrue()) {
            throw runtime2.newArgumentError("can not add Java interface to existing Java class");
        }
    }

    private static void initInterfaceImplMethods(ThreadContext context, RubyClass clazz) {
        RubyClass singleton;
        if (!clazz.isMethodBound("__jcreate_meta!", false)) {
            singleton = clazz.getSingletonClass();
            singleton.addReadAttribute(context, "java_interfaces");
            if (!Java.NEW_STYLE_EXTENSION && clazz.getSuperClass().getRealClass().hasInstanceVariable("@java_class") || RubyInstanceConfig.INTERFACES_USE_PROXY) {
                singleton.addMethod("new", new JavaMethod(singleton, Visibility.PUBLIC){

                    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                        assert (self instanceof RubyClass) : "new defined on non-class";
                        RubyClass clazzSelf = (RubyClass)self;
                        IRubyObject newObj = clazzSelf.allocate();
                        RuntimeHelpers.invoke(context, newObj, "__jcreate!", args2, block);
                        RuntimeHelpers.invoke(context, newObj, "initialize", args2, block);
                        return newObj;
                    }
                });
                clazz.addMethod("__jcreate!", new JavaMethod.JavaMethodN(clazz, Visibility.PRIVATE){

                    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2) {
                        return JavaInterfaceTemplate.jcreateProxy(self, args2);
                    }
                });
            } else {
                JavaInterfaceTemplate.addRealImplClassNew(clazz);
            }
            clazz.addMethod("__jcreate_meta!", new JavaMethod.JavaMethodN(clazz, Visibility.PRIVATE){

                public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2) {
                    IRubyObject result = JavaInterfaceTemplate.jcreateProxy(self, args2);
                    return result;
                }
            });
            clazz.addMethod("java_class", new JavaMethod.JavaMethodZero(clazz, Visibility.PUBLIC){

                public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2) {
                    return ((JavaObject)self.dataGetStruct()).java_class();
                }
            });
            clazz.defineAlias("old_eqq", "===");
            clazz.addMethod("===", new JavaMethod.JavaMethodOne(clazz, Visibility.PUBLIC){

                public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg2) {
                    if (arg2.respondsTo("java_object")) {
                        IRubyObject interfaces2 = self.getMetaClass().getInstanceVariables().fastGetInstanceVariable("@java_interfaces");
                        assert (interfaces2 instanceof RubyArray) : "interface list was not an array";
                        return context.getRuntime().newBoolean(((RubyArray)interfaces2).op_diff(((JavaClass)((JavaObject)arg2.dataGetStruct()).java_class()).interfaces()).equals(RubyArray.newArray(context.getRuntime())));
                    }
                    return RuntimeHelpers.invoke(context, self, "old_eqq", arg2);
                }
            });
        }
        if (!clazz.isMethodBound("implement", false)) {
            singleton = clazz.getSingletonClass();
            singleton.addMethod("implement", new JavaMethod.JavaMethodOne(clazz, Visibility.PRIVATE){

                public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg2) {
                    IRubyObject javaInterfaces = self.getInstanceVariables().fastGetInstanceVariable("@java_interfaces");
                    if (javaInterfaces != null && ((RubyArray)javaInterfaces).includes(context, arg2)) {
                        return RuntimeHelpers.invoke(context, arg2, "implement", self);
                    }
                    return context.getRuntime().getNil();
                }
            });
            singleton.addMethod("implement_all", new JavaMethod.JavaMethodOne(clazz, Visibility.PRIVATE){

                public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg2) {
                    RubyArray javaInterfaces = (RubyArray)self.getInstanceVariables().fastGetInstanceVariable("@java_interfaces");
                    for (int i = 0; i < javaInterfaces.size(); ++i) {
                        RuntimeHelpers.invoke(context, JavaUtilities.get_interface_module(self, javaInterfaces.eltInternal(i)), "implement", self);
                    }
                    return javaInterfaces;
                }
            });
        }
    }

    public static void addRealImplClassNew(RubyClass clazz) {
        RubyClass singleton = clazz.getSingletonClass();
        singleton.addMethod("new", new JavaMethod(singleton, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                assert (self instanceof RubyClass) : "new defined on non-class";
                RubyClass clazzSelf = (RubyClass)self;
                IRubyObject newObj = Java.generateRealClass(clazzSelf);
                RuntimeHelpers.invoke(context, newObj, "initialize", args2, block);
                return newObj;
            }
        });
    }

    private static IRubyObject jcreateProxy(IRubyObject self, IRubyObject[] args2) {
        RubyClass current2 = self.getMetaClass();
        IRubyObject newObject2 = Java.newInterfaceImpl(self, Java.getInterfacesFromRubyClass(current2));
        return JavaUtilities.set_java_object(self, self, newObject2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void appendFeaturesToModule(ThreadContext context, IRubyObject self, RubyModule module) {
        Ruby runtime2 = context.getRuntime();
        if (module.getInstanceVariables().fastHasInstanceVariable("@java_class") && module.getInstanceVariables().fastGetInstanceVariable("@java_class").isTrue()) {
            throw runtime2.newTypeError("can not add Java interface to existing Java interface");
        }
        RubyModule rubyModule = module;
        synchronized (rubyModule) {
            if (!module.getInstanceVariables().fastHasInstanceVariable("@java_interface_mods")) {
                RubyArray javaInterfaceMods = RubyArray.newArray(runtime2, self);
                module.getInstanceVariables().fastSetInstanceVariable("@java_interface_mods", javaInterfaceMods);
                RubyClass singleton = module.getSingletonClass();
                singleton.addMethod("append_features", new JavaMethod.JavaMethodOneBlock(singleton, Visibility.PUBLIC){

                    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg2, Block block) {
                        if (!(arg2 instanceof RubyClass)) {
                            throw context.getRuntime().newTypeError("append_features called with non-class");
                        }
                        RubyClass target = (RubyClass)arg2;
                        RubyArray javaInterfaceMods = (RubyArray)self.getInstanceVariables().fastGetInstanceVariable("@java_interface_mods");
                        target.include(javaInterfaceMods.toJavaArray());
                        return RuntimeHelpers.invokeAs(context, clazz.getSuperClass(), self, name2, arg2, block);
                    }
                });
            } else {
                RubyArray javaInterfaceMods = (RubyArray)module.getInstanceVariables().fastGetInstanceVariable("@java_interface_mods");
                if (!javaInterfaceMods.includes(context, self)) {
                    javaInterfaceMods.append(self);
                }
            }
        }
    }

    @JRubyMethod
    public static IRubyObject extended(ThreadContext context, IRubyObject self, IRubyObject object) {
        if (!(self instanceof RubyModule)) {
            throw context.getRuntime().newTypeError(self, context.getRuntime().getModule());
        }
        RubyClass singleton = object.getSingletonClass();
        singleton.include(new IRubyObject[]{self});
        return singleton;
    }

    @JRubyMethod(name={"[]"}, rest=true, backtrace=true)
    public static IRubyObject op_aref(ThreadContext context, IRubyObject self, IRubyObject[] args2) {
        if (args2.length == 0) {
            return JavaUtilities.get_proxy_class(self, ((JavaClass)RuntimeHelpers.invoke(context, self, "java_class")).array_class());
        }
        RubyClass arrayJavaProxyCreator = context.getRuntime().getClass("ArrayJavaProxyCreator");
        IRubyObject[] newArgs = new IRubyObject[args2.length + 1];
        System.arraycopy(args2, 0, newArgs, 1, args2.length);
        newArgs[0] = RuntimeHelpers.invoke(context, self, "java_class");
        return RuntimeHelpers.invoke(context, (IRubyObject)arrayJavaProxyCreator, "new", newArgs);
    }

    @JRubyMethod(rest=true, backtrace=true)
    public static IRubyObject impl(ThreadContext context, IRubyObject self, IRubyObject[] args2, final Block implBlock) {
        Ruby runtime2 = context.getRuntime();
        if (!implBlock.isGiven()) {
            throw runtime2.newArgumentError("block required to call #impl on a Java interface");
        }
        final RubyArray methodNames = args2.length > 0 ? runtime2.newArray(args2) : null;
        RubyClass implClass = RubyClass.newClass(runtime2, runtime2.getObject());
        implClass.include(new IRubyObject[]{self});
        IRubyObject implObject = implClass.callMethod(context, "new");
        implClass.addMethod("method_missing", new JavaMethod(implClass, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                Arity.checkArgumentCount(context.getRuntime(), args2.length, 1, -1);
                if (methodNames == null || methodNames.include_p(context, args2[0]).isTrue()) {
                    return implBlock.call(context, args2);
                }
                return clazz.getSuperClass().callMethod(context, "method_missing", args2, block);
            }
        });
        return implObject;
    }

    @JRubyMethod(name={"new"}, rest=true, backtrace=true)
    public static IRubyObject rbNew(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
        Ruby runtime2 = context.getRuntime();
        RubyClass implClass = (RubyClass)self.getInstanceVariables().getInstanceVariable("@__implementation");
        if (implClass == null) {
            implClass = RubyClass.newClass(runtime2, runtime2.getClass("InterfaceJavaProxy"));
            implClass.include(new IRubyObject[]{self});
            RuntimeHelpers.setInstanceVariable(implClass, self, "@__implementation");
        }
        return RuntimeHelpers.invoke(context, (IRubyObject)implClass, "new", args2, block);
    }
}

